/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.iterators;

import java.util.NoSuchElementException;
import java.util.Stack;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class PreorderTreeIterator
implements PhylogenyNodeIterator {
    private final Phylogeny _tree;
    private final Stack _stack;

    public PreorderTreeIterator(Phylogeny tree) throws IllegalArgumentException {
        if (tree.isEmpty()) {
            throw new IllegalArgumentException("Attempt to use PreorderTreeIterator on empty tree.");
        }
        this._stack = new Stack();
        this._tree = tree;
        this.reset();
    }

    public void reset() {
        this.getStack().clear();
        this.getStack().push(this.getTree().getRoot());
    }

    public boolean hasNext() {
        return !this.getStack().isEmpty();
    }

    public PhylogenyNode next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Attempt to call \"next()\" on iterator which has no more next elements.");
        }
        PhylogenyNode node = (PhylogenyNode)this.getStack().pop();
        if (!node.isExternal()) {
            int i = node.getNumberOfChildNodes() - 1;
            while (i >= 0) {
                this.getStack().push(node.getChildNode(i));
                --i;
            }
        }
        return node;
    }

    private Stack getStack() {
        return this._stack;
    }

    private Phylogeny getTree() {
        return this._tree;
    }
}

