/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import org.forester.phylogeny.data.PhylogenyData;

public class Support
implements PhylogenyData {
    public static final double INTERVALL_DEFAULT = Double.MIN_VALUE;
    private double _value;
    private String _type;
    private double _interval;

    public Support() {
        this.init();
    }

    public Support(double value, String type) {
        this(value, type, Double.MIN_VALUE);
    }

    public Support(double value, String type, double interval) {
        this.setValue(value);
        this.setType(type);
        this.setInterval(interval);
    }

    public void init() {
        this.setValue(0.0);
        this.setType("");
        this.setInterval(Double.MIN_VALUE);
    }

    public PhylogenyData copy() {
        return new Support(this.getValue(), this.getType(), this.getInterval());
    }

    public boolean isEqual(PhylogenyData support) {
        if (support == null) {
            throw new IllegalArgumentException("Attempt to compare a Support object to null.");
        }
        if (!(support instanceof Support)) {
            throw new IllegalArgumentException("Attempt to compare a Support object to a object of type [" + support.getClass() + "].");
        }
        Support s = (Support)support;
        if (s.getValue() != this.getValue()) {
            return false;
        }
        if (!s.getType().equals(this.getType())) {
            return false;
        }
        return s.getInterval() == this.getInterval();
    }

    public StringBuffer toPhyloXML(int level) {
        StringBuffer sb = new StringBuffer();
        sb.append("<support type=\"");
        sb.append(this.getType());
        sb.append("\"");
        if (this.getInterval() != Double.MIN_VALUE) {
            sb.append(" interval=\"");
            sb.append(this.getInterval());
            sb.append("\"");
        }
        sb.append(">");
        sb.append(this.getValue());
        sb.append("</support>");
        return sb;
    }

    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getType());
        sb.append(": ");
        sb.append(this.getValue());
        if (this.getInterval() != Double.MIN_VALUE) {
            sb.append(" [");
            sb.append(this.getInterval());
            sb.append("]");
        }
        return sb;
    }

    public StringBuffer asSimpleText() {
        return new StringBuffer().append(this.getValue());
    }

    public double getInterval() {
        return this._interval;
    }

    public void setInterval(double interval) {
        this._interval = interval;
    }

    public double getValue() {
        return this._value;
    }

    public void setValue(double value) {
        this._value = value;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }
}

