/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class TagValueUnit
implements Cloneable {
    public static final byte UNKNOWN_TYPE = 0;
    public static final byte STRING_TYPE = 1;
    public static final byte LONG_TYPE = 2;
    public static final byte DOUBLE_TYPE = 3;
    public static final byte BOOLEAN_TYPE = 4;
    public static final byte URL_TYPE = 5;
    private final Object _value;
    private final String _tag;
    private final String _unit;
    private final byte _type;

    public TagValueUnit(String tag, String value, String unit) {
        this._tag = tag;
        this._value = value;
        this._unit = unit;
        this._type = 1;
    }

    public TagValueUnit(String tag, long value, String unit) {
        this._tag = tag;
        this._value = new Long(value);
        this._unit = unit;
        this._type = (byte)2;
    }

    public TagValueUnit(String tag, double value, String unit) {
        this._tag = tag;
        this._value = new Double(value);
        this._unit = unit;
        this._type = (byte)3;
    }

    public TagValueUnit(String tag, boolean value) {
        this._tag = tag;
        this._value = new Boolean(value);
        this._unit = "";
        this._type = (byte)4;
    }

    public TagValueUnit(String tag, URL value) {
        this._tag = tag;
        this._value = value;
        this._unit = "";
        this._type = (byte)5;
    }

    private TagValueUnit(String tag, Object value, String unit, byte type) {
        this._tag = tag;
        this._value = value;
        this._unit = unit;
        this._type = type;
    }

    protected Object clone() {
        return new TagValueUnit(this.getTag(), this.getValue(), this.getUnit(), this.getType());
    }

    public static TagValueUnit createInstance(String nhx) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(nhx, "=");
        int tokens = st.countTokens();
        String error = "Error in NHX custom tag format:\nExpected: X[N|B|C]=[S|D|L|B|U]=<tag>=<value>[=<unit>]\nGot: \"" + nhx + "\" instead";
        if (tokens != 4 && tokens != 5) {
            throw new IllegalArgumentException(error);
        }
        String first = st.nextToken();
        if (!(first.equals("XN") || first.equals("XB") || first.equals("XC"))) {
            throw new IllegalArgumentException(error);
        }
        String type_string = st.nextToken();
        String tag_string = st.nextToken();
        String value_string = st.nextToken();
        String unit_string = "";
        if (tokens == 5) {
            unit_string = st.nextToken();
        }
        TagValueUnit tvu = null;
        if (type_string.equals("S")) {
            tvu = new TagValueUnit(tag_string, value_string, unit_string);
        } else {
            if (type_string.equals("D")) {
                try {
                    tvu = new TagValueUnit(tag_string, Double.parseDouble(value_string), unit_string);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Error in NHX custom tag format:\nCould not parse double from " + value_string);
                }
            }
            if (type_string.equals("L")) {
                try {
                    tvu = new TagValueUnit(tag_string, Long.parseLong(value_string), unit_string);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Error in NHX custom tag format:\nCould not parse integer from " + value_string);
                }
            }
            if (type_string.equals("B")) {
                boolean b;
                if (value_string.equals("T")) {
                    b = true;
                } else if (value_string.equals("F")) {
                    b = false;
                } else {
                    throw new IllegalArgumentException("Error in NHX custom tag format:\nIf type is \"B\" (boolean), value must be either \"T\" or \"F\"\n[\"" + nhx + "\"]");
                }
                if (!unit_string.equals("")) {
                    throw new IllegalArgumentException("Error in NHX custom tag format:\nIf type is \"B\" (boolean), unit must not be set\n[\"" + nhx + "\"]");
                }
                tvu = new TagValueUnit(tag_string, b);
            } else if (type_string.equals("U")) {
                URL url;
                try {
                    url = new URL(value_string.replace('*', ':'));
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Error in NHX custom tag format:\nCould not parse URL from " + value_string);
                }
                if (!unit_string.equals("")) {
                    throw new IllegalArgumentException("Error in NHX custom tag format:\nIf type is \"U\" (URL), unit must not be set\n[\"" + nhx + "\"]");
                }
                tvu = new TagValueUnit(tag_string, url);
            } else {
                throw new IllegalArgumentException(error);
            }
        }
        return tvu;
    }

    public String getTag() {
        return this._tag;
    }

    public Object getValue() {
        return this._value;
    }

    public String getUnit() {
        return this._unit;
    }

    public byte getType() {
        return this._type;
    }

    public String toNHX(boolean for_node) {
        String type = "";
        StringBuffer nhx = new StringBuffer();
        nhx.append(":X");
        if (for_node) {
            nhx.append("N=");
        } else {
            nhx.append("B=");
        }
        if (this.getType() == 1) {
            type = "S";
        } else if (this.getType() == 2) {
            type = "L";
        } else if (this.getType() == 3) {
            type = "D";
        } else if (this.getType() == 4) {
            type = "B";
        } else if (this.getType() == 5) {
            type = "U";
        }
        nhx.append(type);
        nhx.append("=");
        nhx.append(this.getTag());
        nhx.append("=");
        if (this.getType() == 4) {
            if (((Boolean)this.getValue()).booleanValue()) {
                nhx.append("T");
            } else {
                nhx.append("F");
            }
        } else if (this.getType() == 5) {
            nhx.append(this.getValue().toString().replace(':', '*'));
        } else {
            nhx.append(this.getValue());
        }
        if (!this.getUnit().equals("")) {
            nhx.append("=");
            nhx.append(this.getUnit());
        }
        return nhx.toString();
    }

    public String toXML(boolean for_node, boolean for_parent_branch, boolean for_clade) {
        StringBuffer xml = new StringBuffer();
        xml.append("<");
        xml.append(this.getTag());
        xml.append(" ");
        xml.append("type");
        xml.append("=\"");
        if (this.getType() == 1) {
            xml.append("string");
        } else if (this.getType() == 3) {
            xml.append("double");
        } else if (this.getType() == 2) {
            xml.append("long");
        } else if (this.getType() == 4) {
            xml.append("boolean");
        } else if (this.getType() == 5) {
            xml.append("url");
        }
        xml.append("\" unit=\"");
        xml.append(this.getUnit());
        xml.append("\" ");
        xml.append("property");
        xml.append("=\"");
        if (for_node) {
            xml.append("node");
        } else if (for_parent_branch) {
            xml.append("parent_branch");
        } else if (for_clade) {
            xml.append("clade");
        }
        xml.append("\"");
        xml.append(">");
        if (this.getType() == 4) {
            if (((Boolean)this.getValue()).booleanValue()) {
                xml.append("true");
            } else {
                xml.append("false");
            }
        } else {
            xml.append(this.getValue());
        }
        xml.append("</");
        xml.append(this.getTag());
        xml.append(">");
        return xml.toString();
    }

    public String toString() {
        String type = "";
        if (this.getType() == 1) {
            type = "String";
        } else if (this.getType() == 2) {
            type = "integer";
        } else if (this.getType() == 3) {
            type = "double";
        } else if (this.getType() == 4) {
            type = "boolean";
        } else if (this.getType() == 5) {
            type = "URL";
        }
        String s = "Tag  : " + this.getTag() + "\n" + "Value: " + this.getValue() + "\n" + "Unit : " + this.getUnit() + "\n" + "[Type: " + type + "]";
        return s;
    }
}

