/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.forester.phylogeny.Edge;
import org.forester.phylogeny.PhylogenyBranch;
import org.forester.phylogeny.TagValueUnit;
import org.forester.phylogeny.iterators.ChildNodeIteratorForward;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.parsers.PhylogenyParserException;

public class PhylogenyNode {
    public static final double DISTANCE_DEFAULT = -99.0;
    public static final double BOOTSTRAP_DEFAULT = -99.0;
    public static final double DISTANCE_NULL = -100.0;
    public static final int SEQ_X = -11;
    public static final int ORTHOLOGOUS_DEFAULT = -99;
    public static final int PARENT_BRANCH_WIDTH_DEFAULT = -99;
    public static final Color PARENT_BRANCH_COLOR_DEFAULT = null;
    private static int _node_count = 0;
    private int _indicator;
    private int _id;
    private String _taxo_id;
    private double _bootstrap;
    private int _sum_ext_nodes;
    private int _orthologous;
    private int _super_orthologous;
    private int _subtree_neighborings;
    private int _parent_branch_width;
    private int _x;
    private int _y;
    private String _seq_name;
    private String _ec_number;
    private String _taxonomy;
    private int _seq_name_x;
    private int _seq_name_y;
    private int _seq_name_width;
    private int _seq_name_height;
    private double _distance_parent;
    private boolean _duplication_or_spec_assigned;
    private boolean _duplication;
    private boolean _possible_duplication;
    private boolean _collapse;
    private PhylogenyNode _parent;
    private PhylogenyNode _link;
    private ArrayList _connected_edges;
    private Color _color;
    private Vector _vector;
    private Hashtable _tag_value_units_node;
    private Hashtable _tag_value_units_parent_branch;

    public PhylogenyNode(String s) throws PhylogenyParserException {
        this.init();
        this.parseNHX(s);
        this.setID(PhylogenyNode.getNodeCount());
        PhylogenyNode.increaseNodeCount();
        this.setSumExtNodes(1);
    }

    public PhylogenyNode() {
        this.init();
        this.setID(PhylogenyNode.getNodeCount());
        PhylogenyNode.increaseNodeCount();
        this.setSumExtNodes(1);
    }

    private void init() {
        this.setConnectedEdges(new ArrayList());
        this._parent = null;
        this._id = 0;
        this.initializeData();
    }

    public void parseNHX(String s) throws PhylogenyParserException {
        if (s != null && s.length() > 0) {
            int ob = 0;
            int cb = 0;
            String a = "";
            String b = "";
            StringTokenizer t = null;
            ob = s.indexOf("[");
            cb = s.indexOf("]");
            if (ob > -1) {
                a = "";
                b = "";
                if (cb < 0) {
                    throw new PhylogenyParserException("Error in NHX format: No closing ]");
                }
                if (s.indexOf("&&NHX") == ob + 1) {
                    a = s.substring(0, ob);
                    b = s.substring(ob + 6, cb);
                } else {
                    a = s.substring(0, ob);
                }
                s = a + b;
                if (s.indexOf("[") > -1 || s.indexOf("]") > -1) {
                    throw new PhylogenyParserException("Error in NHX format: More than one ] or [");
                }
            }
            if ((t = new StringTokenizer(s, ":")).countTokens() >= 1) {
                if (!s.startsWith(":")) {
                    this.setSeqName(t.nextToken());
                }
                while (t.hasMoreTokens()) {
                    TagValueUnit tvu;
                    s = t.nextToken();
                    if (s.startsWith("S=")) {
                        this.setTaxonomy(s.substring(2));
                        continue;
                    }
                    if (s.startsWith("E=")) {
                        this.setECnumber(s.substring(2));
                        continue;
                    }
                    if (s.startsWith("D=")) {
                        if (s.charAt(2) == 'Y') {
                            this.setDuplication(true);
                            continue;
                        }
                        if (s.charAt(2) == 'N') {
                            this.setDuplication(false);
                            continue;
                        }
                        throw new PhylogenyParserException("Error in NHX format: :D=Y or :D=N");
                    }
                    if (s.startsWith("Co=")) {
                        if (s.charAt(3) == 'Y') {
                            this.setCollapse(true);
                            continue;
                        }
                        if (s.charAt(3) == 'N') {
                            this.setCollapse(false);
                            continue;
                        }
                        throw new PhylogenyParserException("Error in NHX format: :Co=Y or :Co=N");
                    }
                    if (s.startsWith("B=")) {
                        this.setBootstrap(Integer.parseInt(s.substring(2)));
                        continue;
                    }
                    if (s.startsWith("T=")) {
                        this.setTaxonomyID(s.substring(2));
                        continue;
                    }
                    if (s.startsWith("O=")) {
                        this.setOrthologous(Integer.parseInt(s.substring(2)));
                        continue;
                    }
                    if (s.startsWith("SO=")) {
                        this.setSuperOrthologous(Integer.parseInt(s.substring(3)));
                        continue;
                    }
                    if (s.startsWith("SN=")) {
                        this.setSubtreeNeighborings(Integer.parseInt(s.substring(3)));
                        continue;
                    }
                    if (s.startsWith("W=")) {
                        this.setParentBranchWidth(Integer.parseInt(s.substring(2)));
                        continue;
                    }
                    if (s.startsWith("C=")) {
                        Color c = null;
                        c = PhylogenyNode.stringToColor(s.substring(2));
                        if (c == null) continue;
                        this.setColor(c);
                        continue;
                    }
                    if (s.startsWith("XN=")) {
                        tvu = TagValueUnit.createInstance(s);
                        this.addCustomTagValue(tvu, true);
                        continue;
                    }
                    if (s.startsWith("XB=")) {
                        tvu = TagValueUnit.createInstance(s);
                        this.addCustomTagValue(tvu, false);
                        continue;
                    }
                    this.setDistanceToParent(Double.valueOf(s));
                }
            }
        }
    }

    public PhylogenyNode copyNodeData() {
        PhylogenyNode node = new PhylogenyNode();
        PhylogenyNode.decreaseNodeCount();
        node._id = this._id;
        node._bootstrap = this._bootstrap;
        node._sum_ext_nodes = this._sum_ext_nodes;
        node._indicator = this._indicator;
        node._x = this._x;
        node._y = this._y;
        node._duplication = this._duplication;
        node._seq_name = new String(this._seq_name);
        node._ec_number = new String(this._ec_number);
        node._taxonomy = new String(this._taxonomy);
        node._taxo_id = this._taxo_id;
        node._orthologous = this._orthologous;
        node._super_orthologous = this._super_orthologous;
        node._subtree_neighborings = this._subtree_neighborings;
        node._distance_parent = this._distance_parent;
        node._duplication_or_spec_assigned = this._duplication_or_spec_assigned;
        node._collapse = this._collapse;
        node._link = this._link;
        node._vector = this._vector;
        node._parent_branch_width = this._parent_branch_width;
        node._color = this._color;
        node._possible_duplication = this._possible_duplication;
        if (this._tag_value_units_node != null) {
            node._tag_value_units_node = (Hashtable)this._tag_value_units_node.clone();
        }
        if (this._tag_value_units_parent_branch != null) {
            node._tag_value_units_parent_branch = (Hashtable)this._tag_value_units_parent_branch.clone();
        }
        return node;
    }

    public void initializeData() {
        this._indicator = 0;
        this._taxo_id = "";
        this._bootstrap = -99.0;
        this._orthologous = -99;
        this._super_orthologous = -99;
        this._subtree_neighborings = -99;
        this._x = 0;
        this._y = 0;
        this._seq_name = "";
        this._ec_number = "";
        this._taxonomy = "";
        this._distance_parent = -99.0;
        this._duplication_or_spec_assigned = false;
        this._duplication = false;
        this._collapse = false;
        this._link = null;
        this._vector = null;
        this._parent_branch_width = -99;
        this._color = PARENT_BRANCH_COLOR_DEFAULT;
        this._tag_value_units_node = null;
        this._tag_value_units_parent_branch = null;
        this._possible_duplication = false;
    }

    static PhylogenyNode copyTree(PhylogenyNode source) {
        if (source == null) {
            return null;
        }
        PhylogenyNode newnode = source.copyNodeData();
        if (!source.isExternal()) {
            newnode.setChild1(PhylogenyNode.copyTree(source.getChildNode1()));
            newnode.setChild2(PhylogenyNode.copyTree(source.getChildNode2()));
        }
        return newnode;
    }

    public static int getNodeCount() {
        return _node_count;
    }

    public static void setNodeCount(int i) {
        _node_count = i;
    }

    public static void increaseNodeCount() {
        ++_node_count;
    }

    static void decreaseNodeCount() {
        --_node_count;
    }

    public int getID() {
        return this._id;
    }

    public void setID(int i) {
        this._id = i;
    }

    public double getBootstrap() {
        return this._bootstrap;
    }

    public void setBootstrap(double d) {
        if (d < 0.0 && d != -99.0) {
            this._bootstrap = 0.0;
            System.err.print("PhylogenyNode: setBootstrap( int ): WARNING: Negative ");
            System.err.println("_bootstrap has been replaced by _bootstrap 0!\n");
        } else {
            this._bootstrap = d;
        }
    }

    public void setTaxonomyID(String id) {
        this._taxo_id = id;
    }

    public String getTaxonomyID() {
        return this._taxo_id;
    }

    public boolean isPseudoNode() {
        return this.getDistanceToParent() == -100.0;
    }

    public boolean isExternal() {
        return this.getNumberOfChildNodes() < 1;
    }

    public boolean isInternal() {
        return !this.isExternal();
    }

    public boolean isRoot() {
        return this._parent == null;
    }

    public int getSumExtNodes() {
        return this._sum_ext_nodes;
    }

    public void setSumExtNodes(int i) {
        this._sum_ext_nodes = i;
    }

    public int getIndicator() {
        return this._indicator;
    }

    public void setIndicator(int i) {
        this._indicator = i;
    }

    public int getXcoord() {
        return this._x;
    }

    public void setXcoord(int i) {
        this._x = i;
    }

    public int getYcoord() {
        return this._y;
    }

    public void setSeqNameRect(int x, int y, int width, int height) {
        this._seq_name_x = x;
        this._seq_name_y = y;
        this._seq_name_width = width;
        this._seq_name_height = height;
    }

    public boolean isInSeqNameRect(int x, int y) {
        return x > this._seq_name_x && x < this._seq_name_x + this._seq_name_width && y > this._seq_name_y && y < this._seq_name_y + this._seq_name_height;
    }

    public void setYcoord(int i) {
        this._y = i;
    }

    public boolean isDuplication() {
        return this._duplication;
    }

    public void setDuplication(boolean b) {
        this._duplication = b;
        this.setDuplicationOrSpecAssigned(true);
    }

    public void setSeqName(String s) {
        this._seq_name = s.trim();
    }

    public String getSeqName() {
        return this._seq_name;
    }

    public void setECnumber(String s) {
        this._ec_number = s.trim();
    }

    public String getECnumber() {
        return this._ec_number;
    }

    public void setTaxonomy(String s) {
        this._taxonomy = s.trim();
    }

    public String getTaxonomy() {
        return this._taxonomy;
    }

    public double getDistanceToParent() {
        return this._distance_parent;
    }

    public void setDistanceToParent(double d) {
        this._distance_parent = d < 0.0 && d != -99.0 && d != -100.0 ? 0.0 : d;
    }

    public boolean isDuplicationOrSpecAssigned() {
        return this._duplication_or_spec_assigned;
    }

    public void setDuplicationOrSpecAssigned(boolean b) {
        this._duplication_or_spec_assigned = b;
    }

    public void setCollapse(boolean b) {
        this._collapse = b;
    }

    public boolean isCollapse() {
        return this._collapse;
    }

    public PhylogenyNode getPreviousExternalNode() {
        if (this.isInternal()) {
            throw new UnsupportedOperationException("Cannot get the previous external node for an internal node.");
        }
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot get the previous external node for a root node.");
        }
        if (this.isFirstExternalNode()) {
            throw new UnsupportedOperationException("Attempt to get previous external node of the first external node.");
        }
        int index = this.getChildNodeIndex();
        PhylogenyNode previous_node = this;
        PhylogenyNode current_node = this.getParent();
        while (!current_node.isRoot() && (current_node.getNumberOfChildNodes() == 1 || previous_node.isFirstChildNode())) {
            index = current_node.getChildNodeIndex();
            previous_node = current_node;
            current_node = current_node.getParent();
        }
        current_node = current_node.getChildNode(index - 1);
        while (current_node.isInternal()) {
            current_node = current_node.getLastChildNode();
        }
        return current_node;
    }

    public PhylogenyNode getNextExternalNode() {
        if (this.isInternal()) {
            throw new UnsupportedOperationException("Cannot get the next external node for an internal node.");
        }
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot get the next external node for a root node.");
        }
        if (this.isLastExternalNode()) {
            throw new UnsupportedOperationException("Attempt to get next external node of tha last external node.");
        }
        int index = this.getChildNodeIndex();
        PhylogenyNode previous_node = this;
        PhylogenyNode current_node = this.getParent();
        while (!current_node.isRoot() && (current_node.getNumberOfChildNodes() == 1 || previous_node.isLastChildNode())) {
            index = current_node.getChildNodeIndex();
            previous_node = current_node;
            current_node = current_node.getParent();
        }
        current_node = current_node.getChildNode(index + 1);
        while (current_node.isInternal()) {
            current_node = current_node.getFirstChildNode();
        }
        return current_node;
    }

    public boolean isFirstExternalNode() {
        if (this.isInternal()) {
            return false;
        }
        PhylogenyNode node = this;
        while (!node.isRoot()) {
            if (!node.isFirstChildNode()) {
                return false;
            }
            node = node.getParent();
        }
        return true;
    }

    public boolean isLastExternalNode() {
        if (this.isInternal()) {
            return false;
        }
        PhylogenyNode node = this;
        while (!node.isRoot()) {
            if (!node.isLastChildNode()) {
                return false;
            }
            node = node.getParent();
        }
        return true;
    }

    public int getNumberOfChildNodes() {
        int counter = 0;
        if (this.getConnectedEdges() != null) {
            for (int i = 0; i < this.getConnectedEdges().size(); ++i) {
                Edge edge = (Edge)this.getConnectedEdges().get(i);
                if (edge instanceof PhylogenyBranch && ((PhylogenyBranch)edge).isDirectionTowards(this)) continue;
                ++counter;
            }
        }
        return counter;
    }

    public int getNumberOfParents() {
        int counter = 0;
        if (this.getConnectedEdges() != null) {
            for (int i = 0; i < this.getConnectedEdges().size(); ++i) {
                Edge edge = (Edge)this.getConnectedEdges().get(i);
                if (!(edge instanceof PhylogenyBranch) || !((PhylogenyBranch)edge).isDirectionTowards(this)) continue;
                ++counter;
            }
        }
        return counter;
    }

    public PhylogenyNode getChildNode1() {
        return this.getFirstChildNode();
    }

    public PhylogenyNode getChildNode2() {
        return this.getChildNode(1);
    }

    public PhylogenyNode getFirstChildNode() {
        return this.getChildNode(0);
    }

    public PhylogenyNode getLastChildNode() {
        return this.getChildNode(this.getNumberOfChildNodes() - 1);
    }

    public boolean isLastChildNode() {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot determine whether the root is the last child node of its _parent.");
        }
        return this.getChildNodeIndex() == this.getParent().getNumberOfChildNodes() - 1;
    }

    public boolean isFirstChildNode() {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot determine whether the root is the first child node of its _parent.");
        }
        return this.getChildNodeIndex() == 0;
    }

    public PhylogenyNode getChildNode(int i) {
        if (this.isExternal()) {
            throw new UnsupportedOperationException("Cannot get the child node for a external node.");
        }
        if (i >= this.getNumberOfChildNodes() || i < 0) {
            throw new IllegalArgumentException("Attempt to get child node " + i + " of a node with " + this.getNumberOfChildNodes() + " child nodes.");
        }
        return ((PhylogenyBranch)this.getConnectedEdges().get(i)).getConnectedNode(this);
    }

    public int getChildNodeIndex() {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot get the child index for a root node.");
        }
        for (int i = 0; i < this.getParent().getNumberOfChildNodes(); ++i) {
            if (this.getParent().getChildNode(i) != this) continue;
            return i;
        }
        throw new RuntimeException("Unexpected exception: Could not determine the child index for node:\n" + this);
    }

    public void setChild1(PhylogenyNode n) {
        this.setChildNode(0, n);
    }

    public void setChild2(PhylogenyNode n) {
        this.setChildNode(1, n);
    }

    public void setChildNode(int i, PhylogenyNode node) {
        if (this.getNumberOfChildNodes() <= i) {
            this.addChildNode(node);
        } else {
            PhylogenyBranch b = new PhylogenyBranch(node, this, true);
            this.getConnectedEdges().set(i, b);
        }
    }

    private void addChildNode(PhylogenyNode node) {
        PhylogenyBranch b = new PhylogenyBranch(node, this, true);
        this.getConnectedEdges().add(b);
    }

    public void addAsChild(PhylogenyNode node) {
        this.addChildNode(node);
        node.setParent(this);
    }

    public PhylogenyNode getParent() {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot get the _parent of a root node.");
        }
        return this._parent;
    }

    public void setParent(PhylogenyNode n) {
        this._parent = n;
    }

    public void setLink(PhylogenyNode n) {
        this._link = n;
    }

    public PhylogenyNode getLink() {
        return this._link;
    }

    public void setVector(Vector v) {
        this._vector = v;
    }

    public Vector getVector() {
        return this._vector;
    }

    public int getOrthologous() {
        return this._orthologous;
    }

    public void setOrthologous(int i) {
        this._orthologous = i;
    }

    public int getSuperOrthologous() {
        return this._super_orthologous;
    }

    public void setSuperOrthologous(int i) {
        this._super_orthologous = i;
    }

    public int getSubtreeNeighborings() {
        return this._subtree_neighborings;
    }

    public void setSubtreeNeighborings(int i) {
        this._subtree_neighborings = i;
    }

    public boolean isParentBranchWidthAssigned() {
        return this.getParentBranchWidth() != -99;
    }

    public int getParentBranchWidth() {
        return this._parent_branch_width;
    }

    public void setParentBranchWidth(int parent_branch_width) {
        this._parent_branch_width = parent_branch_width;
    }

    public boolean isParentBranchColorAssigned() {
        return this.getColor() != PARENT_BRANCH_COLOR_DEFAULT;
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public void setColor(int red, int green, int blue) {
        this.setColor(new Color(red, green, blue));
    }

    void setNodeCustomTagValueUnits(Hashtable custom_tag_value_units) {
        this._tag_value_units_node = custom_tag_value_units;
    }

    Hashtable getNodeCustomTagValueUnits() {
        return this._tag_value_units_node;
    }

    void setParentBranchCustomTagValueUnits(Hashtable custom_tag_value_units) {
        this._tag_value_units_parent_branch = custom_tag_value_units;
    }

    Hashtable getParentBranchCustomTagValueUnits() {
        return this._tag_value_units_parent_branch;
    }

    public void removeCustomTagValue(String tag) {
        if (this.getNodeCustomTagValueUnits() == null) {
            return;
        }
        if (this.customTagExists(tag)) {
            this.getNodeCustomTagValueUnits().remove(tag);
        }
    }

    public void addCustomTagValue(TagValueUnit tag_value_unit, boolean for_node) throws IllegalArgumentException {
        if (this.getNodeCustomTagValueUnits() == null) {
            this.setNodeCustomTagValueUnits(new Hashtable());
        }
        if (this.getParentBranchCustomTagValueUnits() == null) {
            this.setParentBranchCustomTagValueUnits(new Hashtable());
        }
        if (this.getNodeCustomTagValueUnits().containsKey(tag_value_unit.getTag()) || this.getParentBranchCustomTagValueUnits().containsKey(tag_value_unit.getTag())) {
            throw new IllegalArgumentException("Tag \"" + tag_value_unit.getTag() + "\" is already present");
        }
        if (for_node) {
            this.getNodeCustomTagValueUnits().put(tag_value_unit.getTag(), tag_value_unit);
        } else {
            this.getParentBranchCustomTagValueUnits().put(tag_value_unit.getTag(), tag_value_unit);
        }
    }

    public TagValueUnit getCustomTagValue(String tag) throws IllegalArgumentException {
        TagValueUnit tvu = null;
        if (this.getNodeCustomTagValueUnits() != null) {
            tvu = (TagValueUnit)this.getNodeCustomTagValueUnits().get(tag);
        }
        if (tvu != null) {
            return tvu;
        }
        if (this.getParentBranchCustomTagValueUnits() != null) {
            tvu = (TagValueUnit)this.getParentBranchCustomTagValueUnits().get(tag);
        }
        if (tvu != null) {
            return tvu;
        }
        throw new IllegalArgumentException("Tag \"" + tag + "\" is not present");
    }

    public TagValueUnit[] getCustomTagValueUnitsAsArray() {
        if (this.getParentBranchCustomTagValueUnits() == null && this.getNodeCustomTagValueUnits() == null) {
            return new TagValueUnit[0];
        }
        Enumeration e1 = null;
        Enumeration e2 = null;
        int size = 0;
        if (this.getNodeCustomTagValueUnits() != null) {
            e1 = this.getNodeCustomTagValueUnits().elements();
            size += this.getNodeCustomTagValueUnits().size();
        }
        if (this.getParentBranchCustomTagValueUnits() != null) {
            e2 = this.getParentBranchCustomTagValueUnits().elements();
            size += this.getParentBranchCustomTagValueUnits().size();
        }
        TagValueUnit[] a = new TagValueUnit[size];
        int i = 0;
        while (e1 != null && e1.hasMoreElements()) {
            a[i++] = (TagValueUnit)e1.nextElement();
        }
        while (e2 != null && e2.hasMoreElements()) {
            a[i++] = (TagValueUnit)e2.nextElement();
        }
        return a;
    }

    public TagValueUnit[] getParentBranchCustomTagValueUnitsAsArray() {
        if (this.getParentBranchCustomTagValueUnits() == null) {
            return new TagValueUnit[0];
        }
        Enumeration e = this.getParentBranchCustomTagValueUnits().elements();
        TagValueUnit[] a = new TagValueUnit[this.getParentBranchCustomTagValueUnits().size()];
        int i = 0;
        while (e.hasMoreElements()) {
            a[i++] = (TagValueUnit)e.nextElement();
        }
        return a;
    }

    public TagValueUnit[] getNodeCustomTagValueUnitsAsArray() {
        if (this.getNodeCustomTagValueUnits() == null) {
            return new TagValueUnit[0];
        }
        Enumeration e = this.getNodeCustomTagValueUnits().elements();
        TagValueUnit[] a = new TagValueUnit[this.getNodeCustomTagValueUnits().size()];
        int i = 0;
        while (e.hasMoreElements()) {
            a[i++] = (TagValueUnit)e.nextElement();
        }
        return a;
    }

    public String[] getCustomTagNames() {
        if (this.getNodeCustomTagValueUnits() == null && this.getParentBranchCustomTagValueUnits() == null) {
            return new String[0];
        }
        TagValueUnit[] tvu = this.getCustomTagValueUnitsAsArray();
        String[] tags = new String[tvu.length];
        for (int i = 0; i < tvu.length; ++i) {
            tags[i] = tvu[i].getTag();
        }
        return tags;
    }

    public boolean customTagExists(String tag) {
        boolean exists = false;
        if (this.getNodeCustomTagValueUnits() != null) {
            Enumeration e = this.getNodeCustomTagValueUnits().elements();
            while (e.hasMoreElements() && !exists) {
                TagValueUnit tvu = (TagValueUnit)e.nextElement();
                if (!tvu.getTag().equalsIgnoreCase(tag)) continue;
                exists = true;
            }
        }
        return exists;
    }

    public Vector getAllExternalChildren() {
        Vector<PhylogenyNode> nodes = new Vector<PhylogenyNode>();
        PhylogenyNode node1 = null;
        PhylogenyNode node2 = null;
        if (this.isExternal()) {
            nodes.addElement(this);
            nodes.trimToSize();
            return nodes;
        }
        node1 = this;
        while (!node1.isExternal()) {
            node1 = node1.getChildNode1();
        }
        node2 = this;
        while (!node2.isExternal()) {
            node2 = node2.getChildNode2();
        }
        do {
            nodes.addElement(node1);
        } while ((node1 = node1.getNextExternalNode()) != node2);
        nodes.addElement(node1);
        nodes.trimToSize();
        return nodes;
    }

    public Vector getAllChildren() {
        Vector<PhylogenyNode> nodes = new Vector<PhylogenyNode>();
        if (this.isExternal()) {
            return null;
        }
        PhylogenyNode node1 = this;
        while (!node1.isExternal()) {
            node1 = node1.getChildNode1();
        }
        PhylogenyNode node3 = this;
        while (!node3.isExternal()) {
            node3 = node3.getChildNode2();
        }
        this.setIndicatorsToZero();
        do {
            PhylogenyNode node2 = node1;
            do {
                if (node2.getIndicator() != 0) continue;
                node2.setIndicator(1);
                if (node2.isPseudoNode() || node2 == this) continue;
                nodes.addElement(node2);
            } while ((node2 = node2.getParent()) != this);
        } while ((node1 = node1.getNextExternalNode()) != null && node1.getPreviousExternalNode() != node3);
        nodes.trimToSize();
        return nodes;
    }

    public boolean isParent(PhylogenyNode n) {
        Vector children = this.getAllChildren();
        return children == null ? false : children.contains(n);
    }

    public PhylogenyNode[] copyAllExtChildren() {
        PhylogenyNode[] nodes;
        int i = 1;
        PhylogenyNode first = this;
        PhylogenyNode last = this;
        if (this.isExternal()) {
            nodes = new PhylogenyNode[]{this.copyNodeData()};
        } else {
            while (!first.isExternal()) {
                first = first.getChildNode1();
            }
            while (!last.isExternal()) {
                last = last.getChildNode2();
            }
            PhylogenyNode node = first;
            do {
                node = node.getNextExternalNode();
                ++i;
            } while (node != last);
            nodes = new PhylogenyNode[i];
            node = first;
            for (i = 0; i < nodes.length; ++i) {
                nodes[i] = node.copyNodeData();
                node = node.getNextExternalNode();
            }
        }
        return nodes;
    }

    public String toNewHampshire(boolean simple_nh) {
        StringBuffer sb = new StringBuffer(40);
        if (this.getSeqName().length() > 0) {
            if (simple_nh) {
                String tmp = this.getSeqName();
                if (tmp.length() > 10) {
                    tmp = tmp.substring(0, 11);
                }
                if (tmp.indexOf(47) > 0) {
                    tmp = tmp.substring(0, tmp.indexOf(47));
                }
                sb.append(tmp);
            } else {
                sb.append(this.getSeqName());
            }
        }
        if (this.getDistanceToParent() != -99.0) {
            sb.append(":");
            sb.append(this.getDistanceToParent());
        }
        return sb.toString();
    }

    public String toNewHampshireX() {
        int i;
        TagValueUnit[] a;
        StringBuffer s = new StringBuffer(200);
        StringBuffer s_nhx = new StringBuffer(200);
        if (!this.getSeqName().equals("")) {
            s.append(this.getSeqName());
        }
        if (this.getDistanceToParent() != -99.0) {
            s.append(":");
            s.append(this.getDistanceToParent());
        }
        if (!this.getTaxonomy().equals("")) {
            s_nhx.append(":S=");
            s_nhx.append(this.getTaxonomy());
        }
        if (!this.getTaxonomyID().equals("")) {
            s_nhx.append(":T=");
            s_nhx.append(this.getTaxonomyID());
        }
        if (!this.getECnumber().equals("")) {
            s_nhx.append(":E=");
            s_nhx.append(this.getECnumber());
        }
        if (!this.isExternal()) {
            if (this.isDuplicationOrSpecAssigned()) {
                if (this.isDuplication()) {
                    s_nhx.append(":D=Y");
                } else {
                    s_nhx.append(":D=N");
                }
            }
            if (this.getBootstrap() != -99.0) {
                s_nhx.append(":B=");
                s_nhx.append(this.getBootstrap());
            }
            if (this.isCollapse()) {
                s_nhx.append(":Co=Y");
            }
        } else {
            if (this.getOrthologous() != -99) {
                s_nhx.append(":O=");
                s_nhx.append(this.getOrthologous());
            }
            if (this.getSuperOrthologous() != -99) {
                s_nhx.append(":SO=");
                s_nhx.append(this.getSuperOrthologous());
            }
            if (this.getSubtreeNeighborings() != -99) {
                s_nhx.append(":SN=");
                s_nhx.append(this.getSubtreeNeighborings());
            }
        }
        if (this.getParentBranchWidth() != -99) {
            s_nhx.append(":W=");
            s_nhx.append(this.getParentBranchWidth());
        }
        if (this.getColor() != PARENT_BRANCH_COLOR_DEFAULT) {
            Color c = this.getColor();
            s_nhx.append(":C=");
            s_nhx.append(c.getRed());
            s_nhx.append(".");
            s_nhx.append(c.getGreen());
            s_nhx.append(".");
            s_nhx.append(c.getBlue());
        }
        if (this.getNodeCustomTagValueUnits() != null) {
            a = this.getNodeCustomTagValueUnitsAsArray();
            for (i = 0; i < a.length; ++i) {
                s_nhx.append(a[i].toNHX(true));
            }
        }
        if (this.getParentBranchCustomTagValueUnits() != null) {
            a = this.getParentBranchCustomTagValueUnitsAsArray();
            for (i = 0; i < a.length; ++i) {
                s_nhx.append(a[i].toNHX(false));
            }
        }
        if (s_nhx.length() > 0) {
            s.append("[&&NHX");
            s.append(s_nhx);
            s.append("]");
        }
        return s.toString();
    }

    public String toString() {
        TagValueUnit[] tvu;
        String s = "";
        s = !this.isPseudoNode() ? "\nSeq name                : " + this.getSeqName() : "\nSeq name                :  *pseudo node*";
        s = s + "\nEC number               : " + this.getECnumber();
        s = s + "\nSpecies                 : " + this.getTaxonomy();
        s = !this.getTaxonomyID().equals("") ? s + "\nTaxonomy ID             : " + this.getTaxonomyID() : s + "\nTaxonomy ID             : n/a";
        s = !this.isPseudoNode() && this.getDistanceToParent() != -99.0 ? s + "\nDistance to _parent      : " + this.getDistanceToParent() : s + "\nDistance to _parent      : n/a";
        s = this.getBootstrap() != -99.0 ? s + "\nBootstrap value         : " + this.getBootstrap() : s + "\nBootstrap value         : n/a";
        s = this.isDuplicationOrSpecAssigned() ? s + "\nDuplication             : " + this.isDuplication() : s + "\nDuplication             : n/a";
        s = this.getParentBranchWidth() != -99 ? s + "\nParent branch width     : " + this.getParentBranchWidth() : s + "\nParent branch width     : n/a";
        if (this.getColor() != PARENT_BRANCH_COLOR_DEFAULT) {
            Color c = this.getColor();
            s = s + "\nParent branch color     : " + c.getRed() + "." + c.getGreen() + "." + c.getBlue();
        } else {
            s = s + "\nParent branch color     : n/a";
        }
        if (this.isExternal()) {
            if (this.getOrthologous() != -99) {
                s = s + "\nOrthologous             : " + this.getOrthologous();
            }
            if (this.getSuperOrthologous() != -99) {
                s = s + "\nSuper _orthologous       : " + this.getSuperOrthologous();
            }
            if (this.getSubtreeNeighborings() != -99) {
                s = s + "\nSubtree-neighborings    : " + this.getSubtreeNeighborings();
            }
        }
        s = s + "\nSum of ext nodes\t: " + this.getSumExtNodes();
        s = s + "\nID                      : " + this.getID();
        s = !this.isRoot() ? s + "\nID of _parent            : " + this.getParent().getID() : s + "\nID of _parent            : n/a (root or pseudo root)";
        if (this.isInternal()) {
            for (int i = 0; i < this.getNumberOfChildNodes(); ++i) {
                s = s + "\nID of child " + i + "           : " + this.getChildNode(i).getID();
            }
        } else {
            s = s + "\nID of child             : n/a (external node)";
        }
        if ((tvu = this.getCustomTagValueUnitsAsArray()).length > 0) {
            for (int i = 0; i < tvu.length; ++i) {
                s = s + "\nCustom Tag/Value/Unit #" + i + "\n";
                s = s + tvu[i];
            }
        }
        return s;
    }

    boolean isEmpty(String s) {
        return s == null || s.length() < 1;
    }

    public String toXML() {
        int i;
        TagValueUnit[] a;
        if (this.isPseudoNode()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (!this.isEmpty(this.getSeqName())) {
            sb.append("<sequence_name>");
            sb.append(this.getSeqName());
            sb.append("</sequence_name>");
        }
        if (this.getDistanceToParent() != -99.0) {
            sb.append("<distance>");
            sb.append(this.getDistanceToParent());
            sb.append("</distance>");
        }
        if (!this.isEmpty(this.getTaxonomy())) {
            sb.append("<taxonomy>");
            sb.append(this.getTaxonomy());
            sb.append("</taxonomy>");
        }
        if (!this.isEmpty(this.getTaxonomyID())) {
            sb.append("<taxonomy_id>");
            sb.append(this.getTaxonomyID());
            sb.append("</taxonomy_id>");
        }
        if (!this.isEmpty(this.getECnumber())) {
            sb.append("<_ec_number>");
            sb.append(this.getECnumber());
            sb.append("</_ec_number>");
        }
        if (this.isInternal()) {
            if (this.getBootstrap() != -99.0) {
                sb.append("<");
                sb.append("confidence");
                sb.append(" ");
                sb.append("type");
                sb.append("=\"");
                sb.append("bootstrap");
                sb.append("\">");
                sb.append(this.getBootstrap());
                sb.append("</confidence>");
            }
            if (this.isDuplicationOrSpecAssigned()) {
                sb.append("<is_duplication>");
                if (this.isDuplication()) {
                    sb.append("true");
                }
                if (!this.isDuplication()) {
                    sb.append("false");
                }
                sb.append("</is_duplication>");
            }
        }
        if (this.getParentBranchWidth() != -99) {
            sb.append("<parent_branch_width>");
            sb.append(this.getParentBranchWidth());
            sb.append("</parent_branch_width>");
        }
        if (this.getColor() != PARENT_BRANCH_COLOR_DEFAULT) {
            Color c = this.getColor();
            sb.append("<");
            sb.append("color");
            sb.append(" ");
            sb.append("type");
            sb.append("=\"");
            sb.append("rgb");
            sb.append("\">");
            sb.append("<red>");
            sb.append(c.getRed());
            sb.append("</red>");
            sb.append("<green>");
            sb.append(c.getGreen());
            sb.append("</green>");
            sb.append("<blue>");
            sb.append(c.getBlue());
            sb.append("</blue>");
            sb.append("</color>");
        }
        if (this.isExternal()) {
            if (this.getOrthologous() != -99) {
                sb.append("<orthologous_to_query_count>");
                sb.append(this.getOrthologous());
                sb.append("</orthologous_to_query_count>");
            }
            if (this.getSuperOrthologous() != -99) {
                sb.append("<superorthologous_to_query_count>");
                sb.append(this.getSuperOrthologous());
                sb.append("</superorthologous_to_query_count>");
            }
            if (this.getSubtreeNeighborings() != -99) {
                sb.append("<subtreeneighborings_to_query_count>");
                sb.append(this.getSubtreeNeighborings());
                sb.append("</subtreeneighborings_to_query_count>");
            }
        }
        if (this.getNodeCustomTagValueUnits() != null) {
            a = this.getNodeCustomTagValueUnitsAsArray();
            for (i = 0; i < a.length; ++i) {
                sb.append(a[i].toXML(true, false, false));
            }
        }
        if (this.getParentBranchCustomTagValueUnits() != null) {
            a = this.getParentBranchCustomTagValueUnitsAsArray();
            for (i = 0; i < a.length; ++i) {
                sb.append(a[i].toXML(false, true, false));
            }
        }
        return sb.toString();
    }

    public boolean equals(PhylogenyNode node) {
        return node != null && this.getSeqName().equals(node.getSeqName()) && this.getTaxonomy().equals(node.getTaxonomy()) && this.getECnumber().equals(node.getECnumber()) && this.getTaxonomyID().equals(node.getTaxonomyID());
    }

    public static boolean compareArraysOfNodes(PhylogenyNode[] nodes1, PhylogenyNode[] nodes2) {
        int i = 0;
        int j = 0;
        PhylogenyNode[] n2 = null;
        if (nodes1.length != nodes2.length) {
            return false;
        }
        n2 = new PhylogenyNode[nodes2.length];
        for (i = 0; i < nodes2.length; ++i) {
            n2[i] = nodes2[i].copyNodeData();
        }
        for (i = 0; i < nodes1.length; ++i) {
            block5: {
                for (j = 0; j < n2.length; ++j) {
                    if (!nodes1[i].equals(nodes2[j])) {
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            n2[j] = null;
        }
        return true;
    }

    public void preorderPrint() {
        System.out.println(this + "\n");
        if (this.isInternal()) {
            for (int i = 0; i < this.getNumberOfChildNodes(); ++i) {
                this.getChildNode(i).preorderPrint();
            }
        }
    }

    void setIndicatorsToZero() {
        Stack<PhylogenyNode> stack = new Stack<PhylogenyNode>();
        PhylogenyNode n = this;
        stack.push(n);
        while (!stack.empty()) {
            n = (PhylogenyNode)stack.pop();
            n.setIndicator(0);
            if (!n.isExternal()) {
                stack.push(n.getChildNode1());
            }
            if (n.isExternal()) continue;
            stack.push(n.getChildNode2());
        }
    }

    void setParents() {
        PhylogenyNode start = this;
        PhylogenyNode node = this;
        PhylogenyNode prev = null;
        boolean done = false;
        if (this.isExternal()) {
            return;
        }
        start.setIndicatorsToZero();
        while (!done) {
            if (node == start && start.getIndicator() == 2) {
                done = true;
                continue;
            }
            if (node.getIndicator() == 0 && !node.isExternal()) {
                node.setParent(prev);
                prev = node;
                node.setIndicator(1);
                node = node.getChildNode1();
                continue;
            }
            if (node.getIndicator() == 1 && !node.isExternal()) {
                prev = node;
                node.setIndicator(2);
                node = node.getChildNode2();
                continue;
            }
            if (node.getIndicator() == 2 && !node.isExternal()) {
                node = node.getParent();
                continue;
            }
            if (!node.isExternal()) continue;
            node.setParent(prev);
            node = prev;
        }
    }

    public PhylogenyNode getRoot() {
        PhylogenyNode node = this;
        while (!node.isRoot()) {
            node = node.getParent();
        }
        return node;
    }

    public boolean isPossibleDuplication() {
        return this._possible_duplication;
    }

    public void setPossibleDuplication(boolean possible_duplication) {
        this._possible_duplication = possible_duplication;
        this.setDuplicationOrSpecAssigned(true);
    }

    public PhylogenyNodeIterator iterateChildNodesForward() {
        return new ChildNodeIteratorForward(this);
    }

    public static Color stringToColor(String s) {
        StringTokenizer st = new StringTokenizer(s, ".");
        if (st.countTokens() != 3) {
            throw new IllegalArgumentException("Argument to stringToColor must contain three \".\".");
        }
        int red = PhylogenyNode.limitRangeForColor(Integer.parseInt(st.nextToken()));
        int green = PhylogenyNode.limitRangeForColor(Integer.parseInt(st.nextToken()));
        int blu = PhylogenyNode.limitRangeForColor(Integer.parseInt(st.nextToken()));
        return new Color(red, green, blu);
    }

    private static int limitRangeForColor(int i) {
        if (i > 255) {
            i = 255;
        } else if (i < 0) {
            i = 0;
        }
        return i;
    }

    public ArrayList getConnectedEdges() {
        return this._connected_edges;
    }

    public void setConnectedEdges(ArrayList connected_edges) {
        this._connected_edges = connected_edges;
    }
}

