/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import org.forester.phylogeny.Edge;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.PhylogenyData;

public class PhylogenyBranch
implements Edge {
    private final PhylogenyNode _node_1;
    private final PhylogenyNode _node_2;
    private PhylogenyData _data;
    private boolean _is_directed;
    private boolean _towards_1;

    public PhylogenyBranch(PhylogenyNode first_node, PhylogenyNode second_node) {
        this._node_1 = first_node;
        this._node_2 = second_node;
        this._is_directed = false;
    }

    public PhylogenyBranch(PhylogenyNode first_node, PhylogenyNode second_node, boolean direction_towards_first) {
        this._node_1 = first_node;
        this._node_2 = second_node;
        this._is_directed = true;
        this._towards_1 = direction_towards_first;
    }

    public PhylogenyNode getConnectedNode(PhylogenyNode node) throws IllegalArgumentException {
        if (node == this._node_1) {
            return this._node_2;
        }
        if (node == this._node_2) {
            return this._node_1;
        }
        throw new IllegalArgumentException("Attempt to get connected node on branch with node which is not connected by the branch.");
    }

    public boolean isDirectionTowards(PhylogenyNode node) throws IllegalStateException {
        if (!this._is_directed) {
            throw new IllegalStateException("Attempt to get direction of undirected branch.");
        }
        return node == this._node_1 && this._towards_1;
    }

    public void setDirectionTowards(PhylogenyNode node) {
        this._towards_1 = node == this._node_1;
    }

    public PhylogenyNode getFirstNode() {
        return this._node_1;
    }

    public PhylogenyNode getSecondNode() {
        return this._node_2;
    }

    public PhylogenyData getData() {
        return this._data;
    }

    private void setData(PhylogenyData data) {
        this._data = data;
    }

    public String toString() {
        return "PhylogenyNode 1:\n" + this.getFirstNode().toString() + "\n\nNode 2:\n" + this.getSecondNode().toString();
    }
}

