/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import java.awt.Color;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.forester.io.PhylogenyWriter;
import org.forester.phylogeny.PhylogenyBranch;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.ExternalForwardIterator;
import org.forester.phylogeny.iterators.LevelOrderTreeIterator;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PostorderTreeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.Util;

public class Phylogeny {
    public static final int MAX_LENGTH = 10;
    private PhylogenyNode _root;
    private int _external_nodes;
    private boolean _rooted;
    private String _name;
    private String _description;
    private HashMap _idhash;

    public Phylogeny() {
        this.delete();
    }

    public Phylogeny copy() {
        Phylogeny tree = new Phylogeny();
        if (this.isEmpty()) {
            tree.delete();
            return tree;
        }
        tree._rooted = this._rooted;
        tree._external_nodes = this._external_nodes;
        tree._name = new String(this._name);
        tree._description = new String(this._description);
        tree._idhash = this._idhash;
        tree._root = PhylogenyNode.copyTree(this._root);
        tree.getRoot().setParents();
        return tree;
    }

    public void delete() {
        this._root = null;
        this._rooted = false;
        this._external_nodes = 0;
        this._name = "";
        this._description = "";
        this._idhash = null;
    }

    public Phylogeny subTree(int id) throws IllegalStateException {
        if (!this.isTree()) {
            throw new IllegalStateException("Attempt to get sub tree on phylogeny which is not tree-like.");
        }
        Phylogeny tree = null;
        PhylogenyNode node = null;
        if (this.isEmpty()) {
            return null;
        }
        tree = this.copy();
        node = tree.getNode(id);
        if (node == null || node.isExternal()) {
            return null;
        }
        node.setParent(null);
        node.setDistanceToParent(-99.0);
        tree.setRooted(true);
        tree.setRoot(node);
        tree.adjustNodeCount(true);
        return tree;
    }

    public void unRootAndTrifurcate() throws IllegalStateException {
        if (!this.isTree()) {
            throw new IllegalStateException("Attempt to unroot a phylogeny which is not tree-like.");
        }
        double sum = 0.0;
        if (this.isEmpty()) {
            return;
        }
        this.unRoot();
        if (this.getNumberOfExternalNodes() <= 2) {
            return;
        }
        sum = this.getRoot().getChildNode2().getDistanceToParent() + this.getRoot().getChildNode1().getDistanceToParent();
        if (this.getRoot().getChildNode2().isExternal() || this.getRoot().getChildNode2().isCollapse()) {
            if (sum >= 0.0) {
                this.getRoot().getChildNode2().setDistanceToParent(sum);
            } else {
                this.getRoot().getChildNode2().setDistanceToParent(-99.0);
            }
            this.getRoot().getChildNode1().setDistanceToParent(-100.0);
        } else {
            if (sum >= 0.0) {
                this.getRoot().getChildNode1().setDistanceToParent(sum);
            } else {
                this.getRoot().getChildNode1().setDistanceToParent(-99.0);
            }
            this.getRoot().getChildNode2().setDistanceToParent(-100.0);
        }
    }

    public void unRoot() throws IllegalStateException {
        if (!this.isTree()) {
            throw new IllegalStateException("Attempt to unroot a phylogeny which is not tree-like.");
        }
        if (this.isEmpty()) {
            return;
        }
        this.setIndicatorsToZero();
        if (!this.isRooted() || this.getNumberOfExternalNodes() <= 1) {
            return;
        }
        this.setRooted(false);
    }

    public void removeExtNode(PhylogenyNode n) {
        PhylogenyNode removed_node = null;
        PhylogenyNode p = null;
        PhylogenyNode pp = null;
        if (this.isEmpty()) {
            return;
        }
        if (this.getNumberOfExternalNodes() == 1 && n == this.getFirstExternalNode()) {
            this.delete();
            return;
        }
        removed_node = n;
        p = removed_node.getParent();
        if (p.isRoot()) {
            if (removed_node.isFirstChildNode()) {
                this.setRoot(this.getRoot().getChildNode2());
                this.getRoot().setParent(null);
            } else {
                this.setRoot(this.getRoot().getChildNode1());
                this.getRoot().setParent(null);
            }
        } else {
            pp = removed_node.getParent().getParent();
            if (p.isFirstChildNode()) {
                if (removed_node.isFirstChildNode()) {
                    p.getChildNode2().setDistanceToParent(this.addDist(p.getDistanceToParent(), p.getChildNode2().getDistanceToParent()));
                    pp.setChild1(p.getChildNode2());
                    p.getChildNode2().setParent(pp);
                } else {
                    p.getChildNode1().setDistanceToParent(this.addDist(p.getDistanceToParent(), p.getChildNode1().getDistanceToParent()));
                    pp.setChild1(p.getChildNode1());
                    p.getChildNode1().setParent(pp);
                }
            } else if (removed_node.isFirstChildNode()) {
                p.getChildNode2().setDistanceToParent(this.addDist(p.getDistanceToParent(), p.getChildNode2().getDistanceToParent()));
                pp.setChild2(p.getChildNode2());
                p.getChildNode2().setParent(pp);
            } else {
                p.getChildNode1().setDistanceToParent(this.addDist(p.getDistanceToParent(), p.getChildNode1().getDistanceToParent()));
                pp.setChild2(p.getChildNode1());
                p.getChildNode1().setParent(pp);
            }
            while (pp != this.getRoot()) {
                pp.setSumExtNodes(pp.getSumExtNodes() - 1);
                pp = pp.getParent();
            }
            pp.setSumExtNodes(pp.getSumExtNodes() - 1);
        }
        this._idhash = null;
    }

    private double addDist(double a, double b) {
        if (a >= 0.0 && b >= 0.0) {
            return a + b;
        }
        if (a >= 0.0) {
            return a;
        }
        if (b >= 0.0) {
            return b;
        }
        if (a == -100.0 && b == -100.0) {
            return -100.0;
        }
        return -99.0;
    }

    public void swapChildren(int id) throws IllegalStateException {
        this.swapChildren(this.getNode(id));
    }

    public void swapChildren(PhylogenyNode node) throws IllegalStateException {
        if (!this.isTree()) {
            throw new IllegalStateException("Attempt to swap children on phylogeny which is not tree-like.");
        }
        if (this.isEmpty() || node.isExternal() || node.getNumberOfChildNodes() < 2) {
            return;
        }
        PhylogenyNode first = node.getFirstChildNode();
        int i = 1;
        while (i < node.getNumberOfChildNodes()) {
            node.setChildNode(i - 1, node.getChildNode(i));
            ++i;
        }
        node.setChildNode(node.getNumberOfChildNodes() - 1, first);
    }

    public void orderAppearance(boolean order) throws IllegalStateException {
        if (!this.isTree()) {
            throw new IllegalStateException("Attempt to order appearance on phylogeny which is not tree-like.");
        }
        if (this.isEmpty()) {
            return;
        }
        this.orderAppearanceHelper(this.getRoot(), order);
    }

    private void orderAppearanceHelper(PhylogenyNode n, boolean order) {
        if (n.isExternal()) {
            return;
        }
        PhylogenyNode temp = null;
        if (n.getChildNode1().getSumExtNodes() != n.getChildNode2().getSumExtNodes() && n.getChildNode1().getSumExtNodes() < n.getChildNode2().getSumExtNodes() == order) {
            temp = n.getChildNode1();
            n.setChild1(n.getChildNode2());
            n.setChild2(temp);
        }
        int i = 0;
        while (i < n.getNumberOfChildNodes()) {
            this.orderAppearanceHelper(n.getChildNode(i), order);
            ++i;
        }
    }

    public void setAllNodesToNotCollapse() {
        if (this.isEmpty()) {
            return;
        }
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            node.setCollapse(false);
        }
    }

    public void collapseToDeepestAnotNodes() {
        if (this.isEmpty()) {
            return;
        }
        this.setAllNodesToNotCollapse();
        this.collapseToDeepestAnotNodesHelper(this.getRoot());
        this.adjustNodeCount(true);
    }

    private void collapseToDeepestAnotNodesHelper(PhylogenyNode n) {
        if (n.isExternal()) {
            return;
        }
        if (!(n.isPseudoNode() || n.getTaxonomy().equals("") && n.getSeqName().equals(""))) {
            n.setCollapse(true);
            return;
        }
        int i = 0;
        while (i < n.getNumberOfChildNodes()) {
            this.collapseToDeepestAnotNodesHelper(n.getChildNode(i));
            ++i;
        }
    }

    public void reRoot(int id) {
        this.reRoot(this.getNode(id));
    }

    public void reRoot(PhylogenyNode n) {
        PhylogenyNode nodeA = n;
        PhylogenyNode node = null;
        PhylogenyNode nodeB = null;
        PhylogenyNode nodeC = null;
        PhylogenyNode new_root = null;
        double distance1 = 0.0;
        double distance2 = 0.0;
        double bootstrap1 = 0.0;
        double bootstrap2 = 0.0;
        int width1 = 0;
        int width2 = 0;
        Color color1 = null;
        Color color2 = null;
        Hashtable hash1 = null;
        Hashtable hash2 = null;
        if (this.isEmpty() || this.getNumberOfExternalNodes() < 2) {
            return;
        }
        if (nodeA.isPseudoNode()) {
            throw new IllegalArgumentException("Phylogeny: reRoot(PhylogenyNode): Can not place root on parent branch of pseudo node.");
        }
        this.setRooted(true);
        if (nodeA.isRoot()) {
            this.moveRootToMiddle();
            return;
        }
        if (nodeA.getParent().isRoot()) {
            if (this.getRoot().getChildNode1().isPseudoNode() || this.getRoot().getChildNode2().isPseudoNode()) {
                if (this.getRoot().getChildNode1() == nodeA && this.getRoot().getChildNode2().isPseudoNode()) {
                    node = this.getRoot().getChildNode2();
                }
                if (this.getRoot().getChildNode2() == nodeA && this.getRoot().getChildNode1().isPseudoNode()) {
                    node = this.getRoot().getChildNode1();
                }
                if (nodeA.getDistanceToParent() == -99.0) {
                    node.setDistanceToParent(-99.0);
                } else {
                    double d = nodeA.getDistanceToParent() / 2.0;
                    node.setDistanceToParent(d);
                    nodeA.setDistanceToParent(d);
                }
                node.setParentBranchCustomTagValueUnits(nodeA.getParentBranchCustomTagValueUnits());
                node.setParentBranchWidth(nodeA.getParentBranchWidth());
                node.setColor(nodeA.getColor());
                node.setBootstrap(nodeA.getBootstrap());
            } else {
                this.moveRootToMiddle();
            }
            return;
        }
        nodeB = nodeA.getParent();
        nodeC = nodeB.getParent();
        new_root = new PhylogenyNode();
        if (nodeB.getChildNode2() == nodeA) {
            new_root.setChild1(nodeA);
            new_root.setChild2(nodeB);
        } else {
            new_root.setChild1(nodeB);
            new_root.setChild2(nodeA);
        }
        distance1 = nodeC.getDistanceToParent();
        hash1 = nodeC.getParentBranchCustomTagValueUnits();
        width1 = nodeC.getParentBranchWidth();
        color1 = nodeC.getColor();
        bootstrap1 = nodeC.getBootstrap();
        nodeC.setDistanceToParent(nodeB.getDistanceToParent());
        nodeC.setParentBranchCustomTagValueUnits(nodeB.getParentBranchCustomTagValueUnits());
        nodeC.setParentBranchWidth(nodeB.getParentBranchWidth());
        nodeC.setColor(nodeB.getColor());
        nodeC.setBootstrap(nodeB.getBootstrap());
        nodeB.setParentBranchCustomTagValueUnits(nodeA.getParentBranchCustomTagValueUnits());
        nodeB.setParentBranchWidth(nodeA.getParentBranchWidth());
        nodeB.setColor(nodeA.getColor());
        nodeB.setBootstrap(nodeA.getBootstrap());
        if (nodeA.getDistanceToParent() == -99.0) {
            nodeB.setDistanceToParent(-99.0);
        } else {
            double d = nodeA.getDistanceToParent() / 2.0;
            nodeB.setDistanceToParent(d);
            nodeA.setDistanceToParent(d);
        }
        nodeA.setParent(new_root);
        if (nodeB.getChildNode1() == nodeA) {
            nodeB.setChild1(nodeC);
        } else {
            nodeB.setChild2(nodeC);
        }
        nodeB.setParent(new_root);
        while (!nodeC.isRoot()) {
            nodeA = nodeB;
            nodeB = nodeC;
            nodeC = nodeC.getParent();
            if (nodeB.getChildNode1() == nodeA) {
                nodeB.setChild1(nodeC);
            } else {
                nodeB.setChild2(nodeC);
            }
            nodeB.setParent(nodeA);
            distance2 = nodeC.getDistanceToParent();
            hash2 = nodeC.getParentBranchCustomTagValueUnits();
            width2 = nodeC.getParentBranchWidth();
            color2 = nodeC.getColor();
            bootstrap2 = nodeC.getBootstrap();
            nodeC.setDistanceToParent(distance1);
            nodeC.setParentBranchCustomTagValueUnits(hash1);
            nodeC.setParentBranchWidth(width1);
            nodeC.setColor(color1);
            nodeC.setBootstrap(bootstrap1);
            distance1 = distance2;
            hash1 = hash2;
            width1 = width2;
            color1 = color2;
            bootstrap1 = bootstrap2;
        }
        node = nodeC.getChildNode1() == nodeB ? nodeC.getChildNode2() : nodeC.getChildNode1();
        node.setParent(nodeB);
        if (nodeC.getDistanceToParent() == -100.0 && node.getDistanceToParent() == -100.0) {
            node.setDistanceToParent(-100.0);
        } else if (!(nodeC.getDistanceToParent() != -99.0 && nodeC.getDistanceToParent() != -100.0 || node.getDistanceToParent() != -99.0 && node.getDistanceToParent() != -100.0)) {
            node.setDistanceToParent(-99.0);
        } else {
            node.setDistanceToParent((nodeC.getDistanceToParent() >= 0.0 ? nodeC.getDistanceToParent() : 0.0) + (node.getDistanceToParent() >= 0.0 ? node.getDistanceToParent() : 0.0));
        }
        if (nodeC.getDistanceToParent() != -100.0) {
            node.setParentBranchCustomTagValueUnits(nodeC.getParentBranchCustomTagValueUnits());
            node.setParentBranchWidth(nodeC.getParentBranchWidth());
            node.setColor(nodeC.getColor());
        }
        node.setBootstrap(nodeC.getBootstrap());
        if (nodeB.getChildNode1() != nodeC) {
            nodeB.setChild2(node);
        } else {
            nodeB.setChild1(node);
        }
        this.setRoot(new_root);
    }

    public void reRoot(PhylogenyBranch b) {
        PhylogenyNode n1 = b.getFirstNode();
        PhylogenyNode n2 = b.getSecondNode();
        if (n2 == n1.getChildNode1() || n2 == n1.getChildNode2()) {
            this.reRoot(n2);
        } else if (n1 == n2.getChildNode1() || n1 == n2.getChildNode2()) {
            this.reRoot(n1);
        } else if (n1.getParent() != null && n1.getParent().isRoot() && (n1.getParent().getChildNode1() == n2 || n1.getParent().getChildNode2() == n2)) {
            this.reRoot(n1);
        } else {
            throw new IllegalArgumentException("reRoot( Branch b ): b is not a branch.");
        }
    }

    public void reRootSkeleton(PhylogenyNode n) {
        PhylogenyNode nodeA = n;
        PhylogenyNode node = null;
        PhylogenyNode nodeB = null;
        PhylogenyNode nodeC = null;
        PhylogenyNode new_root = null;
        double distance1 = 0.0;
        double distance2 = 0.0;
        if (this.isEmpty() || this.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setRooted(true);
        if (nodeA.isRoot() || nodeA.getParent().isRoot()) {
            this.moveRootToMiddle();
            return;
        }
        nodeB = nodeA.getParent();
        nodeC = nodeB.getParent();
        new_root = new PhylogenyNode();
        if (nodeB.getChildNode2() == nodeA) {
            new_root.setChild1(nodeA);
            new_root.setChild2(nodeB);
        } else {
            new_root.setChild1(nodeB);
            new_root.setChild2(nodeA);
        }
        distance1 = nodeC.getDistanceToParent();
        nodeC.setDistanceToParent(nodeB.getDistanceToParent());
        if (nodeA.getDistanceToParent() == -99.0) {
            nodeB.setDistanceToParent(-99.0);
        } else {
            double d = nodeA.getDistanceToParent() / 2.0;
            nodeB.setDistanceToParent(d);
            nodeA.setDistanceToParent(d);
        }
        nodeA.setParent(new_root);
        if (nodeB.getChildNode1() == nodeA) {
            nodeB.setChild1(nodeC);
        } else {
            nodeB.setChild2(nodeC);
        }
        nodeB.setParent(new_root);
        while (!nodeC.isRoot()) {
            nodeA = nodeB;
            nodeB = nodeC;
            nodeC = nodeC.getParent();
            if (nodeB.getChildNode1() == nodeA) {
                nodeB.setChild1(nodeC);
            } else {
                nodeB.setChild2(nodeC);
            }
            nodeB.setParent(nodeA);
            distance2 = nodeC.getDistanceToParent();
            nodeC.setDistanceToParent(distance1);
            distance1 = distance2;
        }
        node = nodeC.getChildNode1() == nodeB ? nodeC.getChildNode2() : nodeC.getChildNode1();
        node.setParent(nodeB);
        if (nodeC.getDistanceToParent() == -99.0 && node.getDistanceToParent() == -99.0) {
            node.setDistanceToParent(-99.0);
        } else {
            node.setDistanceToParent((nodeC.getDistanceToParent() >= 0.0 ? nodeC.getDistanceToParent() : 0.0) + (node.getDistanceToParent() >= 0.0 ? node.getDistanceToParent() : 0.0));
        }
        if (nodeB.getChildNode1() != nodeC) {
            nodeB.setChild2(node);
        } else {
            nodeB.setChild1(node);
        }
        this.setRoot(new_root);
    }

    public void reRootSkeleton(PhylogenyBranch b) {
        PhylogenyNode n1 = b.getFirstNode();
        PhylogenyNode n2 = b.getSecondNode();
        if (n2 == n1.getChildNode1() || n2 == n1.getChildNode2()) {
            this.reRootSkeleton(n2);
        } else if (n1 == n2.getChildNode1() || n1 == n2.getChildNode2()) {
            this.reRootSkeleton(n1);
        } else if (n1.getParent() != null && n1.getParent().isRoot() && (n1.getParent().getChildNode1() == n2 || n1.getParent().getChildNode2() == n2)) {
            this.reRootSkeleton(n1);
        } else {
            throw new IllegalArgumentException("reRootSkeleton( Branch b ): b is not a branch.");
        }
    }

    private void moveRootToMiddle() {
        if (this.getRoot().getChildNode1() != null && this.getRoot().getChildNode2() != null) {
            double d1 = this.getRoot().getChildNode1().getDistanceToParent();
            double d2 = this.getRoot().getChildNode2().getDistanceToParent();
            double d = 0.0;
            if (d1 < 0.0) {
                d1 = 0.0;
            }
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            d = (d1 + d2) / 2.0;
            this.getRoot().getChildNode1().setDistanceToParent(d);
            this.getRoot().getChildNode2().setDistanceToParent(d);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Vector getOrthologousNodes(PhylogenyNode n) {
        node = n;
        prev = null;
        v = new Vector<E>();
        if (node.isExternal() && !this.isEmpty()) ** GOTO lbl12
        return null;
lbl-1000:
        // 1 sources

        {
            prev = node;
            if ((node = node.getParent()).isDuplication()) continue;
            if (node.getChildNode1() == prev) {
                Util.addIntoVector(node.getChildNode2().getAllExternalChildren(), v);
                continue;
            }
            Util.addIntoVector(node.getChildNode1().getAllExternalChildren(), v);
lbl12:
            // 4 sources

            ** while (!node.isRoot())
        }
lbl13:
        // 1 sources

        v.trimToSize();
        return v;
    }

    /*
     * Unable to fully structure code
     */
    public Vector getSuperOrthologousNodes(PhylogenyNode n) {
        node = n;
        deepest = null;
        v = new Vector<PhylogenyNode>();
        if (node.isExternal() && !this.isEmpty()) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.getParent();
lbl7:
            // 2 sources

            ** while (!node.isRoot() && !node.getParent().isDuplication())
        }
lbl8:
        // 1 sources

        deepest = node;
        deepest.setIndicatorsToZero();
        do {
            if (!node.isExternal()) {
                if (node.getIndicator() == 0) {
                    node.setIndicator(1);
                    if (!node.isDuplication()) {
                        node = node.getChildNode1();
                    }
                }
                if (node.getIndicator() == 1) {
                    node.setIndicator(2);
                    if (!node.isDuplication()) {
                        node = node.getChildNode2();
                    }
                }
                if (node == deepest || node.getIndicator() != 2) continue;
                node = node.getParent();
                continue;
            }
            if (node != n) {
                v.addElement(node);
            }
            if (node != deepest) {
                node = node.getParent();
                continue;
            }
            node.setIndicator(2);
        } while (node != deepest || deepest.getIndicator() != 2);
        v.trimToSize();
        return v;
    }

    /*
     * Unable to fully structure code
     */
    public Vector getUltraParalogousNodes(PhylogenyNode n) {
        node = n;
        v = new Vector();
        if (node.isExternal() && !this.isEmpty()) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.getParent();
lbl6:
            // 2 sources

            ** while (!node.isRoot() && node.getParent().isDuplication() && this.areAllChildrenDuplications((PhylogenyNode)node.getParent()))
        }
lbl7:
        // 1 sources

        v = node.getAllExternalChildren();
        v.removeElement(n);
        v.trimToSize();
        return v;
    }

    public boolean areAllChildrenDuplications(PhylogenyNode n) {
        if (n.isExternal()) {
            return true;
        }
        if (n.isDuplication()) {
            return this.areAllChildrenDuplications(n.getChildNode1()) && this.areAllChildrenDuplications(n.getChildNode2());
        }
        return false;
    }

    public Vector getSubtreeNeighbors(PhylogenyNode n) {
        PhylogenyNode node = n;
        Vector v = new Vector();
        if (!node.isExternal() || this.isEmpty()) {
            return null;
        }
        if (!node.isRoot()) {
            node = node.getParent();
        }
        if (!node.isRoot()) {
            node = node.getParent();
        }
        v = node.getAllExternalChildren();
        v.removeElement(n);
        v.trimToSize();
        return v;
    }

    public PhylogenyNode getNode(String name) {
        Vector nodes = this.getNodes(name);
        if (this.isEmpty()) {
            return null;
        }
        if (nodes == null || nodes.size() < 1) {
            throw new IllegalArgumentException(String.valueOf(name) + " not found");
        }
        if (nodes.size() > 1) {
            throw new IllegalArgumentException(String.valueOf(name) + " not unique");
        }
        return (PhylogenyNode)nodes.elementAt(0);
    }

    public PhylogenyNode getNode(int id) throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Attempt to find node in an empty phlyogeny.");
        }
        if (this._idhash != null) {
            return (PhylogenyNode)this._idhash.get(new Integer(id));
        }
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (node.getID() != id) continue;
            return node;
        }
        throw new NoSuchElementException("Node for which id=" + id + " not found.");
    }

    public Vector find(String name, String species, String ec, String taxonomy_id) {
        if (this.isEmpty()) {
            return null;
        }
        Vector<PhylogenyNode> nodes = new Vector<PhylogenyNode>();
        boolean failed = false;
        String my_name = Util.sanitize(name).toLowerCase();
        String my_species = Util.sanitize(species).toLowerCase();
        String my_ec = Util.sanitize(ec).toLowerCase();
        String my_taxo_id = Util.sanitize(taxonomy_id).toLowerCase();
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode current = iter.next();
            PhylogenyNode n = null;
            if (!Util.isEmpty(my_name)) {
                if (current.getSeqName().toLowerCase().equals(my_name)) {
                    n = current;
                } else {
                    failed = true;
                }
            }
            if (!failed && !Util.isEmpty(my_species)) {
                if (current.getTaxonomy().toLowerCase().equals(my_species)) {
                    n = current;
                } else {
                    failed = true;
                }
            }
            if (!failed && !Util.isEmpty(my_ec)) {
                if (current.getECnumber().toLowerCase().equals(my_ec)) {
                    n = current;
                } else {
                    failed = true;
                }
            }
            if (!failed && !Util.isEmpty(my_taxo_id)) {
                if (current.getTaxonomyID().toLowerCase().equals(my_taxo_id)) {
                    n = current;
                } else {
                    failed = true;
                }
            }
            if (failed) continue;
            nodes.addElement(n);
        }
        nodes.trimToSize();
        return nodes;
    }

    public Hashtable findInNameSpecECid(String query) {
        Hashtable<PhylogenyNode, String> nodes = new Hashtable<PhylogenyNode, String>();
        if (this.isEmpty()) {
            return nodes;
        }
        if ((query = query.toLowerCase().trim()).equals("")) {
            return nodes;
        }
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode current = iter.next();
            if (current.getSeqName().toLowerCase().indexOf(query) >= 0) {
                nodes.put(current, "");
                continue;
            }
            if (current.getTaxonomy().toLowerCase().indexOf(query) >= 0) {
                nodes.put(current, "");
                continue;
            }
            if (current.getECnumber().toLowerCase().indexOf(query) >= 0) {
                nodes.put(current, "");
                continue;
            }
            if (current.getTaxonomyID().toLowerCase().indexOf(query) < 0) continue;
            nodes.put(current, "");
        }
        return nodes;
    }

    public Vector getNodes(String name) {
        if (this.isEmpty()) {
            return null;
        }
        Vector<PhylogenyNode> nodes = new Vector<PhylogenyNode>();
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode n = iter.next();
            if (!n.getSeqName().equals(name)) continue;
            nodes.addElement(n);
        }
        nodes.trimToSize();
        return nodes;
    }

    public Vector getNodesWithMatchingSpecies(String specname) {
        if (this.isEmpty()) {
            return null;
        }
        Vector<PhylogenyNode> nodes = new Vector<PhylogenyNode>();
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode n = iter.next();
            if (!n.getTaxonomy().equals(specname)) continue;
            nodes.addElement(n);
        }
        nodes.trimToSize();
        return nodes;
    }

    public String[] getAllExternalSeqNames() {
        int i = 0;
        if (this.isEmpty()) {
            return null;
        }
        String[] names = new String[this.getNumberOfExternalNodes()];
        PhylogenyNodeIterator iter = this.iteratorExternalForward();
        while (iter.hasNext()) {
            names[i++] = new String(iter.next().getSeqName());
        }
        return names;
    }

    public double getHeight() {
        if (this.isEmpty()) {
            return 0.0;
        }
        return this.calculateSubtreelHeight(this.getRoot());
    }

    public double getLargestSubtreeHeightDifference() {
        if (this.isEmpty() || this.getRoot().getNumberOfChildNodes() < 1) {
            return 0.0;
        }
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.getRoot().getNumberOfChildNodes()) {
            double l = this.calculateSubtreelHeight(this.getRoot().getChildNode(i));
            if (l > max) {
                max = l;
            }
            if (l < min) {
                min = l;
            }
            ++i;
        }
        return max - min;
    }

    public double getDistance(PhylogenyNode n1, PhylogenyNode n2) {
        double dist = 0.0;
        PhylogenyNode parent1 = n1;
        PhylogenyNode parent2 = n2;
        while (!parent1.equals(parent2)) {
            if (!parent1.isRoot() && !parent1.isParent(n2)) {
                dist += parent1.getDistanceToParent();
                parent1 = parent1.getParent();
            }
            if (parent2.isRoot() || parent2.isParent(n1)) continue;
            dist += parent2.getDistanceToParent();
            parent2 = parent2.getParent();
        }
        return dist;
    }

    private double calculateSubtreelHeight(PhylogenyNode n) {
        if (n.isExternal() || n.isCollapse()) {
            return Util.atLeastZero(n.getDistanceToParent());
        }
        double max = Double.MIN_VALUE;
        int i = 0;
        while (i < n.getNumberOfChildNodes()) {
            double l = this.calculateSubtreelHeight(n.getChildNode(i));
            if (l > max) {
                max = l;
            }
            ++i;
        }
        return max + Util.atLeastZero(n.getDistanceToParent());
    }

    public void normalizeBootstrapValues(double max_bootstrap_value, double max_normalized_value) {
        this.normalizeBootstrapValuesHelper(this.getRoot(), max_bootstrap_value, max_normalized_value);
    }

    private void normalizeBootstrapValuesHelper(PhylogenyNode n, double max_bootstrap_value, double max_normalized_value) {
        if (n == null) {
            return;
        }
        if (!n.isPseudoNode() && n.getBootstrap() != -99.0) {
            if (n.getBootstrap() >= max_bootstrap_value) {
                n.setBootstrap(max_normalized_value);
            } else {
                n.setBootstrap((int)(n.getBootstrap() * max_normalized_value / max_bootstrap_value + 0.5));
            }
        }
        this.normalizeBootstrapValuesHelper(n.getChildNode1(), max_bootstrap_value, max_normalized_value);
        this.normalizeBootstrapValuesHelper(n.getChildNode2(), max_bootstrap_value, max_normalized_value);
    }

    public boolean isEmpty() {
        return this.getRoot() == null;
    }

    public boolean isTree() {
        return true;
    }

    public boolean isCompletelyBinary() {
        if (this.isEmpty()) {
            return false;
        }
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (!node.isInternal() || node.getNumberOfChildNodes() == 2) continue;
            return false;
        }
        return true;
    }

    public double getMaximumBootstrapValue() {
        double max_bootstrap = Double.MIN_VALUE;
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (node.getBootstrap() == -99.0 || !(node.getBootstrap() > max_bootstrap)) continue;
            max_bootstrap = node.getBootstrap();
        }
        return max_bootstrap;
    }

    public int levelOrderReID(int start_label) {
        if (this.isEmpty()) {
            return start_label;
        }
        this._idhash = null;
        int max = Integer.MIN_VALUE;
        PhylogenyNodeIterator it = this.iteratorPreorder();
        while (it.hasNext()) {
            PhylogenyNode node = it.next();
            if (node.isRoot()) {
                node.setID(start_label);
                continue;
            }
            node.setID(node.getParent().getID() + 1);
            if (node.getID() <= max) continue;
            max = node.getID();
        }
        return max;
    }

    public int preorderReID(int start_label) {
        if (this.isEmpty()) {
            return start_label;
        }
        this._idhash = null;
        PhylogenyNodeIterator it = this.iteratorPreorder();
        while (it.hasNext()) {
            it.next().setID(start_label++);
        }
        return start_label;
    }

    public PhylogenyNode getRoot() {
        return this._root;
    }

    public void setRoot(PhylogenyNode n) {
        this._root = n;
    }

    public boolean isRooted() {
        return this._rooted;
    }

    public void setRooted(boolean b) {
        this._rooted = b;
    }

    public PhylogenyNode getFirstExternalNode() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Attempt to obtain first external node of empty Phylogeney.");
        }
        PhylogenyNode node = this.getRoot();
        while (node.isInternal()) {
            node = node.getFirstChildNode();
        }
        return node;
    }

    public int getNumberOfExternalNodes() {
        int i = 0;
        PhylogenyNodeIterator iter = this.iteratorExternalForward();
        while (iter.hasNext()) {
            ++i;
            iter.next();
        }
        return i;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String s) {
        this._name = s;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    private HashMap getIdHash() {
        return this._idhash;
    }

    private void setIdHash(HashMap idhash) {
        this._idhash = idhash;
    }

    public String toString() {
        return this.toNewHampshireX();
    }

    public String toPhyloXML(int level) {
        return new PhylogenyWriter().toPhyloXML(this).toString();
    }

    public String toNewHampshire(boolean simple_nh) {
        return new PhylogenyWriter().toNewHampshire(this, simple_nh).toString();
    }

    public String toNewHampshireX() {
        return new PhylogenyWriter().toNewHampshireX(this).toString();
    }

    public void printExtNodes() {
        if (this.isEmpty()) {
            return;
        }
        PhylogenyNodeIterator iter = this.iteratorExternalForward();
        while (iter.hasNext()) {
            System.out.println(iter.next() + "\n");
        }
    }

    public void printAllNodes() {
        if (this.isEmpty()) {
            return;
        }
        this.getRoot().preorderPrint();
    }

    public void setIndicatorsToZero() {
        if (this.isEmpty()) {
            return;
        }
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            iter.next().setIndicator(0);
        }
    }

    public void hashIDs() {
        if (this.isEmpty()) {
            return;
        }
        this.setIdHash(new HashMap());
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            this.getIdHash().put(new Integer(node.getID()), node);
        }
    }

    public void adjustNodeCount(boolean considerCollapsedNodes) {
        if (this.isEmpty()) {
            return;
        }
        PhylogenyNodeIterator iter = this.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (node.isExternal() || considerCollapsedNodes && node.isCollapse()) {
                node.setSumExtNodes(1);
                continue;
            }
            int sum = 0;
            int i = 0;
            while (i < node.getNumberOfChildNodes()) {
                sum += node.getChildNode(i).getSumExtNodes();
                ++i;
            }
            node.setSumExtNodes(sum);
        }
    }

    public Hashtable getCustomTagNames() {
        Hashtable<String, Boolean> ht = new Hashtable<String, Boolean>();
        if (this.isEmpty()) {
            return ht;
        }
        PhylogenyNodeIterator iter = this.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode current_node = iter.next();
            String[] tags = current_node.getCustomTagNames();
            int i = 0;
            while (i < tags.length) {
                ht.put(tags[i], new Boolean(false));
                ++i;
            }
        }
        return ht;
    }

    public void addAsChild(PhylogenyNode parent) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Attempt to add an empty tree.");
        }
        if (!this.isRooted()) {
            throw new IllegalArgumentException("Attempt to add an unrooted tree.");
        }
        parent.addAsChild(this.getRoot());
    }

    public PhylogenyNodeIterator iteratorExternalForward() {
        return new ExternalForwardIterator(this);
    }

    public PhylogenyNodeIterator iteratorPostorder() {
        return new PostorderTreeIterator(this);
    }

    public PhylogenyNodeIterator iteratorPreorder() {
        return new PreorderTreeIterator(this);
    }

    public PhylogenyNodeIterator iteratorLevelOrder() {
        return new LevelOrderTreeIterator(this);
    }
}

