/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenomics;

import org.forester.phylogenomics.SDI;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;

public class SDIx
extends SDI {
    public SDIx(Phylogeny gene_tree, Phylogeny species_tree) {
        super(gene_tree, species_tree);
    }

    public int infer(boolean strip_species_tree) {
        this.setDuplicationsToZero();
        if (strip_species_tree) {
            SDIx.stripTree(this.getGeneTree(), this.getSpeciesTree());
        }
        this.getSpeciesTree().preorderReID(0);
        this.linkExtNodesOfG();
        this.geneTreePostOrderTraversal(this.getGeneTree().getRoot());
        return this.getDuplications();
    }

    void geneTreePostOrderTraversal(PhylogenyNode g) {
        if (!g.isExternal()) {
            this.geneTreePostOrderTraversal(g.getChildNode1());
            this.geneTreePostOrderTraversal(g.getChildNode2());
            PhylogenyNode a = g.getChildNode1().getLink();
            PhylogenyNode b = g.getChildNode2().getLink();
            while (a != b) {
                if (a.getID() > b.getID()) {
                    a = a.getParent();
                    continue;
                }
                b = b.getParent();
            }
            g.setLink(a);
            g.setDuplicationOrSpecAssigned(true);
            if (a.getNumberOfChildNodes() == 2) {
                if (a == g.getChildNode1().getLink() || a == g.getChildNode2().getLink()) {
                    g.setDuplication(true);
                    this.increaseDuplications();
                } else {
                    g.setDuplication(false);
                }
            } else if (a.getNumberOfChildNodes() > 2) {
                System.out.println(" >2 child nodes!");
            } else {
                g.setDuplication(false);
            }
        }
    }

    int updateM(boolean prev_root_was_dup, PhylogenyNode prev_root_c1, PhylogenyNode prev_root_c2) {
        PhylogenyNode root = this.getGeneTree().getRoot();
        if (root.getChildNode1() == prev_root_c1 || root.getChildNode2() == prev_root_c1) {
            this.calculateMforNode(prev_root_c1);
        } else {
            this.calculateMforNode(prev_root_c2);
        }
        root.setDuplication(prev_root_was_dup);
        this.calculateMforNode(root);
        return this.getDuplications();
    }

    private void calculateMforNode(PhylogenyNode n) {
        if (!n.isExternal()) {
            boolean was_duplication = n.isDuplication();
            PhylogenyNode a = n.getChildNode1().getLink();
            PhylogenyNode b = n.getChildNode2().getLink();
            while (a != b) {
                if (a.getID() > b.getID()) {
                    a = a.getParent();
                    continue;
                }
                b = b.getParent();
            }
            n.setLink(a);
            if (a == n.getChildNode1().getLink() || a == n.getChildNode2().getLink()) {
                n.setDuplication(true);
                if (!was_duplication) {
                    this.increaseDuplications();
                }
            } else {
                n.setDuplication(false);
                if (was_duplication) {
                    this.decreaseDuplications();
                }
            }
        }
    }
}

