/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenomics;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Vector;
import org.forester.atv.ATVapplicationFrame;
import org.forester.phylogenomics.SDI;
import org.forester.phylogenomics.SDIse;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyBranch;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.parsers.nhx.NHXParser;
import org.forester.util.Util;

public class SDIunrooted {
    private static final int TREES_TO_RETURN = 5;
    private static final double ZERO_DIFF = 1.0E-10;
    private int count_ = -1;
    private int min_dup_ = Integer.MAX_VALUE;
    private int min_cost_ = Integer.MAX_VALUE;
    private double min_height_ = Double.MAX_VALUE;
    private double min_diff_ = Double.MAX_VALUE;
    private long time_sdi = -1L;

    public int getCount() {
        return this.count_;
    }

    public int getMinimalDuplications() {
        return this.min_dup_;
    }

    public int getMinimalMappingCost() {
        return this.min_cost_;
    }

    public double getMinimalTreeHeight() {
        return this.min_height_;
    }

    public double getMinimalDiffInSubTreeHeights() {
        return this.min_diff_;
    }

    public long getTimeSumSDI() {
        return this.time_sdi;
    }

    public Phylogeny[] infer(Phylogeny gene_tree, Phylogeny species_tree, boolean minimize_mapping_cost, boolean minimize_sum_of_dup, boolean minimize_height, boolean return_trees, int max_trees_to_return) {
        SDIse sdise = null;
        Vector<Phylogeny> trees = new Vector<Phylogeny>();
        Phylogeny[] tree_array = null;
        PhylogenyBranch[] branches = null;
        Phylogeny g = null;
        Phylogeny species_tree_stripped = null;
        PhylogenyNode prev_root = null;
        PhylogenyNode prev_root_c1 = null;
        PhylogenyNode prev_root_c2 = null;
        int duplications = 0;
        int cost = 0;
        int counter = 0;
        int min_duplications = Integer.MAX_VALUE;
        int min_cost = Integer.MAX_VALUE;
        int j = 0;
        double height = 0.0;
        double diff = 0.0;
        double min_height = Double.MAX_VALUE;
        double min_diff = 0.0;
        double[] height__diff = new double[2];
        boolean need_to_root = true;
        boolean smaller = false;
        boolean equal = false;
        boolean prev_root_was_dup = false;
        if (max_trees_to_return < 1) {
            max_trees_to_return = 1;
        }
        if (minimize_mapping_cost && minimize_sum_of_dup) {
            minimize_sum_of_dup = false;
        }
        if (!(minimize_mapping_cost || minimize_sum_of_dup || minimize_height)) {
            max_trees_to_return = 1;
            need_to_root = false;
        }
        if ((g = gene_tree.copy()).getNumberOfExternalNodes() <= 1) {
            g.setRooted(true);
            this.setMinimalDuplications(0);
            this.setMinimalTreeHeight(0.0);
            tree_array = new Phylogeny[]{g};
            return tree_array;
        }
        species_tree_stripped = species_tree.copy();
        SDI.stripTree(g, species_tree_stripped);
        if (need_to_root) {
            g.reRoot(g.getFirstExternalNode());
            branches = this.getBranchesInOrder(g);
            if (branches == null) {
                throw new RuntimeException("SDIunrooted: Infer: Unexpected error: Failed to obtain array of branches.");
            }
        } else {
            if (!g.isRooted()) {
                throw new IllegalArgumentException("\nSDIunrooted: Infer: Error: Gene tree must be rooted if no rooting is performed.\n");
            }
            branches = new PhylogenyBranch[1];
        }
        if (minimize_mapping_cost || minimize_sum_of_dup || !need_to_root) {
            sdise = new SDIse(g, species_tree_stripped);
            duplications = sdise.infer(false);
        }
        j = 0;
        while (j < branches.length) {
            if (need_to_root) {
                prev_root = g.getRoot();
                prev_root_c1 = prev_root.getChildNode1();
                prev_root_c2 = prev_root.getChildNode2();
                prev_root_was_dup = prev_root.isDuplication();
                g.reRoot(branches[j]);
            }
            if (minimize_mapping_cost || minimize_sum_of_dup) {
                duplications = sdise.updateM(prev_root_was_dup, prev_root_c1, prev_root_c2);
            }
            if (minimize_mapping_cost) {
                cost = sdise.computeMappingCost();
                if (minimize_height && (cost == min_cost || cost < min_cost)) {
                    height__diff = this.moveRootOnBranchToMinHeight(g);
                    height = height__diff[0];
                    diff = height__diff[1];
                }
                if (cost == min_cost) {
                    if (minimize_height) {
                        equal = false;
                        smaller = false;
                        if (height < min_height) {
                            min_height = height;
                            counter = 1;
                            smaller = true;
                        } else if (height == min_height) {
                            ++counter;
                            equal = true;
                        }
                        if (Math.abs(diff) < min_diff) {
                            min_diff = Math.abs(diff);
                        }
                    }
                    if (return_trees) {
                        if (minimize_height) {
                            if (smaller) {
                                trees.removeAllElements();
                                trees.addElement(g.copy());
                            } else if (equal && trees.size() < max_trees_to_return) {
                                trees.addElement(g.copy());
                            }
                        } else {
                            ++counter;
                            if (trees.size() < max_trees_to_return) {
                                trees.addElement(g.copy());
                            }
                        }
                    } else if (!minimize_height) {
                        ++counter;
                    }
                } else if (cost < min_cost) {
                    if (minimize_height) {
                        min_height = height;
                        min_diff = Math.abs(diff);
                    }
                    if (return_trees) {
                        trees.removeAllElements();
                        trees.addElement(g.copy());
                    }
                    counter = 1;
                    min_cost = cost;
                }
                if (duplications < min_duplications) {
                    min_duplications = duplications;
                }
            } else if (minimize_sum_of_dup) {
                if (minimize_height && (duplications == min_duplications || duplications < min_duplications)) {
                    height__diff = this.moveRootOnBranchToMinHeight(g);
                    height = height__diff[0];
                    diff = height__diff[1];
                }
                if (duplications == min_duplications) {
                    if (minimize_height) {
                        equal = false;
                        smaller = false;
                        if (height < min_height) {
                            min_height = height;
                            counter = 1;
                            smaller = true;
                        } else if (height == min_height) {
                            ++counter;
                            equal = true;
                        }
                        if (Math.abs(diff) < min_diff) {
                            min_diff = Math.abs(diff);
                        }
                    }
                    if (return_trees) {
                        if (minimize_height) {
                            if (smaller) {
                                trees.removeAllElements();
                                trees.addElement(g.copy());
                            } else if (equal && trees.size() < max_trees_to_return) {
                                trees.addElement(g.copy());
                            }
                        } else {
                            ++counter;
                            if (trees.size() < max_trees_to_return) {
                                trees.addElement(g.copy());
                            }
                        }
                    } else if (!minimize_height) {
                        ++counter;
                    }
                } else if (duplications < min_duplications) {
                    if (minimize_height) {
                        min_height = height;
                        min_diff = Math.abs(diff);
                    }
                    if (return_trees) {
                        trees.removeAllElements();
                        trees.addElement(g.copy());
                    }
                    counter = 1;
                    min_duplications = duplications;
                }
            } else if (minimize_height) {
                height__diff = this.moveRootOnBranchToMinHeight(g);
                height = height__diff[0];
                diff = height__diff[1];
                if (Math.abs(diff) < 1.0E-10) {
                    sdise = new SDIse(g, species_tree_stripped);
                    min_duplications = sdise.infer(false);
                    min_height = height;
                    min_diff = Math.abs(diff);
                    counter = 1;
                    if (!return_trees) break;
                    trees.addElement(g.copy());
                    break;
                }
            } else {
                min_duplications = duplications;
                if (return_trees) {
                    trees.addElement(g.copy());
                }
            }
            ++j;
        }
        if (return_trees) {
            trees.trimToSize();
            tree_array = new Phylogeny[trees.size()];
            int i = 0;
            while (i < trees.size()) {
                tree_array[i] = (Phylogeny)trees.elementAt(i);
                tree_array[i].adjustNodeCount(false);
                ++i;
            }
        }
        this.setCount(counter);
        this.setMinimalDuplications(min_duplications);
        this.setMinimalMappingCost(min_cost);
        this.setMinimalTreeHeight(min_height);
        this.setMinimalDiffInSubTreeHeights(Math.abs(min_diff));
        return tree_array;
    }

    Phylogeny fastInfer(Phylogeny gene_tree, Phylogeny species_tree) {
        SDIse sdise = null;
        Phylogeny tree_to_return = null;
        Phylogeny species_tree_stripped = null;
        PhylogenyNode prev_root = null;
        PhylogenyNode prev_root_c1 = null;
        PhylogenyNode prev_root_c2 = null;
        PhylogenyBranch[] branches = null;
        boolean prev_root_was_dup = false;
        double height = 0.0;
        double min_height = Double.MAX_VALUE;
        int j = 0;
        int duplications = 0;
        int min_duplications = Integer.MAX_VALUE;
        if (gene_tree.getNumberOfExternalNodes() <= 1) {
            gene_tree.setRooted(true);
            this.setMinimalDuplications(0);
            this.setMinimalTreeHeight(0.0);
            return gene_tree.copy();
        }
        species_tree_stripped = species_tree.copy();
        SDI.stripTree(gene_tree, species_tree_stripped);
        gene_tree.reRootSkeleton(gene_tree.getFirstExternalNode());
        branches = this.getBranchesInOrder(gene_tree);
        if (branches == null) {
            throw new RuntimeException("fastInfer: Unexpected error: Failed to create array of branches.");
        }
        sdise = new SDIse(gene_tree, species_tree_stripped);
        sdise.infer(false);
        j = 0;
        while (j < branches.length) {
            prev_root = gene_tree.getRoot();
            prev_root_c1 = prev_root.getChildNode1();
            prev_root_c2 = prev_root.getChildNode2();
            prev_root_was_dup = prev_root.isDuplication();
            gene_tree.reRootSkeleton(branches[j]);
            duplications = sdise.updateM(prev_root_was_dup, prev_root_c1, prev_root_c2);
            if (duplications <= min_duplications) {
                height = this.moveRootOnBranchToMinHeight(gene_tree)[0];
                if (duplications == min_duplications) {
                    if (height < min_height) {
                        min_height = height;
                        tree_to_return = gene_tree.copy();
                    }
                } else {
                    min_height = height;
                    min_duplications = duplications;
                    tree_to_return = gene_tree.copy();
                }
            }
            ++j;
        }
        this.setMinimalDuplications(min_duplications);
        this.setMinimalTreeHeight(min_height);
        return tree_to_return;
    }

    private PhylogenyBranch[] getBranchesInOrder(Phylogeny t) {
        PhylogenyNode node = t.getRoot();
        PhylogenyBranch[] branches = null;
        int i = 0;
        if (t == null || t.isEmpty() || t.getNumberOfExternalNodes() <= 1) {
            return null;
        }
        branches = node.getChildNode1().isExternal() || node.getChildNode2().isExternal() ? new PhylogenyBranch[3 * t.getNumberOfExternalNodes() - 5] : new PhylogenyBranch[3 * t.getNumberOfExternalNodes() - 6];
        if (t.getNumberOfExternalNodes() == 2) {
            branches[0] = new PhylogenyBranch(t.getRoot().getChildNode1(), t.getRoot().getChildNode2());
            return branches;
        }
        t.setIndicatorsToZero();
        while (!node.isRoot() || node.getIndicator() != 2) {
            if (!node.isExternal() && node.getIndicator() != 2) {
                if (node.getIndicator() == 0) {
                    node.setIndicator(1);
                    node = node.getChildNode1();
                } else {
                    node.setIndicator(2);
                    node = node.getChildNode2();
                }
                if (!node.getParent().isRoot()) {
                    branches[i++] = new PhylogenyBranch(node, node.getParent());
                    continue;
                }
                branches[i++] = new PhylogenyBranch(t.getRoot().getChildNode1(), t.getRoot().getChildNode2());
                continue;
            }
            if (!node.getParent().isRoot() && !node.isExternal()) {
                branches[i++] = new PhylogenyBranch(node, node.getParent());
            }
            node = node.getParent();
        }
        return branches;
    }

    private double[] moveRootOnBranchToMinHeight(Phylogeny t) {
        PhylogenyNode root = t.getRoot();
        PhylogenyNode child1 = root.getChildNode1();
        PhylogenyNode child2 = root.getChildNode2();
        double d = 0.0;
        double diff = 0.0;
        double height = 0.0;
        double[] height_diff = new double[2];
        if (t == null || t.isEmpty() || t.getNumberOfExternalNodes() <= 1) {
            return null;
        }
        d = child1.getDistanceToParent();
        if (Math.abs(d - child2.getDistanceToParent()) > 1.0E-10) {
            throw new RuntimeException("Unexpected error: Root is not in the mid point of its branch.");
        }
        diff = t.getLargestSubtreeHeightDifference();
        height = t.getHeight();
        if (d > 0.0) {
            if (2.0 * d > Math.abs(diff)) {
                child1.setDistanceToParent(d - diff / 2.0);
                child2.setDistanceToParent(d + diff / 2.0);
                height_diff[0] = height - Math.abs(diff / 2.0);
                height_diff[1] = 0.0;
            } else {
                if (diff > 0.0) {
                    child1.setDistanceToParent(0.0);
                    child2.setDistanceToParent(2.0 * d);
                    height_diff[1] = diff - 2.0 * d;
                } else {
                    child1.setDistanceToParent(2.0 * d);
                    child2.setDistanceToParent(0.0);
                    height_diff[1] = diff + 2.0 * d;
                }
                height_diff[0] = height - d;
            }
        } else {
            height_diff[0] = height;
            height_diff[1] = diff;
        }
        return height_diff;
    }

    private void setCount(int i) {
        this.count_ = i;
    }

    private void setMinimalDuplications(int i) {
        this.min_dup_ = i;
    }

    private void setMinimalMappingCost(int i) {
        this.min_cost_ = i;
    }

    private void setMinimalTreeHeight(double d) {
        this.min_height_ = d;
    }

    private void setMinimalDiffInSubTreeHeights(double d) {
        this.min_diff_ = d;
    }

    public static void main(String[] args) {
        boolean minimize_cost = false;
        boolean minimize_sum_of_dup = false;
        boolean minimize_height = false;
        boolean nh = false;
        boolean fast_infer = false;
        int r = 0;
        File species_tree_file = null;
        File gene_tree_file = null;
        Phylogeny gene_tree = null;
        Phylogeny species_tree = null;
        Phylogeny[] trees = null;
        SDIunrooted sdiunrooted = new SDIunrooted();
        DecimalFormat df = new DecimalFormat("0.0#####");
        df.setDecimalSeparatorAlwaysShown(true);
        if (args.length < 2 || args.length > 3) {
            SDIunrooted.errorInCommandLine();
        }
        if (args[0].startsWith("-")) {
            if (args.length < 3) {
                SDIunrooted.errorInCommandLine();
            }
            if (args[0].toLowerCase().indexOf("l") != -1) {
                minimize_cost = true;
            }
            if (args[0].toLowerCase().indexOf("d") != -1) {
                minimize_sum_of_dup = true;
            }
            if (args[0].toLowerCase().indexOf("h") != -1) {
                minimize_height = true;
            }
            if (args[0].toLowerCase().indexOf("x") != -1) {
                fast_infer = true;
            }
            if (args[0].toLowerCase().indexOf("n") != -1) {
                nh = true;
            }
            species_tree_file = new File(args[1]);
            gene_tree_file = new File(args[2]);
        } else {
            if (args.length > 2) {
                SDIunrooted.errorInCommandLine();
            }
            species_tree_file = new File(args[0]);
            gene_tree_file = new File(args[1]);
        }
        if (minimize_cost && minimize_sum_of_dup) {
            minimize_sum_of_dup = false;
        }
        if (fast_infer) {
            minimize_sum_of_dup = true;
            minimize_height = true;
            minimize_cost = false;
        }
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        try {
            gene_tree = factory.create(gene_tree_file, new NHXParser())[0];
        }
        catch (IOException e) {
            System.err.println("\nFailed to read " + gene_tree_file + ". Terminating.\n");
            System.exit(-1);
        }
        try {
            species_tree = factory.create(species_tree_file, new NHXParser())[0];
        }
        catch (IOException e) {
            System.err.println("\nFailed to read " + species_tree_file + ". Terminating.\n");
            System.exit(-1);
        }
        if (nh) {
            Util.extractSpeciesNameFromSeqName(species_tree);
            Util.extractSpeciesNameFromSeqName(gene_tree);
        }
        Util.cleanSpeciesNamesInExtNodes(species_tree);
        if (!(minimize_cost || minimize_sum_of_dup || minimize_height)) {
            gene_tree.setRooted(true);
        }
        r = SDI.stripTree(species_tree, gene_tree);
        System.out.println("\nRemoved " + r + " external nodes from gene tree.\n");
        try {
            if (fast_infer) {
                trees = new Phylogeny[]{sdiunrooted.fastInfer(gene_tree.copy(), species_tree)};
                trees[0].adjustNodeCount(false);
            } else {
                trees = sdiunrooted.infer(gene_tree, species_tree, minimize_cost, minimize_sum_of_dup, minimize_height, true, 5);
            }
        }
        catch (Exception e) {
            System.err.println("Unexpected error during calculation of duplications.");
            System.err.println("Stack trace: ");
            e.printStackTrace();
            System.exit(-1);
        }
        System.out.println("");
        if (fast_infer) {
            System.out.println("Used fast infer.");
        }
        if (minimize_cost) {
            System.out.println("Rooted by minimizing mapping cost L.");
            if (minimize_height) {
                System.out.println("Selected tree(s) with minimal height out of resulting trees.");
            }
            System.out.println("Number differently rooted trees minimizing criterion  : " + sdiunrooted.getCount());
            System.out.println("Minimal cost                                          : " + sdiunrooted.getMinimalMappingCost());
            System.out.println("Minimal duplications                                  : " + sdiunrooted.getMinimalDuplications());
            if (minimize_height) {
                System.out.println("Phylogeny height                                           : " + df.format(sdiunrooted.getMinimalTreeHeight()));
                System.out.println("Difference in subtree heights                         : " + df.format(sdiunrooted.getMinimalDiffInSubTreeHeights()));
            }
            System.out.println("");
        } else if (minimize_sum_of_dup) {
            System.out.println("Rooted by minimizing sum of duplications.");
            if (minimize_height) {
                System.out.println("Selected tree(s) with minimal height out of resulting trees.");
            }
            if (!fast_infer) {
                System.out.println("Number differently rooted trees minimizing criterion        : " + sdiunrooted.getCount());
            }
            System.out.println("Minimal duplications                                        : " + sdiunrooted.getMinimalDuplications());
            if (minimize_height) {
                System.out.println("Phylogeny height                                                 : " + df.format(sdiunrooted.getMinimalTreeHeight()));
                if (!fast_infer) {
                    System.out.println("Difference in subtree heights                               : " + df.format(sdiunrooted.getMinimalDiffInSubTreeHeights()));
                }
            }
            System.out.println("");
        } else if (minimize_height) {
            System.out.println("Rooted by minimizing tree height (midpoint rooting).");
            System.out.println("Minimal tree height                  : " + df.format(sdiunrooted.getMinimalTreeHeight()));
            System.out.println("Minimal difference in subtree heights: " + df.format(sdiunrooted.getMinimalDiffInSubTreeHeights()));
            System.out.println("Duplications in midpoint rooted tree : " + sdiunrooted.getMinimalDuplications());
            System.out.println("");
        } else {
            System.out.println("No (re) rooting was performed.");
            System.out.println("Duplications in tree: " + sdiunrooted.getMinimalDuplications());
            System.out.println("");
        }
        ATVapplicationFrame[] atvframes = new ATVapplicationFrame[trees.length];
        int i = 0;
        while (i < trees.length) {
            atvframes[i] = new ATVapplicationFrame(trees[i], null);
            atvframes[i].setTitle("gene tree " + i);
            atvframes[i].showWhole();
            ++i;
        }
        ATVapplicationFrame atvframe_og = new ATVapplicationFrame(gene_tree, null);
        atvframe_og.setTitle("original gene tree");
        atvframe_og.showWhole();
    }

    private static void errorInCommandLine() {
        System.out.println("\nSDIunrooted: Error in command line.\n");
        System.out.println("Usage: \"SDIunrooted  [-options] <species tree file name> <gene tree file name>\"");
        System.out.println("\nOptions:");
        System.out.println(" -n input trees are in New Hampshire format instead of NHX -- or");
        System.out.println("    the gene tree is in NHX, but species information is");
        System.out.println("    only present in the form of SWISS-PROT sequence names");
        System.out.println(" -l to root by minimizing the mapping cost L (and also the sum of duplications)");
        System.out.println(" -d to root by minimizing the sum of duplications");
        System.out.println(" -h to root by minimizing tree height (can be used together with -l or -d)");
        System.out.println(" -x use fast infer, always minimizes sum of duplications|height");
        System.out.println("\nSpecies tree file");
        System.out.println(" In NHX format, with species names in species name fields; unless -n option");
        System.out.println(" is used.");
        System.out.println("\nGene tree file");
        System.out.println(" In NHX format, with species names in species name fields and sequence names");
        System.out.println(" in sequence name fields; unless -n option is used.");
        System.out.println("");
        System.exit(-1);
    }
}

