/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenomics;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.forester.atv.ATVapplicationFrame;
import org.forester.io.PhylogenyWriter;
import org.forester.phylogenomics.OE;
import org.forester.phylogenomics.SDIse;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.parsers.nhx.NHXParser;
import org.forester.util.Util;

public abstract class SDI {
    private Phylogeny _genetree;
    private Phylogeny _speciestree;
    private int _duplications;
    private int _c;

    public SDI(Phylogeny gene_tree, Phylogeny species_tree) {
        if (!gene_tree.isRooted()) {
            String message = "SDI: gene tree must be rooted.";
            throw new IllegalArgumentException(message);
        }
        if (!species_tree.isRooted()) {
            String message = "SDI: species tree must be rooted.";
            throw new IllegalArgumentException(message);
        }
        this._genetree = gene_tree;
        this._speciestree = species_tree;
        this._duplications = 0;
        this._c = 0;
    }

    public abstract int infer(boolean var1);

    public int computeMappingCost() {
        this._speciestree.levelOrderReID(0);
        this._c = 0;
        this.computeMappingCostHelper(this._genetree.getRoot());
        return this._c;
    }

    public static int stripTree(Phylogeny reference, Phylogeny to_be_stripped) {
        PhylogenyNode r = reference.getFirstExternalNode();
        PhylogenyNode s = to_be_stripped.getFirstExternalNode();
        PhylogenyNode temp = null;
        int i = 0;
        HashMap<String, PhylogenyNode> r_ext_nodes = new HashMap<String, PhylogenyNode>();
        while (r != null) {
            r_ext_nodes.put(r.getTaxonomy(), r);
            r = r.getNextExternalNode();
        }
        while (s != null) {
            temp = s.getNextExternalNode();
            if (!r_ext_nodes.containsKey(s.getTaxonomy())) {
                to_be_stripped.removeExtNode(s);
                ++i;
                s = null;
            }
            s = temp;
        }
        return i;
    }

    public Phylogeny getGeneTree() {
        return this._genetree;
    }

    public Phylogeny getSpeciesTree() {
        return this._speciestree;
    }

    public int getMappingCost() {
        return this._c;
    }

    public int getDuplications() {
        return this._duplications;
    }

    void setDuplicationsToZero() {
        this._duplications = 0;
    }

    void increaseDuplications() {
        ++this._duplications;
    }

    void decreaseDuplications() {
        --this._duplications;
    }

    void linkExtNodesOfG() {
        PhylogenyNodeIterator iter;
        HashMap<String, PhylogenyNode> speciestree_ext_nodes = new HashMap<String, PhylogenyNode>();
        if (this._speciestree.getFirstExternalNode().isRoot()) {
            speciestree_ext_nodes.put(this._speciestree.getFirstExternalNode().getTaxonomy(), this._speciestree.getFirstExternalNode());
        } else {
            iter = this._speciestree.iteratorExternalForward();
            while (iter.hasNext()) {
                PhylogenyNode s = iter.next();
                speciestree_ext_nodes.put(s.getTaxonomy(), s);
            }
        }
        iter = this._genetree.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode g = iter.next();
            PhylogenyNode s = (PhylogenyNode)speciestree_ext_nodes.get(g.getTaxonomy());
            if (s == null) {
                String message = "SDI: species \"" + g.getTaxonomy();
                message = String.valueOf(message) + "\" not present in species tree.";
                throw new IllegalStateException(message);
            }
            g.setLink(s);
        }
    }

    private void computeMappingCostHelper(PhylogenyNode g) {
        if (!g.isExternal()) {
            this.computeMappingCostHelper(g.getChildNode1());
            this.computeMappingCostHelper(g.getChildNode2());
            this._c = g.getLink() != g.getChildNode1().getLink() && g.getLink() != g.getChildNode2().getLink() ? (this._c += g.getChildNode1().getLink().getID() + g.getChildNode2().getLink().getID() - 2 * g.getLink().getID() - 2) : (g.getLink() != g.getChildNode1().getLink() && g.getLink() == g.getChildNode2().getLink() ? (this._c += g.getChildNode1().getLink().getID() - g.getLink().getID() + 1) : (g.getLink() == g.getChildNode1().getLink() && g.getLink() != g.getChildNode2().getLink() ? (this._c += g.getChildNode2().getLink().getID() - g.getLink().getID() + 1) : ++this._c));
        }
    }

    public static void main(String[] args) {
        PhylogenyFactory factory;
        boolean bl = true;
        SDI sdi = null;
        Phylogeny species_tree = null;
        Phylogeny gene_tree = null;
        boolean use_eulenstein = false;
        boolean nh = false;
        File species_tree_file = null;
        File gene_tree_file = null;
        File out_file = new File("sdi_out.nhx");
        int d = 0;
        if (args.length < 2 || args.length > 4) {
            SDI.errorInCommandLine();
        }
        if (args[0].startsWith("-")) {
            if (args.length < 3) {
                SDI.errorInCommandLine();
            }
            if (args[0].toLowerCase().indexOf("e") != -1) {
                use_eulenstein = true;
            }
            if (args[0].toLowerCase().indexOf("n") != -1) {
                nh = true;
            }
            species_tree_file = new File(args[1]);
            gene_tree_file = new File(args[2]);
            if (args.length == 4) {
                out_file = new File(args[3]);
            }
        } else {
            species_tree_file = new File(args[0]);
            gene_tree_file = new File(args[1]);
            if (args.length == 3) {
                out_file = new File(args[2]);
            }
        }
        try {
            factory = ParserBasedPhylogenyFactory.getInstance();
            species_tree = factory.create(species_tree_file, new NHXParser())[0];
        }
        catch (IOException e) {
            System.err.println("Could not read " + species_tree_file + ". Terminating.");
            System.exit(-1);
        }
        try {
            factory = ParserBasedPhylogenyFactory.getInstance();
            gene_tree = factory.create(gene_tree_file, new NHXParser())[0];
        }
        catch (IOException e) {
            System.err.println("Could not read " + gene_tree_file + ". Terminating.");
            System.exit(-1);
        }
        if (nh) {
            Util.extractSpeciesNameFromSeqName(species_tree);
            Util.extractSpeciesNameFromSeqName(gene_tree);
        }
        Util.cleanSpeciesNamesInExtNodes(species_tree);
        try {
            if (use_eulenstein) {
                sdi = new OE(gene_tree, species_tree);
                System.out.println("\nUsing Eulenstein's algorithm.");
            } else {
                sdi = new SDIse(gene_tree, species_tree);
            }
        }
        catch (Exception e) {
            System.err.println("Unexpected error during creation of SDI object: " + e);
            System.exit(-1);
        }
        try {
            d = sdi.infer(true);
        }
        catch (Exception e) {
            System.err.println("Unexpected error during calculation of duplications.");
            System.err.println("Stack trace: ");
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            PhylogenyWriter writer = new PhylogenyWriter();
            writer.toPhyloXML(gene_tree, out_file);
        }
        catch (IOException e) {
            System.err.println("Could not write " + out_file + ". Terminating.");
            System.exit(-1);
        }
        System.out.println("\nNumber of duplications: " + d);
        System.out.flush();
        ATVapplicationFrame atvframe_s = new ATVapplicationFrame(species_tree, null);
        atvframe_s.setTitle("species tree");
        atvframe_s.showWhole();
        ATVapplicationFrame atvframe_g = new ATVapplicationFrame(gene_tree, null);
        atvframe_g.setTitle("gene tree");
        atvframe_g.showWhole();
    }

    private static void errorInCommandLine() {
        System.out.println("\nSDI: Error in command line.\n");
        System.out.println("Usage: \"SDI  [-options] <species tree file name> <gene tree file name> [outfile name]\"");
        System.out.println("\nOptions:");
        System.out.println(" -e to use Eulenstein's algorithm instead of SDIse");
        System.out.println(" -n input trees are in New Hampshire format instead of NHX -- or");
        System.out.println("    the gene tree is in NHX, but species information is");
        System.out.println("    only present in the form of SWISS-PROT sequence names");
        System.out.println("\nSpecies tree file");
        System.out.println(" In NHX format, with species names in species name fields unless -n option");
        System.out.println(" is used.");
        System.out.println("\nGene tree file");
        System.out.println(" In NHX format, with species names in species name fields and sequence names");
        System.out.println(" in sequence name fields unless -n option is used.");
        System.out.println("");
        System.exit(-1);
    }
}

