/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenomics;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.forester.phylogenomics.Int;
import org.forester.phylogenomics.NameAndValues;
import org.forester.phylogenomics.SDI;
import org.forester.phylogenomics.SDIunrooted;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.parsers.nhx.NHXParser;
import org.forester.util.Util;

public class RIO {
    private static final boolean ROOT_BY_MINIMIZING_MAPPING_COST = false;
    private static final boolean ROOT_BY_MINIMIZING_SUM_OF_DUPS = true;
    private static final boolean ROOT_BY_MINIMIZING_TREE_HEIGHT = true;
    private static final boolean TIME = false;
    private static final boolean FAST_INFER = true;
    private static final int EXPECTED_NUMBER_OF_BOOTSTRAPS = 100;
    private HashMap o_hash_maps_;
    private HashMap so_hash_maps_;
    private HashMap up_hash_maps_;
    private HashMap sn_hash_maps_;
    private HashMap m_;
    private HashMap l_;
    private String[] seq_names_;
    private int bootstraps_;
    private int ext_nodes_;
    private long time_;

    public RIO() {
        this.reset();
    }

    public void reset() {
        this.o_hash_maps_ = null;
        this.so_hash_maps_ = null;
        this.up_hash_maps_ = null;
        this.sn_hash_maps_ = null;
        this.seq_names_ = null;
        this.m_ = null;
        this.l_ = null;
        this.bootstraps_ = 1;
        this.ext_nodes_ = 0;
        this.time_ = 0L;
    }

    public void inferOrthologs(File gene_trees_file, Phylogeny species_tree, String query) throws IOException {
        Phylogeny gene_tree = null;
        String incoming = "";
        StringBuffer sb = null;
        BufferedReader in1 = null;
        BufferedReader in2 = null;
        int bs = 0;
        int size = 0;
        if (!gene_trees_file.exists()) {
            throw new IllegalArgumentException(String.valueOf(gene_trees_file.getAbsolutePath()) + " does not exist.");
        }
        if (!gene_trees_file.isFile()) {
            throw new IllegalArgumentException(String.valueOf(gene_trees_file.getAbsolutePath()) + " is not a file.");
        }
        size = (int)(gene_trees_file.length() / 100L) + 1;
        sb = new StringBuffer(size);
        in1 = new BufferedReader(new FileReader(gene_trees_file));
        while ((incoming = in1.readLine()) != null) {
            sb.append(incoming);
            if (incoming.indexOf(";") != -1) break;
        }
        in1.close();
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        gene_tree = factory.create(sb.toString(), new NHXParser())[0];
        Util.extractSpeciesNameFromSeqName(gene_tree);
        SDI.stripTree(gene_tree, species_tree);
        SDI.stripTree(species_tree, gene_tree);
        this.seq_names_ = gene_tree.getAllExternalSeqNames();
        if (this.seq_names_ == null || this.seq_names_.length < 1) {
            return;
        }
        this.o_hash_maps_ = new HashMap(1);
        this.so_hash_maps_ = new HashMap(1);
        this.up_hash_maps_ = new HashMap(1);
        this.sn_hash_maps_ = new HashMap(1);
        this.o_hash_maps_.put(query, new HashMap(this.seq_names_.length));
        this.so_hash_maps_.put(query, new HashMap(this.seq_names_.length));
        this.up_hash_maps_.put(query, new HashMap(this.seq_names_.length));
        this.sn_hash_maps_.put(query, new HashMap(this.seq_names_.length));
        in2 = new BufferedReader(new FileReader(gene_trees_file));
        incoming = "";
        sb = new StringBuffer(size);
        while ((incoming = in2.readLine()) != null) {
            sb.append(incoming);
            if (incoming.indexOf(";") == -1) continue;
            gene_tree = factory.create(sb.toString(), new NHXParser())[0];
            ++bs;
            sb = new StringBuffer(size);
            Util.extractSpeciesNameFromSeqName(gene_tree);
            SDI.stripTree(species_tree, gene_tree);
            this.doInferOrthologs(gene_tree, species_tree, query);
        }
        in2.close();
        this.setBootstraps(bs);
    }

    public void inferOrthologs(Phylogeny[] gene_trees, Phylogeny species_tree) {
        SDI.stripTree(gene_trees[0], species_tree);
        this.seq_names_ = gene_trees[0].getAllExternalSeqNames();
        if (this.seq_names_ == null || this.seq_names_.length < 1) {
            return;
        }
        this.o_hash_maps_ = new HashMap(this.seq_names_.length);
        this.so_hash_maps_ = new HashMap(this.seq_names_.length);
        this.up_hash_maps_ = new HashMap(this.seq_names_.length);
        this.sn_hash_maps_ = new HashMap(this.seq_names_.length);
        int i = 0;
        while (i < this.seq_names_.length) {
            this.o_hash_maps_.put(this.seq_names_[i], new HashMap(this.seq_names_.length));
            this.so_hash_maps_.put(this.seq_names_[i], new HashMap(this.seq_names_.length));
            this.up_hash_maps_.put(this.seq_names_[i], new HashMap(this.seq_names_.length));
            this.sn_hash_maps_.put(this.seq_names_[i], new HashMap(this.seq_names_.length));
            ++i;
        }
        i = 0;
        while (i < gene_trees.length) {
            this.doInferOrthologs(gene_trees[i], species_tree);
            ++i;
        }
        this.setBootstraps(gene_trees.length);
    }

    public void inferOrthologs(File gene_trees_file, Phylogeny species_tree) throws IOException {
        Phylogeny gene_tree = null;
        String incoming = "";
        StringBuffer sb = null;
        BufferedReader in1 = null;
        BufferedReader in2 = null;
        int bs = 0;
        int size = 0;
        if (!gene_trees_file.exists()) {
            throw new IOException(String.valueOf(gene_trees_file.getAbsolutePath()) + " does not exist.");
        }
        if (!gene_trees_file.isFile()) {
            throw new IOException(String.valueOf(gene_trees_file.getAbsolutePath()) + " is not a file.");
        }
        size = (int)(gene_trees_file.length() / 100L) + 1;
        sb = new StringBuffer(size);
        in1 = new BufferedReader(new FileReader(gene_trees_file));
        while ((incoming = in1.readLine()) != null) {
            sb.append(incoming);
            if (incoming.indexOf(";") != -1) break;
        }
        in1.close();
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        gene_tree = factory.create(sb.toString(), new NHXParser())[0];
        Util.extractSpeciesNameFromSeqName(gene_tree);
        SDI.stripTree(gene_tree, species_tree);
        SDI.stripTree(species_tree, gene_tree);
        this.seq_names_ = gene_tree.getAllExternalSeqNames();
        if (this.seq_names_ == null || this.seq_names_.length < 1) {
            return;
        }
        this.o_hash_maps_ = new HashMap(this.seq_names_.length);
        this.so_hash_maps_ = new HashMap(this.seq_names_.length);
        this.up_hash_maps_ = new HashMap(this.seq_names_.length);
        this.sn_hash_maps_ = new HashMap(this.seq_names_.length);
        int i = 0;
        while (i < this.seq_names_.length) {
            this.o_hash_maps_.put(this.seq_names_[i], new HashMap(this.seq_names_.length));
            this.so_hash_maps_.put(this.seq_names_[i], new HashMap(this.seq_names_.length));
            this.up_hash_maps_.put(this.seq_names_[i], new HashMap(this.seq_names_.length));
            this.sn_hash_maps_.put(this.seq_names_[i], new HashMap(this.seq_names_.length));
            ++i;
        }
        in2 = new BufferedReader(new FileReader(gene_trees_file));
        incoming = "";
        sb = new StringBuffer(size);
        while ((incoming = in2.readLine()) != null) {
            sb.append(incoming);
            if (incoming.indexOf(";") == -1) continue;
            gene_tree = factory.create(sb.toString(), new NHXParser())[0];
            ++bs;
            sb = new StringBuffer(size);
            Util.extractSpeciesNameFromSeqName(gene_tree);
            SDI.stripTree(species_tree, gene_tree);
            this.doInferOrthologs(gene_tree, species_tree);
        }
        in2.close();
        this.setBootstraps(bs);
    }

    public String inferredOrthologsToString(String query_name, int sort, double threshold_orthologs, double threshold_subtreeneighborings) {
        HashMap o_hashmap = null;
        HashMap s_hashmap = null;
        HashMap n_hashmap = null;
        String name = "";
        String orthologs = "";
        double o = 0.0;
        double s = 0.0;
        double sn = 0.0;
        double value1 = 0.0;
        double value2 = 0.0;
        double value3 = 0.0;
        double value4 = 0.0;
        double d = 0.0;
        ArrayList<NameAndValues> nv = new ArrayList<NameAndValues>();
        if (this.o_hash_maps_ == null || this.so_hash_maps_ == null || this.sn_hash_maps_ == null) {
            throw new IllegalStateException("Orthologs have not been calculated (successfully).");
        }
        if (sort < 0 || sort > 17) {
            sort = 12;
        }
        if (sort > 2 && this.m_ == null && this.l_ == null) {
            throw new IllegalStateException("Distance list or matrix have not been read in (successfully).");
        }
        if (threshold_orthologs < 0.0) {
            threshold_orthologs = 0.0;
        } else if (threshold_orthologs > 100.0) {
            threshold_orthologs = 100.0;
        }
        if (threshold_subtreeneighborings < 0.0) {
            threshold_subtreeneighborings = 0.0;
        } else if (threshold_subtreeneighborings > 100.0) {
            threshold_subtreeneighborings = 100.0;
        }
        o_hashmap = this.getInferredOrthologs(query_name);
        s_hashmap = this.getInferredSuperOrthologs(query_name);
        n_hashmap = this.getInferredSubtreeNeighbors(query_name);
        if (o_hashmap == null || s_hashmap == null || n_hashmap == null) {
            throw new IllegalStateException("Orthologs for " + query_name + " were not established");
        }
        if (this.seq_names_.length > 0) {
            int i = 0;
            while (i < this.seq_names_.length) {
                name = this.seq_names_[i];
                if (!(name.equals(query_name) || (o = this.getBootstrapValueFromHash(o_hashmap, name)) < threshold_orthologs || (sn = this.getBootstrapValueFromHash(n_hashmap, name)) < threshold_subtreeneighborings)) {
                    s = this.getBootstrapValueFromHash(s_hashmap, name);
                    if (sort >= 3) {
                        d = this.m_ != null ? this.getDistance(query_name, name) : this.getDistance(name);
                    }
                    switch (sort) {
                        case 0: {
                            nv.add(new NameAndValues(name, o, 5));
                            break;
                        }
                        case 1: {
                            nv.add(new NameAndValues(name, o, s, 5));
                            break;
                        }
                        case 2: {
                            nv.add(new NameAndValues(name, s, o, 5));
                            break;
                        }
                        case 3: {
                            nv.add(new NameAndValues(name, o, d, 1));
                            break;
                        }
                        case 4: {
                            nv.add(new NameAndValues(name, d, o, 0));
                            break;
                        }
                        case 5: {
                            nv.add(new NameAndValues(name, o, s, d, 2));
                            break;
                        }
                        case 6: {
                            nv.add(new NameAndValues(name, o, d, s, 1));
                            break;
                        }
                        case 7: {
                            nv.add(new NameAndValues(name, s, o, d, 2));
                            break;
                        }
                        case 8: {
                            nv.add(new NameAndValues(name, s, d, o, 1));
                            break;
                        }
                        case 9: {
                            nv.add(new NameAndValues(name, d, o, s, 0));
                            break;
                        }
                        case 10: {
                            nv.add(new NameAndValues(name, d, s, o, 0));
                            break;
                        }
                        case 11: {
                            nv.add(new NameAndValues(name, o, sn, d, 2));
                            break;
                        }
                        case 12: {
                            nv.add(new NameAndValues(name, o, sn, s, d, 3));
                            break;
                        }
                        case 13: {
                            nv.add(new NameAndValues(name, o, s, sn, d, 3));
                            break;
                        }
                        case 14: {
                            nv.add(new NameAndValues(name, sn, o, s, d, 3));
                            break;
                        }
                        case 15: {
                            nv.add(new NameAndValues(name, sn, d, o, s, 1));
                            break;
                        }
                        case 16: {
                            nv.add(new NameAndValues(name, o, d, sn, s, 1));
                            break;
                        }
                        case 17: {
                            nv.add(new NameAndValues(name, o, sn, d, s, 2));
                            break;
                        }
                        default: {
                            nv.add(new NameAndValues(name, o, 5));
                        }
                    }
                }
                ++i;
            }
            if (nv != null && nv.size() > 0) {
                Object[] nv_array = new NameAndValues[nv.size()];
                int j = 0;
                while (j < nv.size()) {
                    nv_array[j] = (NameAndValues)nv.get(j);
                    ++j;
                }
                Arrays.sort(nv_array);
                int i2 = 0;
                while (i2 < nv_array.length) {
                    name = ((NameAndValues)nv_array[i2]).getName();
                    value1 = ((NameAndValues)nv_array[i2]).getValue1();
                    value2 = ((NameAndValues)nv_array[i2]).getValue2();
                    value3 = ((NameAndValues)nv_array[i2]).getValue3();
                    value4 = ((NameAndValues)nv_array[i2]).getValue4();
                    orthologs = String.valueOf(orthologs) + this.addNameAndValues(name, value1, value2, value3, value4, sort);
                    ++i2;
                }
            }
        }
        if (orthologs == null || orthologs.length() < 1) {
            orthologs = "-";
        }
        return orthologs;
    }

    public String inferredUltraParalogsToString(String query_name, boolean return_dists, double threshold_ultra_paralogs) {
        HashMap sp_hashmap = null;
        String name = "";
        String ultra_paralogs = "";
        int sort = 0;
        double sp = 0.0;
        double value1 = 0.0;
        double value2 = 0.0;
        double d = 0.0;
        ArrayList<NameAndValues> nv = new ArrayList<NameAndValues>();
        if (threshold_ultra_paralogs < 1.0) {
            threshold_ultra_paralogs = 1.0;
        } else if (threshold_ultra_paralogs > 100.0) {
            threshold_ultra_paralogs = 100.0;
        }
        if (this.up_hash_maps_ == null) {
            throw new IllegalStateException("Ultra paralogs have not been calculated (successfully).");
        }
        if (return_dists && this.m_ == null && this.l_ == null) {
            throw new IllegalStateException("Distance list or matrix have not been read in (successfully).");
        }
        sp_hashmap = this.getInferredUltraParalogs(query_name);
        if (sp_hashmap == null) {
            throw new IllegalStateException("Ultra paralogs for " + query_name + " were not established");
        }
        if (this.seq_names_.length > 0) {
            int i = 0;
            while (i < this.seq_names_.length) {
                name = this.seq_names_[i];
                if (!name.equals(query_name) && !((sp = this.getBootstrapValueFromHash(sp_hashmap, name)) < threshold_ultra_paralogs)) {
                    if (return_dists) {
                        d = this.m_ != null ? this.getDistance(query_name, name) : this.getDistance(name);
                        nv.add(new NameAndValues(name, sp, d, 1));
                    } else {
                        nv.add(new NameAndValues(name, sp, 5));
                    }
                }
                ++i;
            }
            if (nv != null && nv.size() > 0) {
                Object[] nv_array = new NameAndValues[nv.size()];
                int j = 0;
                while (j < nv.size()) {
                    nv_array[j] = (NameAndValues)nv.get(j);
                    ++j;
                }
                Arrays.sort(nv_array);
                sort = return_dists ? 91 : 90;
                int i2 = 0;
                while (i2 < nv_array.length) {
                    name = ((NameAndValues)nv_array[i2]).getName();
                    value1 = ((NameAndValues)nv_array[i2]).getValue1();
                    value2 = ((NameAndValues)nv_array[i2]).getValue2();
                    ultra_paralogs = String.valueOf(ultra_paralogs) + this.addNameAndValues(name, value1, value2, 0.0, 0.0, sort);
                    ++i2;
                }
            }
        }
        if (ultra_paralogs == null || ultra_paralogs.length() < 1) {
            ultra_paralogs = "-";
        }
        return ultra_paralogs;
    }

    private double getBootstrapValueFromHash(HashMap h, String name) {
        Int i = (Int)h.get(name);
        if (i == null) {
            return 0.0;
        }
        return i.doubleValue() * 100.0 / (double)this.getBootstraps();
    }

    private String addNameAndValues(String name, double value1, double value2, double value3, double value4, int sort) {
        DecimalFormat df = new DecimalFormat("0.#####");
        df.setDecimalSeparatorAlwaysShown(false);
        String line = "";
        line = name.length() < 8 ? String.valueOf(line) + name + "\t\t\t" : (name.length() < 16 ? String.valueOf(line) + name + "\t\t" : String.valueOf(line) + name + "\t");
        switch (sort) {
            case 0: {
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + "-\t";
                break;
            }
            case 1: {
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + this.addToLine(value2, df);
                line = String.valueOf(line) + "-\t";
                break;
            }
            case 2: {
                line = String.valueOf(line) + this.addToLine(value2, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + "-\t";
                break;
            }
            case 3: {
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + this.addToLine(value2, df);
                break;
            }
            case 4: {
                line = String.valueOf(line) + this.addToLine(value2, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + this.addToLine(value1, df);
                break;
            }
            case 5: {
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + this.addToLine(value2, df);
                line = String.valueOf(line) + this.addToLine(value3, df);
                break;
            }
            case 6: {
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + this.addToLine(value3, df);
                line = String.valueOf(line) + this.addToLine(value2, df);
                break;
            }
            case 7: {
                line = String.valueOf(line) + this.addToLine(value2, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + this.addToLine(value3, df);
                break;
            }
            case 8: {
                line = String.valueOf(line) + this.addToLine(value3, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + this.addToLine(value2, df);
                break;
            }
            case 9: {
                line = String.valueOf(line) + this.addToLine(value2, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + this.addToLine(value3, df);
                line = String.valueOf(line) + this.addToLine(value1, df);
                break;
            }
            case 10: {
                line = String.valueOf(line) + this.addToLine(value3, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + this.addToLine(value2, df);
                line = String.valueOf(line) + this.addToLine(value1, df);
                break;
            }
            case 11: {
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + this.addToLine(value2, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + this.addToLine(value3, df);
                break;
            }
            case 12: {
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + this.addToLine(value2, df);
                line = String.valueOf(line) + this.addToLine(value3, df);
                line = String.valueOf(line) + this.addToLine(value4, df);
                break;
            }
            case 13: {
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + this.addToLine(value3, df);
                line = String.valueOf(line) + this.addToLine(value2, df);
                line = String.valueOf(line) + this.addToLine(value4, df);
                break;
            }
            case 14: {
                line = String.valueOf(line) + this.addToLine(value2, df);
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + this.addToLine(value3, df);
                line = String.valueOf(line) + this.addToLine(value4, df);
                break;
            }
            case 15: {
                line = String.valueOf(line) + this.addToLine(value3, df);
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + this.addToLine(value4, df);
                line = String.valueOf(line) + this.addToLine(value2, df);
                break;
            }
            case 16: {
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + this.addToLine(value3, df);
                line = String.valueOf(line) + this.addToLine(value4, df);
                line = String.valueOf(line) + this.addToLine(value2, df);
                break;
            }
            case 17: {
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + this.addToLine(value2, df);
                line = String.valueOf(line) + this.addToLine(value4, df);
                line = String.valueOf(line) + this.addToLine(value3, df);
                break;
            }
            case 90: {
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + "-\t";
                break;
            }
            case 91: {
                line = String.valueOf(line) + this.addToLine(value1, df);
                line = String.valueOf(line) + this.addToLine(value2, df);
            }
        }
        line = String.valueOf(line) + "\n";
        return line;
    }

    private String addToLine(double value, DecimalFormat df) {
        String s = "";
        s = value != -999.0 ? String.valueOf(df.format(value)) + "\t" : "-\t";
        return s;
    }

    public ArrayList inferredOrthologsToArrayList(String seq_name, double threshold_orthologs) {
        HashMap o_hashmap = null;
        String name = null;
        double o = 0.0;
        ArrayList<String> arraylist = new ArrayList<String>();
        if (this.o_hash_maps_ == null) {
            throw new IllegalStateException("Orthologs have not been calculated (successfully).");
        }
        if (threshold_orthologs < 0.0) {
            threshold_orthologs = 0.0;
        } else if (threshold_orthologs > 100.0) {
            threshold_orthologs = 100.0;
        }
        o_hashmap = this.getInferredOrthologs(seq_name);
        if (o_hashmap == null) {
            throw new IllegalStateException("Orthologs for " + seq_name + " were not established.");
        }
        if (this.seq_names_.length > 0) {
            ArrayList nv = new ArrayList();
            int i = 0;
            while (i < this.seq_names_.length) {
                name = this.seq_names_[i];
                if (!name.equals(seq_name) && !((o = this.getBootstrapValueFromHash(o_hashmap, name)) < threshold_orthologs)) {
                    arraylist.add(name);
                }
                ++i;
            }
        }
        return arraylist;
    }

    public void inferredOrthologTableToFile(File outfile) throws IOException {
        if (this.o_hash_maps_ == null) {
            return;
        }
        this.inferredOrthologTableToFile(outfile, false);
    }

    public void inferredSuperOrthologTableToFile(File outfile) throws IOException {
        if (this.so_hash_maps_ == null) {
            return;
        }
        this.inferredOrthologTableToFile(outfile, true);
    }

    public HashMap getInferredOrthologs(String seq_name) {
        if (this.o_hash_maps_ == null) {
            return null;
        }
        return (HashMap)this.o_hash_maps_.get(seq_name);
    }

    public HashMap getInferredSuperOrthologs(String seq_name) {
        if (this.so_hash_maps_ == null) {
            return null;
        }
        return (HashMap)this.so_hash_maps_.get(seq_name);
    }

    public HashMap getInferredSubtreeNeighbors(String seq_name) {
        if (this.sn_hash_maps_ == null) {
            return null;
        }
        return (HashMap)this.sn_hash_maps_.get(seq_name);
    }

    public HashMap getInferredUltraParalogs(String seq_name) {
        if (this.up_hash_maps_ == null) {
            return null;
        }
        return (HashMap)this.up_hash_maps_.get(seq_name);
    }

    public String getOrder(int sort) {
        String order = "";
        switch (sort) {
            case 0: {
                order = "orthologies";
                break;
            }
            case 1: {
                order = "orthologies > super orthologies";
                break;
            }
            case 2: {
                order = "super orthologies > orthologies";
                break;
            }
            case 3: {
                order = "orthologies > distance to query";
                break;
            }
            case 4: {
                order = "distance to query > orthologies";
                break;
            }
            case 5: {
                order = "orthologies > super orthologies > distance to query";
                break;
            }
            case 6: {
                order = "orthologies > distance to query > super orthologies";
                break;
            }
            case 7: {
                order = "super orthologies > orthologies > distance to query";
                break;
            }
            case 8: {
                order = "super orthologies > distance to query > orthologies";
                break;
            }
            case 9: {
                order = "distance to query > orthologies > super orthologies";
                break;
            }
            case 10: {
                order = "distance to query > super orthologies > orthologies";
                break;
            }
            case 11: {
                order = "orthologies > subtree neighbors > distance to query";
                break;
            }
            case 12: {
                order = "orthologies > subtree neighbors > super orthologies > distance to query";
                break;
            }
            case 13: {
                order = "orthologies > super orthologies > subtree neighbors > distance to query";
                break;
            }
            case 14: {
                order = "subtree neighbors > orthologies > super orthologies > distance to query";
                break;
            }
            case 15: {
                order = "subtree neighbors > distance to query > orthologies > super orthologies";
                break;
            }
            case 16: {
                order = "orthologies > distance to query > subtree neighbors > super orthologies";
                break;
            }
            case 17: {
                order = "orthologies > subtree neighbors > distance to query > super orthologies";
                break;
            }
            default: {
                order = "orthologies";
            }
        }
        return order;
    }

    public long getTime() {
        return this.time_;
    }

    public int getBootstraps() {
        return this.bootstraps_;
    }

    private void setBootstraps(int i) {
        if (i < 1) {
            i = 1;
        }
        this.bootstraps_ = i;
    }

    public int getExtNodesOfAnalyzedGeneTrees() {
        return this.ext_nodes_;
    }

    private void setExtNodesOfAnalyzedGeneTrees(int i) {
        if (i < 1) {
            i = 0;
        }
        this.ext_nodes_ = i;
    }

    public void readDistanceMatrix(File matrix_file) throws IOException {
        String incoming = null;
        StringTokenizer st = null;
        int i = 0;
        int j = 0;
        if (!matrix_file.exists()) {
            throw new IOException(String.valueOf(matrix_file.getAbsolutePath()) + " does not exist.");
        }
        if (!matrix_file.isFile()) {
            throw new IOException(String.valueOf(matrix_file.getAbsolutePath()) + " is not a file.");
        }
        this.m_ = new HashMap();
        this.l_ = null;
        BufferedReader in = new BufferedReader(new FileReader(matrix_file));
        if (in == null) {
            throw new RuntimeException("readDistanceMatrix: failure to create BufferedReader.");
        }
        j = 0;
        i = 0;
        while ((incoming = in.readLine()) != null) {
            st = new StringTokenizer(incoming, " \t\n\r");
            if (st.countTokens() <= 2) continue;
            Vector<Object> current = new Vector<Object>();
            this.m_.put(st.nextToken(), current);
            current.addElement(new Int(i++));
            while (st.hasMoreTokens()) {
                current.addElement(st.nextToken());
            }
            if (j != 0 && current.size() != j) {
                throw new RuntimeException("readDistanceMatrix: " + matrix_file + " might not have the expected format (failed sanity check).");
            }
            j = current.size();
        }
        in.close();
        if (j - 1 != this.m_.size()) {
            throw new RuntimeException("readDistanceMatrix: " + matrix_file + " might not have the expected format (failed sanity check).");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void readDistanceList(File dist_list) throws IOException {
        incoming = null;
        st = null;
        if (!dist_list.exists()) {
            throw new IOException(String.valueOf(dist_list.getAbsolutePath()) + " does not exist.");
        }
        if (!dist_list.isFile()) {
            throw new IOException(String.valueOf(dist_list.getAbsolutePath()) + " is not a file.");
        }
        this.m_ = null;
        this.l_ = new HashMap<K, V>();
        in = new BufferedReader(new FileReader(dist_list));
        if (in != null) ** GOTO lbl16
        throw new RuntimeException("readDistanceList: failure to create BufferedReader.");
lbl-1000:
        // 1 sources

        {
            st = new StringTokenizer(incoming, " \t\n\r");
            if (st.countTokens() != 2) continue;
            this.l_.put(st.nextToken(), new Double(st.nextToken().toString()));
lbl16:
            // 3 sources

            ** while ((incoming = in.readLine()) != null)
        }
lbl17:
        // 1 sources

        in.close();
    }

    public double getDistance(String name1, String name2) {
        Vector vector1 = null;
        Vector vector2 = null;
        Int position_value = null;
        int position = 0;
        String distance_value = null;
        double distance = 0.0;
        name1 = name1.trim();
        name2 = name2.trim();
        if (this.m_ == null) {
            throw new IllegalStateException("Distance matrix has probably not been read in (successfully).");
        }
        vector1 = (Vector)this.m_.get(name1);
        if (vector1 == null) {
            throw new IllegalArgumentException(String.valueOf(name1) + " not found.");
        }
        vector2 = (Vector)this.m_.get(name2);
        if (vector2 == null) {
            throw new IllegalArgumentException(String.valueOf(name2) + " not found.");
        }
        position_value = (Int)vector1.elementAt(0);
        if (position_value == null) {
            throw new RuntimeException("Unexpected failure in method getDistance");
        }
        position = position_value.intValue();
        distance_value = (String)vector2.elementAt(position + 1);
        if (distance_value == null) {
            throw new RuntimeException("Unexpected failure in method getDistance");
        }
        distance = Double.parseDouble(distance_value.trim());
        return distance;
    }

    public double getDistance(String name) {
        double distance = 0.0;
        name = name.trim();
        if (this.l_ == null) {
            throw new IllegalStateException("Distance list has probably not been read in (successfully).");
        }
        if (this.l_.get(name) == null) {
            throw new IllegalArgumentException(String.valueOf(name) + " not found.");
        }
        distance = (Double)this.l_.get(name);
        return distance;
    }

    public static int roundToInt(double d) {
        int i = 0;
        i = (int)(d + 0.5);
        return i;
    }

    private void inferredOrthologTableToFile(File outfile, boolean super_orthologs) throws IOException {
        String name = "";
        String line = "";
        PrintWriter out = null;
        if (this.seq_names_ == null) {
            throw new IllegalStateException("inferredOrthologTableToFile: seq_names_ is null.");
        }
        Arrays.sort(this.seq_names_);
        out = new PrintWriter((Writer)new FileWriter(outfile), true);
        if (out == null) {
            throw new RuntimeException("inferredOrthologTableToFile: failure to create PrintWriter.");
        }
        line = "\t\t\t\t";
        int i = 0;
        while (i < this.seq_names_.length) {
            line = String.valueOf(line) + i + ")\t";
            ++i;
        }
        line = String.valueOf(line) + "\n";
        out.println(line);
        i = 0;
        while (i < this.seq_names_.length) {
            name = this.seq_names_[i];
            line = name.length() < 8 ? String.valueOf(i) + ")\t" + name + "\t\t\t" : (name.length() < 16 ? String.valueOf(i) + ")\t" + name + "\t\t" : String.valueOf(i) + ")\t" + name + "\t");
            line = String.valueOf(line) + this.inferredOrthologsToTableHelper(name, this.seq_names_, i, super_orthologs);
            out.println(line);
            ++i;
        }
        out.close();
    }

    private void doInferOrthologs(Phylogeny gene_tree, Phylogeny species_tree) {
        Phylogeny assigned_tree = null;
        PhylogenyNode node = null;
        SDIunrooted sdiunrooted = new SDIunrooted();
        Vector orthologs = null;
        Vector super_orthologs = null;
        Vector ultra_paralogs = null;
        Vector subtree_neighbors = null;
        assigned_tree = sdiunrooted.fastInfer(gene_tree, species_tree);
        this.setExtNodesOfAnalyzedGeneTrees(assigned_tree.getNumberOfExternalNodes());
        node = assigned_tree.getFirstExternalNode();
        while (node != null) {
            orthologs = assigned_tree.getOrthologousNodes(node);
            this.updateHash(this.o_hash_maps_, node, orthologs);
            super_orthologs = assigned_tree.getSuperOrthologousNodes(node);
            this.updateHash(this.so_hash_maps_, node, super_orthologs);
            subtree_neighbors = assigned_tree.getSubtreeNeighbors(node);
            this.updateHash(this.sn_hash_maps_, node, subtree_neighbors);
            ultra_paralogs = assigned_tree.getUltraParalogousNodes(node);
            this.updateHash(this.up_hash_maps_, node, ultra_paralogs);
            node = node.getNextExternalNode();
        }
    }

    private void doInferOrthologs(Phylogeny gene_tree, Phylogeny species_tree, String query) {
        Phylogeny assigned_tree = null;
        PhylogenyNode node = null;
        SDIunrooted sdiunrooted = new SDIunrooted();
        Vector orthologs = null;
        Vector super_orthologs = null;
        Vector ultra_paralogs = null;
        Vector subtree_neighbors = null;
        assigned_tree = sdiunrooted.fastInfer(gene_tree, species_tree);
        this.setExtNodesOfAnalyzedGeneTrees(assigned_tree.getNumberOfExternalNodes());
        node = assigned_tree.getNode(query);
        orthologs = assigned_tree.getOrthologousNodes(node);
        this.updateHash(this.o_hash_maps_, node, orthologs);
        super_orthologs = assigned_tree.getSuperOrthologousNodes(node);
        this.updateHash(this.so_hash_maps_, node, super_orthologs);
        subtree_neighbors = assigned_tree.getSubtreeNeighbors(node);
        this.updateHash(this.sn_hash_maps_, node, subtree_neighbors);
        ultra_paralogs = assigned_tree.getUltraParalogousNodes(node);
        this.updateHash(this.up_hash_maps_, node, ultra_paralogs);
    }

    private void updateHash(HashMap h, PhylogenyNode n, Vector v) {
        String name = null;
        Int i = null;
        HashMap hash_map = (HashMap)h.get(n.getSeqName());
        if (hash_map == null) {
            throw new RuntimeException("Unexpected failure in method updateHash.");
        }
        int j = 0;
        while (j < v.size()) {
            name = ((PhylogenyNode)v.elementAt(j)).getSeqName();
            if (hash_map.containsKey(name)) {
                i = (Int)hash_map.get(name);
                i.increase();
            } else {
                hash_map.put(name, new Int(1));
            }
            ++j;
        }
    }

    private String inferredOrthologsToTableHelper(String name2, String[] names, int j, boolean super_orthologs) {
        HashMap hashmap = null;
        String name = null;
        String orthologs = new String("");
        Int value_Int = null;
        int value = 0;
        hashmap = !super_orthologs ? this.getInferredOrthologs(name2) : this.getInferredSuperOrthologs(name2);
        if (hashmap == null) {
            throw new RuntimeException("Unexpected failure in method inferredOrthologsToTableHelper");
        }
        int i = 0;
        while (i < names.length) {
            name = names[i];
            value_Int = (Int)hashmap.get(name);
            value = value_Int == null ? 0 : value_Int.intValue();
            if (i == j) {
                if (value != 0) {
                    throw new RuntimeException("Failed sanity check in method inferredOrthologsToTableHelper: value not 0.");
                }
                orthologs = String.valueOf(orthologs) + " \t";
            } else {
                orthologs = String.valueOf(orthologs) + value + "\t";
            }
            ++i;
        }
        return orthologs;
    }
}

