/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenomics;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.parsers.nhx.NHXParser;
import org.forester.util.Util;

public class ORcount {
    private final Phylogeny[] _trees;
    private HashMap _species = null;
    private ArrayList _names = null;
    private static final String[] group_1 = new String[]{"ANOGA", "DROME", "CAEBR", "CAEEL"};
    private static final String[] group_2 = new String[]{"CIOIN", "FUGRU", "MOUSE", "RAT", "HUMAN"};
    private static final String[] all_species = new String[]{"ANOGA", "DROME", "CAEBR", "CAEEL", "CIOIN", "FUGRU", "MOUSE", "RAT", "HUMAN"};
    private int _group1_vs_2_counter = 0;

    public ORcount(Phylogeny[] trees) {
        this._trees = trees;
    }

    public void reset() {
        this.getAllSpecies();
        this.setUpCountingMatrix();
        this.setGroup1Vs2Counter(0);
        this._names = new ArrayList();
    }

    private void getAllSpecies() {
        if (this.getTrees() == null || this.getTrees().length < 1) {
            throw new RuntimeException("Phylogeny array in method \"getAllSpecies( HashMap hash )\" is null or empty.");
        }
        this.setSpecies(new HashMap());
        int i = 0;
        while (i < this.getTrees().length) {
            PhylogenyNode node = this.getTrees()[i].getFirstExternalNode();
            while (node != null) {
                this.getSpecies().put(node.getTaxonomy(), null);
                node = node.getNextExternalNode();
            }
            ++i;
        }
    }

    private void setUpCountingMatrix() {
        if (this.getSpecies() == null || this.getSpecies().size() < 2) {
            throw new RuntimeException("Species HashMap in method \"setUpCountingMatrix()\" is null or contains less than two species.");
        }
        Object[] species_array = this.getSpecies().keySet().toArray();
        int s = species_array.length;
        int i = 0;
        while (i < s) {
            String species = (String)species_array[i];
            HashMap<String, Integer> h = new HashMap<String, Integer>();
            int j = 1 + i;
            while (j < s) {
                h.put((String)species_array[j], new Integer(0));
                ++j;
            }
            this.getSpecies().put(species, h);
            ++i;
        }
    }

    private void printCount() {
        if (this._species == null || this._species.size() < 2) {
            throw new RuntimeException("Species HashMap in method \"setUpCountingMatrix()\" is null or contains less than two species.");
        }
        Object[] species_array = this._species.keySet().toArray();
        int s = species_array.length;
        int i = 0;
        while (i < s - 1) {
            String species = (String)species_array[i];
            System.out.println();
            System.out.println(String.valueOf(species) + ":");
            HashMap h = (HashMap)this._species.get(species);
            int j = 1 + i;
            while (j < s) {
                String sp = (String)species_array[j];
                int c = (Integer)h.get(sp);
                System.out.println(String.valueOf(species) + "-" + sp + ": " + c);
                ++j;
            }
            ++i;
        }
    }

    private void printNames() {
        int i = 0;
        while (i < this._names.size()) {
            System.out.println(String.valueOf(i) + ": " + this._names.get(i));
            ++i;
        }
    }

    private void count(PhylogenyNode node) {
        Vector external_nodes = node.getAllExternalChildren();
        int i = 1;
        while (i < external_nodes.size()) {
            int j = 0;
            while (j < i) {
                PhylogenyNode node_i = (PhylogenyNode)external_nodes.get(i);
                PhylogenyNode node_j = (PhylogenyNode)external_nodes.get(j);
                String si = node_i.getTaxonomy();
                String sj = node_j.getTaxonomy();
                this.count(si, sj, node_i.getSeqName(), node_j.getSeqName());
                ++j;
            }
            ++i;
        }
    }

    private void count(String a, String b, String seq_name_a, String seq_name_b) {
        HashMap h1 = (HashMap)this._species.get(a);
        if (h1 == null) {
            throw new RuntimeException("Unexpected error: Species \"" + a + "\" not present in species matrix.");
        }
        Object h2 = h1.get(b);
        String species_in_h1 = b;
        if (h2 == null) {
            h1 = (HashMap)this._species.get(b);
            if (h1 == null) {
                throw new RuntimeException("Unexpected error: Species \"" + b + "\" not present in species matrix.");
            }
            h2 = h1.get(a);
            species_in_h1 = a;
        }
        if (h2 == null) {
            throw new RuntimeException("Unexpected error: Species \"" + a + "\" not present in species matrix.");
        }
        h1.put(species_in_h1, new Integer((Integer)h2 + 1));
        this._names.add(String.valueOf(a) + "-" + seq_name_a + " = " + b + "-" + seq_name_b);
    }

    public void countSharedAncestralClades(Phylogeny tree, int bootstrap_threshold, String[] group_1, String[] group_2) {
        if (group_1 == null || group_2 == null) {
            throw new IllegalArgumentException("String[](s) in arguments to method \"ORcount.countSharedAncestralClades\" is (are) null.");
        }
        if (!tree.isRooted()) {
            throw new IllegalArgumentException("Phylogeny must be rooted in order to count shared ancestral clades.");
        }
        PhylogenyNodeIterator it = tree.iteratorPostorder();
        tree.setIndicatorsToZero();
        while (it.hasNext()) {
            PhylogenyNode current_node = it.next();
            if (current_node.isPseudoNode()) {
                throw new IllegalArgumentException("Phylogeny can not contain multifurcations in order to count shared ancestral clades.");
            }
            if (current_node.isExternal()) continue;
            PhylogenyNode child1 = current_node.getChildNode1();
            PhylogenyNode child2 = current_node.getChildNode2();
            if (child1.getIndicator() == 1 || child2.getIndicator() == 1) {
                current_node.setIndicator(1);
                continue;
            }
            Vector external_nodes = current_node.getAllExternalChildren();
            String[] external_species = new String[external_nodes.size()];
            int i = 0;
            while (i < external_nodes.size()) {
                PhylogenyNode n = (PhylogenyNode)external_nodes.get(i);
                external_species[i] = n.getTaxonomy().trim().toUpperCase();
                ++i;
            }
            if (!Util.doIntersect(external_species, group_1) || !Util.doIntersect(external_species, group_2)) continue;
            current_node.setIndicator(1);
            if (group_1.length == 1 && group_2.length == 1) {
                this.count(group_1[0], group_2[0], "name a", "name b");
                continue;
            }
            this.increaseGroup1Vs2Counter();
        }
    }

    public void countSharedAncestralClades(Phylogeny[] trees, int bootstrap_threshold) {
        int i = 1;
        while (i < all_species.length) {
            int j = 0;
            while (j < i) {
                String all_i = all_species[i].trim().toUpperCase();
                String all_j = all_species[j].trim().toUpperCase();
                String[] a = new String[]{all_i};
                String[] b = new String[]{all_j};
                int k = 0;
                while (k < trees.length) {
                    this.countSharedAncestralClades(trees[k], bootstrap_threshold, a, b);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (group_1 != null && group_2 != null && group_1.length > 0 && group_2.length > 0) {
            this.setGroup1Vs2Counter(0);
            int k = 0;
            while (k < trees.length) {
                this.countSharedAncestralClades(trees[k], bootstrap_threshold, group_1, group_2);
                ++k;
            }
            System.out.println("\nCount [(" + Util.StringArrayToString(group_1) + ") vs (" + Util.StringArrayToString(group_2) + ")] = " + this.getGroup1Vs2Counter());
        }
    }

    private void countSuperOrthologousRelations(Phylogeny tree, int bootstrap_threshold) {
        PhylogenyNode current_node;
        PhylogenyNodeIterator it = tree.iteratorPostorder();
        if (!tree.isRooted()) {
            throw new IllegalArgumentException("Phylogeny must be rooted in order to count 1:1 orthologous relationships.");
        }
        tree.setIndicatorsToZero();
        it.reset();
        while (it.hasNext()) {
            current_node = it.next();
            if (current_node.isPseudoNode()) {
                throw new IllegalArgumentException("Phylogeny can not contain multifurcations in order to count 1:1 orthologous relationships.");
            }
            if (!current_node.isExternal() && !current_node.isDuplicationOrSpecAssigned()) {
                throw new IllegalArgumentException("All nodes must have duplication or speciation assigned in order to count 1:1 orthologous relationships.");
            }
            if (current_node.isExternal() || !current_node.isDuplication() && current_node.getChildNode1().getIndicator() != 1 && current_node.getChildNode2().getIndicator() != 1) continue;
            current_node.setIndicator(1);
        }
        it.reset();
        while (it.hasNext()) {
            current_node = it.next();
            if (current_node.isExternal() || current_node.getIndicator() != 0 || !current_node.isRoot() && current_node.getParent().getIndicator() != 1 || bootstrap_threshold >= 1 && (!(current_node.getBootstrap() >= (double)bootstrap_threshold) || !(current_node.getChildNode1().getBootstrap() >= (double)bootstrap_threshold) || !(current_node.getChildNode2().getBootstrap() >= (double)bootstrap_threshold))) continue;
            this.count(current_node);
        }
    }

    public void countSuperOrthologousRelations(int bootstrap_threshold) {
        this.reset();
        int i = 0;
        while (i < this._trees.length) {
            this.countSuperOrthologousRelations(this._trees[i], bootstrap_threshold);
            ++i;
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            ORcount.errorInCommandLine();
        }
        Phylogeny[] trees = new Phylogeny[args.length];
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        int i = 0;
        while (i < trees.length) {
            try {
                System.out.println("Reading tree #" + i + "  [" + args[i] + "]");
                trees[i] = factory.create(new File(args[i]), new NHXParser())[0];
            }
            catch (Exception e) {
                System.out.println("\nFailed to read \"" + args[i] + "\". Terminating.\n");
                System.exit(-1);
            }
            ++i;
        }
        System.out.println("Finished reading in trees.\n\n");
        ORcount or_count = new ORcount(trees);
        try {
            System.out.println("\n\n\n\"1:1 ORTHOLOGOUS GENE PAIRS\":\n");
            System.out.println("\n\n\n\"SUPER ORTHOLOGOUS GENE PAIRS\":\n");
            or_count.countSuperOrthologousRelations(0);
            or_count.printNames();
            or_count.printCount();
        }
        catch (Exception e) {
            System.out.println("\nException. Terminating.\n");
            System.out.println("\nException is: " + e + "\n");
            e.printStackTrace();
            System.exit(-1);
        }
        System.out.println("\nDone.");
        System.exit(0);
    }

    private static void errorInCommandLine() {
        System.out.println("\nORcount: Error in command line.\n");
        System.out.println("Usage: \"\"");
        System.out.println("\nOptions:");
        System.out.println(" -");
        System.out.println("");
        System.exit(-1);
    }

    private Phylogeny[] getTrees() {
        return this._trees;
    }

    private void setSpecies(HashMap species) {
        this._species = species;
    }

    private HashMap getSpecies() {
        return this._species;
    }

    private void setGroup1Vs2Counter(int group1_vs_2_counter) {
        this._group1_vs_2_counter = group1_vs_2_counter;
    }

    private int getGroup1Vs2Counter() {
        return this._group1_vs_2_counter;
    }

    private void increaseGroup1Vs2Counter() {
        ++this._group1_vs_2_counter;
    }
}

