/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenomics;

import java.util.HashMap;
import java.util.Vector;
import org.forester.datastructures.BasketDataStructure;
import org.forester.phylogenomics.SDI;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;

public class OE
extends SDI {
    private BasketDataStructure b;

    public OE(Phylogeny gene_tree, Phylogeny species_tree) {
        super(gene_tree, species_tree);
    }

    public int infer(boolean strip_species_tree) {
        this.setDuplicationsToZero();
        if (strip_species_tree) {
            OE.stripTree(this.getGeneTree(), this.getSpeciesTree());
        }
        int x = this.getSpeciesTree().preorderReID(0);
        this.getGeneTree().preorderReID(x);
        this.getSpeciesTree().hashIDs();
        this.getGeneTree().setIndicatorsToZero();
        this.linkExtNodesOfS();
        this.b = new BasketDataStructure(this.getGeneTree().getNumberOfExternalNodes() * 2 + this.getSpeciesTree().getNumberOfExternalNodes() * 2 - 2);
        this.DFS(this.getSpeciesTree().getRoot());
        this.determine(this.getGeneTree().getRoot());
        return this.getDuplications();
    }

    public int computeMappingCost() {
        this.linkExtNodesOfG();
        return super.computeMappingCost();
    }

    void DFS(PhylogenyNode s) {
        Vector nodevector = null;
        if (!s.isExternal()) {
            this.DFS(s.getChildNode1());
            this.b.moveBasket(s.getChildNode1().getID(), s.getID());
            this.DFS(s.getChildNode2());
            this.b.mergeBasket(s.getChildNode2().getID(), s.getID());
        } else {
            nodevector = s.getVector();
            int i = 0;
            while (i < nodevector.size()) {
                PhylogenyNode n = (PhylogenyNode)nodevector.elementAt(i);
                this.b.createBasket(n.getID(), s.getID());
                this.geneTreeWalk(n);
                ++i;
            }
        }
    }

    private void geneTreeWalk(PhylogenyNode g) {
        while (!g.isRoot() && g.getParent().getIndicator() == 1) {
            int species2;
            int species1 = this.b.findBasket((g = g.getParent()).getChildNode1().getID());
            if (species1 < (species2 = this.b.findBasket(g.getChildNode2().getID()))) {
                g.setLink(this.getSpeciesTree().getNode(species1));
            } else {
                g.setLink(this.getSpeciesTree().getNode(species2));
            }
            this.b.insertIntoBasket(g.getID(), g.getLink().getID());
        }
        if (!g.isRoot()) {
            g.getParent().setIndicator(1);
        }
    }

    void linkExtNodesOfS() {
        PhylogenyNode s = this.getSpeciesTree().getFirstExternalNode();
        PhylogenyNode g = this.getGeneTree().getFirstExternalNode();
        String name = null;
        Vector<PhylogenyNode> nodevector = null;
        HashMap genetree_ext_nodes = new HashMap();
        while (g != null) {
            name = g.getTaxonomy();
            if (!genetree_ext_nodes.containsKey(name)) {
                nodevector = new Vector<PhylogenyNode>();
                nodevector.addElement(g);
                genetree_ext_nodes.put(name, nodevector);
            } else {
                ((Vector)genetree_ext_nodes.get(name)).addElement(g);
            }
            g = g.getNextExternalNode();
        }
        while (s != null) {
            nodevector = (Vector<PhylogenyNode>)genetree_ext_nodes.get(s.getTaxonomy());
            if (nodevector == null) {
                String message = "SDI: species \"" + s.getTaxonomy();
                message = String.valueOf(message) + "\" not present in Phylogeny genetree.";
                throw new IllegalStateException(message);
            }
            s.setVector(nodevector);
            s = s.getNextExternalNode();
        }
    }

    void determine(PhylogenyNode g) {
        if (!g.isExternal()) {
            this.determine(g.getChildNode1());
            this.determine(g.getChildNode2());
            g.setDuplicationOrSpecAssigned(true);
            if (g.getChildNode1().isExternal() && g.getChildNode2().isExternal() && g.getChildNode1().getTaxonomy().equals(g.getChildNode2().getTaxonomy())) {
                g.setDuplication(true);
                this.increaseDuplications();
            } else if (g.getLink() == g.getChildNode1().getLink() || g.getLink() == g.getChildNode2().getLink()) {
                g.setDuplication(true);
                this.increaseDuplications();
            } else {
                g.setDuplication(false);
            }
        }
    }
}

