/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenomics;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.forester.io.PhylogenyWriter;
import org.forester.phylogenomics.DistanceCalculator;
import org.forester.phylogenomics.Int;
import org.forester.phylogenomics.RIO;
import org.forester.phylogenomics.SDI;
import org.forester.phylogenomics.SDIunrooted;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.phylogeny.parsers.nhx.NHXParser;
import org.forester.util.Util;

public class DoRIO {
    private static final boolean TIME = false;
    private static final boolean VERBOSE = false;
    private static final boolean MINIMIZE_COST = false;
    private static final boolean MINIMIZE_DUPS = true;
    private static final boolean MINIMIZE_HEIGHT = true;
    private static final int WARN_NO_ORTHOS_DEFAULT = 2;
    private static final int WARN_MORE_THAN_ONE_ORTHO_DEFAULT = 2;
    private static final double THRESHOLD_ULTRA_PARALOGS_DEFAULT = 50.0;
    private static final double WARN_ONE_ORTHO_DEFAULT = 2.0;
    private static final String tree_file_for_dist_val_SUFFIX = ".nhx";
    private static final String ADDITION_FOR_RIO_ANNOT_TREE = ".rio";

    public static void main(String[] args) {
        PhylogenyFactory factory;
        File species_tree_file = null;
        File multiple_trees_file = null;
        File outfile = null;
        File distance_matrix_file = null;
        File distance_list_file = null;
        File tree_file_for_dist_val = null;
        File tree_file_for_avg_bs = null;
        String seq_name = "";
        String output = "";
        String arg = "";
        boolean safe_nhx = false;
        boolean output_ultraparalogs = false;
        ArrayList orthologs_al_for_dc = null;
        double t_orthologs = 0.0;
        double t_sn = 0.0;
        double t_orthologs_dc = 0.0;
        double[] bs_mean_sd = null;
        int sort = 0;
        Phylogeny species_tree = null;
        RIO rio = null;
        PrintWriter out = null;
        long time = 0L;
        int warn_no_orthos = 2;
        int warn_more_than_one_ortho = 2;
        double warn_one_ortho = 2.0;
        double threshold_ultra_paralogs = 50.0;
        DecimalFormat df = new DecimalFormat("0.#####");
        df.setDecimalSeparatorAlwaysShown(false);
        if (args.length < 3 || args.length > 18) {
            DoRIO.errorInCommandLine();
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].trim().charAt(0) != 'I' && args[i].trim().charAt(0) != 'p') {
                if (args[i].trim().length() < 3) {
                    DoRIO.errorInCommandLine();
                } else {
                    arg = args[i].trim().substring(2);
                }
            }
            try {
                switch (args[i].trim().charAt(0)) {
                    case 'M': {
                        if (multiple_trees_file != null) {
                            DoRIO.errorInCommandLine();
                        }
                        multiple_trees_file = new File(arg);
                        break;
                    }
                    case 'N': {
                        if (seq_name != "") {
                            DoRIO.errorInCommandLine();
                        }
                        seq_name = arg;
                        break;
                    }
                    case 'S': {
                        if (species_tree_file != null) {
                            DoRIO.errorInCommandLine();
                        }
                        species_tree_file = new File(arg);
                        break;
                    }
                    case 'O': {
                        if (outfile != null) {
                            DoRIO.errorInCommandLine();
                        }
                        outfile = new File(arg);
                        break;
                    }
                    case 'D': {
                        if (distance_matrix_file != null || distance_list_file != null) {
                            DoRIO.errorInCommandLine();
                        }
                        distance_matrix_file = new File(arg);
                        break;
                    }
                    case 'd': {
                        if (distance_matrix_file != null || distance_list_file != null) {
                            DoRIO.errorInCommandLine();
                        }
                        distance_list_file = new File(arg);
                        break;
                    }
                    case 'T': {
                        if (tree_file_for_dist_val != null) {
                            DoRIO.errorInCommandLine();
                        }
                        tree_file_for_dist_val = new File(arg);
                        break;
                    }
                    case 't': {
                        if (tree_file_for_avg_bs != null) {
                            DoRIO.errorInCommandLine();
                        }
                        tree_file_for_avg_bs = new File(arg);
                        break;
                    }
                    case 'p': {
                        output_ultraparalogs = true;
                        break;
                    }
                    case 'I': {
                        safe_nhx = true;
                        break;
                    }
                    case 'P': {
                        if (sort != 0) {
                            DoRIO.errorInCommandLine();
                        }
                        sort = Integer.parseInt(arg);
                        break;
                    }
                    case 'L': {
                        if (t_orthologs != 0.0) {
                            DoRIO.errorInCommandLine();
                        }
                        t_orthologs = Double.parseDouble(arg);
                        break;
                    }
                    case 'B': {
                        if (t_sn != 0.0) {
                            DoRIO.errorInCommandLine();
                        }
                        t_sn = Double.parseDouble(arg);
                        break;
                    }
                    case 'U': {
                        if (t_orthologs_dc != 0.0) {
                            DoRIO.errorInCommandLine();
                        }
                        t_orthologs_dc = Double.parseDouble(arg);
                        break;
                    }
                    case 'v': {
                        if (threshold_ultra_paralogs != 50.0) {
                            DoRIO.errorInCommandLine();
                        }
                        threshold_ultra_paralogs = Double.parseDouble(arg);
                        break;
                    }
                    case 'X': {
                        if (warn_more_than_one_ortho != 2) {
                            DoRIO.errorInCommandLine();
                        }
                        warn_more_than_one_ortho = Integer.parseInt(arg);
                        break;
                    }
                    case 'Y': {
                        if (warn_no_orthos != 2) {
                            DoRIO.errorInCommandLine();
                        }
                        warn_no_orthos = Integer.parseInt(arg);
                        break;
                    }
                    case 'Z': {
                        if (warn_one_ortho != 2.0) {
                            DoRIO.errorInCommandLine();
                        }
                        warn_one_ortho = Double.parseDouble(arg);
                        break;
                    }
                    default: {
                        DoRIO.errorInCommandLine();
                        break;
                    }
                }
            }
            catch (Exception e) {
                DoRIO.errorInCommandLine();
            }
            ++i;
        }
        if (seq_name == "" || species_tree_file == null || multiple_trees_file == null || outfile == null) {
            DoRIO.errorInCommandLine();
        }
        if (sort < 0 || sort > 17) {
            DoRIO.errorInCommandLine();
        }
        if (sort > 2 && distance_matrix_file == null && distance_list_file == null) {
            DoRIO.errorInCommandLine();
        }
        try {
            factory = ParserBasedPhylogenyFactory.getInstance();
            species_tree = factory.create(species_tree_file, new NHXParser())[0];
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        if (!species_tree.isRooted()) {
            System.out.println("\n\nSpecies tree is not rooted.\n\n");
            System.exit(-1);
        }
        if (!species_tree.isCompletelyBinary()) {
            System.out.println("\n\nSpecies tree is not completely binary.\n\n");
            System.exit(-1);
        }
        Util.cleanSpeciesNamesInExtNodes(species_tree);
        rio = new RIO();
        try {
            if (distance_matrix_file != null) {
                rio.readDistanceMatrix(distance_matrix_file);
            } else if (distance_list_file != null) {
                rio.readDistanceList(distance_list_file);
            }
            rio.inferOrthologs(multiple_trees_file, species_tree.copy(), seq_name);
            output = rio.inferredOrthologsToString(seq_name, sort, t_orthologs, t_sn);
            if (tree_file_for_dist_val != null) {
                Phylogeny p;
                orthologs_al_for_dc = rio.inferredOrthologsToArrayList(seq_name, t_orthologs_dc);
                factory = ParserBasedPhylogenyFactory.getInstance();
                if (tree_file_for_avg_bs != null) {
                    p = factory.create(tree_file_for_avg_bs, new NHXParser())[0];
                    bs_mean_sd = DoRIO.calculateMeanBoostrapValue(p);
                } else {
                    p = factory.create(tree_file_for_dist_val, new NHXParser())[0];
                    bs_mean_sd = DoRIO.calculateMeanBoostrapValue(p);
                }
                if (bs_mean_sd != null && bs_mean_sd.length == 2) {
                    double bs_mean = bs_mean_sd[0];
                    double bs_sd = bs_mean_sd[1];
                    output = String.valueOf(output) + "\n\nMean bootstrap value of consensus tree (sd): " + RIO.roundToInt(bs_mean * 100.0 / (double)rio.getBootstraps()) + "% (+/-" + RIO.roundToInt(bs_sd * 100.0 / (double)rio.getBootstraps()) + "%)\n";
                }
                output = String.valueOf(output) + "\n\nDistance values:\n";
                output = String.valueOf(output) + DoRIO.getDistances(tree_file_for_dist_val, outfile, species_tree, seq_name, orthologs_al_for_dc, rio.getInferredOrthologs(seq_name), rio.getInferredSuperOrthologs(seq_name), rio.getInferredSubtreeNeighbors(seq_name), warn_more_than_one_ortho, warn_no_orthos, warn_one_ortho, rio.getBootstraps(), safe_nhx, t_orthologs_dc);
            }
            if (output_ultraparalogs) {
                output = String.valueOf(output) + "\n\nUltra paralogs:\n";
                output = String.valueOf(output) + rio.inferredUltraParalogsToString(seq_name, sort > 2, threshold_ultra_paralogs);
            }
            output = String.valueOf(output) + "\n\nSort priority: " + rio.getOrder(sort);
            output = String.valueOf(output) + "\nExt nodes    : " + rio.getExtNodesOfAnalyzedGeneTrees();
            output = String.valueOf(output) + "\nBootstraps   : " + rio.getBootstraps() + "\n";
            out = new PrintWriter((Writer)new FileWriter(outfile), true);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        out.println(output);
        out.close();
        System.exit(0);
    }

    private static String getDistances(File tree_file_for_dist_val, File outfile, Phylogeny species_tree, String seq_name, ArrayList al_ortholog_names_for_dc, HashMap ortholog_hashmap, HashMap super_ortholog_hashmap, HashMap sn_hashmap, int warn_more_than_one_ortho, int warn_no_orthos, double warn_one_ortho, int bootstraps, boolean safe_nhx, double t_orthologs_dc) throws IOException {
        int i;
        Phylogeny consensus_tree = null;
        Phylogeny assigned_cons_tree = null;
        String string = "";
        SDIunrooted sdiunrooted = new SDIunrooted();
        ArrayList<PhylogenyNode> al_ortholog_nodes = new ArrayList<PhylogenyNode>();
        double m = 0.0;
        double sd = 0.0;
        double d = 0.0;
        int n = 0;
        int o = 0;
        int so = 0;
        int sn = 0;
        PhylogenyNode node = null;
        Int o_value = null;
        Int so_value = null;
        Int sn_value = null;
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        consensus_tree = factory.create(tree_file_for_dist_val, new NHXParser())[0];
        Util.cleanSpeciesNamesInExtNodes(species_tree);
        Util.extractSpeciesNameFromSeqName(consensus_tree);
        SDI.stripTree(species_tree, consensus_tree);
        assigned_cons_tree = sdiunrooted.infer(consensus_tree, species_tree, false, true, true, true, 1)[0];
        if (safe_nhx) {
            if (bootstraps < 1) {
                bootstraps = 1;
            }
            String seq_n = "";
            String[] seq_names = consensus_tree.getAllExternalSeqNames();
            i = 0;
            while (i < seq_names.length) {
                seq_n = seq_names[i];
                o_value = (Int)ortholog_hashmap.get(seq_n);
                so_value = (Int)super_ortholog_hashmap.get(seq_n);
                sn_value = (Int)sn_hashmap.get(seq_n);
                node = assigned_cons_tree.getNode(seq_n);
                if (o_value != null) {
                    o = o_value.intValue();
                    node.setOrthologous(RIO.roundToInt((double)o * 100.0 / (double)bootstraps));
                }
                if (so_value != null) {
                    so = so_value.intValue();
                    node.setSuperOrthologous(RIO.roundToInt((double)so * 100.0 / (double)bootstraps));
                }
                if (sn_value != null) {
                    sn = sn_value.intValue();
                    node.setSubtreeNeighborings(RIO.roundToInt((double)sn * 100.0 / (double)bootstraps));
                }
                ++i;
            }
            node = assigned_cons_tree.getNode(seq_name);
            node.setOrthologous(-11);
            node.setSuperOrthologous(-11);
            node.setSubtreeNeighborings(-11);
        }
        DistanceCalculator dc = new DistanceCalculator();
        DecimalFormat df = new DecimalFormat("0.######");
        df.setDecimalSeparatorAlwaysShown(false);
        string = "Given the threshold for distance calculations (" + Util.roundToInt(t_orthologs_dc) + "): ";
        if (al_ortholog_names_for_dc.size() == 0) {
            dc.setTree(assigned_cons_tree);
            m = dc.getMean();
            sd = dc.getStandardDeviation();
            d = dc.getDistanceToRoot(seq_name);
            n = dc.getN();
            string = String.valueOf(string) + "No sequence is considered orthologous to query." + "\ndistance of query to root                     = " + df.format(d) + "\nmean of distances (for all sequences) to root = " + df.format(m) + "\nsd of distances (for all sequences) to root   = " + df.format(sd) + "\nn (sum of sequences in alignment plus query)  = " + n;
            if (!(m - (double)warn_no_orthos * sd < d) || !(m + (double)warn_no_orthos * sd > d)) {
                string = String.valueOf(string) + "\nWARNING: distance of query to root is outside of mean+/-" + warn_no_orthos + "*sd!";
            }
        } else if (al_ortholog_names_for_dc.size() == 1) {
            String name_of_ortholog = (String)al_ortholog_names_for_dc.get(0);
            al_ortholog_nodes.add(assigned_cons_tree.getNode(name_of_ortholog));
            al_ortholog_nodes.add(assigned_cons_tree.getNode(seq_name));
            dc.setTreeAndExtNodes(assigned_cons_tree, al_ortholog_nodes);
            d = dc.getDistanceToLCA(seq_name);
            double d_o = dc.getDistanceToLCA(name_of_ortholog);
            string = String.valueOf(string) + "One sequence is considered orthologous to query." + "\nLCA is LCA of query and its ortholog." + "\ndistance of query to LCA    = " + df.format(d) + "\ndistance of ortholog to LCA = " + df.format(d_o);
            if (d_o > 0.0 && d > 0.0 && (d_o >= d && d_o / d > warn_one_ortho || d_o < d && d / d_o > warn_one_ortho)) {
                string = String.valueOf(string) + "\nWARNING: Ratio of distances to LCA is greater than " + warn_one_ortho + "!";
            } else if (!(d_o != 0.0 && d != 0.0 || d_o == 0.0 && d == 0.0)) {
                string = String.valueOf(string) + "\nWARNING: Ratio could not be calculated,  one distance is 0.0!";
            }
        } else {
            i = 0;
            while (i < al_ortholog_names_for_dc.size()) {
                al_ortholog_nodes.add(assigned_cons_tree.getNode((String)al_ortholog_names_for_dc.get(i)));
                ++i;
            }
            al_ortholog_nodes.add(assigned_cons_tree.getNode(seq_name));
            dc.setTreeAndExtNodes(assigned_cons_tree, al_ortholog_nodes);
            m = dc.getMean();
            sd = dc.getStandardDeviation();
            d = dc.getDistanceToLCA(seq_name);
            n = dc.getN();
            string = String.valueOf(string) + "More than one sequence is considered orthologous to query." + "\nLCA is LCA of query and its orthologs." + "\ndistance of query to LCA                               = " + df.format(d) + "\nmean of distances (for query and its orthologs) to LCA = " + df.format(m) + "\nsd of distances (for query and its orthologs) to LCA   = " + df.format(sd) + "\nn (sum of orthologs plus query)                        = " + n;
            if (!(m - (double)warn_more_than_one_ortho * sd < d) || !(m + (double)warn_more_than_one_ortho * sd > d)) {
                string = String.valueOf(string) + "\n!WARNING: distance of query to LCA is outside of mean+/-" + warn_more_than_one_ortho + "*sd!";
            }
        }
        if (safe_nhx) {
            File outfile_act = new File(outfile + ADDITION_FOR_RIO_ANNOT_TREE + tree_file_for_dist_val_SUFFIX);
            PhylogenyWriter writer = new PhylogenyWriter();
            writer.toNewHampshireX(assigned_cons_tree, outfile_act);
        }
        return string;
    }

    public static double[] calculateMeanBoostrapValue(Phylogeny t) {
        double b = 0.0;
        int n = 0;
        long sum = 0L;
        double x = 0.0;
        double mean = 0.0;
        double[] da = new double[2];
        Vector<Double> bv = new Vector<Double>();
        PhylogenyNode node = null;
        PreorderTreeIterator i = null;
        i = new PreorderTreeIterator(t);
        while (i.hasNext()) {
            node = i.next();
            if (node.getParent() != null && node.getParent().isRoot() && node.getParent().getChildNode1().getBootstrap() > 0.0 && node.getParent().getChildNode2().getBootstrap() > 0.0 && node.getParent().getChildNode2() == node || !((b = node.getBootstrap()) > 0.0)) continue;
            sum = (long)((double)sum + b);
            bv.addElement(new Double(b));
            ++n;
        }
        if (n < 2) {
            return null;
        }
        mean = (double)sum / (double)n;
        sum = 0L;
        int j = 0;
        while (j < n) {
            b = ((Integer)bv.elementAt(j)).intValue();
            x = b - mean;
            sum = (long)((double)sum + x * x);
            ++j;
        }
        da[0] = mean;
        da[1] = Math.sqrt((double)sum / ((double)n - 1.0));
        return da;
    }

    private static void errorInCommandLine() {
        System.out.println("\nDoRIO: Error in command line.\n");
        System.out.println("args[ 0 ] - args[ 12 ] use the following tags:\n");
        System.out.println("M= (String) Multiple gene tree file name (mandatory)");
        System.out.println("N= (String) Query, seq name of seq whose orthologs are to be inferred (mandatory)");
        System.out.println("S= (String) Species tree file name (mandatory)");
        System.out.println("O= (String) Output file name (overwrites without warning!)(mandatory)");
        System.out.println("D= (String) Distance matrix file for pairwise distances");
        System.out.println("d= (String) Distance list file for distances to query");
        System.out.println("            (instead of \"D=\")");
        System.out.println("T= (String) Phylogeny file for distances of query to LCA");
        System.out.println("            of orthologs and for mean bootstrap value (if t= is not used),");
        System.out.println("            must be binary )");
        System.out.println("t= (String) Phylogeny file for mean bootstrap value (if this option is used,");
        System.out.println("            the mean bootstrap value is not calculated from the tree read in");
        System.out.println("            with T=), not necessary binary");
        System.out.println("p           Output ultra paralogs");
        System.out.println("I           Save the rooted, with dup vs spec and orthology information");
        System.out.println("            decorated tree read in with T= as \"output-file-name.rio.nhx\"");
        System.out.println("P= (int)    Sort priority");
        System.out.println("L= (double) Threshold orthologs for output (use ' for doubles. e.g. 'Y=5.5')");
        System.out.println("L= (double) Threshold subtree neighborings for output");
        System.out.println("U= (double) Threshold orthologs for distance calculation");
        System.out.println("X= (int)    More than one ortholog: ");
        System.out.println("            numbers of sd the dist. to LCA has to differ from mean to generate a warning");
        System.out.println("Y= (int)    No orthologs:");
        System.out.println("            Numbers of sd the dist to root has to differ from mean to generate a warning");
        System.out.println("Z= (double) One ortholog:");
        System.out.println("            threshold for factor between the two distances to their LCA (larger/smaller)");
        System.out.println("            to generate a warning");
        System.out.println("");
        System.exit(-1);
    }
}

