/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenomics;

import java.io.File;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Vector;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.parsers.nhx.NHXParser;

public class DistanceCalculator {
    public static final double DEFAULT = -1.0;
    private Phylogeny tree_;
    private ArrayList nodes_;
    private int n_;
    private double mean_;
    private double variance_;
    private double stand_dev_;
    private PhylogenyNode lca_;

    public DistanceCalculator() {
        this.tree_ = null;
        this.nodes_ = null;
        this.n_ = 0;
        this.mean_ = -1.0;
        this.variance_ = -1.0;
        this.stand_dev_ = -1.0;
        this.lca_ = null;
    }

    public DistanceCalculator(Phylogeny t) {
        this.setTree(t);
    }

    public DistanceCalculator(Phylogeny t, Vector ext_nodes) {
        this.setTreeAndExtNodes(t, ext_nodes);
    }

    public void setTree(Phylogeny t) {
        this.tree_ = t;
        this.nodes_ = null;
        this.n_ = 0;
        this.mean_ = -1.0;
        this.variance_ = -1.0;
        this.stand_dev_ = -1.0;
        this.lca_ = null;
        this.calculateMeanDistToRoot();
        this.calculateVarianceDistToRoot();
        this.calculateStandardDeviation();
    }

    public void setTreeAndExtNodes(Phylogeny t, Vector ext_nodes) {
        this.setTreeAndExtNodes(t, new ArrayList(ext_nodes));
    }

    public void setTreeAndExtNodes(Phylogeny t, ArrayList ext_nodes) {
        this.tree_ = t;
        this.nodes_ = ext_nodes;
        this.n_ = 0;
        this.mean_ = -1.0;
        this.variance_ = -1.0;
        this.stand_dev_ = -1.0;
        this.lca_ = this.calculateLCA(this.nodes_);
        this.calculateMean();
        this.calculateVariance();
        this.calculateStandardDeviation();
    }

    public double getDistanceToRoot(PhylogenyNode n) {
        if (this.tree_ == null || this.tree_.isEmpty()) {
            return 0.0;
        }
        double d = 0.0;
        try {
            d = this.getDistanceToNode(n, this.tree_.getRoot());
        }
        catch (Exception e) {
            System.err.println("getDistanceToRoot(PhylogenyNode): Unexpected exception: " + e);
            System.exit(-1);
        }
        return d;
    }

    public double getDistanceToNode(PhylogenyNode outer, PhylogenyNode inner) {
        double d = 0.0;
        double dist = 0.0;
        while (inner != outer && !outer.isRoot()) {
            if (!outer.isPseudoNode() && (d = outer.getDistanceToParent()) > 0.0) {
                dist += d;
            }
            outer = outer.getParent();
        }
        if (!inner.isRoot() && outer.isRoot()) {
            throw new IllegalArgumentException("getDistanceToNode(PhylogenyNode outer,PhylogenyNode inner): PhylogenyNode inner is not closer to the root than PhylogenyNode outer or is not on the same \"subtree\"");
        }
        return dist;
    }

    public double getDistanceToRoot(String seq_name) {
        if (this.tree_ == null || this.tree_.isEmpty()) {
            return 0.0;
        }
        return this.getDistanceToNode(seq_name, this.tree_.getRoot());
    }

    public double getDistanceToLCA(String seq_name) {
        if (this.tree_ == null || this.tree_.isEmpty() || this.lca_ == null) {
            return 0.0;
        }
        return this.getDistanceToNode(seq_name, this.lca_);
    }

    public double getDistanceToNode(String seq_name, PhylogenyNode inner) {
        if (this.tree_ == null || this.tree_.isEmpty()) {
            return 0.0;
        }
        return this.getDistanceToNode(this.tree_.getNode(seq_name), inner);
    }

    public double getMean() {
        return this.mean_;
    }

    public double getVariance() {
        return this.variance_;
    }

    public double getStandardDeviation() {
        return this.stand_dev_;
    }

    public int getN() {
        return this.n_;
    }

    private void calculateMeanDistToRoot() {
        if (this.tree_ == null || this.tree_.isEmpty()) {
            return;
        }
        double sum = 0.0;
        PhylogenyNode node = this.tree_.getFirstExternalNode();
        this.n_ = 0;
        while (node != null) {
            ++this.n_;
            sum += this.getDistanceToRoot(node);
            node = node.getNextExternalNode();
        }
        this.setMean(sum / (double)this.n_);
    }

    private void calculateMean() {
        if (this.nodes_ == null || this.nodes_.isEmpty() || this.tree_ == null || this.tree_.isEmpty()) {
            return;
        }
        double sum = 0.0;
        ListIterator li = this.nodes_.listIterator();
        this.n_ = 0;
        try {
            while (li.hasNext()) {
                ++this.n_;
                sum += this.getDistanceToNode((PhylogenyNode)li.next(), this.lca_);
            }
        }
        catch (Exception e) {
            System.err.println("calculateMean(): Exception: " + e);
            System.exit(-1);
        }
        this.setMean(sum / (double)this.n_);
    }

    private void calculateVarianceDistToRoot() {
        if (this.getMean() == -1.0 || this.tree_ == null || this.tree_.isEmpty() || (double)this.n_ <= 1.0) {
            return;
        }
        double x = 0.0;
        double sum = 0.0;
        PhylogenyNode node = this.tree_.getFirstExternalNode();
        while (node != null) {
            x = this.getDistanceToRoot(node) - this.getMean();
            sum += x * x;
            node = node.getNextExternalNode();
        }
        this.setVariance(sum / (double)(this.n_ - 1));
    }

    private void calculateVariance() {
        if (this.getMean() == -1.0 || this.nodes_ == null || this.nodes_.isEmpty() || this.tree_ == null || this.tree_.isEmpty() || (double)this.n_ <= 1.0) {
            return;
        }
        double x = 0.0;
        double sum = 0.0;
        ListIterator li = this.nodes_.listIterator();
        try {
            while (li.hasNext()) {
                x = this.getDistanceToNode((PhylogenyNode)li.next(), this.lca_) - this.getMean();
                sum += x * x;
            }
        }
        catch (Exception e) {
            System.err.println("calculateVariance(): Exception: " + e);
            System.exit(-1);
        }
        this.setVariance(sum / (double)(this.n_ - 1));
    }

    private void calculateStandardDeviation() {
        if (this.getVariance() == -1.0 || this.getVariance() < 0.0) {
            return;
        }
        this.setStandardDeviation(Math.sqrt(this.getVariance()));
    }

    private PhylogenyNode calculateLCA(ArrayList nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        PhylogenyNode node = (PhylogenyNode)nodes.get(0);
        int c = node.getSumExtNodes();
        int v = nodes.size();
        while (!node.isRoot() && c < v) {
            node = node.getParent();
            c = node.getSumExtNodes();
        }
        ArrayList current_nodes = new ArrayList(node.getAllExternalChildren());
        while (!node.isRoot() && !current_nodes.containsAll(nodes)) {
            node = node.getParent();
            current_nodes = new ArrayList(node.getAllExternalChildren());
        }
        return node;
    }

    private void setMean(double d) {
        this.mean_ = d;
    }

    private void setVariance(double d) {
        this.variance_ = d;
    }

    private void setStandardDeviation(double d) {
        this.stand_dev_ = d;
    }

    public static void main(String[] args) {
        File tree_file = null;
        Phylogeny tree = null;
        DistanceCalculator dc = null;
        tree_file = new File(args[0]);
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            tree = factory.create(tree_file, new NHXParser())[0];
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
        double time = System.currentTimeMillis();
        dc = new DistanceCalculator(tree);
        double m = dc.getMean();
        double var = dc.getVariance();
        double sd = dc.getStandardDeviation();
        time = (double)System.currentTimeMillis() - time;
        System.out.println("\nn   = " + dc.getN());
        System.out.println("mea = " + m);
        System.out.println("var = " + var);
        System.out.println("sd  = " + sd + "\n");
        System.out.println("t=" + time + "\n");
    }
}

