/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PostOrderStackObject;

public final class PhylogenyWriter {
    private boolean _saw_comma;
    private StringBuffer _sb;
    private PhylogenyNode _root;
    private boolean _has_next;
    private Stack _stack;
    private byte _output_formt;
    private boolean _simple_nh;
    private int _level;
    private static final byte TO_NH = 0;
    private static final byte TO_NHX1 = 1;
    private static final byte TO_PHYLOXML1 = 2;

    public StringBuffer toNewHampshire(Phylogeny tree, boolean simple_nh) {
        this.setOutputFormt((byte)0);
        this.setSimpleNH(simple_nh);
        return this.getOutput(tree);
    }

    public void toNewHampshire(Phylogeny tree, boolean simple_nh, File out_file) throws IOException {
        PhylogenyWriter.writeToFile(this.toNewHampshire(tree, simple_nh), out_file);
    }

    public StringBuffer toNewHampshireX(Phylogeny tree) {
        this.setOutputFormt((byte)1);
        return this.getOutput(tree);
    }

    public void toNewHampshireX(Phylogeny tree, File out_file) throws IOException {
        PhylogenyWriter.writeToFile(this.toNewHampshireX(tree), out_file);
    }

    public StringBuffer toPhyloXML(Phylogeny tree) {
        this.setOutputFormt((byte)2);
        return this.getOutput(tree);
    }

    public void toPhyloXML(Phylogeny tree, File out_file) throws IOException {
        PhylogenyWriter.writeToFile(this.toPhyloXML(tree), out_file);
    }

    private StringBuffer getOutput(Phylogeny tree) {
        if (tree != null && !tree.isEmpty()) {
            this.init(tree);
            if (this.getOutputFormt() == 2) {
                this.getStringBuffer().append("<phylogeny>");
            }
            while (this.isHasNext()) {
                this.next();
            }
            if (this.getOutputFormt() == 2) {
                this.getStringBuffer().append("</phylogeny>");
            }
            return this.getStringBuffer();
        }
        return new StringBuffer(0);
    }

    private void init(Phylogeny tree) {
        this.setStringBuffer(new StringBuffer());
        this.setSawComma(false);
        this.setHasNext(true);
        this.setRoot(tree.getRoot());
        this.setStack(new Stack());
        this.getStack().push(new PostOrderStackObject(tree.getRoot(), 1));
        this.setLevel(0);
    }

    private void next() {
        while (true) {
            PostOrderStackObject si = (PostOrderStackObject)this.getStack().pop();
            PhylogenyNode node = si.getNode();
            int phase = si.getPhase();
            if (phase > node.getNumberOfChildNodes()) {
                this.setHasNext(node != this.getRoot());
                this.writeNode(node);
                if (!node.isRoot()) {
                    if (!node.isLastChildNode()) {
                        this.writeCladeSeparator();
                    }
                    this.writeCloseClade();
                }
                return;
            }
            this.getStack().push(new PostOrderStackObject(node, phase + 1));
            if (!node.isInternal()) continue;
            this.getStack().push(new PostOrderStackObject(node.getChildNode(phase - 1), 1));
            this.writeOpenClade();
        }
    }

    private void writeOpenClade() {
        if (this.getOutputFormt() == 2) {
            for (int i = 0; i < this.getLevel(); ++i) {
                this.getStringBuffer().append("  ");
            }
            this.getStringBuffer().append("<clade>");
        } else if (this.getOutputFormt() == 1 || this.getOutputFormt() == 0) {
            if (!this.isSawComma()) {
                this.getStringBuffer().append("(");
            }
            this.setSawComma(false);
        }
        this.increaseLevel();
    }

    private void writeCloseClade() {
        if (this.getOutputFormt() == 2) {
            this.getStringBuffer().append("</clade>");
        } else if (this.getOutputFormt() == 1 || this.getOutputFormt() == 0) {
            this.getStringBuffer().append(")");
        }
        this.decreaseLevel();
    }

    private void writeCladeSeparator() {
        if (this.getOutputFormt() == 2) {
            this.getStringBuffer().append("\n");
        } else if (this.getOutputFormt() == 1 || this.getOutputFormt() == 0) {
            this.getStringBuffer().append(",");
            this.setSawComma(true);
        }
    }

    private void writeNode(PhylogenyNode node) {
        if (this.getOutputFormt() == 2) {
            this.getStringBuffer().append(node.toXML());
        } else if (this.getOutputFormt() == 1) {
            this.getStringBuffer().append(node.toNewHampshireX());
        } else if (this.getOutputFormt() == 0) {
            this.getStringBuffer().append(node.toNewHampshire(this.isSimpleNH()));
        }
    }

    private static void writeToFile(StringBuffer sb, File out_file) throws IOException {
        if (out_file.exists()) {
            throw new IOException("Attempt to overwrite existing file \"" + out_file.getAbsolutePath() + " \".");
        }
        if (!out_file.canWrite()) {
            throw new IOException("Can not write to file \"" + out_file.getAbsolutePath() + " \".");
        }
        PrintWriter out = new PrintWriter((Writer)new FileWriter(out_file), true);
        out.print(sb);
        out.flush();
        out.close();
    }

    private boolean isHasNext() {
        return this._has_next;
    }

    private void setHasNext(boolean has_next) {
        this._has_next = has_next;
    }

    private void increaseLevel() {
        ++this._level;
    }

    private void decreaseLevel() {
        --this._level;
    }

    private PhylogenyNode getRoot() {
        return this._root;
    }

    private void setRoot(PhylogenyNode root) {
        this._root = root;
    }

    private StringBuffer getStringBuffer() {
        return this._sb;
    }

    private void setStringBuffer(StringBuffer sb) {
        this._sb = sb;
    }

    private Stack getStack() {
        return this._stack;
    }

    private void setStack(Stack stack) {
        this._stack = stack;
    }

    private boolean isSawComma() {
        return this._saw_comma;
    }

    private void setSawComma(boolean saw_comma) {
        this._saw_comma = saw_comma;
    }

    private byte getOutputFormt() {
        return this._output_formt;
    }

    private void setOutputFormt(byte output_formt) {
        this._output_formt = output_formt;
    }

    private boolean isSimpleNH() {
        return this._simple_nh;
    }

    private void setSimpleNH(boolean simple_nh) {
        this._simple_nh = simple_nh;
    }

    private int getLevel() {
        return this._level;
    }

    private void setLevel(int level) {
        this._level = level;
    }
}

