/*
 * Decompiled with CFR 0.152.
 */
package org.forester.extensions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.forester.atv.ATVnodeGlyphPanel;
import org.forester.extensions.ExpressionLegend;
import org.forester.extensions.ExpressionPanel;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.TagValueUnit;

public class NodeExpressionPanel
extends ATVnodeGlyphPanel
implements ActionListener {
    ExpressionPanel expression_panel;
    protected String legend_string = "No information about this expression graph";
    protected ExpressionLegend legend = null;
    protected JButton legend_button;

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.legend_button) {
            this.legend = new ExpressionLegend(this.legend_string);
        }
    }

    public void init(Container parent, PhylogenyNode n) {
        super.init(parent, n);
        if (n != null) {
            PhylogenyNode rnode = n;
            while (!rnode.isRoot()) {
                rnode = rnode.getParent();
            }
            TagValueUnit exp_data = null;
            try {
                exp_data = rnode.getCustomTagValue("expression_tissues");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (exp_data != null) {
                this.legend_string = (String)exp_data.getValue();
            }
            this.expression_panel = new ExpressionPanel();
            this.expression_panel.setGlyphWidth(this.glyph_width);
            this.expression_panel.setBars(n, this.is_frame);
            this.glyph_list_height = this.expression_panel.getPreferredSize().height;
            this.glyph_list_height += 50;
            this.glyph_list_width = this.expression_panel.getPreferredSize().width;
            this.glyph_pane = new JScrollPane(this.expression_panel);
            this.glyph_pane.getHorizontalScrollBar().setUnitIncrement(20);
            this.glyph_pane.getHorizontalScrollBar().setBlockIncrement(50);
            this.glyph_pane.getVerticalScrollBar().setUnitIncrement(20);
            this.glyph_pane.getVerticalScrollBar().setBlockIncrement(50);
            this.add((Component)this.glyph_pane, "Center");
            this.legend_button = new JButton("Legend");
            this.legend_button.addActionListener(this);
            if (this.button_panel == null) {
                this.button_panel = new JPanel();
                this.button_panel.add(this.legend_button);
                this.add((Component)this.button_panel, "South");
            } else {
                this.button_panel.add(this.legend_button);
            }
            Dimension new_size = new Dimension(this.glyph_list_width, this.glyph_list_height);
            this.setPreferredSize(new_size);
            this.setMaximumSize(new_size);
            this.setMinimumSize(new_size);
        }
    }

    public void update(PhylogenyNode n) {
        this.expression_panel.setBars(n, this.is_frame);
        this.expression_panel.repaint();
    }
}

