/*
 * Decompiled with CFR 0.152.
 */
package org.forester.extensions;

import java.awt.Dimension;
import java.awt.Font;
import java.util.Vector;
import javax.swing.JPanel;
import org.forester.phylogeny.PhylogenyNode;

public class ExtensionPanel
extends JPanel {
    protected Vector sequence_names = new Vector();
    Vector bars = new Vector();
    protected Font font = new Font("Helvetica", 0, 9);
    protected int max_name_chars = 0;
    protected int max_name_index = 0;
    protected int max_name_length;
    protected int glyph_x_off;
    protected int glyph_y_start = 0;
    protected int glyph_y_off;
    protected int glyph_width = 100;
    protected int glyph_height = 10;
    protected int glyph_max_y;

    public ExtensionPanel() {
        this.setFont(this.font);
    }

    protected void createBars(PhylogenyNode node, boolean is_frame) {
    }

    protected int getFirstTerminalNodeX(PhylogenyNode n) {
        PhylogenyNode node = n;
        while (node.getNumberOfChildNodes() > 0) {
            node = node.getFirstChildNode();
        }
        return node.getYcoord();
    }

    protected void getSequenceNames(PhylogenyNode n) {
        if (n != null) {
            if (n.getNumberOfChildNodes() >= 2) {
                this.getSequenceNames(n.getChildNode1());
                this.getSequenceNames(n.getChildNode2());
            } else {
                String seq_name = n.getSeqName();
                if (seq_name.length() > this.max_name_chars) {
                    this.max_name_chars = seq_name.length();
                    this.max_name_index = this.sequence_names.size();
                }
                this.sequence_names.add(seq_name);
            }
        }
    }

    protected void normalizeBars() {
    }

    public void setBars(PhylogenyNode node, boolean is_frame) {
        this.bars.removeAllElements();
        this.sequence_names.removeAllElements();
        this.getSequenceNames(node);
        int i = 0;
        while (i < this.sequence_names.size()) {
            int w = this.getFontMetrics(this.getFont()).stringWidth((String)this.sequence_names.elementAt(this.max_name_index));
            if (w > this.max_name_length) {
                this.max_name_length = w;
            }
            ++i;
        }
        this.glyph_height = this.getFontMetrics(this.getFont()).getAscent();
        this.glyph_x_off = this.max_name_length + 7;
        if (is_frame) {
            this.glyph_y_off = 5;
        }
        this.createBars(node, is_frame);
        this.normalizeBars();
        Dimension d = new Dimension(this.glyph_x_off + this.glyph_width + 5, this.glyph_max_y + 10);
        this.setPreferredSize(d);
    }

    public void setGlyphWidth(int new_width) {
        this.glyph_width = new_width;
    }
}

