/*
 * Decompiled with CFR 0.152.
 */
package org.forester.extensions;

import java.awt.Color;
import java.awt.Graphics;
import org.forester.extensions.ExpressionBar;
import org.forester.extensions.ExtensionPanel;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.TagValueUnit;

public class ExpressionPanel
extends ExtensionPanel {
    protected void createBars(PhylogenyNode n, boolean is_frame) {
        if (n != null) {
            if (n.getNumberOfChildNodes() > 0) {
                int i = 0;
                while (i < n.getNumberOfChildNodes()) {
                    this.createBars(n.getChildNode(i), is_frame);
                    ++i;
                }
            } else {
                ExpressionBar eb;
                if (!is_frame) {
                    this.glyph_y_off = n.getYcoord() - this.glyph_height / 2;
                }
                if (n.customTagExists("expression")) {
                    TagValueUnit exp_data = n.getCustomTagValue("expression");
                    String exp_data_str = (String)exp_data.getValue();
                    eb = new ExpressionBar(this.glyph_x_off, this.glyph_y_off, this.glyph_width, this.glyph_height, exp_data_str);
                } else {
                    eb = new ExpressionBar(this.glyph_x_off, this.glyph_y_off, this.glyph_width, this.glyph_height, "");
                }
                this.bars.add(eb);
                if (is_frame) {
                    this.glyph_y_off += 20;
                }
                this.glyph_max_y = this.glyph_y_off + this.glyph_height;
            }
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.black);
        int sh = g.getFontMetrics().getAscent();
        int num_names = this.sequence_names.size();
        int i = 0;
        while (i < num_names) {
            ExpressionBar eb = (ExpressionBar)this.bars.elementAt(i);
            g.drawString((String)this.sequence_names.elementAt(i), 2, eb.getY() + sh);
            eb.paint(g);
            ++i;
        }
    }
}

