/*
 * Decompiled with CFR 0.152.
 */
package org.forester.extensions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.forester.extensions.ExpressionBar;

public class ExpressionLegend
extends JFrame
implements ActionListener {
    protected String tissue_string;
    protected JButton close_button;

    public ExpressionLegend(String legend_string) {
        Container contentPane = this.getContentPane();
        ColorRangeIcon cri = new ColorRangeIcon();
        JLabel jl = new JLabel("Color range (low to high):", cri, 2);
        jl.setIconTextGap(10);
        jl.setHorizontalTextPosition(2);
        this.getContentPane().add((Component)jl, "North");
        this.tissue_string = this.makeTissueString(legend_string);
        this.getContentPane().add(new JLabel(this.tissue_string));
        JPanel button_panel = new JPanel();
        this.close_button = new JButton("Close");
        this.close_button.addActionListener(this);
        button_panel.add(this.close_button);
        contentPane.add((Component)button_panel, "South");
        this.setSize(300, 350);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.close_button) {
            this.dispose();
        }
    }

    private String makeTissueString(String legend_string) {
        String new_string = "<html>Order of tissues shown in graph:<br>";
        StringTokenizer tokens = new StringTokenizer(legend_string, "|");
        int count = 1;
        while (tokens.hasMoreTokens()) {
            String tissue = tokens.nextToken();
            new_string = String.valueOf(new_string) + "<b>" + count + ".</b> " + tissue + "<br>";
            ++count;
        }
        new_string = String.valueOf(new_string) + "</html>";
        return new_string;
    }

    class ColorRangeIcon
    implements Icon {
        int icon_width;
        int icon_height = 10;
        int bar_width = 5;
        Color[] all_colors = ExpressionBar.getAllColors();

        ColorRangeIcon() {
            this.icon_width = this.all_colors.length * this.bar_width;
        }

        public int getIconWidth() {
            return this.icon_width;
        }

        public int getIconHeight() {
            return this.icon_height;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int bar_x = x;
            int i = 0;
            while (i < this.all_colors.length) {
                g.setColor(this.all_colors[i]);
                g.fillRect(bar_x, y, this.bar_width, this.icon_height);
                bar_x += this.bar_width;
                ++i;
            }
        }
    }
}

