/*
 * Decompiled with CFR 0.152.
 */
package org.forester.extensions;

import java.awt.Color;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class ExpressionBar {
    static Color[] all_colors = new Color[]{new Color(0, 0, 0), new Color(34, 139, 34), new Color(0, 25, 0), new Color(173, 255, 47), new Color(255, 255, 0), new Color(255, 215, 0), new Color(255, 193, 37), new Color(255, 165, 0), new Color(255, 69, 0), new Color(255, 0, 0), new Color(205, 0, 0), new Color(139, 10, 80), new Color(205, 16, 118), new Color(255, 110, 180), new Color(255, 181, 197), new Color(255, 255, 255), new Color(255, 255, 255)};
    Color[] colors;
    int x;
    int y;
    int width;
    int height;
    int num_bars;
    int[] exps;
    int max_expression_value;

    public ExpressionBar(int x, int y, int width, int height, String stringExps) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.setData(stringExps);
        this.getColors();
    }

    public static Color[] getAllColors() {
        return all_colors;
    }

    private void getColors() {
        int j = 0;
        while (j < this.exps.length) {
            this.colors[j] = this.expColor(this.exps[j]);
            ++j;
        }
    }

    public void setData(String express) {
        char u = '_';
        char s = ' ';
        int index = 0;
        String data = express.replace(u, s);
        StringTokenizer token = new StringTokenizer(data);
        this.num_bars = token.countTokens();
        this.colors = new Color[this.num_bars];
        this.exps = new int[this.num_bars];
        this.max_expression_value = 0;
        while (token.hasMoreTokens()) {
            String e = token.nextToken();
            this.exps[index] = Integer.parseInt(e);
            if (this.exps[index] > this.max_expression_value) {
                this.max_expression_value = this.exps[index];
            }
            ++index;
        }
    }

    public int getMaxExpressionValue() {
        return this.max_expression_value;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    private Color expColor(int e) {
        if (e == 0) {
            return all_colors[0];
        }
        if (e == 1) {
            return all_colors[1];
        }
        if (e > 1 && e <= 3) {
            return all_colors[2];
        }
        if (e > 3 && e <= 6) {
            return all_colors[3];
        }
        if (e > 6 && e <= 10) {
            return all_colors[4];
        }
        if (e > 10 && e <= 15) {
            return all_colors[5];
        }
        if (e > 15 && e <= 21) {
            return all_colors[6];
        }
        if (e > 21 && e <= 28) {
            return all_colors[7];
        }
        if (e > 28 && e <= 36) {
            return all_colors[8];
        }
        if (e > 36 && e <= 45) {
            return all_colors[9];
        }
        if (e > 45 && e <= 55) {
            return all_colors[10];
        }
        if (e > 55 && e <= 66) {
            return all_colors[11];
        }
        if (e > 66 && e <= 78) {
            return all_colors[12];
        }
        if (e > 78 && e <= 91) {
            return all_colors[13];
        }
        if (e > 91 && e <= 105) {
            return all_colors[14];
        }
        if (e > 105 && e <= 120) {
            return all_colors[15];
        }
        return all_colors[16];
    }

    public void normalize(int max_value) {
        if (max_value > 16) {
            double div = max_value / 16;
            int i = 0;
            while (i < this.exps.length) {
                this.exps[i] = (int)((double)this.exps[i] / div);
                ++i;
            }
        }
    }

    public void paint(Graphics g) {
        Color old_color = g.getColor();
        if (this.num_bars > 0) {
            int bar_width = this.width / this.num_bars;
            int x_off = this.x;
            int k = 0;
            while (k < this.num_bars) {
                g.setColor(Color.black);
                g.drawRect(x_off, this.y, bar_width, this.height);
                g.setColor(this.colors[k]);
                g.fillRect(x_off, this.y, bar_width, this.height);
                x_off += bar_width;
                ++k;
            }
        }
        g.setColor(old_color);
    }
}

