/*
 * Decompiled with CFR 0.152.
 */
package org.forester.extensions;

import java.awt.Color;
import java.awt.Graphics;
import org.forester.extensions.ChromosomeBar;
import org.forester.extensions.ExtensionPanel;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.TagValueUnit;

public class ChromosomePanel
extends ExtensionPanel {
    protected void createBars(PhylogenyNode n, boolean is_frame) {
        if (n != null) {
            if (n.getNumberOfChildNodes() > 0) {
                int i = 0;
                while (i < n.getNumberOfChildNodes()) {
                    this.createBars(n.getChildNode(i), is_frame);
                    ++i;
                }
            } else {
                ChromosomeBar bar;
                if (!is_frame) {
                    this.glyph_y_off = n.getYcoord() - this.glyph_height / 2;
                }
                if (n.customTagExists("chromosome")) {
                    TagValueUnit tag_data = n.getCustomTagValue("chromosome");
                    String data_str = (String)tag_data.getValue();
                    bar = new ChromosomeBar(this.glyph_x_off, this.glyph_y_off, this.glyph_width, this.glyph_height, data_str);
                } else {
                    bar = new ChromosomeBar(this.glyph_x_off, this.glyph_y_off, this.glyph_width, this.glyph_height, "");
                }
                this.bars.add(bar);
                if (is_frame) {
                    this.glyph_y_off += 20;
                }
                this.glyph_max_y = this.glyph_y_off + this.glyph_height;
            }
        }
    }

    protected void normalizeBars() {
        int max_size = 0;
        int num_names = this.bars.size();
        int i = 0;
        while (i < num_names) {
            int test_size = ((ChromosomeBar)this.bars.elementAt(i)).getChrLength();
            if (test_size > max_size) {
                max_size = test_size;
            }
            ++i;
        }
        i = 0;
        while (i < num_names) {
            ((ChromosomeBar)this.bars.elementAt(i)).normalize(max_size);
            ++i;
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.black);
        int sh = g.getFontMetrics().getAscent();
        int num_names = this.sequence_names.size();
        int i = 0;
        while (i < num_names) {
            ChromosomeBar cb = (ChromosomeBar)this.bars.elementAt(i);
            g.drawString((String)this.sequence_names.elementAt(i), 2, cb.getY() + sh);
            cb.paint(g);
            ++i;
        }
    }
}

