/*
 * Decompiled with CFR 0.152.
 */
package org.forester.extensions;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class ChromosomeBar {
    int x;
    int y;
    int width;
    int height;
    Font font = new Font("Sans Serif", 0, 8);
    int label_off = 18;
    int max_chr_length = 0;
    String chr_label = "";
    int chr_length;
    int display_chr_length = 0;
    int chr_pos;
    int display_chr_pos;

    public ChromosomeBar(int x, int y, int width, int height, String data) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.max_chr_length = width - this.label_off;
        this.parse(data);
    }

    public int getChrLength() {
        return this.chr_length;
    }

    public int getChrPos() {
        return this.chr_pos;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void normalize(int max_value) {
        double scale_factor = (double)this.max_chr_length / (double)max_value;
        this.display_chr_length = (int)((double)this.chr_length * scale_factor);
        this.display_chr_pos = (int)((double)this.chr_pos * scale_factor);
    }

    public void paint(Graphics g) {
        Color old_color = g.getColor();
        g.setColor(Color.black);
        g.drawLine(this.x + this.label_off, this.y + this.height / 2 + 1, this.x + this.label_off + this.display_chr_length, this.y + this.height / 2 + 1);
        g.drawLine(this.x + this.label_off, this.y + this.height / 2, this.x + this.label_off + this.display_chr_length, this.y + this.height / 2);
        g.setColor(Color.red);
        g.fillOval(this.x + this.label_off + this.display_chr_pos, this.y + this.height / 2 - 2, 5, 5);
        g.setColor(old_color);
    }

    private void parse(String data) {
        StringTokenizer tokens = new StringTokenizer(data, "|");
        if (tokens.countTokens() == 3) {
            this.chr_label = tokens.nextToken();
            this.display_chr_length = this.chr_length = Integer.parseInt(tokens.nextToken());
            this.chr_pos = Integer.parseInt(tokens.nextToken());
        } else {
            System.out.println("Error in chromosome data: need \"label|chr length|pos\" but found " + data);
        }
    }
}

