/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import java.util.Random;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;

public final class Helper {
    public static void randomizeSpecies(int min, int max, Phylogeny t) {
        if (t == null || t.isEmpty()) {
            return;
        }
        int mi = Math.abs(min);
        int ma = Math.abs(max);
        Random r = new Random();
        PhylogenyNode n = t.getFirstExternalNode();
        while (n != null) {
            n.setTaxonomy(String.valueOf(Math.abs(r.nextInt()) % (ma - mi + 1) + mi));
            n = n.getNextExternalNode();
        }
    }

    public static void numberSpeciesInOrder(Phylogeny t) {
        if (t == null || t.isEmpty()) {
            return;
        }
        PhylogenyNode n = t.getFirstExternalNode();
        int j = 1;
        while (n != null) {
            n.setTaxonomy(String.valueOf(j));
            ++j;
            n = n.getNextExternalNode();
        }
    }

    public static void numberSpeciesInDescOrder(Phylogeny t) {
        if (t == null || t.isEmpty()) {
            return;
        }
        PhylogenyNode n = t.getFirstExternalNode();
        int j = t.getRoot().getSumExtNodes();
        while (n != null) {
            n.setTaxonomy(String.valueOf(j));
            --j;
            n = n.getNextExternalNode();
        }
    }

    public static void intervalNumberSpecies(Phylogeny t, int i) {
        if (t == null || t.isEmpty()) {
            return;
        }
        PhylogenyNode n = t.getFirstExternalNode();
        int j = 1;
        boolean odd = true;
        while (n != null) {
            if (odd) {
                n.setTaxonomy(String.valueOf(j));
            } else {
                n.setTaxonomy(String.valueOf(j + i));
                ++j;
            }
            odd = !odd;
            n = n.getNextExternalNode();
        }
    }
}

