/*
 * Decompiled with CFR 0.152.
 */
package org.forester.datastructures;

public class BasketDataStructure {
    private int[] link;
    int[] rank;
    private static final int DEFAULT_RANK = 0;

    public BasketDataStructure(int s) {
        this.link = new int[s];
        this.rank = new int[s];
    }

    public void createBasket(int g, int s) {
        this.link[s] = this.link[g] = s;
        this.rank[g] = 0;
        this.rank[s] = 0;
    }

    public void moveBasket(int s1, int s2) {
        this.link[s2] = this.link[s1] = s2;
    }

    public void mergeBasket(int s1, int s2) {
        this.link[s1] = s2;
        if (this.rank[s1] == this.rank[s2]) {
            int n = s2;
            this.rank[n] = this.rank[n] + 1;
        }
    }

    public int findBasket(int g) {
        if (this.link[g] == g) {
            return g;
        }
        this.link[g] = this.findBasket(this.link[g]);
        return this.link[g];
    }

    public void insertIntoBasket(int g, int s) {
        this.link[g] = s;
    }

    public String toString() {
        String s = new String();
        int i = 0;
        while (i < this.link.length) {
            s = String.valueOf(s) + i + ":   ";
            s = String.valueOf(s) + "Link : " + this.link[i] + "    ";
            s = String.valueOf(s) + "Rank : " + this.rank[i] + "\n";
            ++i;
        }
        return s;
    }
}

