/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;

public class HighlightSeqFrame
extends JDialog
implements ActionListener {
    JTextArea sequencenames;
    JButton highlightbtn;
    JButton cancelbtn;
    ArrayList sequencelist;
    String instructions = "Type or paste one or more sequence names in the box below:";

    public HighlightSeqFrame(Frame owner) {
        super(owner, "Highlight Sequences", true, owner.getGraphicsConfiguration());
        this.setSize(360, 320);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        JTextPane tp = new JTextPane();
        tp.setFont(new Font("Sans Serif", 1, 12));
        tp.setSize(new Dimension(360, 40));
        tp.setBackground(this.getBackground());
        tp.setEnabled(false);
        tp.setText(this.instructions);
        cp.add((Component)tp, "North");
        this.sequencenames = new JTextArea();
        cp.add((Component)this.sequencenames, "Center");
        JPanel btn_panel = new JPanel();
        this.highlightbtn = new JButton("Select");
        this.highlightbtn.addActionListener(this);
        btn_panel.add(this.highlightbtn);
        this.cancelbtn = new JButton("Cancel");
        this.cancelbtn.addActionListener(this);
        btn_panel.add(this.cancelbtn);
        cp.add((Component)btn_panel, "South");
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.cancelbtn) {
            this.sequencelist = null;
            this.hide();
        } else if (o == this.highlightbtn) {
            String name_str = this.sequencenames.getText();
            this.sequencelist = name_str.length() > 0 ? this.parseSequenceNames(name_str) : null;
            this.hide();
        }
    }

    public ArrayList getSequenceNames() {
        return this.sequencelist;
    }

    private ArrayList parseSequenceNames(String name_str) {
        ArrayList<Object> list = null;
        name_str = name_str.trim();
        name_str = name_str.replaceAll("\\n", " ");
        name_str = name_str.replaceAll("\\t", " ");
        name_str = name_str.replaceAll(",", " ");
        name_str = name_str.replaceAll(":", " ");
        name_str = name_str.replaceAll(";", " ");
        StringTokenizer st = new StringTokenizer(name_str = name_str.replaceAll("\\s+", " "), " ");
        if (st.countTokens() > 0) {
            list = new ArrayList<Object>();
            while (st.hasMoreElements()) {
                list.add(st.nextElement());
            }
        }
        return list;
    }
}

