/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.applet.AppletContext;
import java.awt.event.MouseEvent;
import java.net.URL;
import org.forester.atv.ATVConfig;
import org.forester.atv.ATVapplet;
import org.forester.atv.ATVnodeGlyphPanel;
import org.forester.atv.ATVpanel_applet;
import org.forester.atv.ATVtreePanel;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;

class ATVtreePanel_applet
extends ATVtreePanel {
    static final String SWISSPROT_URL_DE = "http://www.expasy.ch/cgi-bin/sprot-search-de?";
    static final String SWISSPROT_URL_AC = "http://www.expasy.ch/cgi-bin/sprot-search-ac?";
    static final int GO_TO_SWISSPROT = 0;
    static final int DISPLAY_NODE_POPUP = 1;
    private ATVapplet atv_applet;

    ATVtreePanel_applet(Phylogeny t, ATVConfig cs, ATVpanel_applet ap, ATVnodeGlyphPanel atvextension) {
        super(t, cs, ap, atvextension);
        this.atv_applet = ((ATVpanel_applet)this.atvpanel).getATVappletFrame().getATVapplet();
    }

    void displayNodePopup(PhylogenyNode node) {
        String seq_list = "";
        seq_list = this.getSequenceList(node, seq_list);
        URL new_url = null;
        String url_string = this.config_settings.getNodePopupURL();
        url_string = String.valueOf(url_string) + seq_list;
        AppletContext ac = this.atv_applet.getAppletContext();
        try {
            new_url = new URL(url_string);
            ac.showDocument(new_url, "info");
        }
        catch (Exception ex1) {
            try {
                new_url = new URL(this.atv_applet.getCodeBase().getProtocol(), this.atv_applet.getCodeBase().getHost(), String.valueOf(this.atv_applet.getCodeBase().getPath()) + url_string);
                ac.showDocument(new_url, "info");
            }
            catch (Exception ex2) {
                System.out.println("Unable to open node popup info. Trying URL: " + new_url.toString());
                System.out.println("Encountered exception while bringing up node info popup: " + ex2.toString());
            }
        }
    }

    private String getSequenceList(PhylogenyNode n, String seq_list) {
        String new_seq_list = seq_list;
        if (n != null) {
            if (!n.isExternal() && n.getChildNode1() != null && n.getChildNode2() != null) {
                new_seq_list = this.getSequenceList(n.getChildNode1(), new_seq_list);
                new_seq_list = this.getSequenceList(n.getChildNode2(), new_seq_list);
            } else {
                if (new_seq_list.length() > 0) {
                    new_seq_list = String.valueOf(new_seq_list) + ",";
                }
                new_seq_list = String.valueOf(new_seq_list) + n.getSeqName();
            }
        }
        return new_seq_list;
    }

    void goToSwissProt(PhylogenyNode node) {
        String s = node.getSeqName().trim();
        URL u = null;
        int i = s.indexOf("/");
        if (i > 10 || s.length() < 3 || !node.isExternal()) {
            return;
        }
        if (i > 0) {
            s = s.substring(0, i);
        }
        s = (s = s.replace(' ', '_')).indexOf("_") != -1 ? SWISSPROT_URL_DE + s : SWISSPROT_URL_AC + s;
        try {
            u = new URL(s);
        }
        catch (Exception e) {
            System.err.println("ATVgraphic_applet: goToSwissProt( PhylogenyNode ): Could not create URL from: " + s + ". Exception: " + e);
            e.printStackTrace();
        }
        if (u != null) {
            try {
                ((ATVpanel_applet)this.atvpanel).getATVappletFrame().getATVapplet().go(u);
            }
            catch (Exception e) {
                System.err.println("ATVgraphic_applet: goToSwissProt( PhylogenyNode ): " + e);
                e.printStackTrace();
            }
        }
    }

    public void MouseClicked(MouseEvent e) {
        String seqname;
        super.MouseClicked(e);
        int x = e.getX();
        int y = e.getY();
        PhylogenyNode node = this.findNode(x, y);
        if (node != null) {
            if (e.getModifiers() != 4) {
                if (this.action_when_node_clicked == 0) {
                    this.goToSwissProt(node);
                } else if (this.action_when_node_clicked == 1) {
                    this.displayNodePopup(node);
                }
            }
        } else if (this.config_settings.getSequencePopupURL() != null && this.config_settings.getSequencePopupURL().length() > 0 && this.atvcontrolpanel.seqNameExtNodes() && (seqname = this.findSequenceName(x, y)) != null && seqname.length() > 0) {
            AppletContext ac = this.atv_applet.getAppletContext();
            try {
                String url_string = this.config_settings.getSequencePopupURL();
                url_string = String.valueOf(url_string) + seqname;
                URL seq_url = new URL(url_string);
                ac.showDocument(seq_url, "geneinfo");
            }
            catch (Exception ex) {
                System.out.println("Encountered exception while bringing up sequence data window: " + ex.toString());
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.config_settings.getSequencePopupURL() != null && this.config_settings.getSequencePopupURL().length() > 0 && this.atvcontrolpanel.seqNameExtNodes()) {
            String seqname = this.findSequenceName(x, y);
            if (seqname != null && seqname.length() > 0) {
                this.setCursor(this.hand_cursor);
            } else {
                super.mouseMoved(e);
            }
        }
    }
}

