/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.forester.atv.ATVConfig;
import org.forester.atv.ATVMouseMotionListener;
import org.forester.atv.ATVcontrol;
import org.forester.atv.ATVeditNodeFrame;
import org.forester.atv.ATVmouseListener;
import org.forester.atv.ATVnodeGlyphFrame;
import org.forester.atv.ATVnodeGlyphPanel;
import org.forester.atv.ATVnodeSeqFrame;
import org.forester.atv.ATVpanel;
import org.forester.atv.TreeColorSet;
import org.forester.atv.TreeFontSet;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.TagValueUnit;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.Util;

class ATVtreePanel
extends JPanel
implements ActionListener {
    ATVcontrol atvcontrolpanel;
    ATVConfig config_settings;
    private static final int MAX_ORTHO_DEFAULT = 100;
    static final int BOX_SIZE = 6;
    static final int HALF_BOX_SIZE = 3;
    static final int MAX_SUBTREES = 100;
    static final int MAX_POPUPFRAMES = 10;
    static final int MOVE = 30;
    static final int EDIT_INFO = 6;
    static final int COLLAPSE = 7;
    static final int REROOT = 8;
    static final int SUBTREE = 9;
    static final int SWAP = 10;
    static final int SHOW_NODE_SEQUENCES = 11;
    static final int SHOW_NODE_GLYPH_INFO = 12;
    static final int CUSTOM_OPTION = 13;
    private NumberFormat dist_nf = NumberFormat.getNumberInstance();
    TreeFontSet fontset;
    TreeColorSet colorset;
    Hashtable species_colors = null;
    int next_default_color = 0;
    String[] default_species_colors = new String[]{"0xff9999", "0x0000ff", "0xa52a2a", "0xff0000", "0x33a033", "0x803380", "0xcd3333", "0xd76400", "0x500000", "0x780078", "0x0000f5", "0x00007d", "0x00f500", "0x00af00", "0x00ff00"};
    ATVnodeSeqFrame[] atvnodeseqframes = new ATVnodeSeqFrame[10];
    int seqframe_index = 0;
    ATVnodeGlyphFrame[] atvnodeglyphframes = new ATVnodeGlyphFrame[10];
    int glyphframe_index = 0;
    ATVeditNodeFrame[] atveditnodeframes = new ATVeditNodeFrame[10];
    int editframe_index = 0;
    PhylogenyNode node = null;
    Phylogeny tree = null;
    Phylogeny[] trees = new Phylogeny[100];
    int subtree_index = 0;
    ATVpanel atvpanel = null;
    ATVnodeGlyphPanel atvextension = null;
    String glyph_class_name;
    Hashtable _found_nodes = null;
    PhylogenyNode _highlight_node = null;
    private int longest_ext_node_info = 0;
    private int max_ortho = 100;
    int action_when_node_clicked = 0;
    private double x_correction_factor = 0.0;
    private double x_distance = 0.0;
    private double y_distance = 0.0;
    double x_current;
    int y_current;
    protected Cursor arrow_cursor = Cursor.getPredefinedCursor(0);
    protected Cursor hand_cursor = Cursor.getPredefinedCursor(12);
    JPopupMenu clickto_single_menu = null;
    JPopupMenu clickto_multiple_menu = null;
    JMenuItem[] clickto_single_items;
    JMenuItem[] clickto_multiple_items;

    ATVtreePanel() {
    }

    ATVtreePanel(Phylogeny t, ATVConfig config_settings, ATVpanel tjp, ATVnodeGlyphPanel atvextension) {
        this.tree = t;
        this.config_settings = config_settings;
        this.atvextension = atvextension;
        if (this.tree != null && !this.tree.isEmpty()) {
            this.tree.adjustNodeCount(true);
        }
        this.atvpanel = tjp;
        this.colorset = new TreeColorSet(true);
        this.fontset = new TreeFontSet(this);
        this.fontset.mediumFonts();
        this.setBackground(this.colorset.get_background_color());
        this.addMouseListener(new ATVmouseListener(this));
        this.addMouseMotionListener(new ATVMouseMotionListener(this));
        this.calculateLongestExtNodeInfo();
        this.max_ortho = 100;
        this.dist_nf.setMaximumFractionDigits(6);
        this.dist_nf.setMinimumFractionDigits(1);
        this.species_colors = new Hashtable();
    }

    public void actionPerformed(ActionEvent e) {
        boolean done = false;
        String cmd = e.getActionCommand();
        JMenuItem mi = (JMenuItem)e.getSource();
        int index = 0;
        while (index < this.clickto_multiple_items.length && !done) {
            if (mi == this.clickto_multiple_items[index]) {
                this.atvpanel.getATVcontrol().setClickToAction(index);
                this.handleClickToAction(this.action_when_node_clicked, null);
                done = true;
            }
            ++index;
        }
        if (!done) {
            index = 0;
            while (index < this.clickto_single_items.length && !done) {
                if (mi == this.clickto_single_items[index]) {
                    this.atvpanel.getATVcontrol().setClickToAction(index);
                    PhylogenyNode node = (PhylogenyNode)this.clickto_single_menu.getClientProperty("node");
                    this.handleClickToAction(this.action_when_node_clicked, node);
                    done = true;
                }
                ++index;
            }
        }
    }

    void assignGraphicsForBranchWithColorForParentBranch(PhylogenyNode node, boolean is_vertical, Graphics g) {
        if (this.atvcontrolpanel.isColorBranches() && node.isParentBranchColorAssigned() && (!is_vertical || node.isRoot() || !node.getParent().isPseudoNode() && !node.getParent().getChildNode1().isPseudoNode() && !node.getParent().getChildNode2().isPseudoNode())) {
            g.setColor(node.getColor());
        } else {
            g.setColor(this.colorset.get_branch_color());
        }
    }

    void assignGraphicsForNodeBoxWithColorForParentBranch(PhylogenyNode node, Graphics g) {
        if (this.atvcontrolpanel.isColorBranches() && node.isParentBranchColorAssigned()) {
            g.setColor(node.getColor());
        } else {
            g.setColor(this.colorset.get_branch_color());
        }
    }

    private double calculateBranchLength(PhylogenyNode node, int ext_nodes_x, int factor) {
        double x2double;
        if (this.atvcontrolpanel.useRealBranchLengths()) {
            double d = node.getDistanceToParent();
            if (d < 0.0) {
                d = 0.0;
            }
            x2double = this.x_current + this.x_correction_factor * d;
        } else {
            x2double = node.isExternal() || node.isCollapse() ? (double)ext_nodes_x : (node.isPseudoNode() ? this.x_current : this.x_current + this.x_distance * (double)factor);
        }
        if (!(this.atvcontrolpanel.useRealBranchLengths() || !node.isPseudoNode() || node.isPseudoNode() || node.isExternal() || node.isCollapse())) {
            PhylogenyNode n = node.getParent();
            while (n.isPseudoNode()) {
                n = n.getParent();
            }
            x2double += (double)(n.getSumExtNodes() - node.getSumExtNodes()) * this.x_distance;
        }
        return x2double;
    }

    private Color calculateColorForOrthologous(PhylogenyNode n) {
        int o = n.getOrthologous();
        if (o == -11) {
            return this.colorset.get_seq_x_color();
        }
        if (o > this.getMaxOrtho()) {
            o = this.getMaxOrtho();
        } else if (o < 0) {
            o = 0;
        }
        int green = o * 200 / this.getMaxOrtho();
        return new Color(this.colorset.get_ext_node_seq_color().getRed(), green, this.colorset.get_ext_node_seq_color().getBlue());
    }

    private Color calculateColorForSuperOrthologous(PhylogenyNode n) {
        int o = n.getSuperOrthologous();
        if (o == -11) {
            return this.colorset.get_seq_x_color();
        }
        if (o > this.getMaxOrtho()) {
            o = this.getMaxOrtho();
        } else if (o < 0) {
            o = 0;
        }
        int red = o * 255 / this.getMaxOrtho();
        return new Color(red, this.colorset.get_ext_node_seq_color().getGreen(), this.colorset.get_ext_node_seq_color().getBlue());
    }

    private Color calculateColorForSubtreeNeighbors(PhylogenyNode n) {
        int o = n.getSubtreeNeighborings();
        if (o == -11) {
            return this.colorset.get_seq_x_color();
        }
        if (o > this.getMaxOrtho()) {
            o = this.getMaxOrtho();
        } else if (o < 0) {
            o = 0;
        }
        int c = o * 255 / this.getMaxOrtho();
        return new Color(this.colorset.get_ext_node_seq_color().getRed(), c, c);
    }

    void calculateLongestExtNodeInfo() {
        if (this.tree == null || this.tree.isEmpty()) {
            return;
        }
        int longest = 0;
        int sum = 0;
        PhylogenyNodeIterator iter = this.tree.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            sum = this.fontset.fm_large_italic.stringWidth(String.valueOf(node.getTaxonomy()) + " ") + this.fontset.fm_large.stringWidth(String.valueOf(node.getSeqName()) + " ") + this.fontset.fm_large.stringWidth(node.getECnumber());
            String s = this.customDataAsString(node);
            if (s != null) {
                sum += this.fontset.fm_large.stringWidth("  " + s);
            }
            if (sum > longest) {
                longest = sum;
            }
            sum = 0;
        }
        this.setLongestExtNodeInfo(longest);
    }

    void collapse(PhylogenyNode node) {
        if (!node.isExternal()) {
            node.setCollapse(!node.isCollapse());
            this.tree.adjustNodeCount(true);
            this.resetPreferredSize();
            this.atvpanel.adjustJScrollPane();
            this.atvpanel.treeChanged(this.tree.getRoot());
            this.repaint();
        }
    }

    String customDataAsString(PhylogenyNode node) {
        TagValueUnit[] tvu = node.getCustomTagValueUnitsAsArray();
        if (tvu.length > 0) {
            StringBuffer sb = new StringBuffer(100);
            int i = 0;
            while (i < tvu.length) {
                String tag = tvu[i].getTag();
                if (this.atvcontrolpanel != null && this.atvcontrolpanel.isCustomTagChecked(tag)) {
                    Object value = tvu[i].getValue();
                    String unit = tvu[i].getUnit();
                    sb.append(tag);
                    sb.append(": ");
                    sb.append(value.toString());
                    sb.append(unit);
                    sb.append(" | ");
                }
                ++i;
            }
            if (sb.length() > 0) {
                return "| " + sb.toString();
            }
        }
        return null;
    }

    private void customOption(PhylogenyNode n) {
        if (this._found_nodes != null && this._found_nodes.containsKey(n)) {
            this.atvpanel.atvframe.customOption(this._found_nodes);
        } else {
            this.atvpanel.atvframe.customOption(n);
        }
    }

    void drawCollapsedNode(int x, int y, Graphics g, PhylogenyNode node, boolean found, boolean in_color) {
        int height;
        String label;
        int start_y;
        int start_x;
        int offset = 0;
        g.setColor(this.colorset.get_branch_color());
        g.drawRect(x - 3, y - 3, 6, 6);
        if (found) {
            g.setColor(this.colorset.get_background_color());
        } else {
            g.setColor(this.colorset.get_collapse_fill_color());
        }
        g.fillRect(x - 3 + 1, y - 3 + 1, 5, 5);
        if (this.atvcontrolpanel.speciesExtNodes() && node.getTaxonomy().length() > 0) {
            g.setFont(this.fontset.large_italic_font);
            g.setColor(this.colorset.get_species_name_color());
            start_x = x + 3 + 3;
            start_y = y + this.fontset.fm_large_italic.getAscent() / 2;
            label = node.getTaxonomy();
            if (this.atvcontrolpanel.seqNameExtNodes() && node.getSeqName().length() > 0) {
                label = String.valueOf(label) + ":";
                g.drawString(label, start_x, start_y);
                offset = this.fontset.fm_large_italic.stringWidth(label);
            } else {
                g.drawString(label, start_x, start_y);
            }
            if (this._found_nodes != null && this._found_nodes.containsKey(node)) {
                g.setColor(this.colorset.get_found_color());
                height = g.getFontMetrics().getAscent();
                g.drawRect(start_x, start_y - height, g.getFontMetrics().stringWidth(label), height);
            }
        }
        if (this.atvcontrolpanel.seqNameExtNodes() && node.getSeqName().length() > 0) {
            g.setFont(this.fontset.large_font);
            g.setColor(this.colorset.get_int_node_seq_color());
            start_x = x + 3 + 3 + offset;
            start_y = y + this.fontset.fm_large.getAscent() / 2;
            label = node.getSeqName();
            g.drawString(label, start_x, start_y);
            if (this._found_nodes != null && this._found_nodes.containsKey(node)) {
                g.setColor(this.colorset.get_found_color());
                height = g.getFontMetrics().getAscent();
                g.drawRect(start_x, start_y - height, g.getFontMetrics().stringWidth(label), height);
            }
        }
    }

    void drawFoundNode(int x, int y, Graphics g, boolean duplication, boolean in_color) {
        if (duplication) {
            g.setColor(this.colorset.get_dup_box_color());
        } else {
            g.setColor(this.colorset.get_box_color());
        }
        g.drawRect(x - 3, y - 3, 6, 6);
        g.setColor(this.colorset.get_found_color());
        g.fillRect(x - 3 + 1, y - 3 + 1, 5, 5);
    }

    void drawLine(int x1, int y1, int x2, int y2, PhylogenyNode node, boolean is_vertical, Graphics g, boolean in_color) {
        if (this.atvcontrolpanel.isWidthBranches() && node.isParentBranchWidthAssigned() && (!is_vertical || !node.getParent().getChildNode1().isPseudoNode() && !node.getParent().getChildNode2().isPseudoNode())) {
            int w = node.getParentBranchWidth();
            if (w < 1) {
                return;
            }
            if (!is_vertical) {
                g.fillRect(x1, y1 - w / 2, x2 - x1, w);
            } else if (y2 > y1) {
                g.fillRect(x1, y1, w, y2 - y1 + w / 2);
            } else {
                int w2 = w / 2;
                g.fillRect(x1, y2 - w2, w, y1 - y2 + w2 + 1);
            }
        } else {
            g.drawLine(x1, y1, x2, y2);
        }
    }

    void drawNodeBox(int x, int y, PhylogenyNode node, Graphics g, boolean in_color) {
        if (this._highlight_node == node) {
            g.setColor(this.colorset.get_found_color());
            g.drawOval(x - 8, y - 8, 16, 16);
            g.drawOval(x - 9, y - 8, 17, 17);
            g.drawOval(x - 9, y - 9, 18, 18);
        }
        if (!node.isPseudoNode() && this.atvcontrolpanel.isMarkNodesWithBox()) {
            if (node.isCollapse()) {
                this.drawCollapsedNode(x, y, g, node, this._found_nodes != null && this._found_nodes.containsKey(node), in_color);
            } else if (this._found_nodes != null && this._found_nodes.containsKey(node)) {
                if (!this.atvcontrolpanel.writeDupSpec() && node.isDuplicationOrSpecAssigned() && node.isDuplication()) {
                    this.drawFoundNode(x, y, g, true, in_color);
                } else {
                    this.drawFoundNode(x, y, g, false, in_color);
                }
            } else {
                if (this.atvcontrolpanel.writeDupSpec() && node.isDuplicationOrSpecAssigned() && node.isDuplication()) {
                    g.setColor(this.colorset.get_dup_box_color());
                } else {
                    this.assignGraphicsForNodeBoxWithColorForParentBranch(node, g);
                }
                g.fillRect(x - 3, y - 3, 6, 6);
            }
        }
    }

    PhylogenyNode findNode(int x, int y) {
        int wiggle = 3;
        if (this.tree == null || this.tree.isEmpty()) {
            return null;
        }
        PhylogenyNodeIterator iter = this.tree.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (node.isPseudoNode() || !this.tree.isRooted() && node.isRoot() || node.getXcoord() - 3 - wiggle > x || node.getXcoord() + 3 + wiggle < x || node.getYcoord() - 3 - wiggle > y || node.getYcoord() + 3 + wiggle < y) continue;
            return node;
        }
        return null;
    }

    String findSequenceName(int x, int y) {
        if (this.tree == null || this.tree.isEmpty()) {
            return null;
        }
        PhylogenyNodeIterator iter = this.tree.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (node.isPseudoNode() || !this.tree.isRooted() && node.isRoot() || !node.isInSeqNameRect(x, y)) continue;
            return node.getSeqName();
        }
        return null;
    }

    int getActionWhenNodeClicked() {
        return this.action_when_node_clicked;
    }

    ATVpanel getATVpanel() {
        return this.atvpanel;
    }

    public Hashtable getFoundNodes() {
        return this._found_nodes;
    }

    int getLengthOfRootSpecies() {
        if (this.tree == null || this.tree.isEmpty()) {
            return 0;
        }
        return this.fontset.fm_small_italic.stringWidth(this.tree.getRoot().getTaxonomy());
    }

    int getLongestExtNodeInfo() {
        return this.longest_ext_node_info;
    }

    int getMaxOrtho() {
        return this.max_ortho;
    }

    Phylogeny getTree() {
        return this.tree;
    }

    public TreeColorSet getTreeColorSet() {
        return this.colorset;
    }

    double getXcorrectionFactor() {
        return this.x_correction_factor;
    }

    double getXdistance() {
        return this.x_distance;
    }

    double getYdistance() {
        return this.y_distance;
    }

    private void handleClickToAction(int action, PhylogenyNode node) {
        if (action == 6) {
            this.popupEditFrame(node);
        } else if (action == 7) {
            this.collapse(node);
        } else if (action == 8) {
            this.reRoot(node);
        } else if (action == 9) {
            this.subTree(node);
        } else if (action == 10) {
            this.swap(node);
        } else if (action == 11) {
            this.popupNodeSeqFrame(node);
        } else if (action == 12) {
            this.popupGlyphFrame(node);
        } else if (action == 13) {
            this.customOption(node);
        }
    }

    private void labelExtNode(Graphics g, int x1, PhylogenyNode node, boolean in_color) {
        if (this.atvcontrolpanel.speciesExtNodes() && node.getTaxonomy().length() > 0) {
            this.paintSpeciesExtNode(g, x1, node, in_color);
        }
        if (this.atvcontrolpanel.seqNameExtNodes() && node.getSeqName().length() > 0) {
            this.paintSeqExtName(g, x1, node, in_color);
        }
        if (this.atvcontrolpanel.isECExtNodes() && node.getECnumber().length() > 0) {
            this.paintECExtNode(g, x1, node, in_color);
        }
        if (this.atvcontrolpanel.colorOrthologous() && node.getOrthologous() != -99 || this.atvcontrolpanel.colorSuperOrthologous() && node.getSuperOrthologous() != -99 || this.atvcontrolpanel.colorSubtreeNeighbors() && node.getSubtreeNeighborings() != -99) {
            this.paintOrthologous(g, x1, node, in_color);
        }
        this.paintCustomExtData(g, x1, node, in_color);
        if (this.atvcontrolpanel.writeBranchLengthValues() && !node.isRoot() && node.getDistanceToParent() >= 0.0) {
            this.paintBranchLength(g, node, in_color);
        }
    }

    private void makePopupMenus() {
        String title;
        this.clickto_single_menu = new JPopupMenu();
        Hashtable clickto_hash = this.atvpanel.getATVcontrol().getAllClickToItems();
        Vector clickto_names = this.atvpanel.getATVcontrol().getSingleClickToNames();
        this.clickto_single_items = new JMenuItem[clickto_names.size()];
        int i = 0;
        while (i < clickto_names.size()) {
            title = (String)clickto_names.elementAt(i);
            this.clickto_single_items[i] = new JMenuItem(title);
            this.clickto_single_items[i].addActionListener(this);
            this.clickto_single_menu.add(this.clickto_single_items[i]);
            ++i;
        }
        this.clickto_multiple_menu = new JPopupMenu();
        clickto_names = this.atvpanel.getATVcontrol().getMultipleClickToNames();
        this.clickto_multiple_items = new JMenuItem[clickto_names.size()];
        i = 0;
        while (i < clickto_names.size()) {
            title = (String)clickto_names.elementAt(i);
            this.clickto_multiple_items[i] = new JMenuItem(title);
            this.clickto_multiple_items[i].addActionListener(this);
            this.clickto_multiple_menu.add(this.clickto_multiple_items[i]);
            ++i;
        }
    }

    public void MouseClicked(MouseEvent e) {
        int y;
        int x = e.getX();
        PhylogenyNode node = this.findNode(x, y = e.getY());
        if (node != null) {
            this._highlight_node = node;
            if ((e.getModifiers() & 1) != 0) {
                if (this._found_nodes == null) {
                    this._found_nodes = new Hashtable();
                }
                this._found_nodes.put(node, "");
                if (this._found_nodes.size() > 1) {
                    this.atvpanel.getATVcontrol().setMultipleSelect(true);
                }
            } else if ((e.getModifiers() & 2) != 0) {
                this.popupClickToMenu(node, e.getX(), e.getY());
            } else {
                int m = e.getModifiers();
                if (e.getModifiers() == 4) {
                    this.popupClickToMenu(node, e.getX(), e.getY());
                } else {
                    if (this._found_nodes != null && !this._found_nodes.containsKey(node)) {
                        this._found_nodes.clear();
                        this.atvpanel.getATVcontrol().setMultipleSelect(false);
                    }
                    this.handleClickToAction(this.action_when_node_clicked, node);
                }
            }
        } else {
            this._highlight_node = null;
            this.atvpanel.getATVcontrol().setMultipleSelect(false);
            this._found_nodes = null;
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        int y;
        int x = e.getX();
        PhylogenyNode node = this.findNode(x, y = e.getY());
        if (node != null) {
            this.setCursor(this.hand_cursor);
        } else {
            this.setCursor(this.arrow_cursor);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintTree(g, true);
    }

    private void paintBootstrapValue(Graphics g, boolean in_color) {
        String bs = "" + this.node.getBootstrap();
        int parent_x = this.node.getParent().getXcoord();
        g.setFont(this.fontset.small_font);
        g.setColor(this.colorset.get_bootstrap_color());
        g.drawString(bs, Util.roundToInt((double)parent_x + (this.x_current - (double)parent_x - (double)this.fontset.fm_small.stringWidth(bs)) / 2.0), this.y_current + this.fontset.small_maxAscent - 1);
    }

    private void paintBranch(Graphics g, int x1, int x2, int y1, int y2, PhylogenyNode node, boolean in_color) {
        this.assignGraphicsForBranchWithColorForParentBranch(node, true, g);
        if (!(node.isPseudoNode() || node.isRoot() && !this.tree.isRooted())) {
            this.drawLine(x1, y1, x1, y2, node, true, g, in_color);
        } else {
            g.drawLine(x1, y1, x1, y2);
        }
        this.assignGraphicsForBranchWithColorForParentBranch(node, false, g);
        this.drawLine(x1, y2, x2, y2, node, false, g, in_color);
        this.drawNodeBox(x2, y2, node, g, in_color);
    }

    private void paintBranchLength(Graphics g, PhylogenyNode node, boolean in_color) {
        g.setFont(this.fontset.small_font);
        g.setColor(this.colorset.get_branch_length_color());
        if (!node.isRoot()) {
            g.drawString(this.dist_nf.format(node.getDistanceToParent()), node.getParent().getXcoord() + 3, this.y_current - this.fontset.small_maxDescent);
        } else {
            g.drawString(this.dist_nf.format(node.getDistanceToParent()), 3, this.y_current - this.fontset.small_maxDescent);
        }
    }

    private void paintECExtNode(Graphics g, int x1, PhylogenyNode node, boolean in_color) {
        g.setFont(this.fontset.large_font);
        g.setColor(this.colorset.get_ec_color());
        int x = this.atvcontrolpanel.speciesExtNodes() && node.getTaxonomy().length() > 0 ? this.fontset.fm_large_italic.stringWidth(String.valueOf(node.getTaxonomy()) + " ") : 0;
        if (this.atvcontrolpanel.seqNameExtNodes() && node.getSeqName().length() > 0) {
            x += this.fontset.fm_large.stringWidth(String.valueOf(node.getSeqName()) + " ");
        }
        int start_x = x1 + x + 3 + 3;
        int start_y = this.y_current + this.fontset.fm_large.getAscent() / 2;
        String label = node.getECnumber();
        g.drawString(label, start_x, start_y);
        if (this._found_nodes != null && this._found_nodes.containsKey(node)) {
            g.setColor(this.colorset.get_found_color());
            int height = g.getFontMetrics().getAscent();
            g.drawRect(start_x, start_y - height, g.getFontMetrics().stringWidth(label), height);
        }
    }

    void paintCustomData(int x, int y, PhylogenyNode node, Graphics g, boolean in_color) {
        String s = this.customDataAsString(node);
        if (s != null) {
            g.setColor(this.colorset.get_custom_data_color());
            if (node.isExternal()) {
                g.setFont(this.fontset.large_font);
            } else {
                g.setFont(this.fontset.small_font);
            }
            g.drawString(s, x, y);
        }
    }

    private void paintCustomExtData(Graphics g, int x1, PhylogenyNode node, boolean in_color) {
        int x = this.atvcontrolpanel.speciesExtNodes() && node.getTaxonomy().length() > 0 ? this.fontset.fm_large_italic.stringWidth(String.valueOf(node.getTaxonomy()) + " ") : 0;
        if (this.atvcontrolpanel.seqNameExtNodes() && node.getSeqName().length() > 0) {
            x += this.fontset.fm_large.stringWidth(String.valueOf(node.getSeqName()) + " ");
        }
        if (this.atvcontrolpanel.isECExtNodes() && node.getECnumber().length() > 0) {
            x += this.fontset.fm_large.stringWidth(String.valueOf(node.getECnumber()) + " ");
        }
        if (this.atvcontrolpanel.colorOrthologous() && node.getOrthologous() != -99 || this.atvcontrolpanel.colorSuperOrthologous() && node.getSuperOrthologous() != -99 || this.atvcontrolpanel.colorSubtreeNeighbors() && node.getSubtreeNeighborings() != -99) {
            x += this.fontset.fm_large.stringWidth(" [     ] ");
        }
        this.paintCustomData(x1 + x + 3 + 3, this.y_current + this.fontset.fm_large.getAscent() / 2, node, g, in_color);
    }

    private void paintECIntNode(Graphics g, int x1, PhylogenyNode node, boolean in_color) {
        g.setColor(this.colorset.get_ec_color());
        g.setFont(this.fontset.large_font);
        int x = this.atvcontrolpanel.seqNameInternalNodes() && node.getSeqName().length() > 0 ? this.fontset.fm_large.stringWidth(String.valueOf(node.getSeqName()) + " ") : 0;
        int start_x = x1 - x - this.fontset.fm_large.stringWidth(node.getECnumber()) - 4 - 3;
        int start_y = this.y_current - this.fontset.fm_large.getMaxDescent();
        String label = node.getECnumber();
        g.drawString(label, start_x, start_y);
        if (this._found_nodes != null && this._found_nodes.containsKey(node)) {
            g.setColor(this.colorset.get_found_color());
            int height = g.getFontMetrics().getAscent();
            g.drawRect(start_x, start_y - height, g.getFontMetrics().stringWidth(label), height);
        }
    }

    private boolean paintNode(Graphics g, int ext_nodes_x, boolean in_color) {
        double x2double;
        int factor;
        boolean done = false;
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        if (!this.node.isPseudoNode()) {
            if (this.atvcontrolpanel.writeBranchLengthValues() && this.node.getIndicator() == 0 && this.node.getDistanceToParent() != -99.0) {
                this.paintBranchLength(g, this.node, in_color);
            }
            if (this.atvcontrolpanel.writeBootstrapValues() && this.node.getIndicator() == 0 && !this.node.isRoot() && this.node.getBootstrap() != -99.0 && this.tree.getNumberOfExternalNodes() >= 2) {
                this.paintBootstrapValue(g, in_color);
            }
        }
        if (this.node.isRoot() && this.tree.isRooted() && this.node.getIndicator() == 0) {
            x1 = Util.roundToInt(this.x_current);
            this.paintRootBranch(g, x1, y1, this.tree.getRoot(), in_color);
        }
        if (this.node.getIndicator() == 0 && !this.node.isExternal()) {
            this.node.setIndicator(1);
            factor = this.node.getSumExtNodes() - this.node.getChildNode1().getSumExtNodes();
            x1 = Util.roundToInt(this.x_current);
            y1 = this.y_current;
            y2 = this.y_current - Util.roundToInt(this.y_distance * (double)factor);
            this.node.setXcoord(x1);
            this.node.setYcoord(y1);
            if (!this.node.isPseudoNode()) {
                if (this.atvcontrolpanel.speciesInternalNodes() && !this.node.isCollapse() && this.node.getTaxonomy().length() > 0) {
                    this.paintSpeciesIntNode(g, x1, in_color);
                }
                int x = this.atvcontrolpanel.speciesInternalNodes() && this.node.getTaxonomy().length() > 0 ? this.fontset.fm_small_italic.stringWidth(String.valueOf(this.node.getTaxonomy()) + " ") : 0;
                this.paintCustomData(x1 + x + 3 + 3, this.y_current + this.fontset.fm_small.getAscent() / 2, this.node, g, in_color);
                if (this.atvcontrolpanel.seqNameInternalNodes() && this.node.getSeqName().length() > 0 && !this.node.isCollapse()) {
                    this.paintSeqIntNode(g, x1, this.node, in_color);
                }
                if (this.atvcontrolpanel.isECInternalNodes() && this.node.getECnumber().length() > 0 && !this.node.isCollapse()) {
                    this.paintECIntNode(g, x1, this.node, in_color);
                }
                if (this.atvcontrolpanel.writeDupSpec() && this.node.isDuplicationOrSpecAssigned() && !this.node.isCollapse()) {
                    this.paintSpecEvent(g, x1, in_color);
                }
            }
            if (!this.node.isCollapse()) {
                x2double = this.calculateBranchLength(this.node.getChildNode1(), ext_nodes_x, factor);
                x2 = Util.roundToInt(x2double);
                this.paintBranch(g, x1, x2, y1, y2, this.node.getChildNode1(), in_color);
                this.x_current = x2double;
                this.y_current = y2;
                this.node = this.node.getChildNode1();
            }
        }
        if (this.node.getIndicator() == 1 && !this.node.isExternal()) {
            this.node.setIndicator(2);
            if (!this.node.isCollapse()) {
                factor = this.node.getSumExtNodes() - this.node.getChildNode2().getSumExtNodes();
                x1 = Util.roundToInt(this.x_current);
                y1 = this.y_current;
                y2 = this.y_current + Util.roundToInt(this.y_distance * (double)factor);
                x2double = this.calculateBranchLength(this.node.getChildNode2(), ext_nodes_x, factor);
                x2 = Util.roundToInt(x2double);
                this.paintBranch(g, x1, x2, y1, y2, this.node.getChildNode2(), in_color);
                this.x_current = x2double;
                this.y_current = y2;
                this.node = this.node.getChildNode2();
            }
        }
        if (this.node.isRoot()) {
            done = true;
        } else if (this.node.getIndicator() == 2 && !this.node.isExternal()) {
            this.node = this.node.getParent();
            this.x_current = this.node.getXcoord();
            this.y_current = this.node.getYcoord();
        }
        if (this.node.isExternal()) {
            x1 = Util.roundToInt(this.x_current);
            this.labelExtNode(g, x1, this.node, in_color);
            this.node.setXcoord(x1);
            this.node.setYcoord(this.y_current);
            if (this.node.isLastExternalNode()) {
                done = true;
            }
            if (!this.node.isRoot()) {
                this.node = this.node.getParent();
                this.x_current = this.node.getXcoord();
                this.y_current = this.node.getYcoord();
            }
        }
        return !done;
    }

    private void paintOrthologous(Graphics g, int x1, PhylogenyNode node, boolean in_color) {
        g.setColor(this.calculateColorForOrthologous(node));
        g.setFont(this.fontset.large_font);
        int x = this.atvcontrolpanel.speciesExtNodes() && node.getTaxonomy().length() > 0 ? this.fontset.fm_large_italic.stringWidth(String.valueOf(node.getTaxonomy()) + " ") : 0;
        if (this.atvcontrolpanel.seqNameExtNodes() && node.getSeqName().length() > 0) {
            x += this.fontset.fm_large.stringWidth(String.valueOf(node.getSeqName()) + " ");
        }
        if (this.atvcontrolpanel.isECExtNodes() && node.getECnumber().length() > 0) {
            x += this.fontset.fm_large.stringWidth(String.valueOf(node.getECnumber()) + " ");
        }
        if (this.atvcontrolpanel.colorOrthologous()) {
            g.setColor(this.calculateColorForOrthologous(node));
            if (node.getOrthologous() == -11) {
                g.drawString(" [ Q ]", x1 + x + 3 + 3, this.y_current + this.fontset.fm_large.getAscent() / 2);
            } else {
                g.drawString(" [ " + node.getOrthologous() + " ]", x1 + x + 3 + 3, this.y_current + this.fontset.fm_large.getAscent() / 2);
            }
        } else if (this.atvcontrolpanel.colorSuperOrthologous()) {
            g.setColor(this.calculateColorForSuperOrthologous(node));
            if (node.getSuperOrthologous() == -11) {
                g.drawString(" [ Q ]", x1 + x + 3 + 3, this.y_current + this.fontset.fm_large.getAscent() / 2);
            } else {
                g.drawString(" [ " + node.getSuperOrthologous() + " ]", x1 + x + 3 + 3, this.y_current + this.fontset.fm_large.getAscent() / 2);
            }
        } else if (this.atvcontrolpanel.colorSubtreeNeighbors()) {
            g.setColor(this.calculateColorForSubtreeNeighbors(node));
            if (node.getSubtreeNeighborings() == -11) {
                g.drawString(" [ Q ]", x1 + x + 3 + 3, this.y_current + this.fontset.fm_large.getAscent() / 2);
            } else {
                g.drawString(" [ " + node.getSubtreeNeighborings() + " ]", x1 + x + 3 + 3, this.y_current + this.fontset.fm_large.getAscent() / 2);
            }
        }
    }

    private void paintRootBranch(Graphics g, int x1, int y1, PhylogenyNode to_node, boolean in_color) {
        this.assignGraphicsForBranchWithColorForParentBranch(this.node, false, g);
        if (this.atvcontrolpanel.useRealBranchLengths() && to_node.getDistanceToParent() > 0.0) {
            double d = this.x_correction_factor * to_node.getDistanceToParent();
            this.drawLine(x1 - Util.roundToInt(d), this.y_current, x1, this.y_current, this.node, false, g, in_color);
        } else {
            this.drawLine(x1 - Util.roundToInt(this.x_distance), this.y_current, x1, this.y_current, this.node, false, g, in_color);
        }
        this.drawNodeBox(x1, this.y_current, this.node, g, in_color);
    }

    private void paintSeqExtName(Graphics g, int x1, PhylogenyNode node, boolean in_color) {
        g.setFont(this.fontset.large_font);
        if (this.atvcontrolpanel.colorOrthologous() && node.getOrthologous() != -99) {
            g.setColor(this.calculateColorForOrthologous(node));
        } else if (this.atvcontrolpanel.colorSuperOrthologous() && node.getSuperOrthologous() != -99) {
            g.setColor(this.calculateColorForSuperOrthologous(node));
        } else if (this.atvcontrolpanel.colorSubtreeNeighbors() && node.getSubtreeNeighborings() != -99) {
            g.setColor(this.calculateColorForSubtreeNeighbors(node));
        } else if (in_color && this.atvcontrolpanel.colorAccordingToSpecies()) {
            g.setColor(this.speciesStringToColor(node.getTaxonomy()));
        } else {
            g.setColor(this.colorset.get_ext_node_seq_color());
        }
        int x = this.atvcontrolpanel.speciesExtNodes() && node.getTaxonomy().length() > 0 ? this.fontset.fm_large_italic.stringWidth(String.valueOf(node.getTaxonomy()) + " ") : 0;
        g.drawString(node.getSeqName(), x1 + x + 3 + 3, this.y_current + this.fontset.fm_large.getAscent() / 2);
        Rectangle seq_rec = new Rectangle(x1 + x + 3 + 3, this.y_current - this.fontset.fm_large.getAscent() / 2, this.fontset.fm_large.stringWidth(node.getSeqName()), this.fontset.fm_large.getHeight());
        if (this._found_nodes != null && this._found_nodes.containsKey(node)) {
            g.setColor(this.colorset.get_found_color());
            g.drawRect(seq_rec.x, seq_rec.y, seq_rec.width, seq_rec.height);
        }
        node.setSeqNameRect(seq_rec.x, seq_rec.y, seq_rec.width, seq_rec.height);
    }

    private void paintSeqIntNode(Graphics g, int x1, PhylogenyNode node, boolean in_color) {
        g.setColor(this.colorset.get_int_node_seq_color());
        g.setFont(this.fontset.large_font);
        int start_x = x1 - this.fontset.fm_large.stringWidth(node.getSeqName()) - 3 - 3;
        int start_y = this.y_current - this.fontset.fm_large.getMaxDescent();
        String label = node.getSeqName();
        g.drawString(label, start_x, start_y);
        node.setSeqNameRect(start_x, this.y_current, this.fontset.fm_large.stringWidth(label), this.fontset.fm_large.getHeight());
        if (this._found_nodes != null && this._found_nodes.containsKey(node)) {
            g.setColor(this.colorset.get_found_color());
            int height = g.getFontMetrics().getAscent();
            g.drawRect(start_x, start_y - height, g.getFontMetrics().stringWidth(label), height);
        }
    }

    private void paintSpeciesExtNode(Graphics g, int x1, PhylogenyNode node, boolean in_color) {
        g.setFont(this.fontset.large_italic_font);
        if (this.atvcontrolpanel.colorOrthologous() && node.getOrthologous() != -99) {
            g.setColor(this.calculateColorForOrthologous(node));
        } else if (this.atvcontrolpanel.colorSuperOrthologous() && node.getSuperOrthologous() != -99) {
            g.setColor(this.calculateColorForSuperOrthologous(node));
        } else if (this.atvcontrolpanel.colorSubtreeNeighbors() && node.getSubtreeNeighborings() != -99) {
            g.setColor(this.calculateColorForSubtreeNeighbors(node));
        } else if (in_color && this.atvcontrolpanel.colorAccordingToSpecies()) {
            g.setColor(this.speciesStringToColor(node.getTaxonomy()));
        } else {
            g.setColor(this.colorset.get_species_name_color());
        }
        int start_x = x1 + 3 + 3;
        int start_y = this.y_current + this.fontset.fm_large.getAscent() / 2;
        String label = String.valueOf(node.getTaxonomy()) + " ";
        g.drawString(label, start_x, start_y);
        if (this._found_nodes != null && this._found_nodes.containsKey(node)) {
            g.setColor(this.colorset.get_found_color());
            int height = g.getFontMetrics().getAscent();
            g.drawRect(start_x, start_y - height, g.getFontMetrics().stringWidth(label), height);
        }
    }

    private void paintSpeciesIntNode(Graphics g, int x1, boolean in_color) {
        g.setFont(this.fontset.small_italic_font);
        if (in_color && this.atvcontrolpanel.colorAccordingToSpecies()) {
            g.setColor(this.speciesStringToColor(this.node.getTaxonomy()));
        } else {
            g.setColor(this.colorset.get_species_name_color());
        }
        int start_x = x1 + 3 + 3;
        int start_y = this.y_current + this.fontset.fm_small_italic.getAscent() / 2;
        String label = this.node.getTaxonomy();
        g.drawString(label, start_x, start_y);
        if (this._found_nodes != null && this._found_nodes.containsKey(this.node)) {
            g.setColor(this.colorset.get_found_color());
            int height = g.getFontMetrics().getAscent();
            g.drawRect(start_x, start_y - height, g.getFontMetrics().stringWidth(label), height);
        }
    }

    private void paintSpecEvent(Graphics g, int x1, boolean in_color) {
        g.setColor(this.colorset.get_dub_spec_color());
        g.setFont(this.fontset.large_font);
        int x = this.atvcontrolpanel.speciesInternalNodes() ? this.fontset.fm_large.getMaxAscent() : 0;
        if (this.node.isDuplication()) {
            g.drawString("D", x1 + 3 + 3, this.y_current + this.fontset.fm_large.getAscent() / 2 + x);
        } else {
            g.drawString("S", x1 + 3 + 3, this.y_current + this.fontset.fm_large.getAscent() / 2 + x);
        }
    }

    public void paintTree(Graphics g, boolean print_in_color) {
        boolean done = false;
        if (this.tree == null || this.tree.isEmpty()) {
            return;
        }
        this.node = this.tree.getRoot();
        this.tree.setIndicatorsToZero();
        TreeColorSet old_colorset = this.colorset;
        if (!print_in_color) {
            this.colorset = new TreeColorSet(false);
        }
        this.x_current = !this.tree.isRooted() ? 30.0 : (this.tree.getRoot().getDistanceToParent() > 0.0 && this.atvcontrolpanel.useRealBranchLengths() ? 30.0 + this.tree.getRoot().getDistanceToParent() * this.x_correction_factor : 30.0 + this.getXdistance());
        this.y_current = Util.roundToInt(this.getYdistance() * (double)this.tree.getNumberOfExternalNodes() + 15.0);
        int ext_nodes_x = 30 + Util.roundToInt(this.x_distance * (double)this.tree.getNumberOfExternalNodes());
        g.setColor(this.colorset.get_background_color());
        g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        while (this.paintNode(g, ext_nodes_x, print_in_color)) {
        }
        if (!print_in_color) {
            this.colorset = old_colorset;
        }
        if (this.atvextension != null) {
            this.atvextension.update(this.tree.getRoot());
        }
    }

    private void popupClickToMenu(PhylogenyNode node, int x, int y) {
        if (this.clickto_single_menu == null) {
            this.makePopupMenus();
        }
        if (this._found_nodes == null || !this._found_nodes.containsKey(node)) {
            this.clickto_single_menu.putClientProperty("node", node);
            this.clickto_single_menu.show(this, x, y);
        } else {
            this.clickto_multiple_menu.show(this, x, y);
        }
    }

    private void popupEditFrame(PhylogenyNode n) {
        if (this.editframe_index < 10) {
            this.atveditnodeframes[this.editframe_index] = this._found_nodes != null && this._found_nodes.containsKey(n) ? new ATVeditNodeFrame(this.atvpanel.getATVtreePanel().getFoundNodes(), this.tree, this.atvcontrolpanel.isTreeEditable(), this.atvpanel.getATVtreePanel(), this.editframe_index) : new ATVeditNodeFrame(n, this.tree, this.atvcontrolpanel.isTreeEditable(), this, this.editframe_index);
            ++this.editframe_index;
        } else {
            JOptionPane.showMessageDialog(this, "Too many edit popups are open");
        }
    }

    private void popupGlyphFrame(PhylogenyNode n) {
        if (this.glyphframe_index < 10) {
            this.atvnodeglyphframes[this.glyphframe_index] = new ATVnodeGlyphFrame(this.glyph_class_name, n, this, this.glyphframe_index);
            this.atvnodeglyphframes[this.glyphframe_index].setTitle("Graphs");
            this.atvnodeglyphframes[this.glyphframe_index].initGlyphFrame();
            ++this.glyphframe_index;
        } else {
            JOptionPane.showMessageDialog(this, "Too many graph popups are open");
        }
    }

    void removeAllEditNodeJFrames() {
        int i = 0;
        while (i <= 9) {
            if (this.atveditnodeframes[i] != null) {
                this.atveditnodeframes[i].dispose();
                this.atveditnodeframes[i] = null;
            }
            ++i;
        }
        this.editframe_index = 0;
    }

    private void popupNodeSeqFrame(PhylogenyNode n) {
        if (this.seqframe_index < 10) {
            this.atvnodeseqframes[this.seqframe_index] = new ATVnodeSeqFrame(n, this, this.seqframe_index);
            ++this.seqframe_index;
        } else {
            JOptionPane.showMessageDialog(this, "Too many sequence list popups are open");
        }
    }

    void removeEditNodeFrame(int i) {
        --this.editframe_index;
        this.atveditnodeframes[i] = null;
        if (i < this.editframe_index) {
            int j = 0;
            while (j < this.editframe_index - 1) {
                this.atveditnodeframes[j] = this.atveditnodeframes[j + 1];
                ++j;
            }
            this.atveditnodeframes[this.editframe_index] = null;
        }
    }

    void removeGlyphNodeFrame(int i) {
        --this.glyphframe_index;
        this.atvnodeglyphframes[i] = null;
        if (i < this.glyphframe_index) {
            int j = 0;
            while (j < this.glyphframe_index - 1) {
                this.atvnodeglyphframes[j] = this.atvnodeglyphframes[j + 1];
                ++j;
            }
            this.atvnodeglyphframes[this.glyphframe_index] = null;
        }
    }

    void removeNodeSeqFrame(int i) {
        --this.seqframe_index;
        this.atvnodeseqframes[i] = null;
        if (i < this.seqframe_index) {
            int j = 0;
            while (j < this.seqframe_index - 1) {
                this.atvnodeseqframes[j] = this.atvnodeseqframes[j + 1];
                ++j;
            }
            this.atvnodeseqframes[this.seqframe_index] = null;
        }
    }

    void removeRoot() {
        if (this.tree == null) {
            return;
        }
        if (this.tree.isEmpty()) {
            return;
        }
        this.tree.unRoot();
        this.atvpanel.treeChanged(this.tree.getRoot());
        this.repaint();
    }

    void removeRootTri() {
        if (this.tree == null) {
            return;
        }
        if (this.tree.isEmpty()) {
            return;
        }
        this.tree.unRootAndTrifurcate();
        this.atvpanel.treeChanged(this.tree.getRoot());
        this.repaint();
    }

    void reRoot(PhylogenyNode node) {
        if (!node.isRoot() && !node.getParent().isRoot() || !this.tree.isRooted()) {
            try {
                this.tree.reRoot(node);
                this.tree.adjustNodeCount(true);
            }
            catch (Exception e) {
                System.err.println("ATVgraphic: reRoot( node ): " + e);
            }
            this.resetPreferredSize();
            this.atvpanel.adjustJScrollPane();
            this.atvpanel.treeChanged(this.tree.getRoot());
            this.repaint();
        }
    }

    void resetPreferredSize() {
        if (this.tree == null || this.tree.isEmpty()) {
            return;
        }
        int x = 0;
        int y = 0;
        y = 30 + Util.roundToInt(this.getYdistance() * (double)this.tree.getNumberOfExternalNodes() * 2.0);
        x = this.atvcontrolpanel.useRealBranchLengths() ? 30 + this.getLongestExtNodeInfo() + this.getLengthOfRootSpecies() + Util.roundToInt(this.getXcorrectionFactor() * this.tree.getHeight() + this.getXdistance()) : 30 + this.getLongestExtNodeInfo() + this.getLengthOfRootSpecies() + Util.roundToInt(this.getXdistance() * (double)(this.tree.getNumberOfExternalNodes() + 2));
        this.setPreferredSize(new Dimension(x, y));
    }

    void setActionWhenNodeClicked(int i) {
        this.action_when_node_clicked = i;
    }

    public void setControlPeer(ATVcontrol peer) {
        this.atvcontrolpanel = peer;
    }

    void setFoundNodes(Hashtable found_nodes) {
        this._found_nodes = found_nodes;
    }

    void setGlyphClass(String new_class) {
        this.glyph_class_name = new_class;
    }

    void setMaxOrtho(int m) {
        this.max_ortho = m;
    }

    public void setLargeFonts() {
        this.fontset.largeFonts();
    }

    void setLongestExtNodeInfo(int i) {
        this.longest_ext_node_info = i;
    }

    public void setMediumFonts() {
        this.fontset.mediumFonts();
    }

    void setParametersForPainting(int x, int y) {
        if (this.tree != null && !this.tree.isEmpty()) {
            this.calculateLongestExtNodeInfo();
            double xdist = (double)(x - this.getLongestExtNodeInfo() - 30 - this.getLengthOfRootSpecies()) / ((double)this.tree.getNumberOfExternalNodes() + 2.0);
            double ydist = (double)(y - 30) / ((double)this.tree.getNumberOfExternalNodes() * 2.0);
            if (xdist < 0.0) {
                xdist = 0.0;
            }
            if (ydist < 0.0) {
                ydist = 0.0;
            }
            this.setXdistance(xdist);
            this.setYdistance(ydist);
            if (this.tree.getHeight() > Double.MIN_VALUE) {
                double corr = ((double)(x - 30 - this.getLongestExtNodeInfo()) - this.getXdistance() - (double)this.getLengthOfRootSpecies()) / this.tree.getHeight();
                if (corr < 0.0) {
                    corr = 0.0;
                }
                this.setXcorrectionFactor(corr);
            } else {
                this.setXcorrectionFactor(0.0);
            }
        }
    }

    public void setSmallFonts() {
        this.fontset.smallFonts();
    }

    void setSpeciesColors(Hashtable colors) {
        this.species_colors = colors;
    }

    public void setTinyFonts() {
        this.fontset.tinyFonts();
    }

    void setTree(Phylogeny t) {
        this.tree = t;
    }

    void setTreeColorSet(TreeColorSet colorset) {
        this.colorset = colorset;
        this.setBackground(colorset.get_background_color());
        this.repaint();
    }

    void setXdistance(double i) {
        this.x_distance = i;
    }

    void setXcorrectionFactor(double i) {
        this.x_correction_factor = i;
    }

    void setYdistance(double i) {
        this.y_distance = i;
    }

    public Color speciesStringToColor(String species) {
        if (species == null || species.length() < 1) {
            return this.colorset.get_species_name_color();
        }
        Color c = this.colorset.get_species_name_color();
        if (this.species_colors.get(species) != null) {
            c = (Color)this.species_colors.get(species);
        } else if (this.next_default_color < this.default_species_colors.length) {
            String color_str = this.default_species_colors[this.next_default_color];
            c = Color.decode(color_str);
            ++this.next_default_color;
            this.species_colors.put(species, c);
        } else {
            System.out.println("Out of colors for species " + species);
        }
        return c;
    }

    void subTree(PhylogenyNode node) {
        if (!node.isExternal() && !node.isRoot() && this.subtree_index <= 99) {
            this.trees[this.subtree_index++] = this.tree;
            this.tree = this.tree.subTree(node.getID());
        } else if (node.isRoot() && this.subtree_index >= 1) {
            this.trees[this.subtree_index] = null;
            this.tree = this.trees[--this.subtree_index];
        }
        this.atvpanel.getATVcontrol().showWhole();
        this.atvpanel.treeChanged(this.tree.getRoot());
        this.repaint();
    }

    void swap(PhylogenyNode node) {
        if (!node.isExternal()) {
            this.tree.swapChildren(node);
        }
        this.repaint();
        this.atvpanel.treeChanged(this.tree.getRoot());
    }
}

