/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class ATVtextframe
extends JFrame
implements ActionListener,
ClipboardOwner {
    private boolean can_use_clipboard;
    private String text;
    private JTextArea jtextarea;
    private JButton close_button;
    private JButton copy_button;
    private JPanel buttonjpanel;
    private static Color ta_text_color = new Color(0, 0, 0);
    private static Color ta_background_color = new Color(240, 240, 240);
    private static Color background_color = new Color(215, 215, 215);
    private static Color button_background_color = new Color(215, 215, 215);
    private static Color button_text_color = new Color(0, 0, 0);
    private static final Font button_font = new Font("Helvetica", 0, 10);
    private static final Font ta_font = new Font("Helvetica", 0, 10);
    private Container contentpane;

    ATVtextframe(String s) {
        this.setTitle("ATV");
        this.text = s;
        this.can_use_clipboard = true;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkSystemClipboardAccess();
            }
            catch (Exception e) {
                this.can_use_clipboard = false;
            }
        }
        this.setBackground(background_color);
        this.buttonjpanel = new JPanel();
        this.buttonjpanel.setBackground(background_color);
        this.close_button = new JButton("          Close          ");
        this.close_button.setBackground(button_background_color);
        this.close_button.setForeground(button_text_color);
        this.close_button.setFont(button_font);
        this.close_button.addActionListener(this);
        this.buttonjpanel.add(this.close_button);
        if (this.can_use_clipboard) {
            this.copy_button = new JButton("Copy to clipboard");
            this.copy_button.setBackground(button_background_color);
            this.copy_button.setForeground(button_text_color);
            this.copy_button.setFont(button_font);
            this.copy_button.addActionListener(this);
            this.buttonjpanel.add(this.copy_button);
        }
        this.contentpane = this.getContentPane();
        this.contentpane.setLayout(new BorderLayout());
        this.jtextarea = new JTextArea(this.text);
        this.jtextarea.setBackground(ta_background_color);
        this.jtextarea.setForeground(ta_text_color);
        this.jtextarea.setFont(ta_font);
        this.jtextarea.setEditable(false);
        this.jtextarea.setWrapStyleWord(true);
        this.jtextarea.setLineWrap(true);
        this.contentpane.add((Component)new JScrollPane(this.jtextarea), "Center");
        this.buttonjpanel.setLayout(new FlowLayout(1, 20, 5));
        this.contentpane.add((Component)this.buttonjpanel, "South");
        this.setSize(500, 400);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ATVtextframe.this.close();
            }
        });
        this.setVisible(true);
    }

    void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.close_button) {
            this.close();
        } else if (o == this.copy_button) {
            this.copy();
        }
    }

    private void copy() {
        if (!this.can_use_clipboard) {
            return;
        }
        Clipboard sys_clipboard = this.getToolkit().getSystemClipboard();
        StringSelection contents = new StringSelection(this.jtextarea.getText());
        sys_clipboard.setContents(contents, this);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

