/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.forester.atv.ATVConfig;
import org.forester.atv.ATVcontrol;
import org.forester.atv.ATVframe;
import org.forester.atv.ATVnodeGlyphPanel;
import org.forester.atv.ATVtreePanel;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;

class ATVpanel
extends JPanel {
    ATVframe atvframe;
    ATVtreePanel atvtreepanel;
    ATVcontrol atvcontrol;
    JScrollPane treegraphic_jsp;
    JPanel tree_panel = new JPanel(new BorderLayout());
    ATVnodeGlyphPanel atvextension = null;
    JScrollPane extension_jsp = null;
    static final Color background_color = new Color(0, 0, 0);

    ATVpanel() {
    }

    ATVpanel(Phylogeny t, ATVConfig config_settings, ATVframe parent) {
        this.atvframe = parent;
        this.setupExtensionPanel(config_settings, t);
        this.atvtreepanel = new ATVtreePanel(t, config_settings, this, this.atvextension);
        if (this.atvtreepanel == null) {
            System.out.println("atvtreepanel == null");
        }
        this.atvcontrol = new ATVcontrol(this, this.atvtreepanel, config_settings);
        this.atvtreepanel.setControlPeer(this.atvcontrol);
        this.initialize();
        this.setupTreeGraphic(config_settings, this.atvtreepanel);
        this.getATVcontrol().showWhole();
    }

    void initialize() {
        this.setBackground(background_color);
        this.treegraphic_jsp = new JScrollPane(this.atvtreepanel);
        this.treegraphic_jsp.getHorizontalScrollBar().setUnitIncrement(20);
        this.treegraphic_jsp.getHorizontalScrollBar().setBlockIncrement(50);
        this.treegraphic_jsp.getVerticalScrollBar().setUnitIncrement(20);
        this.treegraphic_jsp.getVerticalScrollBar().setBlockIncrement(50);
        if (this.atvextension != null) {
            this.atvextension.setGlyphWidth(60);
            Phylogeny t = this.atvtreepanel.getTree();
            if (t != null) {
                this.atvextension.init(this, t.getRoot());
            } else {
                this.atvextension.init(this, null);
            }
            this.extension_jsp = new JScrollPane(this.atvextension);
            this.extension_jsp.getHorizontalScrollBar().setUnitIncrement(20);
            this.extension_jsp.getHorizontalScrollBar().setBlockIncrement(50);
            this.extension_jsp.getVerticalScrollBar().setUnitIncrement(20);
            this.extension_jsp.getVerticalScrollBar().setBlockIncrement(50);
        }
        this.setLayout(new BorderLayout());
        this.tree_panel = new JPanel(new BorderLayout());
        this.tree_panel.add((Component)this.treegraphic_jsp, "Center");
        if (this.extension_jsp != null) {
            this.tree_panel.add((Component)this.extension_jsp, "East");
        }
        this.add((Component)this.tree_panel, "Center");
        this.add((Component)this.atvcontrol, "West");
    }

    Dimension getSizeOfViewport() {
        return this.treegraphic_jsp.getViewport().getExtentSize();
    }

    void adjustJScrollPane() {
        this.tree_panel.remove(this.treegraphic_jsp);
        this.tree_panel.add((Component)this.treegraphic_jsp, "Center");
        this.treegraphic_jsp.revalidate();
    }

    ATVtreePanel getATVtreePanel() {
        return this.atvtreepanel;
    }

    ATVcontrol getATVcontrol() {
        return this.atvcontrol;
    }

    void setupExtensionPanel(ATVConfig config_settings, Phylogeny t) {
        int glyph_type = config_settings.getGlyphType();
        if (glyph_type != 0) {
            try {
                Class<?> newc;
                Class<?> c = this.getClass();
                ClassLoader cl = c.getClassLoader();
                if (glyph_type == 1) {
                    newc = cl.loadClass("org.forester.extensions.NodeExpressionPanel");
                } else if (glyph_type == 2) {
                    newc = cl.loadClass("org.forester.extensions.NodeChromosomePanel");
                } else {
                    System.out.println("Unknown glyph type: " + glyph_type);
                    return;
                }
                this.atvextension = (ATVnodeGlyphPanel)newc.newInstance();
            }
            catch (Exception e) {
                System.out.println("Error encountered while creating glyph frame; " + e.toString());
            }
        }
    }

    void terminate() {
        this.atvtreepanel.removeAllEditNodeJFrames();
    }

    void treeChanged(PhylogenyNode n) {
        if (this.atvextension != null) {
            this.atvextension.treeChanged(n);
            this.atvextension.repaint();
        }
    }

    void setupTreeGraphic(ATVConfig config_settings, ATVtreePanel atvtreepanel) {
        atvtreepanel.setSpeciesColors(config_settings.getSpeciesColors());
    }
}

