/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.forester.atv.ATVnodeSeqFrame;
import org.forester.phylogeny.PhylogenyNode;

public class ATVnodeSeqPanel
extends JPanel
implements ActionListener,
ClipboardOwner {
    private boolean can_use_clipboard;
    private PhylogenyNode node;
    private ATVnodeSeqFrame atvnodeseqframe;
    private Vector sequence_names = new Vector();
    JLabel popup_title;
    JButton close_button;
    JButton copy_button;
    JTextArea name_list;

    ATVnodeSeqPanel(PhylogenyNode n, ATVnodeSeqFrame anf) {
        this.node = n;
        this.atvnodeseqframe = anf;
        String title = "ATV";
        this.atvnodeseqframe.setTitle(title);
        this.can_use_clipboard = true;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkSystemClipboardAccess();
            }
            catch (Exception e) {
                this.can_use_clipboard = false;
            }
        }
        this.setLayout(new BorderLayout(10, 10));
        this.popup_title = new JLabel("Sequences for this node");
        this.popup_title.setHorizontalAlignment(0);
        this.add((Component)this.popup_title, "North");
        this.getNodeInfo();
        this.displayNodeInfo();
        JPanel button_panel = new JPanel(new FlowLayout());
        this.close_button = new JButton("Close");
        this.close_button.addActionListener(this);
        button_panel.add(this.close_button);
        if (this.can_use_clipboard) {
            this.copy_button = new JButton("Copy to Clipboard");
            this.copy_button.addActionListener(this);
            button_panel.add(this.copy_button);
        }
        this.add((Component)button_panel, "South");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.close_button) {
            this.close();
        } else if (e.getSource() == this.copy_button) {
            this.copy();
        }
    }

    void close() {
        this.atvnodeseqframe.remove();
        this.atvnodeseqframe.dispose();
        this.atvnodeseqframe = null;
    }

    private void copy() {
        if (!this.can_use_clipboard) {
            return;
        }
        Clipboard sys_clipboard = this.getToolkit().getSystemClipboard();
        StringSelection contents = new StringSelection(this.name_list.getText());
        sys_clipboard.setContents(contents, this);
    }

    private void getNodeInfo() {
        this.getSequenceNames(this.node);
    }

    private void displayNodeInfo() {
        this.name_list = new JTextArea("");
        this.name_list.setEditable(false);
        this.name_list.setWrapStyleWord(true);
        this.name_list.setLineWrap(true);
        this.add((Component)new JScrollPane(this.name_list), "Center");
        int num_names = this.sequence_names.size();
        String list = "";
        int i = 0;
        while (i < num_names) {
            list = String.valueOf(list) + (String)this.sequence_names.elementAt(i) + "\n";
            ++i;
        }
        this.name_list.setText(list);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void getSequenceNames(PhylogenyNode n) {
        if (n != null) {
            if (!n.isExternal() && n.getChildNode1() != null && n.getChildNode2() != null) {
                this.getSequenceNames(n.getChildNode1());
                this.getSequenceNames(n.getChildNode2());
            } else {
                this.sequence_names.add(n.getSeqName());
            }
        }
    }
}

