/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.forester.atv.ATVnodeGlyphPanel;
import org.forester.atv.ATVtreePanel;
import org.forester.phylogeny.PhylogenyNode;

public class ATVnodeGlyphFrame
extends JFrame
implements ActionListener {
    private String class_name;
    private ATVnodeGlyphPanel atvnodeglyphpanel;
    private ATVtreePanel atvtreepanel;
    private int frame_index;
    private PhylogenyNode node;
    protected String title = "Glyphs for this node";
    protected JLabel popup_title;
    protected JPanel button_panel = new JPanel();
    protected JButton close_button;

    ATVnodeGlyphFrame(String name, PhylogenyNode n, ATVtreePanel tp, int x) {
        this.class_name = name;
        this.atvtreepanel = tp;
        this.frame_index = x;
        this.node = n;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.close_button) {
            this.close();
        }
    }

    void close() {
        this.remove();
        this.dispose();
    }

    ATVtreePanel getATVtreePanel() {
        return this.atvtreepanel;
    }

    public JPanel getButtonPanel() {
        return this.button_panel;
    }

    public void initGlyphFrame() {
        try {
            Class<?> c = this.getClass();
            ClassLoader cl = c.getClassLoader();
            Class<?> newc = cl.loadClass(this.class_name);
            this.atvnodeglyphpanel = (ATVnodeGlyphPanel)newc.newInstance();
            this.atvnodeglyphpanel.init(this, this.node);
            Dimension d = this.atvnodeglyphpanel.getSize();
            d.width += 80;
            if (d.height < 250) {
                d.height += 60;
            } else if (d.height > 400) {
                d.height = 400;
            }
            this.setSize(d);
            Container contentPane = this.getContentPane();
            contentPane.add((Component)this.atvnodeglyphpanel, "Center");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    ATVnodeGlyphFrame.this.remove();
                    ATVnodeGlyphFrame.this.dispose();
                }
            });
            this.close_button = new JButton("Close");
            this.close_button.addActionListener(this);
            this.button_panel.add(this.close_button);
            contentPane.add((Component)this.button_panel, "South");
            this.popup_title = new JLabel(this.title);
            this.popup_title.setHorizontalTextPosition(0);
            contentPane.add((Component)this.popup_title, "North");
            this.setVisible(true);
        }
        catch (Exception e) {
            System.out.println("Error encountered while creating glyph pop-up: " + e.toString());
            this.remove();
            this.dispose();
        }
    }

    void remove() {
        this.atvtreepanel.removeGlyphNodeFrame(this.frame_index);
    }

    public void setTitle(String new_title) {
        this.title = new_title;
    }
}

