/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.forester.atv.ATVColorSchemeChooser;
import org.forester.atv.ATVConfig;
import org.forester.atv.ATVconstants;
import org.forester.atv.ATVpanel;
import org.forester.atv.ATVtextframe;
import org.forester.atv.HighlightSeqFrame;
import org.forester.atv.TreeColorSet;
import org.forester.phylogenomics.SDI;
import org.forester.phylogenomics.SDIse;
import org.forester.phylogenomics.SDIunrooted;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.util.Util;

public abstract class ATVframe
extends JFrame
implements ActionListener {
    protected Phylogeny reload_tree_ = null;
    protected Phylogeny species_tree_ = null;
    protected JMenuBar jmenubar;
    protected JMenu file_jmenu;
    protected JMenu edit_jmenu;
    protected JMenu SDI_jmenu;
    protected JMenu genomics_jmenu;
    protected JMenu view_jmenu;
    protected JMenu options_jmenu;
    protected JMenu help_jmenu;
    protected JMenuItem open_item;
    protected JMenuItem open_url_item;
    protected JMenuItem save_item;
    protected JMenuItem saveas_item;
    protected JMenuItem close_item;
    protected JMenuItem reload_item;
    protected JMenuItem remove_root_item;
    protected JMenuItem remove_root_tri_item;
    protected JMenuItem find_item;
    protected JMenuItem find_reset_item;
    protected JMenuItem highlight_item;
    protected JMenuItem tiny_fonts_item;
    protected JMenuItem small_fonts_item;
    protected JMenuItem medium_fonts_item;
    protected JMenuItem large_fonts_item;
    protected JMenuItem switch_colors_item;
    protected JMenuItem view_as_NH_item;
    protected JMenuItem view_as_NHX_item;
    protected JMenuItem view_as_XML_item;
    protected JMenuItem about_item;
    protected JMenuItem help_item;
    protected JMenuItem hide_show_item;
    protected JMenuItem load_species_tree_item;
    protected JMenuItem infer_dups_item;
    protected JMenuItem root_min_dups_height_item;
    protected JMenuItem root_min_L_height_item;
    protected JMenuItem root_min_height_item;
    protected ATVpanel atvpanel;
    protected Container contentpane;
    protected ATVtextframe atvtextframe;
    protected JLabel xs_label;
    protected JLabel ys_label;
    protected static final Font menu_font = new Font("Helvetica", 0, 10);
    protected String config_filename;
    ATVConfig config_settings;

    protected void about() {
        String about = "ATV (A Phylogeny Viewer)\nVersion 3.00 BETA\n";
        about = String.valueOf(about) + "Copyright (C) 1999-2005 Washington University School of Medicine\n";
        about = String.valueOf(about) + "and Howard Hughes Medical Institute\n";
        about = String.valueOf(about) + "All Rights Reserved\n";
        about = String.valueOf(about) + "Authors: Christian M. Zmasek, Ethy Cannon\n";
        about = String.valueOf(about) + "Last modified: 11/7/05\n";
        about = String.valueOf(about) + "Reference: Zmasek C.M. and Eddy S.R. Bioinformatics, 17, 383 (2001)\n";
        about = String.valueOf(about) + "For more information & download:\n";
        about = String.valueOf(about) + "http://www.phylogenomics.us/atv/\n";
        about = String.valueOf(about) + "Comments: cmzmasek@yahoo.com";
        JOptionPane.showMessageDialog(this, about, "ATV Applet (Java 1.4 or greater)", -1);
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.reload_item) {
            this.reLoad();
        } else if (o == this.open_url_item) {
            this.openURL();
        } else if (o == this.close_item) {
            this.close();
        } else if (o == this.remove_root_item) {
            this.removeRoot();
        } else if (o == this.remove_root_tri_item) {
            this.removeRootTri();
        } else if (o == this.switch_colors_item) {
            this.switchColors();
        } else if (o == this.view_as_NH_item) {
            this.viewAsNH();
        } else if (o == this.view_as_NHX_item) {
            this.viewAsNHX();
        } else if (o == this.view_as_XML_item) {
            this.viewAsXML();
        } else if (o == this.tiny_fonts_item) {
            this.atvpanel.getATVtreePanel().setTinyFonts();
            this.atvpanel.getATVtreePanel().repaint();
        } else if (o == this.small_fonts_item) {
            this.atvpanel.getATVtreePanel().setSmallFonts();
            this.atvpanel.getATVtreePanel().repaint();
        } else if (o == this.medium_fonts_item) {
            this.atvpanel.getATVtreePanel().setMediumFonts();
            this.atvpanel.getATVtreePanel().repaint();
        } else if (o == this.large_fonts_item) {
            this.atvpanel.getATVtreePanel().setLargeFonts();
            this.atvpanel.getATVtreePanel().repaint();
        } else if (o == this.about_item) {
            this.about();
        } else if (o == this.help_item) {
            this.help();
        } else if (o == this.hide_show_item) {
            this.hideShowItemHelp();
        } else if (o == this.find_item) {
            this.find();
        } else if (o == this.highlight_item) {
            this.highlightSequences();
        } else if (o == this.find_reset_item) {
            this.findReset();
        }
        this.contentpane.repaint();
    }

    protected void buildEditMenu() {
        this.edit_jmenu = this.createMenu("Edit");
        this.remove_root_item = new JMenuItem("Remove root");
        this.edit_jmenu.add(this.remove_root_item);
        this.remove_root_tri_item = new JMenuItem("Remove root and trifurcate");
        this.edit_jmenu.add(this.remove_root_tri_item);
        this.edit_jmenu.addSeparator();
        this.find_item = new JMenuItem("Search...");
        this.edit_jmenu.add(this.find_item);
        this.highlight_item = new JMenuItem("Select Sequences...");
        this.edit_jmenu.add(this.highlight_item);
        this.find_reset_item = new JMenuItem("Unselect All");
        this.edit_jmenu.add(this.find_reset_item);
        this.customizeJMenuItem(this.remove_root_item);
        this.customizeJMenuItem(this.remove_root_tri_item);
        this.customizeJMenuItem(this.find_item);
        this.customizeJMenuItem(this.highlight_item);
        this.customizeJMenuItem(this.find_reset_item);
        this.jmenubar.add(this.edit_jmenu);
    }

    protected void buildFileMenu() {
        this.file_jmenu = this.createMenu("File");
        this.reload_item = new JMenuItem("Reload");
        this.file_jmenu.add(this.reload_item);
        this.file_jmenu.addSeparator();
        this.open_url_item = new JMenuItem("Open tree URL...");
        this.file_jmenu.add(this.open_url_item);
        this.file_jmenu.addSeparator();
        this.close_item = new JMenuItem("Close");
        this.file_jmenu.add(this.close_item);
        this.customizeJMenuItem(this.reload_item);
        this.customizeJMenuItem(this.open_url_item);
        this.customizeJMenuItem(this.close_item);
        this.jmenubar.add(this.file_jmenu);
    }

    protected void buildHelpMenu() {
        this.help_jmenu = this.createMenu("Help");
        this.help_item = new JMenuItem("Help");
        this.help_jmenu.add(this.help_item);
        this.hide_show_item = new JMenuItem("Hide item help");
        this.help_jmenu.add(this.hide_show_item);
        this.help_jmenu.addSeparator();
        this.about_item = new JMenuItem("About");
        this.help_jmenu.add(this.about_item);
        this.customizeJMenuItem(this.help_item);
        this.customizeJMenuItem(this.hide_show_item);
        this.customizeJMenuItem(this.about_item);
        this.jmenubar.add(this.help_jmenu);
    }

    protected void buildOptionsMenu() {
        this.options_jmenu = new JMenu("Display Options");
        this.options_jmenu.setFont(menu_font);
        this.options_jmenu.setBackground(ATVconstants.MENU_BACKGROUND_COLOR_DEFAULT);
        this.options_jmenu.setForeground(ATVconstants.MENU_TEXT_COLOR_DEFAULT);
        this.switch_colors_item = new JMenuItem("Switch colors...");
        this.options_jmenu.add(this.switch_colors_item);
        this.options_jmenu.addSeparator();
        this.tiny_fonts_item = new JMenuItem("Tiny fonts");
        this.options_jmenu.add(this.tiny_fonts_item);
        this.small_fonts_item = new JMenuItem("Small fonts");
        this.options_jmenu.add(this.small_fonts_item);
        this.medium_fonts_item = new JMenuItem("Medium fonts");
        this.options_jmenu.add(this.medium_fonts_item);
        this.large_fonts_item = new JMenuItem("Large fonts");
        this.options_jmenu.add(this.large_fonts_item);
        this.options_jmenu.addSeparator();
        this.customizeJMenuItem(this.switch_colors_item);
        this.customizeJMenuItem(this.tiny_fonts_item);
        this.customizeJMenuItem(this.small_fonts_item);
        this.customizeJMenuItem(this.medium_fonts_item);
        this.customizeJMenuItem(this.large_fonts_item);
        this.jmenubar.add(this.options_jmenu);
    }

    protected void buildViewMenu() {
        this.view_jmenu = this.createMenu("View as Text");
        this.view_as_XML_item = new JMenuItem("View as PhyloXML...");
        this.view_jmenu.add(this.view_as_XML_item);
        this.view_as_NH_item = new JMenuItem("View as NH...");
        this.view_jmenu.add(this.view_as_NH_item);
        this.view_as_NHX_item = new JMenuItem("View as NHX...");
        this.view_jmenu.add(this.view_as_NHX_item);
        this.customizeJMenuItem(this.view_as_NH_item);
        this.customizeJMenuItem(this.view_as_NHX_item);
        this.customizeJMenuItem(this.view_as_XML_item);
        this.jmenubar.add(this.view_jmenu);
    }

    protected void close() {
        this.removeatvtextframe();
        this.atvpanel.terminate();
        this.contentpane.removeAll();
        this.setVisible(false);
        this.dispose();
    }

    protected JMenu createMenu(String title) {
        JMenu jmenu = new JMenu(title);
        jmenu.setFont(menu_font);
        jmenu.setBackground(ATVconstants.MENU_BACKGROUND_COLOR_DEFAULT);
        jmenu.setForeground(ATVconstants.MENU_TEXT_COLOR_DEFAULT);
        return jmenu;
    }

    protected void customizeJMenuItem(JMenuItem jmi) {
        jmi.setFont(menu_font);
        jmi.setBackground(ATVconstants.MENU_BACKGROUND_COLOR_DEFAULT);
        jmi.setForeground(ATVconstants.MENU_TEXT_COLOR_DEFAULT);
        jmi.addActionListener(this);
    }

    public void customOption(PhylogenyNode node) {
    }

    public void customOption(Hashtable node_hash) {
    }

    protected void exceptionOccuredDuringOpenFile(Exception e) {
        JOptionPane.showMessageDialog(this, "Exception: " + e, "Error during File|Open", 0);
    }

    protected void exceptionOccuredDuringSaveAs(Exception e) {
        JOptionPane.showMessageDialog(this, "Exception" + e, "Error during File|SaveAs", 0);
    }

    protected void find() {
        if (this.atvpanel.getATVtreePanel().getTree() == null || this.atvpanel.getATVtreePanel().getTree().isEmpty()) {
            return;
        }
        String message = "String to search for in sequence and species names,\nEC numbers; or integer for taxonomy IDs:";
        String query = JOptionPane.showInputDialog(this, message, "Search", 3);
        if (query != null && !(query = query.trim()).equals("")) {
            Hashtable nodes = null;
            try {
                nodes = this.atvpanel.getATVtreePanel().getTree().findInNameSpecECid(query);
            }
            catch (Exception e) {
                System.err.println("Unexpected exception: " + e);
            }
            if (nodes != null && nodes.size() > 0) {
                this.atvpanel.getATVtreePanel().setFoundNodes(nodes);
            } else {
                JOptionPane.showMessageDialog(this, "Could not find \"" + query + "\"", "Search", 0);
            }
        }
        this.contentpane.repaint();
    }

    protected void findReset() {
        if (this.atvpanel.getATVtreePanel().getTree() == null || this.atvpanel.getATVtreePanel().getTree().isEmpty()) {
            return;
        }
        this.atvpanel.getATVtreePanel().setFoundNodes(null);
        this.contentpane.repaint();
    }

    protected boolean GAndSDoHaveMoreThanOneSpeciesInComman(Phylogeny gene_tree) {
        if (gene_tree == null || gene_tree.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Gene tree and species tree have no species in common.", "Error during SDI", 0);
            return false;
        }
        if (gene_tree.getNumberOfExternalNodes() < 2) {
            JOptionPane.showMessageDialog(this, "Gene tree and species tree have only one species in common.", "Error during SDI", 0);
            return false;
        }
        return true;
    }

    protected void help() {
        String help = "Display options\n-------------------\nUse the checkboxes to select types of information to display on the tree.\n\nClickable Tree nodes\n----------\nAll nodes are active and can be clicked. Select the action by clicking a radio button:\no  display editable info -- display and edit information of a node.\n    To edit information, box \"Editable\" needs to be checked.\no  collapse/uncollapse -- collapse and uncollapse subtree from clicked node.\no  root/reroot -- change tree root to clicked node.\no  swap children -- switch children on either side of clicked node.\no  subtree/parent tree -- toggle between subtree from clicked node and whole tree.\no  display sequences -- pop up a list of all sequences in subtree at clicked node.\n-  there may be additional choices depending on this particular setup\n\nApplet-only click-to options:\no  SWISS-PROT -- go to SWISS-PROT and display its entry for the corresponding sequence.\n    Only available in JApplet version.\n    Seq names need to be proper SWISS-PROT names for this to work.\n\nRight clicking on a node always displays the information of a node.\n\nZooming:\n--------\nUse the buttons on the control panel to zoom the tree in and out, both horizontally and vertically.\nThe entire tree can be fitted into the window by clicking the \"show whole\" button.\n\nQuick tree manipulation:\n------------------------\nOrder Subtrees -- order the tree by branch length\nUncollapse All -- uncollapse any and all collapsed branches\nCollapse to Deepest Annotation Level -- Collapse tree to deepest onnotation level.\nReload tree -- Restore the tree from its file\n\nMenus\n-----\nFile/Reload -- Restore tree to original data.\nFile/Open -- Open a new tree file; not available in applet.\nFile/Open URL -- Open a new tree from URL.\nFile/Save, Save As -- Save tree; not available in applet.\nFile/Print -- prints the tree as displayed; not available in applet.\n\nEdit/Remove root -- remove the root from the tree.\nEdit/Remove root and trifurcurate -- Remove root and put three branches at the lowest level.\nEdit/Search -- Find all occurrences of a string in any node.\nEdit/Highlight Sequences -- Highlight a set of sequence names.\nEdit/Remove Highlighting -- Clear all selected and hightlighted text.\n\nView As Text/XML, NH, NHX -- view tree in its current state in any of three formats.\n   NOTE: some information can't be represented in NH and NHX.\n\nDisplay Options/Switch colors -- choose new colors for the tree.\nDisplay Options/Tiny fonts, Small fonts, Medium fonts, Large fonts -- change font size.\nHelp/About -- information about ATV.\nHelp/Help -- this popup.\n\nGeneral remarks:\n----------------\no  ATV can deal with trees with an arbitrary number of \n    children per parent (except for SDI).\no  The application version permits copying to the clipboard \n    in the \"View\"|\"View as ...\" frame (either by control-c or button press).\no  Changes made to a subtree affect this subtree and its subtrees,\n    but not any of its parent tree(s).\no  ATV tries to detect whether the numerical values in a NH tree\n    are likely to be bootstrap values instead of branch length values.\n\n Remarks regarding SDI (Speciation Duplication Inference):\no  Each external node of the gene tree (in display) needs to be associated with\n    a species: either directly through the \"Species\" field, or the species\n    is part of the sequence name in the form \"XXXX_SPECIES\"\n    (e.g. \"ACON_DROME\" or \"ACON_DROME/123-4489\" which is also acceptable).\no  A species tree for each species of the gene tree needs to be loaded with\n   \"SDI\"|\"Load species tree\" prior the SDI execution.\no  !External nodes of the gene tree associated with species not present in\n    the species tree are REMOVED prior to SDI execution!\no  Both the gene tree and the species tree must be completely binary.\no  Duplications and speciations are a function of the position of the root.\n    Hence, after each manual \"Root/Reroot\"ing some duplications will be\n    incorrect and need to be inferred again\n    with: \"SDI\"|\"SDI (Speciation Duplication Inference)\n\nFor more information: http://www.phylogenomics.us/atv/\nEmail: cmzmasek@yahoo.com, ethy@a415software.com\n\n";
        ATVtextframe atf = new ATVtextframe(help);
    }

    protected void hideShowItemHelp() {
        String s = this.hide_show_item.getLabel();
        if (s.startsWith("Hide")) {
            this.atvpanel.getATVcontrol().showItemHelpButtons(false);
            this.hide_show_item.setLabel("Show item help");
        } else {
            this.atvpanel.getATVcontrol().showItemHelpButtons(true);
            this.hide_show_item.setLabel("Hide item help");
        }
    }

    protected void highlightSequences() {
        HighlightSeqFrame hsf = new HighlightSeqFrame(this);
        hsf.show();
        ArrayList namelist = hsf.getSequenceNames();
        if (namelist != null) {
            Hashtable<PhylogenyNode, String> found_nodes = new Hashtable<PhylogenyNode, String>();
            int i = 0;
            while (i < namelist.size()) {
                String seqname = (String)namelist.get(i);
                Hashtable nodes = this.atvpanel.getATVtreePanel().getTree().findInNameSpecECid(seqname);
                if (nodes != null && nodes.keys().hasMoreElements()) {
                    PhylogenyNode pn = (PhylogenyNode)nodes.keys().nextElement();
                    found_nodes.put(pn, "");
                }
                ++i;
            }
            this.atvpanel.atvtreepanel.setFoundNodes(found_nodes);
            this.contentpane.repaint();
        }
    }

    public void highlightSequences(Vector seq_list) {
        System.out.println("ATVframe.highlightSequences()");
        System.out.println("seq_list: " + seq_list + " has " + seq_list.size() + " members");
        Hashtable<PhylogenyNode, String> found_nodes = new Hashtable<PhylogenyNode, String>();
        Phylogeny tree = this.atvpanel.getATVtreePanel().getTree();
        if (tree != null) {
            if (seq_list != null && tree != null) {
                int i = 0;
                while (i < seq_list.size()) {
                    String seqname = (String)seq_list.get(i);
                    System.out.println("Found seq name " + seqname);
                    Hashtable nodes = tree.findInNameSpecECid(seqname);
                    if (nodes != null && nodes.keys().hasMoreElements()) {
                        PhylogenyNode pn = (PhylogenyNode)nodes.keys().nextElement();
                        System.out.println("Add node to highlight list");
                        found_nodes.put(pn, "");
                    }
                    ++i;
                }
                System.out.println("Set found nodes: " + found_nodes + " with " + found_nodes.size() + " nodes");
                this.atvpanel.atvtreepanel.setFoundNodes(found_nodes);
            } else {
                System.out.println("Clear list of found nodes");
                this.atvpanel.atvtreepanel.setFoundNodes(null);
            }
            this.contentpane.repaint();
        }
        System.out.println("All done with ATVframe.highlightSequences()");
    }

    protected void inferDups() {
        if (!this.isOKforSDI()) {
            return;
        }
        if (!this.atvpanel.getATVtreePanel().getTree().isRooted()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not rooted.", "Error during SDI", 0);
            return;
        }
        Phylogeny gene_tree = this.atvpanel.getATVtreePanel().getTree().copy();
        SDIse sdi = null;
        int duplications = -1;
        gene_tree.setAllNodesToNotCollapse();
        gene_tree.adjustNodeCount(false);
        Util.extractSpeciesNameFromSeqName(gene_tree);
        SDI.stripTree(this.species_tree_, gene_tree);
        if (!this.GAndSDoHaveMoreThanOneSpeciesInComman(gene_tree)) {
            return;
        }
        try {
            sdi = new SDIse(gene_tree, this.species_tree_.copy());
            duplications = ((SDI)sdi).infer(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Exception during SDI", 0);
        }
        String title = this.getTitle();
        if (title.indexOf(" [") > -1) {
            title = title.substring(0, title.indexOf(" ["));
        }
        if (duplications >= 0) {
            title = String.valueOf(title) + " [" + duplications + " duplications]";
        }
        this.setTitle(title);
        this.atvpanel.getATVtreePanel().setTree(gene_tree);
        this.showWhole();
        this.contentpane.repaint();
    }

    protected boolean isOKforSDI() {
        if (this.atvpanel.getATVtreePanel().getTree() == null || this.atvpanel.getATVtreePanel().getTree().isEmpty()) {
            return false;
        }
        if (this.species_tree_ == null || this.species_tree_.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No species tree loaded.", "Error during SDI", 0);
            return false;
        }
        if (!this.atvpanel.getATVtreePanel().getTree().isCompletelyBinary()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not completely binary.", "Error during SDI", 0);
            return false;
        }
        return true;
    }

    protected abstract void openURL();

    protected abstract void reLoad();

    protected void removeatvtextframe() {
        if (this.atvtextframe != null) {
            this.atvtextframe.close();
            this.atvtextframe = null;
        }
    }

    protected void removeRoot() {
        this.atvpanel.getATVtreePanel().removeRoot();
    }

    protected void removeRootTri() {
        this.atvpanel.getATVtreePanel().removeRootTri();
    }

    protected void rootMinDupsHeight() {
        if (!this.isOKforSDI()) {
            return;
        }
        Phylogeny gene_tree = this.atvpanel.getATVtreePanel().getTree().copy();
        SDIunrooted sdiunrooted = new SDIunrooted();
        gene_tree.setAllNodesToNotCollapse();
        gene_tree.adjustNodeCount(false);
        Util.extractSpeciesNameFromSeqName(gene_tree);
        SDI.stripTree(this.species_tree_, gene_tree);
        if (!this.GAndSDoHaveMoreThanOneSpeciesInComman(gene_tree)) {
            return;
        }
        try {
            gene_tree = sdiunrooted.infer(gene_tree, this.species_tree_, false, true, true, true, 1)[0];
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Exception during SDI", 0);
            return;
        }
        int duplications = sdiunrooted.getMinimalDuplications();
        String title = this.getTitle();
        if (title.indexOf(" [") > -1) {
            title = title.substring(0, title.indexOf(" ["));
        }
        if (duplications >= 0) {
            title = String.valueOf(title) + " [" + duplications + " duplications]";
        }
        this.setTitle(title);
        this.atvpanel.getATVtreePanel().setTree(gene_tree);
        this.showWhole();
        this.contentpane.repaint();
    }

    protected void rootMinHeight() {
        if (!this.isOKforSDI()) {
            return;
        }
        Phylogeny gene_tree = this.atvpanel.getATVtreePanel().getTree().copy();
        SDIunrooted sdiunrooted = new SDIunrooted();
        gene_tree.setAllNodesToNotCollapse();
        gene_tree.adjustNodeCount(false);
        Util.extractSpeciesNameFromSeqName(gene_tree);
        SDI.stripTree(this.species_tree_, gene_tree);
        if (!this.GAndSDoHaveMoreThanOneSpeciesInComman(gene_tree)) {
            return;
        }
        try {
            gene_tree = sdiunrooted.infer(gene_tree, this.species_tree_, false, false, true, true, 1)[0];
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Exception during SDI", 0);
            return;
        }
        int duplications = sdiunrooted.getMinimalDuplications();
        String title = this.getTitle();
        if (title.indexOf(" [") > -1) {
            title = title.substring(0, title.indexOf(" ["));
        }
        if (duplications >= 0) {
            title = String.valueOf(title) + " [" + duplications + " duplications]";
        }
        this.setTitle(title);
        this.atvpanel.getATVtreePanel().setTree(gene_tree);
        this.showWhole();
        this.contentpane.repaint();
    }

    protected void rootMinLHeight() {
        if (!this.isOKforSDI()) {
            return;
        }
        Phylogeny gene_tree = this.atvpanel.getATVtreePanel().getTree().copy();
        SDIunrooted sdiunrooted = new SDIunrooted();
        gene_tree.setAllNodesToNotCollapse();
        gene_tree.adjustNodeCount(false);
        Util.extractSpeciesNameFromSeqName(gene_tree);
        SDI.stripTree(this.species_tree_, gene_tree);
        if (!this.GAndSDoHaveMoreThanOneSpeciesInComman(gene_tree)) {
            return;
        }
        try {
            gene_tree = sdiunrooted.infer(gene_tree, this.species_tree_, true, false, true, true, 1)[0];
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Exception during SDI", 0);
            return;
        }
        int duplications = sdiunrooted.getMinimalDuplications();
        int L = sdiunrooted.getMinimalMappingCost();
        String title = this.getTitle();
        if (title.indexOf(" [") > -1) {
            title = title.substring(0, title.indexOf(" ["));
        }
        if (duplications >= 0 && L >= 0) {
            title = String.valueOf(title) + " [" + duplications + " duplications  L=" + L + "]";
        }
        this.setTitle(title);
        this.atvpanel.getATVtreePanel().setTree(gene_tree);
        this.showWhole();
        this.contentpane.repaint();
    }

    protected void setMaxOrtho(int m) {
        this.atvpanel.getATVtreePanel().setMaxOrtho(m);
    }

    public void showWhole() {
        this.atvpanel.getATVcontrol().showWhole();
    }

    protected void switchColors() {
        TreeColorSet colorset = this.atvpanel.getATVtreePanel().getTreeColorSet();
        ATVColorSchemeChooser csc = new ATVColorSchemeChooser((Frame)this, colorset);
        csc.setVisible(true);
        this.atvpanel.getATVtreePanel().setTreeColorSet(colorset);
    }

    protected void viewAsNH() {
        this.removeatvtextframe();
        if (this.atvpanel.getATVtreePanel().getTree() == null) {
            return;
        }
        if (this.atvpanel.getATVtreePanel().getTree().isEmpty()) {
            return;
        }
        this.atvtextframe = new ATVtextframe(this.atvpanel.getATVtreePanel().getTree().toNewHampshire(false));
    }

    protected void viewAsNHX() {
        this.removeatvtextframe();
        if (this.atvpanel.getATVtreePanel().getTree() == null) {
            return;
        }
        if (this.atvpanel.getATVtreePanel().getTree().isEmpty()) {
            return;
        }
        this.atvtextframe = new ATVtextframe(this.atvpanel.getATVtreePanel().getTree().toNewHampshireX());
    }

    protected void viewAsXML() {
        this.removeatvtextframe();
        if (this.atvpanel.getATVtreePanel().getTree() == null) {
            return;
        }
        if (this.atvpanel.getATVtreePanel().getTree().isEmpty()) {
            return;
        }
        this.atvtextframe = new ATVtextframe(this.atvpanel.getATVtreePanel().getTree().toPhyloXML(0));
    }
}

