/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.forester.atv.ATVeditNodeFrame;
import org.forester.atv.DoubleDocument;
import org.forester.atv.IntegerDocument;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.TagValueUnit;

class ATVeditNodePanel
extends JPanel
implements ActionListener {
    private Phylogeny tree;
    private PhylogenyNode node;
    private Hashtable nodes;
    private ATVeditNodeFrame atveditnodeframe;
    private boolean editable = false;
    private JLabel seq_name_label;
    private JLabel Species_label;
    private JLabel EC_label;
    private JLabel GO_label;
    private JLabel Distance_parent_label;
    private JLabel Bootstrap_label;
    private JLabel color_label;
    private JLabel width_label;
    private JLabel Sum_ext_nodes_label;
    private JLabel Sum_ext_nodes_tf;
    private JLabel taxo_id_label;
    private JLabel orthologous_label;
    private JLabel super_orthologous_label;
    private JLabel sn_label;
    private JLabel message_label;
    private JTextField Seq_name_tf;
    private JTextField Species_tf;
    private JTextField EC_tf;
    private JTextField GO_tf;
    private JTextField Distance_parent_tf;
    private JTextField taxo_id_tf;
    private JTextField Bootstrap_tf;
    private JTextField color_tf;
    private JTextField width_tf;
    private JTextField orthologous_tf;
    private JTextField super_orthologous_tf;
    private JTextField sn_tf;
    private JRadioButton Duplication_rb;
    private JRadioButton Speciation_rb;
    private JRadioButton NA_rb;
    private JPanel headerpanel;
    private JPanel messagepanel;
    private JPanel buttonjpanel;
    private JPanel radiobuttonjpanel;
    private ButtonGroup radiobuttongroup;
    private JButton cancel_button;
    private JButton reset_button;
    private JButton write_button;
    private JPanel standard_data;
    private JPanel custom_data;
    private Hashtable tvu_label_tags;
    private Hashtable tvu_textfield_values;
    private Hashtable tvu_textfield_units;
    private static final Font header_font = new Font("Helvetica", 1, 11);
    private static final Font label_font = new Font("Helvetica", 0, 10);
    private static final Font tf_font = new Font("Helvetica", 0, 10);
    private static final Font button_font = new Font("Helvetica", 0, 10);
    private static final Font message_font = new Font("Helvetica", 1, 10);
    private static final Color background_color = new Color(215, 215, 215);
    private static final Color label_text_color = new Color(0, 0, 0);
    private static final Color tf_text_color = new Color(0, 0, 0);
    private static final Color tf_background_color = new Color(250, 250, 250);
    private static final Color button_background_color = new Color(165, 165, 165);
    private static final Color button_text_color = new Color(0, 0, 0);
    private static final Color message_color = new Color(205, 0, 0);
    private static String header_str = "Set values for this node";
    private String message = " ";
    private static String badcolor_err = "Not a valid color string.<br>Color should be in the format, red, green, blue.<br>For example: '100,100,100'";
    private static String badbootstrap_err = "NumberFormatException in bootstrap value. ";
    private static String baddistance_err = "NumberFormatException in distance value. ";
    private static String badwidth_err = "NumberFormatException in branch width value. ";

    ATVeditNodePanel(Hashtable nodes, Phylogeny t, boolean editable, ATVeditNodeFrame anf) {
        this.nodes = nodes;
        this.tree = t;
        this.editable = editable;
        this.atveditnodeframe = anf;
        this.buildPanel();
    }

    ATVeditNodePanel(PhylogenyNode n, Phylogeny t, boolean editable, ATVeditNodeFrame anf) {
        this.node = n;
        this.tree = t;
        this.editable = editable;
        this.atveditnodeframe = anf;
        this.buildPanel();
    }

    private void buildPanel() {
        this.setSize(this.atveditnodeframe.getSize());
        this.setPreferredSize(this.atveditnodeframe.getSize());
        int width = this.atveditnodeframe.getWidth();
        this.setBackground(background_color);
        this.setLayout(new BoxLayout(this, 1));
        this.headerpanel = new JPanel();
        this.standard_data = new JPanel();
        this.custom_data = new JPanel();
        this.radiobuttonjpanel = new JPanel();
        this.messagepanel = new JPanel();
        this.buttonjpanel = new JPanel();
        this.add(this.headerpanel);
        this.add(this.standard_data);
        this.add(this.custom_data);
        this.add(this.radiobuttonjpanel);
        this.add(this.messagepanel);
        this.add(this.buttonjpanel);
        JLabel header = new JLabel(header_str);
        header.setFont(header_font);
        this.headerpanel.add(header);
        this.standard_data.setLayout(new GridLayout(0, 2, 3, 0));
        this.addStandardFields();
        if (this.node != null && !this.node.isExternal()) {
            this.addRadioButtons();
        }
        if (this.node != null) {
            this.addCustomFields();
        }
        this.message_label = new JLabel(" ");
        this.message_label.setFont(message_font);
        this.message_label.setForeground(message_color);
        this.messagepanel.add(this.message_label);
        this.addButtons();
        this.reset();
        this.revalidate();
        this.setSize(this.getPreferredSize());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancel_button) {
            this.close();
        } else {
            if (this.editable && e.getSource() == this.reset_button) {
                this.reset();
                this.atveditnodeframe.getATVtreePanel().repaint();
            }
            if (this.editable && e.getSource() == this.write_button) {
                this.writeToTree();
                if (this.message.length() == 0) {
                    this.atveditnodeframe.getATVtreePanel().repaint();
                    this.close();
                }
            }
        }
    }

    private void addButtons() {
        this.buttonjpanel.setLayout(new FlowLayout());
        this.buttonjpanel.setBackground(background_color);
        if (this.editable) {
            this.write_button = new JButton("OK");
            this.write_button.setFont(button_font);
            this.write_button.setForeground(button_text_color);
            this.write_button.setBackground(background_color);
            this.write_button.setToolTipText("Write the values for this node to the tree");
            this.write_button.addActionListener(this);
            this.buttonjpanel.add(this.write_button);
            this.reset_button = new JButton("Reset");
            this.reset_button.setFont(button_font);
            this.reset_button.setForeground(button_text_color);
            this.reset_button.setBackground(background_color);
            this.reset_button.setToolTipText("Read values for this node from tree");
            this.reset_button.addActionListener(this);
            this.buttonjpanel.add(this.reset_button);
            this.cancel_button = new JButton("Cancel");
            this.cancel_button.setFont(button_font);
            this.cancel_button.setForeground(button_text_color);
            this.cancel_button.setBackground(background_color);
            this.cancel_button.addActionListener(this);
            this.buttonjpanel.add(this.cancel_button);
        } else {
            this.cancel_button = new JButton("Close");
            this.cancel_button.setFont(button_font);
            this.cancel_button.setForeground(button_text_color);
            this.cancel_button.setBackground(background_color);
            this.cancel_button.addActionListener(this);
            this.buttonjpanel.add(this.cancel_button);
        }
    }

    private void addCustomFields() {
        TagValueUnit[] tvus = this.node.getCustomTagValueUnitsAsArray();
        Hashtable tvu_hash = this.tree.getCustomTagNames();
        Enumeration keys = tvu_hash.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            tvu_hash.put(key, new TagValueUnit(key, "", ""));
        }
        if (tvu_hash.size() > 0) {
            this.custom_data.setLayout(new GridLayout(tvu_hash.size() + 1, 3, 3, 0));
            this.custom_data.setBorder(BorderFactory.createTitledBorder("Custom Data"));
            ((TitledBorder)this.custom_data.getBorder()).setTitleFont(new Font("Sans Serif", 0, 9));
            JLabel h1 = new JLabel("Name  ");
            h1.setFont(message_font);
            h1.setHorizontalAlignment(4);
            this.custom_data.add(h1);
            JLabel h2 = new JLabel("  Value");
            h2.setFont(message_font);
            this.custom_data.add(h2);
            JLabel h3 = new JLabel("  Unit");
            h3.setFont(message_font);
            this.custom_data.add(h3);
            this.tvu_label_tags = new Hashtable();
            this.tvu_textfield_values = new Hashtable();
            this.tvu_textfield_units = new Hashtable();
            int i = 0;
            while (i < tvus.length) {
                tvu_hash.put(tvus[i].getTag(), tvus[i]);
                ++i;
            }
            Enumeration keys2 = tvu_hash.keys();
            while (keys2.hasMoreElements()) {
                String key = (String)keys2.nextElement();
                TagValueUnit tvu = (TagValueUnit)tvu_hash.get(key);
                JLabel tag = new JLabel(key);
                JTextField value = new JTextField(14);
                JTextField unit = new JTextField(4);
                this.tvu_label_tags.put(key, tag);
                this.tvu_textfield_values.put(key, value);
                this.tvu_textfield_units.put(key, unit);
                this.addJTFforValue(tag, value, unit);
            }
        }
    }

    private void addJLabel(JLabel jl) {
        jl.setFont(label_font);
        jl.setForeground(label_text_color);
        jl.setHorizontalAlignment(4);
        this.standard_data.add(jl);
    }

    private void addJTF(JTextField jtf) {
        jtf.setMinimumSize(jtf.getPreferredSize());
        jtf.setFont(tf_font);
        jtf.setForeground(tf_text_color);
        jtf.setBackground(tf_background_color);
        jtf.setEditable(this.editable);
        this.standard_data.add(jtf);
    }

    private void addJTFforValue(JLabel tag, JTextField value, JTextField unit) {
        tag.setFont(label_font);
        tag.setForeground(label_text_color);
        tag.setHorizontalAlignment(4);
        value.setFont(tf_font);
        value.setForeground(tf_text_color);
        value.setBackground(tf_background_color);
        value.setEditable(this.editable);
        unit.setFont(tf_font);
        unit.setForeground(tf_text_color);
        unit.setBackground(tf_background_color);
        unit.setEditable(this.editable);
        this.custom_data.add(tag);
        this.custom_data.add(value);
        this.custom_data.add(unit);
    }

    private void addRadioButtons() {
        this.radiobuttongroup = new ButtonGroup();
        this.radiobuttonjpanel.setLayout(new GridLayout(1, 3, 0, 0));
        this.radiobuttonjpanel.setBackground(background_color);
        this.Duplication_rb = new JRadioButton("duplication");
        this.Speciation_rb = new JRadioButton("speciation");
        this.NA_rb = new JRadioButton("not assigned");
        this.radiobuttongroup.add(this.Duplication_rb);
        this.radiobuttongroup.add(this.Speciation_rb);
        this.radiobuttongroup.add(this.NA_rb);
        this.Duplication_rb.setEnabled(this.editable);
        this.Duplication_rb.setFont(label_font);
        this.Duplication_rb.setForeground(label_text_color);
        this.Duplication_rb.setBackground(background_color);
        this.radiobuttonjpanel.add(this.Duplication_rb);
        this.Speciation_rb.setEnabled(this.editable);
        this.Speciation_rb.setFont(label_font);
        this.Speciation_rb.setForeground(label_text_color);
        this.Speciation_rb.setBackground(background_color);
        this.radiobuttonjpanel.add(this.Speciation_rb);
        this.NA_rb.setEnabled(this.editable);
        this.NA_rb.setFont(label_font);
        this.NA_rb.setForeground(label_text_color);
        this.NA_rb.setBackground(background_color);
        this.radiobuttonjpanel.add(this.NA_rb);
    }

    private void addStandardFields() {
        if (this.node != null) {
            this.seq_name_label = new JLabel("seq name");
            this.addJLabel(this.seq_name_label);
            this.Seq_name_tf = new JTextField(25);
            this.addJTF(this.Seq_name_tf);
        }
        this.Species_label = new JLabel("species");
        this.addJLabel(this.Species_label);
        this.Species_tf = new JTextField(25);
        this.addJTF(this.Species_tf);
        this.taxo_id_label = new JLabel("taxonomy ID");
        this.addJLabel(this.taxo_id_label);
        this.taxo_id_tf = new JTextField(25);
        this.taxo_id_tf.setDocument(new IntegerDocument());
        this.addJTF(this.taxo_id_tf);
        if (this.node != null) {
            this.EC_label = new JLabel("EC number");
            this.addJLabel(this.EC_label);
            this.EC_tf = new JTextField(25);
            this.addJTF(this.EC_tf);
        }
        this.GO_label = new JLabel("GO term (term or ID)");
        this.addJLabel(this.GO_label);
        this.GO_tf = new JTextField(25);
        this.addJTF(this.GO_tf);
        if (this.node != null) {
            this.Distance_parent_label = new JLabel("distance to parent");
            this.addJLabel(this.Distance_parent_label);
            this.Distance_parent_tf = new JTextField(25);
            this.Distance_parent_tf.setDocument(new DoubleDocument());
            this.addJTF(this.Distance_parent_tf);
        }
        if (this.node != null && !this.node.isExternal()) {
            this.Bootstrap_label = new JLabel("bootstrap value");
            this.addJLabel(this.Bootstrap_label);
            this.Bootstrap_tf = new JTextField(25);
            this.Bootstrap_tf.setDocument(new IntegerDocument());
            this.addJTF(this.Bootstrap_tf);
        }
        if (this.node != null && this.node.isExternal()) {
            if (this.node.getOrthologous() != -99) {
                this.orthologous_label = new JLabel("orthologous to query");
                this.addJLabel(this.orthologous_label);
                this.orthologous_tf = new JTextField(25);
                this.orthologous_tf.setDocument(new IntegerDocument());
                this.addJTF(this.orthologous_tf);
                this.orthologous_tf.setEnabled(false);
            }
            if (this.node.getSubtreeNeighborings() != -99) {
                this.sn_label = new JLabel("subtr-neighb to query");
                this.addJLabel(this.sn_label);
                this.sn_tf = new JTextField(25);
                this.sn_tf.setDocument(new IntegerDocument());
                this.addJTF(this.sn_tf);
                this.sn_tf.setEnabled(false);
            }
            if (this.node.getSuperOrthologous() != -99) {
                this.super_orthologous_label = new JLabel("s-orthologous to query");
                this.addJLabel(this.super_orthologous_label);
                this.super_orthologous_tf = new JTextField(25);
                this.super_orthologous_tf.setDocument(new IntegerDocument());
                this.addJTF(this.super_orthologous_tf);
                this.super_orthologous_tf.setEnabled(false);
            }
        }
        this.color_label = new JLabel("color of parent branch (r, g, b)");
        this.addJLabel(this.color_label);
        this.color_tf = new JTextField(25);
        this.addJTF(this.color_tf);
        this.width_label = new JLabel("width of parent branch");
        this.addJLabel(this.width_label);
        this.width_tf = new JTextField(25);
        this.addJTF(this.width_tf);
        if (this.node != null && !this.node.isExternal()) {
            this.Sum_ext_nodes_label = new JLabel("sum of ext nodes");
            this.addJLabel(this.Sum_ext_nodes_label);
            this.Sum_ext_nodes_tf = new JLabel("25");
            this.addJLabel(this.Sum_ext_nodes_tf);
            this.Sum_ext_nodes_tf.setHorizontalAlignment(2);
        }
    }

    void reset() {
        if (this.nodes != null) {
            this.resetMultiple();
        } else if (this.node != null) {
            this.resetSingle();
        }
    }

    void resetMultiple() {
        String species = null;
        String taxonomy = null;
        String go = null;
        String br_color_str = null;
        String br_width = null;
        Enumeration e = this.nodes.keys();
        while (e.hasMoreElements()) {
            PhylogenyNode n = (PhylogenyNode)e.nextElement();
            String s = n.getTaxonomy();
            if (species == null) {
                species = s;
            } else if (!species.equals(s)) {
                species = "-";
            }
            String t = n.getTaxonomyID();
            if (taxonomy == null) {
                taxonomy = t;
            } else if (!taxonomy.equals(t)) {
                taxonomy = "-";
            }
            String g = "not implemented";
            if (go == null) {
                go = g;
            } else if (!g.equalsIgnoreCase(go)) {
                go = "-";
            }
            Color c = null;
            if (n.isParentBranchColorAssigned()) {
                c = n.getColor();
            }
            String color_str = "";
            if (c != null) {
                color_str = c.getRed() + "," + c.getGreen() + "," + c.getBlue();
            }
            if (br_color_str == null) {
                br_color_str = color_str;
            } else if (!br_color_str.equalsIgnoreCase(color_str)) {
                br_color_str = "-";
            }
            String w = "";
            if (n.isParentBranchWidthAssigned()) {
                w = "" + n.getParentBranchWidth();
            }
            if (br_width == null) {
                br_width = w;
                continue;
            }
            if (br_width.equalsIgnoreCase(w)) continue;
            br_width = "-";
        }
        if (species != null && species.length() > 0) {
            this.Species_tf.setText(species);
        }
        if (taxonomy != null && taxonomy.length() > 0) {
            this.taxo_id_tf.setText(taxonomy);
        }
        if (go != null && go.length() > 0) {
            this.GO_tf.setText(go);
        }
        if (br_color_str != null && br_color_str.length() > 0) {
            this.color_tf.setText(br_color_str);
        }
        if (br_width != null && br_width.length() > 0) {
            this.width_tf.setText(br_width);
        }
    }

    void resetSingle() {
        this.message_label.setText(" ");
        this.message = "";
        if (!this.node.isPseudoNode()) {
            this.Seq_name_tf.setText(this.node.getSeqName());
        } else {
            this.Seq_name_tf.setText("*pseudo node*");
        }
        this.Species_tf.setText(this.node.getTaxonomy());
        this.taxo_id_tf.setText(this.node.getTaxonomyID());
        this.EC_tf.setText(this.node.getECnumber());
        this.GO_tf.setText("not implemented");
        if (!this.node.isPseudoNode() && this.node.getDistanceToParent() != -99.0) {
            this.Distance_parent_tf.setText("" + this.node.getDistanceToParent());
        } else {
            this.Distance_parent_tf.setText("");
        }
        if (this.node.isParentBranchColorAssigned()) {
            Color c = this.node.getColor();
            String s = c.toString();
            this.color_tf.setText(c.getRed() + "," + c.getGreen() + "," + c.getBlue());
        }
        if (this.node.isParentBranchWidthAssigned()) {
            this.width_tf.setText("" + this.node.getParentBranchWidth());
        }
        if (!this.node.isExternal()) {
            if (this.node.getBootstrap() != -99.0) {
                this.Bootstrap_tf.setText("" + this.node.getBootstrap());
            } else {
                this.Bootstrap_tf.setText("");
            }
            this.Sum_ext_nodes_tf.setText("" + this.node.getSumExtNodes());
            if (!this.node.isDuplicationOrSpecAssigned()) {
                this.NA_rb.setSelected(true);
            } else if (this.node.isDuplication()) {
                this.Duplication_rb.setSelected(true);
            } else {
                this.Speciation_rb.setSelected(true);
            }
        }
        if (this.node.isExternal()) {
            if (this.node.getOrthologous() != -99 && this.node.getOrthologous() != -11) {
                this.orthologous_tf.setText("" + this.node.getOrthologous());
            }
            if (this.node.getSuperOrthologous() != -99 && this.node.getSuperOrthologous() != -11) {
                this.super_orthologous_tf.setText("" + this.node.getSuperOrthologous());
            }
            if (this.node.getSubtreeNeighborings() != -99 && this.node.getSubtreeNeighborings() != -11) {
                this.sn_tf.setText("" + this.node.getSubtreeNeighborings());
            }
        }
        TagValueUnit[] tvua = this.node.getCustomTagValueUnitsAsArray();
        int i = 0;
        while (i < tvua.length) {
            JTextField value = (JTextField)this.tvu_textfield_values.get(tvua[i].getTag());
            JTextField unit = (JTextField)this.tvu_textfield_units.get(tvua[i].getTag());
            value.setText(tvua[i].getValue().toString());
            unit.setText(tvua[i].getUnit());
            ++i;
        }
    }

    void writeToTree() {
        if (this.nodes != null) {
            this.writeMultiple();
        } else {
            this.writeSingle();
        }
    }

    void writeMultiple() {
        this.message = "";
        this.message_label.setText(" ");
        String species = this.Species_tf.getText();
        String taxonomy = this.taxo_id_tf.getText();
        String go = this.GO_tf.getText();
        String br_color_str = this.color_tf.getText();
        String br_width_str = this.width_tf.getText();
        Color br_color = null;
        if (br_color_str.length() > 0 && !br_color_str.equals("-")) {
            StringTokenizer st = new StringTokenizer(br_color_str, ",");
            if (st.countTokens() == 3) {
                try {
                    int r = Integer.parseInt(st.nextToken());
                    int g = Integer.parseInt(st.nextToken());
                    int b = Integer.parseInt(st.nextToken());
                    br_color = new Color(r, g, b);
                }
                catch (Exception e) {
                    this.message = String.valueOf(this.message) + badcolor_err;
                }
            } else {
                this.message = String.valueOf(this.message) + badcolor_err;
            }
        }
        int br_width = 0;
        if (br_width_str.length() > 0) {
            try {
                br_width = Integer.parseInt(br_width_str);
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + badwidth_err;
            }
        }
        Enumeration keys = this.nodes.keys();
        while (this.message.length() == 0 && keys.hasMoreElements()) {
            PhylogenyNode n = (PhylogenyNode)keys.nextElement();
            if (species.length() > 0 && !species.equals("-")) {
                n.setTaxonomy(species);
            }
            if (taxonomy.length() > 0 && !taxonomy.equals("-")) {
                n.setTaxonomyID(taxonomy);
            }
            if (go.length() > 0) {
                go.equals("-");
            }
            if (br_color != null) {
                n.setColor(br_color);
            }
            if (br_width <= 0) continue;
            n.setParentBranchWidth(br_width);
        }
        if (this.message.length() > 1) {
            Toolkit.getDefaultToolkit().beep();
            this.message_label.setText("<html>" + this.message + "</html>");
        } else {
            this.reset();
        }
    }

    void writeSingle() {
        boolean exception = false;
        double d = 0.0;
        int i = 0;
        this.message = "";
        this.message_label.setText(" ");
        this.node.setSeqName(this.replaceInappropriateChars(this.Seq_name_tf.getText().trim()));
        this.node.setTaxonomy(this.replaceInappropriateChars(this.Species_tf.getText().trim()));
        this.node.setECnumber(this.replaceInappropriateChars(this.EC_tf.getText().trim()));
        this.node.setTaxonomyID(this.replaceInappropriateChars(this.taxo_id_tf.getText().trim()));
        if (this.Distance_parent_tf.getText().trim().length() > 0) {
            exception = false;
            try {
                d = Double.valueOf(this.Distance_parent_tf.getText().trim());
                if (d < 0.0) {
                    d = 0.0;
                }
            }
            catch (NumberFormatException e) {
                exception = true;
                this.message = baddistance_err;
            }
            if (!exception) {
                this.node.setDistanceToParent(d);
            }
        } else {
            this.node.setDistanceToParent(-99.0);
        }
        if (this.color_tf.getText().trim().length() > 0) {
            String s = this.color_tf.getText();
            StringTokenizer st = new StringTokenizer(s, ",");
            if (st.countTokens() == 3) {
                try {
                    int r = Integer.parseInt(st.nextToken());
                    int g = Integer.parseInt(st.nextToken());
                    int b = Integer.parseInt(st.nextToken());
                    Color c = new Color(r, g, b);
                    this.node.setColor(c);
                }
                catch (Exception e) {
                    this.message = String.valueOf(this.message) + badcolor_err;
                }
            } else {
                this.message = String.valueOf(this.message) + badcolor_err;
            }
        }
        if (this.width_tf.getText().trim().length() > 0) {
            try {
                int w = Integer.parseInt(this.width_tf.getText());
                this.node.setParentBranchWidth(w);
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + badwidth_err;
            }
        }
        if (!this.node.isExternal()) {
            if (this.Bootstrap_tf.getText().trim().length() > 0) {
                exception = false;
                try {
                    i = Integer.parseInt(this.Bootstrap_tf.getText().trim());
                }
                catch (NumberFormatException e) {
                    exception = true;
                    this.message = badbootstrap_err;
                }
                if (!exception) {
                    this.node.setBootstrap(i);
                }
            } else {
                this.node.setBootstrap(-99.0);
            }
            if (this.Duplication_rb.isSelected()) {
                this.node.setDuplication(true);
            } else if (this.Speciation_rb.isSelected()) {
                this.node.setDuplication(false);
            } else {
                this.node.setDuplicationOrSpecAssigned(false);
            }
        }
        if (this.message.length() > 1) {
            Toolkit.getDefaultToolkit().beep();
            this.message_label.setText("<html>" + this.message + "</html>");
        } else {
            this.reset();
        }
    }

    void close() {
        this.atveditnodeframe.remove();
        this.atveditnodeframe.dispose();
        this.atveditnodeframe = null;
    }

    private String replaceInappropriateChars(String s) {
        s = s.replace('[', '{');
        s = s.replace(']', '}');
        s = s.replace('(', '{');
        s = s.replace(')', '}');
        s = s.replace(':', '*');
        s = s.replace(',', '|');
        s = s.replace(' ', '_');
        return s;
    }
}

