/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.forester.atv.ATVConfig;
import org.forester.atv.ATVconstants;
import org.forester.atv.ATVpanel;
import org.forester.atv.ATVtreePanel;
import org.forester.atv.QuickHelpFrame;
import org.forester.phylogeny.Phylogeny;

class ATVcontrol
extends JPanel
implements ActionListener {
    ATVtreePanel atvtreepanel;
    ATVpanel atvpanel;
    ATVConfig config_settings;
    JCheckBox userealbl;
    JCheckBox seqnameextnodes;
    JCheckBox seqnameintnodes;
    JCheckBox speciesextnodes;
    JCheckBox speciesintnodes;
    JCheckBox ecintnodes;
    JCheckBox ecextnodes;
    JCheckBox write_b_l;
    JCheckBox writebootstrap;
    JCheckBox write_d_s;
    JCheckBox color_orthos;
    JCheckBox color_super_orthos;
    JCheckBox color_s_n;
    JCheckBox color_acc_species;
    JCheckBox editable;
    JCheckBox color_branches;
    JCheckBox width_branches;
    JCheckBox mark_nodes_with_box;
    JButton userealbl_help;
    JButton seqnameextnodes_help;
    JButton seqnameintnodes_help;
    JButton speciesextnodes_help;
    JButton speciesintnodes_help;
    JButton ecintnodes_help;
    JButton ecextnodes_help;
    JButton writebl_help;
    JButton writebootstrap_help;
    JButton writed_s_help;
    JButton color_orthos_help;
    JButton color_super_orthos_help;
    JButton color_sn_help;
    JButton color_acc_species_help;
    JButton editable_help;
    JButton color_branches_help;
    JButton width_branches_help;
    JButton mark_nodes_with_box_help;
    JButton custom_data_btn;
    JPopupMenu custom_data_menu;
    Hashtable custom_tags = new Hashtable();
    boolean multiselect = false;
    JLabel click_to;
    JComboBox click_to_list;
    Hashtable all_click_to_names;
    Vector single_click_to_names;
    Vector multiple_click_to_names;
    int edit_cb_item;
    int collapse_cb_item;
    int reroot_cb_item;
    int swap_cb_item;
    int subtree_cb_item;
    int display_node_sequences_cb_item;
    int display_node_glyph_info_cb_item;
    int go_to_swissprot_cb_item;
    int display_node_popup_cb_item;
    int display_glyph_popup_cb_item;
    int custom_option_cb_item;
    int num_click_to_opts;
    int num_mult_click_to_opts;
    JButton zoom_in_x;
    JButton zoom_in_y;
    JButton zoom_out_x;
    JButton zoom_out_y;
    JButton show_whole;
    JButton order;
    JButton uncollapse_all;
    JButton collapse_to_deepest_annot;
    JButton reload_tree;
    boolean order_of_appearance;
    static final Font jcb_font = new Font("Helvetica", 0, 10);
    static final Font js_font = new Font("Helvetica", 0, 9);
    static final Font jcb_bold_font = new Font("Helvetica", 1, 10);
    static Color background_color;
    static Color jcb_text_color;
    static Color jcb_background_color;
    static Color button_text_color;
    static Color button_background_color;

    ATVcontrol() {
    }

    ATVcontrol(ATVpanel ap, ATVtreePanel atp, ATVConfig config_settings) {
        this.atvpanel = ap;
        this.atvtreepanel = atp;
        this.config_settings = config_settings;
        this.setDefaultColors();
        this.setBackground(background_color);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.setLayout(new GridLayout(0, 1, 2, 2));
        this.order_of_appearance = true;
        this.setupControls();
    }

    public void actionPerformed(ActionEvent e) {
        ATVtreePanel tp = this.atvtreepanel;
        if (e.getSource() == this.click_to_list) {
            this.setClickToAction(this.click_to_list.getSelectedIndex());
        } else if (e.getSource() == this.color_orthos) {
            this.setCheckbox(this.color_super_orthos, false);
            this.setCheckbox(this.color_s_n, false);
        } else if (e.getSource() == this.color_super_orthos) {
            this.setCheckbox(this.color_orthos, false);
            this.setCheckbox(this.color_s_n, false);
        } else if (e.getSource() == this.color_s_n) {
            this.setCheckbox(this.color_orthos, false);
            this.setCheckbox(this.color_super_orthos, false);
        } else if (tp.getTree() != null) {
            if (e.getSource() == this.userealbl) {
                this.showWhole();
            }
            if (e.getSource() == this.custom_data_btn) {
                this.custom_data_menu.show(this, this.custom_data_btn.getX(), this.custom_data_btn.getY());
            } else if (e.getSource() == this.zoom_in_x) {
                this.atvtreepanel.setXdistance((int)(this.atvtreepanel.getXdistance() * 1.05) + 1);
                this.atvtreepanel.setXcorrectionFactor(this.atvtreepanel.getXcorrectionFactor() * 1.1);
                this.atvtreepanel.resetPreferredSize();
            } else if (e.getSource() == this.zoom_in_y) {
                this.atvtreepanel.setYdistance((int)(this.atvtreepanel.getYdistance() * 1.05) + 1);
                this.atvtreepanel.resetPreferredSize();
            } else if (e.getSource() == this.zoom_out_x) {
                this.atvtreepanel.setXdistance((int)(this.atvtreepanel.getXdistance() * 0.95));
                this.atvtreepanel.setXcorrectionFactor(this.atvtreepanel.getXcorrectionFactor() * 0.9);
                this.atvtreepanel.resetPreferredSize();
            } else if (e.getSource() == this.zoom_out_y) {
                this.atvtreepanel.setYdistance((int)(this.atvtreepanel.getYdistance() * 0.95));
                this.atvtreepanel.resetPreferredSize();
            } else if (e.getSource() == this.show_whole) {
                this.showWhole();
            } else if (e.getSource() == this.order) {
                tp.getTree().orderAppearance(this.order_of_appearance);
                this.order_of_appearance = !this.order_of_appearance;
            } else if (e.getSource() == this.uncollapse_all) {
                this.uncollapseAll(tp);
            } else if (e.getSource() == this.collapse_to_deepest_annot) {
                this.collapseToDeepestAnnot(tp);
            } else if (e.getSource() == this.reload_tree) {
                this.reloadTree();
            } else if (e.getSource() == this.userealbl_help) {
                this.showHelp("userealbl", this.userealbl.getText());
            } else if (e.getSource() == this.writebl_help) {
                this.showHelp("writebl", this.write_b_l.getText());
            } else if (e.getSource() == this.color_branches_help) {
                this.showHelp("color_branches", this.color_branches.getText());
            } else if (e.getSource() == this.width_branches_help) {
                this.showHelp("width_branches", this.width_branches.getText());
            } else if (e.getSource() == this.seqnameextnodes_help) {
                this.showHelp("seqnameextnodes", this.seqnameextnodes.getText());
            } else if (e.getSource() == this.seqnameintnodes_help) {
                this.showHelp("seqnameintnodes", this.seqnameintnodes.getText());
            } else if (e.getSource() == this.speciesextnodes_help) {
                this.showHelp("speciesextnodes", this.speciesextnodes.getText());
            } else if (e.getSource() == this.speciesintnodes_help) {
                this.showHelp("speciesintnodes", this.speciesintnodes.getText());
            } else if (e.getSource() == this.ecintnodes_help) {
                this.showHelp("ecintnodes", this.ecintnodes.getText());
            } else if (e.getSource() == this.ecextnodes_help) {
                this.showHelp("ecextnodes", this.ecextnodes.getText());
            } else if (e.getSource() == this.writebootstrap_help) {
                this.showHelp("ecextnodes", this.writebootstrap.getText());
            } else if (e.getSource() == this.writed_s_help) {
                this.showHelp("writed_s", this.write_d_s.getText());
            } else if (e.getSource() == this.color_orthos_help) {
                this.showHelp("ecextnodes", this.color_orthos.getText());
            } else if (e.getSource() == this.color_super_orthos_help) {
                this.showHelp("color_super_orthos", this.color_super_orthos.getText());
            } else if (e.getSource() == this.color_sn_help) {
                this.showHelp("color_sn", this.color_s_n.getText());
            } else if (e.getSource() == this.color_acc_species_help) {
                this.showHelp("color_acc_species", this.color_acc_species.getText());
            } else if (e.getSource() == this.editable_help) {
                this.showHelp("ecexteditablenodes", this.editable.getText());
            } else if (e.getSource() == this.mark_nodes_with_box_help) {
                this.showHelp("mark_nodes_with_box", this.mark_nodes_with_box.getText());
            }
            this.atvpanel.adjustJScrollPane();
            this.atvtreepanel.repaint();
        }
    }

    protected void addCheckbox(int which, String title) {
        JPanel ch_panel = new JPanel(new BorderLayout(0, 0));
        switch (which) {
            case 0: {
                this.userealbl = new JCheckBox(title);
                this.userealbl_help = new JButton("?");
                this.addJCB(this.userealbl, this.userealbl_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 13: {
                this.color_acc_species = new JCheckBox(title);
                this.color_acc_species_help = new JButton("?");
                this.addJCB(this.color_acc_species, this.color_acc_species_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 2: {
                this.seqnameextnodes = new JCheckBox(title);
                this.seqnameextnodes_help = new JButton("?");
                this.addJCB(this.seqnameextnodes, this.seqnameextnodes_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 1: {
                this.seqnameintnodes = new JCheckBox(title);
                this.seqnameintnodes_help = new JButton("?");
                this.addJCB(this.seqnameintnodes, this.seqnameintnodes_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 4: {
                this.speciesextnodes = new JCheckBox(title);
                this.speciesextnodes_help = new JButton("?");
                this.addJCB(this.speciesextnodes, this.speciesextnodes_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 3: {
                this.speciesintnodes = new JCheckBox(title);
                this.speciesintnodes_help = new JButton("?");
                this.addJCB(this.speciesintnodes, this.speciesintnodes_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 6: {
                this.ecextnodes = new JCheckBox(title);
                this.ecextnodes_help = new JButton("?");
                this.addJCB(this.ecextnodes, this.ecextnodes_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 5: {
                this.ecintnodes = new JCheckBox(title);
                this.ecintnodes_help = new JButton("?");
                this.addJCB(this.ecintnodes, this.ecintnodes_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 7: {
                this.write_b_l = new JCheckBox(title);
                this.writebl_help = new JButton("?");
                this.addJCB(this.write_b_l, this.writebl_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 8: {
                this.writebootstrap = new JCheckBox(title);
                this.writebootstrap_help = new JButton("?");
                this.addJCB(this.writebootstrap, this.writebootstrap_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 9: {
                this.write_d_s = new JCheckBox(title);
                this.writed_s_help = new JButton("?");
                this.addJCB(this.write_d_s, this.writed_s_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 14: {
                this.color_branches = new JCheckBox(title);
                this.color_branches_help = new JButton("?");
                this.addJCB(this.color_branches, this.color_branches_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 15: {
                this.width_branches = new JCheckBox(title);
                this.width_branches_help = new JButton("?");
                this.addJCB(this.width_branches, this.width_branches_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 10: {
                this.color_orthos = new JCheckBox(title);
                this.color_orthos_help = new JButton("?");
                this.addJCB(this.color_orthos, this.color_orthos_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 11: {
                this.color_super_orthos = new JCheckBox(title);
                this.color_super_orthos_help = new JButton("?");
                this.addJCB(this.color_super_orthos, this.color_super_orthos_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 12: {
                this.color_s_n = new JCheckBox(title);
                this.color_sn_help = new JButton("?");
                this.addJCB(this.color_s_n, this.color_sn_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 16: {
                this.mark_nodes_with_box = new JCheckBox(title);
                this.mark_nodes_with_box_help = new JButton("?");
                this.addJCB(this.mark_nodes_with_box, this.mark_nodes_with_box_help, ch_panel);
                this.add(ch_panel);
                break;
            }
            default: {
                System.out.println("Unknown checkbox: " + which);
            }
        }
    }

    private void addClickToOption(int which, String title) {
        this.click_to_list.addItem(title);
        this.single_click_to_names.add(title);
        this.all_click_to_names.put(new Integer(which), title);
    }

    protected void addCustomControls() {
        this.custom_data_btn = new JButton("Show Custom Data");
        this.addJB(this.custom_data_btn, this);
        this.custom_data_btn.setEnabled(false);
        this.custom_data_menu = new JPopupMenu();
        ActionListener customMenuItemListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)e.getSource();
                String cmd = cbmi.getActionCommand();
                ATVcontrol.this.custom_tags.put(cmd, new Boolean(cbmi.isSelected()));
                ATVcontrol.this.atvpanel.adjustJScrollPane();
                ATVcontrol.this.atvtreepanel.repaint();
            }
        };
        Phylogeny tree = this.atvtreepanel.getTree();
        if (tree != null && !tree.isEmpty() && tree.getCustomTagNames() != null && tree.getCustomTagNames().size() > 0) {
            this.custom_data_btn.setEnabled(true);
            Enumeration e = tree.getCustomTagNames().keys();
            while (e.hasMoreElements()) {
                String tag_name = (String)e.nextElement();
                JCheckBoxMenuItem custom_item = new JCheckBoxMenuItem(tag_name);
                custom_item.addActionListener(customMenuItemListener);
                this.custom_data_menu.add(custom_item);
            }
        }
    }

    protected void addJB(JButton jb, JPanel p) {
        jb.setBorder(BorderFactory.createRaisedBevelBorder());
        jb.setBackground(button_background_color);
        jb.setForeground(button_text_color);
        jb.setFont(jcb_font);
        p.add(jb);
        jb.addActionListener(this);
    }

    protected void addJCB(JCheckBox jcb, JButton b, JPanel p) {
        jcb.setBackground(jcb_background_color);
        jcb.setForeground(jcb_text_color);
        jcb.setFont(jcb_font);
        p.add((Component)jcb, "Center");
        b.setMargin(new Insets(1, 1, 1, 1));
        b.addActionListener(this);
        b.setBounds(0, 0, 20, 20);
        b.setSize(new Dimension(20, 20));
        b.setPreferredSize(new Dimension(20, 20));
        b.setMinimumSize(new Dimension(20, 20));
        b.setMaximumSize(new Dimension(20, 20));
        p.add((Component)b, "East");
        jcb.addActionListener(this);
    }

    protected void addButtons() {
        JLabel spacer = new JLabel("");
        spacer.setOpaque(false);
        spacer.setFont(jcb_font);
        this.add(spacer);
        JPanel x_panel = new JPanel(new GridLayout(1, 2, 0, 0));
        JPanel y_panel = new JPanel(new GridLayout(1, 2, 0, 0));
        x_panel.setBackground(this.getBackground());
        y_panel.setBackground(this.getBackground());
        this.add(x_panel);
        this.add(y_panel);
        this.zoom_in_x = new JButton("zoom in X");
        this.zoom_in_y = new JButton("zoom in Y");
        this.zoom_out_x = new JButton("zoom out X");
        this.zoom_out_y = new JButton("zoom out Y");
        this.show_whole = new JButton("show whole");
        this.order = new JButton("order subtrees");
        this.uncollapse_all = new JButton("uncollapse all");
        this.collapse_to_deepest_annot = new JButton("collapse to deepest annotation");
        this.reload_tree = new JButton("reload tree");
        this.addJB(this.zoom_in_x, x_panel);
        this.addJB(this.zoom_out_x, x_panel);
        this.addJB(this.zoom_in_y, y_panel);
        this.addJB(this.zoom_out_y, y_panel);
        this.addJB(this.show_whole, this);
        JLabel spacer2 = new JLabel("");
        spacer2.setFont(jcb_font);
        this.add(spacer2);
        this.addJB(this.order, this);
        this.addJB(this.uncollapse_all, this);
        this.addJB(this.collapse_to_deepest_annot, this);
        JLabel spacer3 = new JLabel("");
        spacer3.setFont(jcb_font);
        this.add(spacer3);
        this.addJB(this.reload_tree, this);
    }

    public boolean colorAccordingToSpecies() {
        return this.color_acc_species != null && this.color_acc_species.isSelected();
    }

    public boolean colorOrthologous() {
        return this.color_orthos != null && this.color_orthos.isSelected();
    }

    public boolean colorSubtreeNeighbors() {
        return this.color_s_n != null && this.color_s_n.isSelected();
    }

    public boolean colorSuperOrthologous() {
        return this.color_super_orthos != null && this.color_super_orthos.isSelected();
    }

    protected void collapseToDeepestAnnot(ATVtreePanel tp) {
        Phylogeny t = tp.getTree();
        if (t != null && !t.isEmpty()) {
            t.collapseToDeepestAnotNodes();
            this.showWhole();
        }
    }

    protected void endClickToOptions() {
        this.click_to_list.addActionListener(this);
        this.multiple_click_to_names = new Vector();
        this.multiple_click_to_names.add(this.all_click_to_names.get(new Integer(0)));
    }

    public Hashtable getAllClickToItems() {
        return this.all_click_to_names;
    }

    public Vector getMultipleClickToNames() {
        return this.multiple_click_to_names;
    }

    public Vector getSingleClickToNames() {
        return this.single_click_to_names;
    }

    public boolean isColorBranches() {
        return this.color_branches != null && this.color_branches.isSelected();
    }

    public boolean isCustomTagChecked(String tag) {
        if (this.custom_tags.get(tag) != null) {
            return (Boolean)this.custom_tags.get(tag);
        }
        return false;
    }

    public boolean isECExtNodes() {
        return this.ecextnodes != null && this.ecextnodes.isSelected();
    }

    public boolean isECInternalNodes() {
        return this.ecintnodes != null && this.ecintnodes.isSelected();
    }

    public boolean isMarkNodesWithBox() {
        return this.mark_nodes_with_box != null && this.mark_nodes_with_box.isSelected();
    }

    public boolean isTreeEditable() {
        return this.config_settings.isTreeEditable();
    }

    public boolean isWidthBranches() {
        return this.width_branches != null && this.width_branches.isSelected();
    }

    protected void reloadTree() {
        this.atvpanel.atvframe.reLoad();
    }

    public void setClickToAction(int action) {
        if (action == this.edit_cb_item) {
            this.atvtreepanel.setActionWhenNodeClicked(6);
        } else if (action == this.collapse_cb_item) {
            this.atvtreepanel.setActionWhenNodeClicked(7);
        } else if (action == this.reroot_cb_item) {
            this.atvtreepanel.setActionWhenNodeClicked(8);
        } else if (action == this.subtree_cb_item) {
            this.atvtreepanel.setActionWhenNodeClicked(9);
        } else if (action == this.swap_cb_item) {
            this.atvtreepanel.setActionWhenNodeClicked(10);
        } else if (action == this.display_node_sequences_cb_item) {
            this.atvtreepanel.setActionWhenNodeClicked(11);
        } else if (action == this.display_node_popup_cb_item) {
            this.atvtreepanel.setActionWhenNodeClicked(1);
        } else if (action == this.display_node_glyph_info_cb_item) {
            this.atvtreepanel.setActionWhenNodeClicked(12);
        } else if (action == this.custom_option_cb_item) {
            this.atvtreepanel.setActionWhenNodeClicked(13);
        }
        this.click_to_list.setSelectedIndex(action);
    }

    protected void setCheckbox(JCheckBox cb, boolean state) {
        if (cb != null) {
            cb.setSelected(state);
        }
    }

    public void setCheckbox(int which, boolean state) {
        switch (which) {
            case 0: {
                this.userealbl.setSelected(state);
                break;
            }
            case 13: {
                this.color_acc_species.setSelected(state);
                break;
            }
            case 2: {
                this.seqnameextnodes.setSelected(state);
                break;
            }
            case 1: {
                this.seqnameintnodes.setSelected(state);
                break;
            }
            case 4: {
                this.speciesextnodes.setSelected(state);
                break;
            }
            case 3: {
                this.speciesintnodes.setSelected(state);
                break;
            }
            case 6: {
                this.ecextnodes.setSelected(state);
                break;
            }
            case 5: {
                this.ecintnodes.setSelected(state);
                break;
            }
            case 7: {
                this.write_b_l.setSelected(state);
                break;
            }
            case 8: {
                this.writebootstrap.setSelected(state);
                break;
            }
            case 9: {
                this.write_d_s.setSelected(state);
                break;
            }
            case 14: {
                this.color_branches.setSelected(state);
                break;
            }
            case 15: {
                this.width_branches.setSelected(state);
                break;
            }
            case 10: {
                this.color_orthos.setSelected(state);
                break;
            }
            case 11: {
                this.color_super_orthos.setSelected(state);
                break;
            }
            case 12: {
                this.color_s_n.setSelected(state);
                break;
            }
            case 16: {
                this.mark_nodes_with_box.setSelected(state);
                break;
            }
            default: {
                System.out.println("Unknown checkbox: " + which);
            }
        }
    }

    protected void setDefaultColors() {
        background_color = ATVconstants.GUI_BACKGROUND_DEFAULT;
        jcb_text_color = ATVconstants.CHECKBOX_TEXT_COLOR_DEFAULT;
        jcb_background_color = ATVconstants.CHECKBOX_BACKGROUND_COLOR_DEFAULT;
        button_text_color = ATVconstants.BUTTON_TEXT_COLOR_DEFAULT;
        button_background_color = ATVconstants.BUTTON_BACKGROUND_COLOR_DEFAULT;
    }

    protected void setMultipleSelect(boolean b) {
        this.multiselect = b;
        this.click_to_list.removeAllItems();
        this.display_node_glyph_info_cb_item = -1;
        this.display_node_sequences_cb_item = -1;
        this.subtree_cb_item = -1;
        this.swap_cb_item = -1;
        this.reroot_cb_item = -1;
        this.collapse_cb_item = -1;
        this.edit_cb_item = -1;
        if (this.multiselect) {
            int cb_index = 0;
            if (this.config_settings.doDisplayClickToOption(0)) {
                this.edit_cb_item = cb_index++;
                this.click_to_list.addItem(this.config_settings.getClickToTitle(0));
            }
        } else {
            this.setupClickToOptions();
        }
        this.repaint();
    }

    public boolean seqNameExtNodes() {
        return this.seqnameextnodes != null && this.seqnameextnodes.isSelected();
    }

    public boolean seqNameInternalNodes() {
        return this.seqnameintnodes != null && this.seqnameintnodes.isSelected();
    }

    protected void setupControls() {
        this.setupDisplayCheckboxes();
        this.startClickToOptions();
        this.setupClickToOptions();
        this.endClickToOptions();
        this.addCustomControls();
        this.addButtons();
    }

    private void setupClickToOptions() {
        int default_option = this.config_settings.getDefaultDisplayClicktoOption();
        int selected_index = 0;
        int cb_index = 0;
        if (this.config_settings.doDisplayClickToOption(0)) {
            this.edit_cb_item = cb_index;
            this.addClickToOption(0, this.config_settings.getClickToTitle(0));
            if (default_option == 0) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this.config_settings.doDisplayClickToOption(1)) {
            this.collapse_cb_item = cb_index;
            this.addClickToOption(1, this.config_settings.getClickToTitle(1));
            if (default_option == 1) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this.config_settings.doDisplayClickToOption(2)) {
            this.reroot_cb_item = cb_index;
            this.addClickToOption(2, this.config_settings.getClickToTitle(2));
            if (default_option == 2) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this.config_settings.doDisplayClickToOption(3)) {
            this.subtree_cb_item = cb_index;
            this.addClickToOption(3, this.config_settings.getClickToTitle(3));
            if (default_option == 3) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this.config_settings.doDisplayClickToOption(4)) {
            this.swap_cb_item = cb_index;
            this.addClickToOption(4, this.config_settings.getClickToTitle(4));
            if (default_option == 4) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this.config_settings.doDisplayClickToOption(5)) {
            this.display_node_sequences_cb_item = cb_index;
            this.addClickToOption(5, this.config_settings.getClickToTitle(5));
            if (default_option == 5) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this.config_settings.doDisplayClickToOption(6)) {
            this.go_to_swissprot_cb_item = cb_index;
            this.addClickToOption(6, this.config_settings.getClickToTitle(6));
            if (default_option == 6) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this.config_settings.doDisplayClickToOption(7)) {
            this.display_node_popup_cb_item = cb_index;
            this.addClickToOption(7, this.config_settings.getDisplayNodePopupTitle());
            if (default_option == 7) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this.config_settings.doDisplayClickToOption(8)) {
            this.display_glyph_popup_cb_item = cb_index;
            this.addClickToOption(8, this.config_settings.getClickToTitle(8));
            if (default_option == 8) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this.config_settings.doDisplayClickToOption(9)) {
            this.custom_option_cb_item = cb_index;
            this.addClickToOption(9, this.config_settings.getClickToTitle(9));
            if (default_option == 9) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        this.click_to_list.setSelectedIndex(selected_index);
        this.setClickToAction(selected_index);
    }

    private void setupDisplayCheckboxes() {
        if (this.config_settings.doDisplayOption(0)) {
            this.addCheckbox(0, this.config_settings.getDisplayTitle(0));
            this.setCheckbox(0, this.config_settings.doCheckOption(0));
        }
        if (this.config_settings.doDisplayOption(1)) {
            this.addCheckbox(1, this.config_settings.getDisplayTitle(1));
            this.setCheckbox(1, this.config_settings.doCheckOption(1));
        }
        if (this.config_settings.doDisplayOption(2)) {
            this.addCheckbox(2, this.config_settings.getDisplayTitle(2));
            this.setCheckbox(2, this.config_settings.doCheckOption(2));
        }
        if (this.config_settings.doDisplayOption(3)) {
            this.addCheckbox(3, this.config_settings.getDisplayTitle(3));
            this.setCheckbox(3, this.config_settings.doCheckOption(3));
        }
        if (this.config_settings.doDisplayOption(4)) {
            this.addCheckbox(4, this.config_settings.getDisplayTitle(4));
            this.setCheckbox(4, this.config_settings.doCheckOption(4));
        }
        if (this.config_settings.doDisplayOption(5)) {
            this.addCheckbox(5, this.config_settings.getDisplayTitle(5));
            this.setCheckbox(5, this.config_settings.doCheckOption(5));
        }
        if (this.config_settings.doDisplayOption(6)) {
            this.addCheckbox(6, this.config_settings.getDisplayTitle(6));
            this.setCheckbox(6, this.config_settings.doCheckOption(6));
        }
        if (this.config_settings.doDisplayOption(7)) {
            this.addCheckbox(7, this.config_settings.getDisplayTitle(7));
            this.setCheckbox(7, this.config_settings.doCheckOption(7));
        }
        if (this.config_settings.doDisplayOption(8)) {
            this.addCheckbox(8, this.config_settings.getDisplayTitle(8));
            this.setCheckbox(8, this.config_settings.doCheckOption(8));
        }
        if (this.config_settings.doDisplayOption(9)) {
            this.addCheckbox(9, this.config_settings.getDisplayTitle(9));
            this.setCheckbox(9, this.config_settings.doCheckOption(9));
        }
        if (this.config_settings.doDisplayOption(10)) {
            this.addCheckbox(10, this.config_settings.getDisplayTitle(10));
            this.setCheckbox(10, this.config_settings.doCheckOption(10));
        }
        if (this.config_settings.doDisplayOption(11)) {
            this.addCheckbox(11, this.config_settings.getDisplayTitle(11));
            this.setCheckbox(11, this.config_settings.doCheckOption(11));
        }
        if (this.config_settings.doDisplayOption(12)) {
            this.addCheckbox(12, this.config_settings.getDisplayTitle(12));
            this.setCheckbox(12, this.config_settings.doCheckOption(12));
        }
        if (this.config_settings.doDisplayOption(13)) {
            this.addCheckbox(13, this.config_settings.getDisplayTitle(13));
            this.setCheckbox(13, this.config_settings.doCheckOption(13));
        }
        if (this.config_settings.doDisplayOption(14)) {
            this.addCheckbox(14, this.config_settings.getDisplayTitle(14));
            this.setCheckbox(14, this.config_settings.doCheckOption(14));
        }
        if (this.config_settings.doDisplayOption(15)) {
            this.addCheckbox(15, this.config_settings.getDisplayTitle(15));
            this.setCheckbox(15, this.config_settings.doCheckOption(15));
        }
        if (this.config_settings.doDisplayOption(16)) {
            this.addCheckbox(16, this.config_settings.getDisplayTitle(16));
            this.setCheckbox(16, this.config_settings.doCheckOption(16));
        }
    }

    protected void showHelp(String which, String title) {
        QuickHelpFrame qhf = new QuickHelpFrame((Frame)this.atvpanel.atvframe, which, title);
        qhf.show();
    }

    public void showItemHelpButtons(boolean b) {
        if (this.userealbl_help != null) {
            this.userealbl_help.setVisible(b);
        }
        if (this.seqnameextnodes_help != null) {
            this.seqnameextnodes_help.setVisible(b);
        }
        if (this.seqnameintnodes_help != null) {
            this.seqnameintnodes_help.setVisible(b);
        }
        if (this.speciesextnodes_help != null) {
            this.speciesextnodes_help.setVisible(b);
        }
        if (this.speciesintnodes_help != null) {
            this.speciesintnodes_help.setVisible(b);
        }
        if (this.ecintnodes_help != null) {
            this.ecintnodes_help.setVisible(b);
        }
        if (this.ecextnodes_help != null) {
            this.ecextnodes_help.setVisible(b);
        }
        if (this.writebl_help != null) {
            this.writebl_help.setVisible(b);
        }
        if (this.writebootstrap_help != null) {
            this.writebootstrap_help.setVisible(b);
        }
        if (this.writed_s_help != null) {
            this.writed_s_help.setVisible(b);
        }
        if (this.color_orthos_help != null) {
            this.color_orthos_help.setVisible(b);
        }
        if (this.color_super_orthos_help != null) {
            this.color_super_orthos_help.setVisible(b);
        }
        if (this.color_sn_help != null) {
            this.color_sn_help.setVisible(b);
        }
        if (this.color_acc_species_help != null) {
            this.color_acc_species_help.setVisible(b);
        }
        if (this.editable_help != null) {
            this.editable_help.setVisible(b);
        }
        if (this.color_branches_help != null) {
            this.color_branches_help.setVisible(b);
        }
        if (this.width_branches_help != null) {
            this.width_branches_help.setVisible(b);
        }
        if (this.mark_nodes_with_box_help != null) {
            this.mark_nodes_with_box_help.setVisible(b);
        }
    }

    protected void showWhole() {
        this.atvtreepanel.setParametersForPainting(this.atvpanel.getSizeOfViewport().width, this.atvpanel.getSizeOfViewport().height);
        this.atvtreepanel.resetPreferredSize();
        this.atvpanel.adjustJScrollPane();
    }

    public boolean speciesExtNodes() {
        return this.speciesextnodes != null && this.speciesextnodes.isSelected();
    }

    public boolean speciesInternalNodes() {
        return this.speciesintnodes != null && this.speciesintnodes.isSelected();
    }

    protected void startClickToOptions() {
        JLabel spacer = new JLabel("");
        spacer.setFont(jcb_font);
        this.add(spacer);
        this.click_to = new JLabel("click on node to:");
        this.click_to.setFont(jcb_bold_font);
        this.click_to.setForeground(jcb_text_color);
        this.click_to.setBackground(background_color);
        this.add(this.click_to);
        this.click_to_list = new JComboBox();
        this.click_to_list.setBackground(background_color);
        this.click_to_list.setFont(js_font);
        this.add(this.click_to_list);
        this.all_click_to_names = new Hashtable();
        this.single_click_to_names = new Vector();
    }

    void uncollapseAll(ATVtreePanel tp) {
        Phylogeny t = tp.getTree();
        if (t != null && !t.isEmpty()) {
            t.setAllNodesToNotCollapse();
            t.adjustNodeCount(false);
            this.showWhole();
        }
    }

    public boolean useRealBranchLengths() {
        return this.userealbl != null && this.userealbl.isSelected();
    }

    public boolean writeBranchLengthValues() {
        return this.write_b_l != null && this.write_b_l.isSelected();
    }

    public boolean writeBootstrapValues() {
        return this.writebootstrap != null && this.writebootstrap.isSelected();
    }

    public boolean writeDupSpec() {
        return this.write_d_s != null && this.write_d_s.isSelected();
    }
}

