/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import org.forester.atv.ATVConfig;
import org.forester.atv.ATVconstants;
import org.forester.atv.ATVframe;
import org.forester.atv.ATVpanel;
import org.forester.atv.ATVprinter;
import org.forester.atv.NHFilter;
import org.forester.atv.NHXFilter;
import org.forester.atv.XMLFilter;
import org.forester.io.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.parsers.nhx.NHXParser;
import org.forester.phylogeny.parsers.xml.SimplePhyloXMLParser1;
import org.forester.util.Util;

public class ATVapplicationFrame
extends ATVframe {
    protected static final int FRAME_X_SIZE = 640;
    protected static final int FRAME_Y_SIZE = 580;
    protected static final int PRINT_X_SIZE = 580;
    protected static final int PRINT_Y_SIZE = 700;
    protected File treefile = null;
    protected JFileChooser open_filechooser;
    protected JFileChooser saveas_filechooser;
    protected static final NHXFilter nhxfilter = new NHXFilter();
    protected static final NHFilter nhfilter = new NHFilter();
    protected static final XMLFilter xmlfilter = new XMLFilter();
    File open_dir;
    protected JMenuItem print_item;
    protected JMenuItem print_options_jmenu;
    protected JCheckBox print_in_color;
    protected JSlider x_slider;
    protected JSlider y_slider;
    protected static final int SLIDER_MIN = 0;
    protected static final int SLIDER_MAX = 200;
    protected static final int SLIDER_VAL = 100;
    protected static final int SLIDER_MAJS = 50;
    protected static final int SLIDER_MINS = 10;

    public ATVapplicationFrame(Phylogeny t, String config_file) {
        this.setVisible(false);
        this.config_filename = config_file;
        if (t != null && !t.isEmpty()) {
            this.reload_tree_ = t.copy();
        }
        this.atvtextframe = null;
        this.species_tree_ = null;
        if (t != null && !t.isEmpty() && !Util.isEmpty(t.getName())) {
            this.setTitle("ATV [" + t.getName() + "]");
        } else {
            this.setTitle("ATV");
        }
        this.config_settings = new ATVConfig(config_file, false, false);
        this.atvpanel = new ATVpanel(t, this.config_settings, this);
        this.open_filechooser = new JFileChooser();
        this.open_filechooser.setCurrentDirectory(new File("."));
        this.open_filechooser.setMultiSelectionEnabled(false);
        this.open_filechooser.setFileFilter(nhxfilter);
        this.open_filechooser.addChoosableFileFilter(nhfilter);
        this.open_filechooser.addChoosableFileFilter(this.open_filechooser.getAcceptAllFileFilter());
        this.saveas_filechooser = new JFileChooser();
        this.saveas_filechooser.setCurrentDirectory(new File("."));
        this.saveas_filechooser.setMultiSelectionEnabled(false);
        this.saveas_filechooser.setFileFilter(nhxfilter);
        this.saveas_filechooser.addChoosableFileFilter(xmlfilter);
        this.saveas_filechooser.addChoosableFileFilter(nhfilter);
        this.saveas_filechooser.addChoosableFileFilter(this.saveas_filechooser.getAcceptAllFileFilter());
        this.jmenubar = new JMenuBar();
        this.jmenubar.setBackground(ATVconstants.MENU_BACKGROUND_COLOR_DEFAULT);
        this.buildFileMenu();
        this.buildEditMenu();
        this.buildViewMenu();
        this.buildOptionsMenu();
        this.buildSDIMenu();
        this.buildHelpMenu();
        this.setJMenuBar(this.jmenubar);
        this.jmenubar.add(this.help_jmenu);
        this.contentpane = this.getContentPane();
        this.contentpane.setLayout(new BorderLayout());
        this.contentpane.add((Component)this.atvpanel, "Center");
        this.setSize(640, 580);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ATVapplicationFrame.this.close();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ATVapplicationFrame.this.atvpanel.getATVtreePanel().setParametersForPainting(ATVapplicationFrame.this.atvpanel.getATVtreePanel().getWidth(), ATVapplicationFrame.this.atvpanel.getATVtreePanel().getHeight());
            }
        });
        this.setVisible(true);
        this.atvpanel.getATVcontrol().showWhole();
        this.contentpane.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Object o = e.getSource();
        if (o == this.open_item) {
            this.openFile();
        } else if (o == this.save_item) {
            this.save(this.atvpanel.getATVtreePanel().getTree());
        } else if (o == this.saveas_item) {
            this.saveAs(this.atvpanel.getATVtreePanel().getTree());
        } else if (o == this.print_item) {
            this.printTree();
        } else if (o == this.view_as_NH_item) {
            this.viewAsNH();
        } else if (o == this.view_as_NHX_item) {
            this.viewAsNHX();
        } else if (o == this.view_as_XML_item) {
            this.viewAsXML();
        } else if (o == this.load_species_tree_item) {
            this.openSpeciesTreeFile();
        } else if (o == this.infer_dups_item) {
            this.inferDups();
        } else if (o == this.root_min_dups_height_item) {
            this.rootMinDupsHeight();
        } else if (o == this.root_min_L_height_item) {
            this.rootMinLHeight();
        } else if (o == this.root_min_height_item) {
            this.rootMinHeight();
        }
        this.contentpane.repaint();
    }

    protected void buildFileMenu() {
        this.file_jmenu = this.createMenu("File");
        this.print_options_jmenu = new JMenu("Print Options");
        this.print_options_jmenu.setFont(menu_font);
        this.print_options_jmenu.setBackground(ATVconstants.MENU_BACKGROUND_COLOR_DEFAULT);
        this.print_options_jmenu.setForeground(ATVconstants.MENU_TEXT_COLOR_DEFAULT);
        this.reload_item = new JMenuItem("Reload tree");
        this.file_jmenu.add(this.reload_item);
        this.file_jmenu.addSeparator();
        this.open_item = new JMenuItem("Open tree...");
        this.file_jmenu.add(this.open_item);
        this.open_url_item = new JMenuItem("Open tree URL...");
        this.file_jmenu.add(this.open_url_item);
        this.saveas_item = new JMenuItem("Save As...");
        this.file_jmenu.add(this.saveas_item);
        this.save_item = new JMenuItem("Save");
        this.file_jmenu.add(this.save_item);
        this.file_jmenu.addSeparator();
        this.file_jmenu.add(this.print_options_jmenu);
        this.print_item = new JMenuItem("Print...");
        this.file_jmenu.add(this.print_item);
        this.file_jmenu.addSeparator();
        this.close_item = new JMenuItem("Close");
        this.file_jmenu.add(this.close_item);
        this.print_in_color = new JCheckBox("Print in color");
        this.print_in_color.setFont(menu_font);
        this.print_in_color.setForeground(ATVconstants.MENU_TEXT_COLOR_DEFAULT);
        this.print_options_jmenu.add(this.print_in_color);
        this.xs_label = new JLabel("X size:");
        this.xs_label.setForeground(ATVconstants.MENU_TEXT_COLOR_DEFAULT);
        this.xs_label.setFont(menu_font);
        this.ys_label = new JLabel("Y size:");
        this.ys_label.setFont(menu_font);
        this.ys_label.setForeground(ATVconstants.MENU_TEXT_COLOR_DEFAULT);
        this.x_slider = new JSlider(0, 200, 100);
        this.x_slider.setFont(menu_font);
        this.x_slider.setMajorTickSpacing(50);
        this.x_slider.setMinorTickSpacing(10);
        this.x_slider.setPaintTicks(true);
        this.x_slider.setPaintLabels(true);
        this.x_slider.setSnapToTicks(true);
        this.print_options_jmenu.add(this.xs_label);
        this.print_options_jmenu.add(this.x_slider);
        this.y_slider = new JSlider(0, 200, 100);
        this.y_slider.setFont(menu_font);
        this.y_slider.setMajorTickSpacing(50);
        this.y_slider.setMinorTickSpacing(10);
        this.y_slider.setPaintTicks(true);
        this.y_slider.setPaintLabels(true);
        this.y_slider.setSnapToTicks(true);
        this.print_options_jmenu.add(this.ys_label);
        this.print_options_jmenu.add(this.y_slider);
        this.customizeJMenuItem(this.reload_item);
        this.customizeJMenuItem(this.open_item);
        this.customizeJMenuItem(this.open_url_item);
        this.customizeJMenuItem(this.save_item);
        this.customizeJMenuItem(this.saveas_item);
        this.customizeJMenuItem(this.print_item);
        this.customizeJMenuItem(this.close_item);
        this.jmenubar.add(this.file_jmenu);
    }

    protected void buildGenomicsMenu() {
        this.genomics_jmenu = this.createMenu("Phylogenomics");
        this.jmenubar.add(this.genomics_jmenu);
    }

    protected void buildSDIMenu() {
        this.SDI_jmenu = new JMenu("SDI");
        this.SDI_jmenu.setFont(menu_font);
        this.SDI_jmenu.setBackground(ATVconstants.MENU_BACKGROUND_COLOR_DEFAULT);
        this.SDI_jmenu.setForeground(ATVconstants.MENU_TEXT_COLOR_DEFAULT);
        this.infer_dups_item = new JMenuItem("SDI (Speciation Duplication Inference)");
        this.SDI_jmenu.add(this.infer_dups_item);
        this.SDI_jmenu.addSeparator();
        this.root_min_dups_height_item = new JMenuItem("SDI and root by minimizing duplications | height");
        this.SDI_jmenu.add(this.root_min_dups_height_item);
        this.root_min_L_height_item = new JMenuItem("SDI and root by minimizing cost L | height");
        this.SDI_jmenu.add(this.root_min_L_height_item);
        this.root_min_height_item = new JMenuItem("SDI and root by minimizing height");
        this.SDI_jmenu.add(this.root_min_height_item);
        this.SDI_jmenu.addSeparator();
        this.load_species_tree_item = new JMenuItem("Load species tree");
        this.SDI_jmenu.add(this.load_species_tree_item);
        this.customizeJMenuItem(this.infer_dups_item);
        this.customizeJMenuItem(this.root_min_dups_height_item);
        this.customizeJMenuItem(this.root_min_L_height_item);
        this.customizeJMenuItem(this.root_min_height_item);
        this.customizeJMenuItem(this.load_species_tree_item);
        this.jmenubar.add(this.SDI_jmenu);
    }

    private void openFile() {
        boolean exception = false;
        Phylogeny t = null;
        if (this.open_dir == null) {
            this.open_dir = System.getProperty("user.dir") != null ? new File(System.getProperty("user.dir")) : new File(System.getProperty("user.home"));
        }
        this.open_filechooser.setCurrentDirectory(this.open_dir);
        int result = this.open_filechooser.showOpenDialog(this.contentpane);
        File file = this.open_filechooser.getSelectedFile();
        this.open_dir = this.open_filechooser.getCurrentDirectory();
        if (file != null && result == 0) {
            if (this.open_filechooser.getFileFilter() == nhfilter || this.open_filechooser.getFileFilter() == nhxfilter) {
                try {
                    PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                    t = factory.create(file, new NHXParser())[0];
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringOpenFile(e);
                }
            } else if (this.open_filechooser.getFileFilter() == xmlfilter) {
                try {
                    PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                    t = factory.create(file, new SimplePhyloXMLParser1())[0];
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringOpenFile(e);
                }
            } else {
                try {
                    if (file.getName().toLowerCase().endsWith(".xml")) {
                        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                        t = factory.create(file, new SimplePhyloXMLParser1())[0];
                    } else {
                        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                        t = factory.create(file, new NHXParser())[0];
                    }
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringOpenFile(e);
                }
            }
            if (!exception && t != null && !t.isEmpty()) {
                this.reload_tree_ = t.copy();
                this.removeatvtextframe();
                this.atvpanel.terminate();
                this.contentpane.removeAll();
                this.atvpanel = new ATVpanel(t, this.config_settings, this);
                this.jmenubar.remove(this.help_jmenu);
                this.jmenubar.add(this.help_jmenu);
                this.contentpane.add((Component)this.atvpanel, "Center");
                this.setVisible(true);
                this.treefile = file;
                if (!Util.isEmpty(t.getName())) {
                    this.setTitle("ATV [" + t.getName() + "]" + " [" + this.treefile + "]");
                } else {
                    this.setTitle("ATV [" + this.treefile + "]");
                }
                this.atvpanel.getATVtreePanel().setParametersForPainting(this.atvpanel.getATVtreePanel().getWidth(), this.atvpanel.getATVtreePanel().getHeight());
                this.atvpanel.getATVcontrol().showWhole();
            }
            this.contentpane.repaint();
        }
    }

    protected void openURL() {
        URL url = null;
        Phylogeny t = null;
        String message = "Please enter a complete URL";
        String url_string = JOptionPane.showInputDialog(this, message, "Open URL to read a phyloXML/NH/NHX tree", 3);
        if (url_string != null && url_string.length() > 0) {
            PhylogenyFactory factory;
            try {
                url = new URL(url_string);
                if (url.getFile().toLowerCase().endsWith(".xml")) {
                    factory = ParserBasedPhylogenyFactory.getInstance();
                    t = factory.create(url.openStream(), new SimplePhyloXMLParser1())[0];
                } else {
                    factory = ParserBasedPhylogenyFactory.getInstance();
                    t = factory.create(url.openStream(), new NHXParser())[0];
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "TreeJAppletJFrame: openURL(): Exception: " + e, "Malformed URL", 0);
            }
            if (url != null) {
                try {
                    factory = ParserBasedPhylogenyFactory.getInstance();
                    t = factory.create(url.openStream(), new NHXParser())[0];
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "TreeJAppletJFrame: openURL(): \nException: " + e, "Could not read Phylogeny", 0);
                }
                if (t != null && !t.isEmpty()) {
                    this.reload_tree_ = t.copy();
                    this.removeatvtextframe();
                    this.atvpanel.terminate();
                    this.contentpane.removeAll();
                    this.atvpanel = new ATVpanel(t, this.config_settings, this);
                    this.jmenubar.remove(this.help_jmenu);
                    this.jmenubar.add(this.help_jmenu);
                    this.contentpane.add((Component)this.atvpanel, "Center");
                    this.setVisible(true);
                    this.contentpane.repaint();
                    this.setTitle("ATV: " + url);
                    this.treefile = null;
                    this.atvpanel.getATVtreePanel().setParametersForPainting(this.atvpanel.getATVtreePanel().getWidth(), this.atvpanel.getATVtreePanel().getHeight());
                }
            }
            this.contentpane.repaint();
        }
    }

    protected void reLoad() {
        boolean do_reload_tree;
        int retval = JOptionPane.showConfirmDialog(this, "Are you sure you want to undo all of your changes?", "Verify Reload", 0);
        boolean bl = do_reload_tree = retval == 0;
        if (do_reload_tree && this.reload_tree_ != null && !this.reload_tree_.isEmpty()) {
            Phylogeny t = this.reload_tree_.copy();
            this.removeatvtextframe();
            this.atvpanel.terminate();
            this.contentpane.removeAll();
            this.atvpanel = new ATVpanel(t, this.config_settings, this);
            this.contentpane.add((Component)this.atvpanel, "Center");
            this.setVisible(true);
            if (this.treefile != null) {
                this.setTitle("ATV: " + this.treefile);
            } else {
                this.setTitle("ATV");
            }
            this.atvpanel.getATVtreePanel().setParametersForPainting(this.atvpanel.getATVtreePanel().getWidth(), this.atvpanel.getATVtreePanel().getHeight());
            this.atvpanel.getATVcontrol().showWhole();
            this.contentpane.repaint();
        }
    }

    private void save(Phylogeny t) {
        int i;
        if (this.treefile == null) {
            if (t != null) {
                this.saveAs(t);
            }
            return;
        }
        if (this.treefile.exists() && (i = JOptionPane.showConfirmDialog(this, this.treefile + " already exists. Overwrite?", "File|Save", 2, 2)) != 0) {
            return;
        }
        try {
            PhylogenyWriter writer = new PhylogenyWriter();
            writer.toPhyloXML(t, this.treefile);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Exception: " + e, "Error during File|Save", 0);
        }
    }

    private void saveAs(Phylogeny t) {
        if (t == null) {
            return;
        }
        boolean ow = false;
        boolean exception = false;
        int result = this.saveas_filechooser.showSaveDialog(this.contentpane);
        File file = this.saveas_filechooser.getSelectedFile();
        if (file != null && result == 0) {
            if (file.exists()) {
                int i = JOptionPane.showConfirmDialog(this, file + " already exists. Overwrite?", "File|SaveAs", 2, 2);
                if (i == 0) {
                    ow = true;
                } else {
                    return;
                }
            }
            if (this.saveas_filechooser.getFileFilter() == nhfilter) {
                try {
                    PhylogenyWriter writer = new PhylogenyWriter();
                    writer.toNewHampshire(t, false, file);
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringSaveAs(e);
                }
            } else if (this.saveas_filechooser.getFileFilter() == nhxfilter) {
                try {
                    PhylogenyWriter writer = new PhylogenyWriter();
                    writer.toNewHampshireX(t, file);
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringSaveAs(e);
                }
            } else if (this.saveas_filechooser.getFileFilter() == xmlfilter) {
                try {
                    PhylogenyWriter writer = new PhylogenyWriter();
                    writer.toPhyloXML(t, file);
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringSaveAs(e);
                }
            } else if (file.getName().trim().toLowerCase().endsWith(".nh")) {
                try {
                    PhylogenyWriter writer = new PhylogenyWriter();
                    writer.toNewHampshire(t, false, file);
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringSaveAs(e);
                }
            } else {
                try {
                    PhylogenyWriter writer = new PhylogenyWriter();
                    writer.toPhyloXML(t, file);
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringSaveAs(e);
                }
            }
            if (!exception) {
                this.treefile = file;
                this.setTitle("ATV: " + this.treefile);
            }
        }
    }

    private void printTree() {
        if (this.atvpanel.getATVtreePanel().getTree() == null || this.atvpanel.getATVtreePanel().getTree().isEmpty()) {
            return;
        }
        ATVprinter atvprinter = null;
        this.atvpanel.getATVtreePanel().setParametersForPainting(580 * this.x_slider.getValue() / 100, 700 * this.y_slider.getValue() / 100);
        atvprinter = this.treefile != null ? new ATVprinter(this.atvpanel.getATVtreePanel(), this.atvpanel.getATVcontrol(), this.treefile.toString(), this.print_in_color.isSelected()) : new ATVprinter(this.atvpanel.getATVtreePanel(), this.atvpanel.getATVcontrol(), "ATVprinter", this.print_in_color.isSelected());
        this.atvpanel.getATVtreePanel().setParametersForPainting(this.atvpanel.getATVtreePanel().getWidth(), this.atvpanel.getATVtreePanel().getHeight());
        this.contentpane.repaint();
    }

    private void openSpeciesTreeFile() {
        Phylogeny t = null;
        boolean exception = false;
        int result = this.open_filechooser.showOpenDialog(this.contentpane);
        File file = this.open_filechooser.getSelectedFile();
        if (file != null && result == 0) {
            PhylogenyFactory factory;
            if (this.open_filechooser.getFileFilter() == nhfilter || this.open_filechooser.getFileFilter() == nhxfilter) {
                try {
                    factory = ParserBasedPhylogenyFactory.getInstance();
                    t = factory.create(file, new NHXParser())[0];
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringOpenFile(e);
                }
            } else if (this.open_filechooser.getFileFilter() == xmlfilter) {
                try {
                    factory = ParserBasedPhylogenyFactory.getInstance();
                    t = factory.create(file, new SimplePhyloXMLParser1())[0];
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringOpenFile(e);
                }
            } else {
                try {
                    if (file.getName().toLowerCase().endsWith(".xml")) {
                        factory = ParserBasedPhylogenyFactory.getInstance();
                        t = factory.create(file, new SimplePhyloXMLParser1())[0];
                    } else {
                        factory = ParserBasedPhylogenyFactory.getInstance();
                        t = factory.create(file, new NHXParser())[0];
                    }
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringOpenFile(e);
                }
            }
            if (!exception && t != null && !t.isRooted()) {
                exception = true;
                t = null;
                JOptionPane.showMessageDialog(this, "Species tree is not rooted.", "Species tree not loaded", 0);
            }
            if (!exception && t != null && !t.isCompletelyBinary()) {
                exception = true;
                t = null;
                JOptionPane.showMessageDialog(this, "Species tree is not completely binary.", "Species tree not loaded", 0);
            }
            if (!exception && t != null) {
                Util.cleanSpeciesNamesInExtNodes(t);
                String s = "";
                Vector v1 = t.getRoot().getAllExternalChildren();
                Vector<String> v2 = new Vector<String>();
                int i = 0;
                while (i < v1.size()) {
                    s = ((PhylogenyNode)v1.elementAt(i)).getTaxonomy();
                    if (s == null || s == "") {
                        exception = true;
                        t = null;
                        JOptionPane.showMessageDialog(this, "Species tree contains empty species fields.", "Species tree not loaded", 0);
                        break;
                    }
                    v2.addElement(s);
                    ++i;
                }
                i = 0;
                while (i < v2.size()) {
                    s = (String)v2.elementAt(i);
                    if (v2.indexOf(s) != v2.lastIndexOf(s)) {
                        exception = true;
                        t = null;
                        JOptionPane.showMessageDialog(this, "Species tree contains duplicate species.", "Species tree not loaded", 0);
                        break;
                    }
                    ++i;
                }
            }
            if (!exception && t != null) {
                this.species_tree_ = t;
                JOptionPane.showMessageDialog(this, "Species tree successfully loaded.", "SDI", 1);
            }
            this.contentpane.repaint();
        }
    }

    private void exit() {
        System.exit(0);
    }
}

