/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import org.forester.atv.ATVConfig;
import org.forester.atv.ATVapplet;
import org.forester.atv.ATVconstants;
import org.forester.atv.ATVframe;
import org.forester.atv.ATVpanel;
import org.forester.atv.ATVpanel_applet;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.parsers.nhx.NHXParser;

public class ATVappletFrame
extends ATVframe {
    private ATVapplet atvapplet;
    private static final int FRAME_X_SIZE = 640;
    private static final int FRAME_Y_SIZE = 580;

    public ATVappletFrame(ATVapplet parent_atvapplet, String config_file) {
        this.config_filename = config_file;
        this.setTitle("ATV");
        this.atvapplet = parent_atvapplet;
        this.atvtextframe = null;
        URL url = null;
        Phylogeny t = null;
        Object level_string = null;
        if (this.atvapplet.getURLstring() != null) {
            try {
                url = new URL(this.atvapplet.getURLstring());
            }
            catch (Exception e) {
                System.out.println("ATVapplet: ");
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "ATVapplet: Could not create URL from: " + this.atvapplet.getURLstring() + "\nException: " + e, "Could not create URL", 0);
                this.close();
            }
        }
        if (url != null) {
            try {
                PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                t = factory.create(url.openStream(), new NHXParser())[0];
            }
            catch (Exception e) {
                System.out.println("ATVapplet: ");
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "ATVapplet: Could not read Phylogeny: \nException: " + e, "Could not read Phylogeny", 0);
                this.close();
            }
        }
        if (t != null && !t.isEmpty()) {
            this.reload_tree_ = t.copy();
        } else {
            System.out.println("ATVapplet: Phylogeny is null or empty.");
            this.reload_tree_ = null;
        }
        this.config_settings = new ATVConfig(this.config_filename, true, true);
        this.atvpanel = new ATVpanel_applet(t, this.config_settings, this);
        this.jmenubar = new JMenuBar();
        this.jmenubar.setBackground(ATVconstants.MENU_BACKGROUND_COLOR_DEFAULT);
        this.buildFileMenu();
        this.buildEditMenu();
        this.buildViewMenu();
        this.buildOptionsMenu();
        this.buildHelpMenu();
        this.setJMenuBar(this.jmenubar);
        this.contentpane = this.getContentPane();
        this.contentpane.setLayout(new BorderLayout());
        this.contentpane.add((Component)this.atvpanel, "Center");
        this.setSize(640, 580);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ATVappletFrame.this.close();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ATVappletFrame.this.atvpanel.getATVtreePanel().setParametersForPainting(ATVappletFrame.this.atvpanel.getATVtreePanel().getWidth(), ATVappletFrame.this.atvpanel.getATVtreePanel().getHeight());
            }
        });
        this.setVisible(true);
    }

    public ATVapplet getATVapplet() {
        return this.atvapplet;
    }

    public ATVpanel getATVpanel() {
        return this.atvpanel;
    }

    protected void openURL() {
        URL url = null;
        Phylogeny t = null;
        String message = "Please enter a complete URL. Must refer to same server as provided this Applet.";
        String url_string = JOptionPane.showInputDialog(this, message, "Open URL to read a NH/NHX tree", 3);
        if (url_string != null && url_string.length() > 4) {
            try {
                url = new URL(url_string);
            }
            catch (Exception e) {
                System.out.println("ATVapplet: ");
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "ATVapplet: openURL(): Exception: " + e, "Malformed URL", 0);
            }
            if (url != null) {
                try {
                    PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                    t = factory.create(url.openStream(), new NHXParser())[0];
                }
                catch (Exception e) {
                    System.out.println("ATVapplet: ");
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "ATVapplet: openURL(): \nException: " + e, "Could not read Phylogeny", 0);
                }
                if (t != null) {
                    this.reload_tree_ = t.copy();
                    this.removeatvtextframe();
                    this.atvpanel.terminate();
                    this.contentpane.removeAll();
                    this.atvpanel = new ATVpanel_applet(t, this.config_settings, this);
                    this.jmenubar.remove(this.help_jmenu);
                    this.jmenubar.add(this.help_jmenu);
                    this.contentpane.add((Component)this.atvpanel, "Center");
                    this.setVisible(true);
                    this.contentpane.repaint();
                    this.setTitle("ATV: " + url);
                    this.atvpanel.getATVcontrol().showWhole();
                }
            }
        }
    }

    protected void reLoad() {
        boolean do_reload_tree;
        int retval = JOptionPane.showConfirmDialog(this, "Are you sure you want to undo all of your changes?", "Verify Reload", 0);
        boolean bl = do_reload_tree = retval == 0;
        if (do_reload_tree && this.reload_tree_ != null && !this.reload_tree_.isEmpty()) {
            Phylogeny t = this.reload_tree_.copy();
            this.removeatvtextframe();
            this.atvpanel.terminate();
            this.contentpane.removeAll();
            this.atvpanel = new ATVpanel_applet(t, this.config_settings, this);
            this.contentpane.add((Component)this.atvpanel, "Center");
            this.setVisible(true);
            this.contentpane.repaint();
            this.atvpanel.getATVcontrol().showWhole();
        }
    }
}

