/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.io.IOException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import org.forester.atv.ATVappletFrame;

public class ATVapplet
extends JApplet {
    private ATVappletFrame atvappletframe;
    private String url_string = "";
    private String level_string = "";
    private String message1 = "";
    private String message2 = "";
    private static final Color background_color = new Color(100, 100, 100);
    private static final Color font_color = new Color(255, 51, 0);
    private static final Color ex_background_color = new Color(0, 0, 0);
    private static final Color ex_font_color = new Color(255, 0, 0);
    private static final Font font = new Font("Helvetica", 1, 9);
    private boolean exception;

    public void init() {
        this.exception = false;
        this.setName("ATV JApplet");
        this.url_string = this.getParameter("url_of_tree_to_load");
        System.out.println("ATVapplet: URL of tree to load: \"" + this.url_string + "\"");
        this.setBackground(background_color);
        this.setForeground(font_color);
        this.setFont(font);
        this.repaint();
        String s = null;
        try {
            s = System.getProperty("java.version");
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        if (s != null && s.length() > 0) {
            this.message2 = "[Your Java version: " + s + "]";
            this.repaint();
        }
        String config_filename = this.getParameter("config_file");
        try {
            this.atvappletframe = new ATVappletFrame(this, config_filename);
            this.atvappletframe.getATVpanel().getATVcontrol().showWhole();
            this.atvappletframe.getATVpanel().adjustJScrollPane();
            this.atvappletframe.getATVpanel().getATVtreePanel().repaint();
        }
        catch (Exception e) {
            this.setBackground(ex_background_color);
            this.setForeground(ex_font_color);
            this.exception = true;
            this.message1 = "Exception: " + e;
            System.out.println("ATVapplet: " + e);
            e.printStackTrace();
            this.repaint();
        }
        if (!this.exception) {
            this.message1 = "ATV Applet is now ready!";
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        g.drawString(this.message2, 10, 20);
        g.drawString(this.message1, 10, 40);
    }

    String getURLstring() {
        return this.url_string;
    }

    String getLevelString() {
        return this.level_string;
    }

    void go(URL url) throws IOException {
        AppletContext context = this.getAppletContext();
        try {
            context.showDocument(url, "ATV");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, String.valueOf(e.toString()) + "\nURL = " + url, "Exception in ATVapplet", 0);
            throw new IOException(e.toString());
        }
    }

    public void destroy() {
        if (this.atvappletframe != null) {
            this.atvappletframe.close();
        }
    }
}

