/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.io.File;
import org.forester.atv.ATVapplicationFrame;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.parsers.nhx.NHXParser;
import org.forester.phylogeny.parsers.xml.SimplePhyloXMLParser1;

public class ATVapp {
    public static void main(String[] args) {
        Phylogeny p = null;
        Phylogeny tree = null;
        String config_filename = null;
        try {
            int filename_index = 0;
            if (args.length > 0) {
                if (args[0].startsWith("-c")) {
                    config_filename = args[1];
                    filename_index += 2;
                }
                if (args.length > filename_index) {
                    File f = new File(args[filename_index]);
                    PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                    System.out.println("startup file: " + f.getName() + " exists: " + f.exists());
                    p = f.getName().toLowerCase().endsWith(".xml") ? factory.create(f, new SimplePhyloXMLParser1())[0] : factory.create(f, new NHXParser())[0];
                }
            }
        }
        catch (Exception e) {
            System.out.println();
            System.out.println("Failure during startup of ATVapp:");
            System.out.println(e.getMessage());
            System.out.println();
            System.exit(-1);
        }
        if (p != null) {
            tree = p;
        }
        String curDir = System.getProperty("user.dir");
        System.out.println("working directory: " + curDir);
        ATVapplicationFrame atvframe = new ATVapplicationFrame(tree, config_filename);
    }
}

