/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.forester.atv.TreeColorSet;
import org.forester.atv.TreeFontSet;

public class ATVConfig {
    boolean config_writeable;
    String config_filename;
    String default_config_filename = "ATVConfig.conf";
    boolean tree_editable = true;
    public static final int use_real_br_lengths = 0;
    public static final int seq_name_internal_nodes = 1;
    public static final int seq_name_ext_nodes = 2;
    public static final int species_internal_nodes = 3;
    public static final int species_ext_nodes = 4;
    public static final int ec_internal_nodes = 5;
    public static final int ec_ext_nodes = 6;
    public static final int write_br_length_values = 7;
    public static final int write_bootstrap_values = 8;
    public static final int write_dup_spec = 9;
    public static final int color_orthologous = 10;
    public static final int color_super_orthologous = 11;
    public static final int color_subtree_neighbors = 12;
    public static final int color_according_to_species = 13;
    public static final int color_branches = 14;
    public static final int width_branches = 15;
    public static final int mark_nodes_with_box = 16;
    String[][] display_options = new String[][]{{"real branch lengths", "display", "yes"}, {"seq name int nodes", "display", "no"}, {"seq name ext nodes", "display", "yes"}, {"species int nodes", "nodisplay", "no"}, {"species ext nodes", "display", "no"}, {"int EC names", "nodisplay", "no"}, {"ext EC names", "nodisplay", "no"}, {"branch length values", "display", "no"}, {"bootstrap values", "display", "no"}, {"write_dup_spec", "nodisplay", "no"}, {"display orthology", "nodisplay", "no"}, {"display s-orthology", "nodisplay", "no"}, {"display subtr-neighbors", "nodisplay", "no"}, {"color species", "display", "no"}, {"color branches", "nodisplay", "no"}, {"width branches", "nodisplay", "no"}, {"show node boxes", "display", "yes"}};
    public static final int edit_info = 0;
    public static final int collapse_uncollapse = 1;
    public static final int reroot = 2;
    public static final int subtree = 3;
    public static final int swap = 4;
    public static final int display_sequences = 5;
    public static final int go_to_swiss_prot = 6;
    public static final int display_node_popup = 7;
    public static final int display_glyph_popup = 8;
    public static final int custom_option = 9;
    String[][] clickto_options = new String[][]{{"display editable info", "display"}, {"collapse/uncollapse", "display"}, {"root/reroot", "display"}, {"get subtree/parent tree", "display"}, {"swap", "display"}, {"display sequences", "display"}, {"go to swiss prot", "nodisplay"}, {"display popup", "nodisplay"}, {"display glyph popup", "nodisplay"}, {"custom option", "nodisplay"}};
    int default_clickto = 0;
    TreeColorSet tree_color_set;
    TreeFontSet tree_font_set;
    Hashtable species_colors = new Hashtable();
    String node_popup_title;
    String node_popup_URL;
    String sequence_popup_URL;
    public static final int glyph_none = 0;
    public static final int glyph_expression = 1;
    public static final int glyph_chromosome = 2;
    int glyph_type = 0;

    public ATVConfig(String cf, boolean is_url, boolean is_applet) {
        this.config_filename = cf == null || cf.length() == 0 ? this.default_config_filename : cf;
        this.config_filename = this.config_filename.trim();
        URL u = null;
        if (is_url) {
            try {
                u = new URL(this.config_filename);
                try {
                    InputStreamReader isr = new InputStreamReader(u.openStream());
                    BufferedReader bf = new BufferedReader(isr);
                    this.readConfig(bf);
                    bf.close();
                }
                catch (Exception e) {
                    System.out.println("Exception encountered while opening read stream for config file, " + this.config_filename + ": " + e.toString());
                }
            }
            catch (Exception e) {
                System.out.println("Cannot find or open config url, " + this.config_filename);
            }
        } else {
            File f = new File(this.config_filename);
            String path = f.getAbsolutePath();
            if (f.exists() && f.canRead()) {
                try {
                    BufferedReader bf = new BufferedReader(new FileReader(f));
                    this.readConfig(bf);
                    bf.close();
                }
                catch (Exception e) {
                    System.out.println("Exception encountered while opening read stream for config file, " + this.config_filename + ": " + e.toString());
                }
            } else {
                System.out.println("Cannot find or read config file, " + f.getAbsolutePath());
            }
        }
        this.sanityCheck(is_applet);
    }

    public boolean doCheckOption(int which) {
        return this.display_options[which][2].equals("yes");
    }

    public boolean doDisplayClickToOption(int which) {
        return this.clickto_options[which][1].equals("display");
    }

    public boolean doDisplayOption(int which) {
        return this.display_options[which][1].equals("display");
    }

    private int getClickToIndex(String name) {
        int index = -1;
        if (name.equals("edit_info")) {
            index = 0;
        } else if (name.equals("collapse_uncollapse")) {
            index = 1;
        } else if (name.equals("reroot")) {
            index = 2;
        } else if (name.equals("subtree")) {
            index = 3;
        } else if (name.equals("swap")) {
            index = 4;
        } else if (name.equals("display_sequences")) {
            index = 5;
        } else if (name.equals("go_to_swiss_prot")) {
            index = 6;
        } else if (name.equals("display_node_popup")) {
            index = 7;
        } else if (name.equals("display_glyph_popup")) {
            index = 8;
        } else if (name.equals("custom_option")) {
            index = 9;
        }
        return index;
    }

    public int getClickToOptionsCount() {
        return this.clickto_options.length;
    }

    public String getClickToTitle(int which) {
        return this.clickto_options[which][0];
    }

    public int getDefaultDisplayClicktoOption() {
        return this.default_clickto;
    }

    public String getDisplayNodePopupTitle() {
        return this.node_popup_title;
    }

    public String getDisplayTitle(int which) {
        return this.display_options[which][0];
    }

    public int getGlyphType() {
        return this.glyph_type;
    }

    public String getNodePopupURL() {
        return this.node_popup_URL;
    }

    public String getSequencePopupURL() {
        return this.sequence_popup_URL;
    }

    public Hashtable getSpeciesColors() {
        return this.species_colors;
    }

    public TreeColorSet getTreeColorSet() {
        return null;
    }

    public TreeFontSet getTreeFontSet() {
        return null;
    }

    public boolean isTreeEditable() {
        return this.tree_editable;
    }

    private void readConfig(BufferedReader conf_in) {
        try {
            String line;
            do {
                if ((line = conf_in.readLine()) == null || (line = line.trim()).startsWith("#") || line.length() == 0) continue;
                line = line.replaceAll("\\s+", "\t");
                StringTokenizer st = new StringTokenizer(line, "\t");
                this.setKeyValue(st);
            } while (line != null);
        }
        catch (Exception e) {
            System.out.println("Exception while reading config file: " + e.toString());
        }
    }

    private void sanityCheck(boolean is_applet) {
        if (!is_applet) {
            this.clickto_options[6][1] = "nodisplay";
            this.clickto_options[7][1] = "nodisplay";
        }
    }

    private void setKeyValue(StringTokenizer st) {
        String key = (String)st.nextElement();
        key = key.replace(':', ' ');
        if ((key = key.trim()).equals("editable")) {
            this.tree_editable = ((String)st.nextElement()).equals("yes");
        } else if (key.equals("sequence_popup_URL")) {
            if (st.hasMoreElements()) {
                this.sequence_popup_URL = (String)st.nextElement();
            }
        } else if (key.equals("node_popup_URL")) {
            if (st.hasMoreElements()) {
                this.node_popup_URL = (String)st.nextElement();
            }
        } else if (key.equals("node_popup_title")) {
            this.node_popup_title = "";
            while (st.hasMoreElements()) {
                this.node_popup_title = String.valueOf(this.node_popup_title) + (String)st.nextElement() + " ";
            }
            this.node_popup_title = this.node_popup_title.replaceAll("\"", "");
            this.node_popup_title = this.node_popup_title.trim();
        } else if (key.equals("default_click_to")) {
            String clickto_name = (String)st.nextElement();
            this.default_clickto = this.getClickToIndex(clickto_name);
            if (this.default_clickto == -1) {
                System.out.println("Invalid default clickto name: " + clickto_name);
                this.default_clickto = 0;
            }
        } else if (key.equals("custom_option_label")) {
            String s = "";
            while (st.hasMoreElements()) {
                s = String.valueOf(s) + (String)st.nextElement() + " ";
            }
            s = s.replaceAll("\"", "");
            this.clickto_options[9][0] = s = s.trim();
        } else if (key.equals("glyph_type")) {
            String glyph_name = (String)st.nextElement();
            if (glyph_name.equals("expression")) {
                this.glyph_type = 1;
            } else if (glyph_name.equals("chromosome")) {
                this.glyph_type = 2;
            } else if (glyph_name.equals("none")) {
                this.glyph_type = 0;
            } else {
                System.out.println("Unknown glyph type: " + glyph_name);
            }
        } else if (st.countTokens() >= 2) {
            int key_index = -1;
            if (key.equals("use_real_br_lengths")) {
                key_index = 0;
            } else if (key.equals("color_according_to_species")) {
                key_index = 13;
            } else if (key.equals("seq_name_ext_nodes")) {
                key_index = 2;
            } else if (key.equals("seq_name_internal_nodes")) {
                key_index = 1;
            } else if (key.equals("species_ext_nodes")) {
                key_index = 4;
            } else if (key.equals("species_internal_nodes")) {
                key_index = 3;
            } else if (key.equals("ec_ext_nodes")) {
                key_index = 6;
            } else if (key.equals("ec_internal_nodes")) {
                key_index = 5;
            } else if (key.equals("write_br_length_values")) {
                key_index = 7;
            } else if (key.equals("write_bootstrap_values")) {
                key_index = 8;
            } else if (key.equals("write_dup_spec")) {
                key_index = 9;
            } else if (key.equals("color_branches")) {
                key_index = 14;
            } else if (key.equals("width_branches")) {
                key_index = 15;
            } else if (key.equals("color_orthologous")) {
                key_index = 10;
            } else if (key.equals("color_subtree_neighbors")) {
                key_index = 12;
            } else if (key.equals("color_super_orthologous")) {
                key_index = 11;
            } else if (key.equals("mark_nodes_with_box")) {
                key_index = 16;
            }
            if (key_index >= 0) {
                this.display_options[key_index][1] = (String)st.nextElement();
                this.display_options[key_index][2] = (String)st.nextElement();
            } else if (key.equals("click_to")) {
                String click_to_name = (String)st.nextElement();
                key_index = this.getClickToIndex(click_to_name);
                if (key_index >= 0) {
                    this.clickto_options[key_index][1] = (String)st.nextElement();
                } else {
                    System.out.println("Unknown click-to option: " + click_to_name);
                }
            } else if (key.equals("species_color")) {
                this.species_colors.put(st.nextElement(), Color.decode((String)st.nextElement()));
            } else {
                System.out.println("Unknown config key: " + key);
            }
        } else {
            System.out.println("Unknown config key: " + key);
        }
    }
}

