/*
 * Decompiled with CFR 0.152.
 */
package org.forester.atv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.forester.atv.TreeColorSet;

public class ATVColorSchemeChooser
extends JDialog
implements ActionListener {
    TreeColorSet colorset;
    JComboBox selector;
    JPanel color_panel;
    JPanel[] color_labels;
    int selected_scheme;
    JButton okbtn;
    JButton cancelbtn;

    public ATVColorSchemeChooser(Frame parent, TreeColorSet colorset) {
        super(parent, "Choose Color Scheme", true);
        this.colorset = colorset;
        this.setSize(400, 350);
        Container contentpane = this.getContentPane();
        contentpane.setLayout(new BorderLayout(5, 15));
        JPanel select_panel = new JPanel();
        JLabel l = new JLabel("Choose a color scheme:");
        select_panel.add(l);
        Vector<String> list = new Vector<String>();
        int i = 0;
        while (i < TreeColorSet.scheme_names.length) {
            list.add(TreeColorSet.scheme_names[i]);
            ++i;
        }
        this.selector = new JComboBox(list);
        this.selector.setPreferredSize(new Dimension(100, 20));
        this.selector.getModel().addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent e) {
            }

            public void intervalRemoved(ListDataEvent e) {
            }

            public void contentsChanged(ListDataEvent e) {
                int selection = ATVColorSchemeChooser.this.selector.getSelectedIndex();
                ATVColorSchemeChooser.this.changeDialogColors(selection);
            }
        });
        select_panel.add(this.selector);
        contentpane.add((Component)select_panel, "North");
        int num_colors = TreeColorSet.color_fields.length;
        this.color_panel = new JPanel(new GridLayout(num_colors, 2, 8, 0));
        JLabel[] headings = new JLabel[num_colors];
        this.color_labels = new JPanel[num_colors];
        int i2 = 0;
        while (i2 < num_colors) {
            headings[i2] = new JLabel(TreeColorSet.color_fields[i2]);
            headings[i2].setFont(new Font("Sans Serif", 0, 9));
            headings[i2].setHorizontalAlignment(4);
            this.color_panel.add(headings[i2]);
            this.color_labels[i2] = new JPanel();
            this.color_labels[i2].setPreferredSize(new Dimension(15, 40));
            this.color_panel.add(this.color_labels[i2]);
            ++i2;
        }
        contentpane.add((Component)this.color_panel, "Center");
        this.setColors(TreeColorSet.color_schemes[0]);
        JPanel btn_panel = new JPanel();
        this.okbtn = new JButton("OK");
        this.okbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ATVColorSchemeChooser.this.ok();
            }
        });
        btn_panel.add(this.okbtn);
        this.cancelbtn = new JButton("Cancel");
        this.cancelbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ATVColorSchemeChooser.this.ok();
            }
        });
        btn_panel.add(this.cancelbtn);
        btn_panel.setPreferredSize(new Dimension(400, 30));
        this.getContentPane().add((Component)btn_panel, "South");
        this.setCurrentColor(colorset.getCurrentColorScheme());
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void cancel() {
        this.selected_scheme = -1;
        this.setVisible(false);
    }

    public void changeDialogColors(int scheme_index) {
        this.selected_scheme = scheme_index;
        this.setColors(TreeColorSet.color_schemes[scheme_index]);
    }

    public int getScheme() {
        return this.selected_scheme;
    }

    public void ok() {
        this.colorset.setColors(this.selected_scheme);
        this.setVisible(false);
    }

    private void setColors(Color[] colors) {
        int i = 0;
        while (i < colors.length) {
            this.color_labels[i].setBackground(colors[i]);
            ++i;
        }
    }

    public void setCurrentColor(int color_index) {
        this.setColors(TreeColorSet.color_schemes[color_index]);
        this.selector.setSelectedIndex(color_index);
    }
}

