/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2008) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * BinnedData.java
 *
 * Created on October 29, 2007, 3:39 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.broad.igv.preprocess;

import java.util.List;

/**
 *
 * @author jrobinso
 */
public class BinnedData {
    
    /** Zoom level represented by this collection of bins */
    int zoomLevel;
    
    /** LocationBin size (or scale)  */
    double binSize;
    
    /** The mean number of data points in a bin */
    private double meanCount;
    
    /** The median number of data points in a bin */
    private double medianCount;
    
    /** The maximum # of data points in a bin */
    private double maxCount;
    
    private double percentile10;
    
    /** The 90th percentile */
    private double percentile90;
    
    /** The number of data points per bin */
    private int [] nPts;
    
    /** The bins */
    private List<? extends Bin> bins;
    
    /** Tile boundaries.  Tiles are fixed length in genomic coordinates */
    private int [] tileBoundaries;
    
    public BinnedData(int zoomLevel, double binSize, List<? extends Bin> bins, int [] tileBoundaries) {
        this.zoomLevel = zoomLevel;
        this.binSize = binSize;
        this.bins = bins;
        this.tileBoundaries = tileBoundaries;
    }
    
    public int getZoomLevel() {
        return zoomLevel;
    }
    
    public  List<? extends Bin> getBins() {
        return bins;
    }
    
    
    public int [] getLocations() {
        int []  locations = new int[bins.size()];
        for(int i=0; i<bins.size(); i++) {
            locations[i] = bins.get(i).getStart();
        }
        return locations;
    }
    
    /** Used for feature processing */
    public float [] getCounts() {
        float []  nPts = new float[bins.size()];
        for(int i=0; i<bins.size(); i++) {
            nPts[i] = bins.get(i).getFeatureCount();
        }
        return nPts;
    }
    
    public int [] getTileBoundaries() {
        return tileBoundaries;
    }
    
    public double getBinSize() {
        return binSize;
    }
    
    public double getMeanCount() {
        return meanCount;
    }
    
    public void setMeanCount(double meanCount) {
        this.meanCount = meanCount;
    }
    
    public double getMedianCount() {
        return medianCount;
    }
    
    public void setMedianCount(double medianCount) {
        this.medianCount = medianCount;
    }

    
    public double getMaxCount() {
        return maxCount;
    }
    
    public void setMaxCount(double maxCount) {
        this.maxCount = maxCount;
    }

    public double getPercentile90Count() {
        return percentile90;
    }

    public void setPercentile90(double percentile90) {
        this.percentile90 = percentile90;
    }

    public double getPercentile10() {
        return percentile10;
    }

    public void setPercentile10(double percentile10) {
        this.percentile10 = percentile10;
    }
}
