/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2008) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * GenomeManager.java
 *
 * Created on November 9, 2007, 9:12 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.broad.igv.feature;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author jrobinso
 */
public class GenomeManager {
    
    private static GenomeManager theInstance = null;
    private Map<String, Genome> genomeMap;
    
    /** Creates a new instance of GenomeManager */
    private GenomeManager() {
        genomeMap = new HashMap();
    }
    
    public static synchronized GenomeManager getInstance() {
        if(theInstance == null) {
            theInstance = new GenomeManager();
        }
        return theInstance;
    }
        
    /**
     * Return the genome identified by the id (e.g. mm8, hg17, etc).
     * TODO -- need to handle case of cytoband file not found
     */
    public Genome getGenome(String id) {       
        Genome genome = genomeMap.get(id);
        if(genome == null){
            genome = new Genome(id);
            String cytobandFile = "/resources/" + id + "_cytoBand.txt";
            InputStream is = GenomeManager.class.getResourceAsStream(cytobandFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            genome.setChromosomeMap(CytoBandFileParser.loadData(reader));
        }
        return genome;
        
    }
    
    
}
