/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2008) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * Genome.java
 *
 * Created on November 9, 2007, 9:05 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.broad.igv.feature;

import java.util.Collection;
import java.util.LinkedHashMap;

/**
 * Simple model of a genome, essesntially a collection of cytobands.
 */
public class Genome {

    private String name;
    private LinkedHashMap<String, Chromosome> chromosomeMap;
    long length = -1;

    /** Creates a new instance of Genome */
    public Genome(String name) {
        this.name = name;
        setChromosomeMap(new LinkedHashMap(24));
    }

    public void setChromosomeMap(LinkedHashMap<String, Chromosome> chromosomeMap) {
        this.chromosomeMap = chromosomeMap;
    }

    public Chromosome getChromosome(String chrName) {
        return chromosomeMap.get(chrName);
    }

    public Collection<String> getChromosomeNames() {
        return chromosomeMap.keySet();
    }

    public Collection<Chromosome> getChromosomes() {
        return chromosomeMap.values();
    }

    public long getLength() {
        if (length < 0) {
            length = 0;
            for (Chromosome chr : chromosomeMap.values()) {
                length += chr.getLength();
            }
        }
        return length;
    }

    public long getCumulativeOffset(String chr) {      
        long offset = 0;
        for (String c : getChromosomeNames()) {
            if(chr.equals(c)) break;
            offset += getChromosome(chr).getLength();
        }
        return offset;
    }

    public String getName() {
        return name;
    }
}
