/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2008) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

package org.broad.igv.feature;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author jrobinso
 */
public class Chromosome {
    private String name;
    private int centrimere = 0;
    private List<Cytoband> cytobands;
    private int length = 0;

    public Chromosome(String name) {

        this.name = name;
        cytobands = new ArrayList<Cytoband>();
    }

    public int getCentrimere() {
        return centrimere;
    }

    public void setCentrimere(int centrimere) {
        this.centrimere = centrimere;
    }

    public List<Cytoband> getCytobands() {
        return cytobands;
    }

    public void setCytobands(List<Cytoband> cytobands) {
        this.cytobands = cytobands;
    }

    /**
     * Add a cytoband.  If the band is a centrimere and the centrimere location
     * has not been initialized set it.
     */
    public void addCytoband(Cytoband band) {

        cytobands.add(band);
        if ((band.getType() == 'c') && (centrimere == 0)) {
            centrimere = band.getEnd();
        }
        length = Math.max(length, band.getEnd());
    }
    
    /**
     * Return the length of the chromosome, which is the end of the last cytoband
     */
    public int getLength() {
        return length;
    }

    public String getName() {
        return name;
    }

}
