/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2008) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
package org.broad.igv.data.wgs;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

/**
 *
 * @author jrobinso
 */
public class Test {

    public static void main(String[] args) {
        DataInputStream dis = null;
        File inputFile = new File("/Users/jrobinso/IGV/SeqTrack/chr17.bin");
        int start = 7532916;
        int end  = 7532965;
        try
        {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(inputFile)));
            dis.skip(start * Short.SIZE / 8);

            for (int i = 0; i < (end - start); i++)
            {
                if (dis.available() >= (Short.SIZE / 8))
                {
                    System.out.println(start + i + "\t" + dis.readShort());
                }
            }
            dis.close();
        } catch (IOException e)
        {
            e.printStackTrace();

        } finally
        {
            try
            {
                dis.close();
            } catch (IOException ex)
            {
                ex.printStackTrace();
            }
        }
    }
}

