/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2008) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/



package org.broad.igv.util;

//~--- JDK imports ------------------------------------------------------------

import java.awt.Color;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;




/**
 * Class description
 *
 *
 * @version    Enter version here..., 08/11/13
 * @author     Enter your name here...    
 */
public class ColorUtilities {
    
    private static Logger log = Logger.getLogger(ColorUtilities.class);

    private static double ln2 = Math.log(2);

    /**
     * Method description
     *
     *
     * @param idx
     * @param alpha
     *
     * @return
     */
    public static Color randomColor(int idx, int alpha) {

        int col1 = 0;
        int col2 = 0;
        int col3 = 0;

        int BASE_COL = 40;
        int RAND_COL = 255 - BASE_COL;

        idx += 1;    // avoid 0
        col1 = Math.abs(BASE_COL + (idx * 33) % RAND_COL);
        col2 = Math.abs(BASE_COL + (idx * 55) % RAND_COL);
        col3 = Math.abs(BASE_COL + (idx * 77) % RAND_COL);

        return new Color(col1, col2, col3, alpha);
    }

    /**
     * Port of DChip function of the same name.
     *
     * @param idx
     *
     * @return
     */
    public static Color randomColor(int idx) {

        int col1 = 0;
        int col2 = 0;
        int col3 = 0;

        int BASE_COL = 40;
        int RAND_COL = 255 - BASE_COL;

        idx += 1;    // avoid 0
        col1 = Math.abs(BASE_COL + (idx * 33) % RAND_COL);
        col2 = Math.abs(BASE_COL + (idx * 55) % RAND_COL);
        col3 = Math.abs(BASE_COL + (idx * 77) % RAND_COL);

        return new Color(col1, col2, col3);
    }

    /**
     *
     *
     * @param idx
     *
     * @return
     */
    public static Color getSubtleColor(int idx) {

        int red = 0;
        int green = 0;
        int blue = 0;

        if ((idx >= 0) && (idx <= 255))
        {

            int base = 255 - idx;

            red = base;
            green = base;
            blue = 255;
        }
        else if ((idx >= 256) && (idx <= 511))
        {

            int base = (255 * 2) - idx;

            red = 255;
            green = base;
            blue = base;
        }
        else if ((idx >= 512) && (idx <= 768))
        {

            int base = (255 * 3) - idx;

            red = base;
            green = 255;
            blue = base;
        }

        return new Color(red, green, blue);    // .getHSBColor(.4f, .4f, .4f);
    }

    private static void testColorValueRange(int r, int g, int b, int a) {
        boolean rangeError = false;
        String badComponentString = "";

        if ((a < 0) || (a > 255))
        {
            rangeError = true;
            badComponentString = badComponentString + " Alpha";
        }
        if ((r < 0) || (r > 255))
        {
            rangeError = true;
            badComponentString = badComponentString + " Red";
        }
        if ((g < 0) || (g > 255))
        {
            rangeError = true;
            badComponentString = badComponentString + " Green";
        }
        if ((b < 0) || (b > 255))
        {
            rangeError = true;
            badComponentString = badComponentString + " Blue";
        }
        if (rangeError == true)
        {
            throw new IllegalArgumentException("Color parameter outside of expected range:"
                                               + badComponentString);
        }
    }

    private static float[] hsbvals = new float[3];

    /**
     * Method description
     *
     *
     * @param inputColor
     * @param hue
     * @param saturation
     * @param brightness
     *
     * @return
     */
    public static Color adjustHSB(Color inputColor, float hue, float saturation, float brightness) {
        Color.RGBtoHSB(inputColor.getRed(), inputColor.getGreen(), inputColor.getBlue(), hsbvals);
        return Color.getHSBColor(hue * hsbvals[0], saturation * hsbvals[1],
                                 brightness * hsbvals[2]);
    }

    
    public static String convertColorToRGBString(Color color) {
        
        StringBuffer buffer = new StringBuffer();
        buffer.append(color.getRed());
        buffer.append(",");
        buffer.append(color.getGreen());
        buffer.append(",");
        buffer.append(color.getBlue());
        return buffer.toString();
    }
    
    public static Color convertRGBStringToColor(String commaSeparatedRGB) {
        
        String rgb[] = commaSeparatedRGB.split(",");
        Color color = new Color(
            Integer.parseInt(rgb[0]),
            Integer.parseInt(rgb[1]),
            Integer.parseInt(rgb[2])
        );
        return color;
    }
    
    /**
     * Method description
     *
     *
     * @param color
     *
     * @return
     */
    public static Color getColorFromString(String string) {
        try
        {
            String[] rgb = string.split(",");
            int red = Integer.parseInt(rgb[0]);
            int green = Integer.parseInt(rgb[1]);
            int blue = Integer.parseInt(rgb[2]);
            return new Color(red, green, blue);

        } catch (NumberFormatException numberFormatException)
        {
            log.error("Error in color string. ", numberFormatException);
            return null;
        }

    }
}
