/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2008) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.track;

/**
 *
 * @author jrobinso
 */
public enum WindowFunction {
    
    mean("Mean"), 
    median("Median"), 
    min("Minimum"), 
    max("Maximum"), 
    percentile10("10th Percentile"), 
    percentile90("90th Percentile"), 
    percentile98("98th Percentile"), 
    stddev("Standard Deviation"),
    count("Count"), 
    density("Density");
    
    private String displayName = "";
    WindowFunction(String displayName) {
        this.displayName = displayName;
    }
    
    public String getDisplayName() {
        return displayName;
    }
    
    static public WindowFunction getWindowFunction(String name) {
        
        WindowFunction windowFunction = null;
        if(WindowFunction.mean.name().equals(name)) {
            windowFunction = WindowFunction.mean;
        }
        else
        if(WindowFunction.median.name().equals(name)) {
            windowFunction = WindowFunction.median;
        }
        else
        if(WindowFunction.min.name().equals(name)) {
            windowFunction = WindowFunction.min;
        }
        else
        if(WindowFunction.max.name().equals(name)) {
            windowFunction = WindowFunction.max;
        }
        else
        if(WindowFunction.percentile10.name().equals(name)) {
            windowFunction = WindowFunction.percentile10;
        }
        else
        if(WindowFunction.percentile90.name().equals(name)) {
            windowFunction = WindowFunction.percentile90;
        }
        else
        if(WindowFunction.percentile98.name().equals(name)) {
            windowFunction = WindowFunction.percentile98;
        }
        else
        if(WindowFunction.stddev.name().equals(name)) {
            windowFunction = WindowFunction.stddev;
        }
        else
        if(WindowFunction.count.name().equals(name)) {
            windowFunction = WindowFunction.count;
        }
        else
        if(WindowFunction.density.name().equals(name)) {
            windowFunction = WindowFunction.density;
        }
        return windowFunction;
    }
}
