/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2008) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * RangeBin.java
 *
 * Created on October 29, 2007, 3:40 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.broad.igv.preprocess;

/**
 * Represents a tile bin.
 *   start -- start location of the bin
 *   features --  list of features that partially or fully overlap the bin
 * 
 * // TODO = this is a mix of two types, a feature type bin and snp type bin.  
 * //        the feature bin uses the "features" collection, snp type uses
 *           startIndex / endIndex.
 * //        refactor to combine both or split.
 * @author jrobinso
 */
public class RangeBin implements Bin {

    private int startIndex;  // <- inclusive
    private int endIndex;   // <- exclusive
    private int start;


    public RangeBin(int location) {
        this.start = location;
    }



    public int getFeatureCount() {

            return endIndex - startIndex;

    }


    public int getStart() {
        return start;
    }

    
    public int getStartIndex() {
        return startIndex;
    }

    public int getEndIndex() {
        return endIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }
    
    
}

