/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.preprocess;


import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.broad.igv.feature.ParsingUtils;

/**
 *            reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
String nextLine;

// Create a buffer to hold tokens;
String[] tokens = new String[20];
while ((nextLine = reader.readLine()) != null && (nextLine.trim().length() > 0))
{
nextLine = nextLine.trim();
if(nextLine.startsWith("#")) {
continue;
}

char separator = (type == FileType.ALIGNED) ? '\t' : ' ';
int nTokens = ParsingUtils.split(nextLine, tokens, separator);
try
{
if ((type == FileType.ALIGNED && nTokens >= 3) ||
(type == FileType.REALIGNED && nTokens >= 4))

{

 * @author jrobinso
 */
public class MAQFileIterator implements AlignmentFileIterator {

    enum FileType {

        ALIGNED, REALIGNED
    };
    static FileType type = FileType.ALIGNED;
    BufferedReader reader;
    String nextLine = null;
    Alignment nextAlignment;
    boolean closed;
    String[] tokens = new String[10];

    public MAQFileIterator(File file) throws IOException {

        type = (file.getName().endsWith("realign") || file.getName().endsWith(
                "realign.txt"))
                ? FileType.REALIGNED : FileType.ALIGNED;
        reader = new BufferedReader(new InputStreamReader(new FileInputStream(
                file)));
        advance();
    }

    private void advance() throws IOException {
        nextAlignment = null;
        while ((nextLine = reader.readLine()) != null) {
            nextLine = nextLine.trim();
            if (nextLine.startsWith("#")) {
                continue;
            }

            char separator = (type == FileType.ALIGNED) ? '\t' : ' ';
            int nTokens = ParsingUtils.split(nextLine, tokens, separator);

            if ((type == FileType.ALIGNED && nTokens >= 3) ||
                    (type == FileType.REALIGNED && nTokens >= 4)) {
                nextAlignment = (type == FileType.ALIGNED) ? getAlignment(tokens,
                        nTokens) : getAlignmentSolexa(tokens, nTokens);
                break;
            }
        }

    }

    public boolean hasNext() {
        return !closed && nextAlignment != null;
    }

    public Alignment next() throws IOException {
        Alignment retValue = nextAlignment;
        advance();
        return retValue;
    }

    public void close() throws IOException {
        reader.close();
        closed = true;
    }

    private Alignment getAlignment(String[] tokens, int nTokens) {
        String chr = tokens[0];
        int start = new Integer(tokens[1]);
        int end = new Integer(tokens[2]);
        boolean strand = false;
        if (nTokens > 3) {
            strand = tokens[3].trim().equals("-");
        }
        return new Alignment(chr, start, end, strand);
    }

    // GTTACATTTTTCAGTATAAAGTTAGTGTAGTATTC 17500 1 9:34004972 R GAATACTACACTAACTTTATACTGAAAAATGTAAC 14359
    static String[] locusBuf = new String[2];

    private Alignment getAlignmentSolexa(String[] tokens, int nTokens) {
        String sequence = tokens[0];
        String locusString = tokens[3];
        String strandString = tokens[4];

        ParsingUtils.split(locusString, locusBuf, ':');

        String chr = "chr" + locusBuf[0];
        int start = new Integer(locusBuf[1]);
        int end = start + sequence.length();
        boolean strand = strandString.equals("R");

        return new Alignment(chr, start, end, strand);
    }
}
