/*
* The Broad Institute
* SOFTWARE COPYRIGHT NOTICE AGREEMENT
* This is copyright (2007-2008) by the Broad Institute/Massachusetts Institute
* of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
* (the "License"); you may not use this file except in compliance with
*  the License.  You may obtain a copy of the License at
*
*    http://www.opensource.org/licenses/gpl-2.0.php
*
* This software is supplied without any warranty or guaranteed support
* whatsoever. Neither the Broad Institute nor MIT can be responsible for its
* use, misuse, or functionality.
*/




package org.broad.igv.preprocess;

//~--- non-JDK imports --------------------------------------------------------

import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;

//~--- JDK imports ------------------------------------------------------------

import java.io.*;

import java.util.*;

/**
 *
 * @author jrobinso
 */
public class AlignmentTestFileGenerator {

    /**
     * Method description
     *
     *
     * @param args
     *
     * @throws IOException
     */
    public static void main(String[] args) throws IOException {
        String genomeId = ((args.length > 0) ? args[0] : "hg18");
        generateTestFile(genomeId);
    }

    /**
     * Method description
     *
     * Generate a test file f randomly distributed peaks for the given genoe
     *
     * @param genomeId
     *
     * @throws IOException
     */
    public static void generateTestFile(String genomeId) throws IOException {
        int step = 1000000;
        int width = 100000;
        int readLength = 50;
        Random r = new Random();

        PrintWriter pw = new PrintWriter(new FileWriter(genomeId + ".large.aligned.txt"));

        Genome genome = GenomeManager.getInstance().getGenome(genomeId);
        Chromosome[] chromosomes = genome.getChromosomes().toArray(new Chromosome[] {});

        int nAlignments = 50000000;
        for (int i = 0; i < nAlignments; i++)
        {

            int cIdx = (int) (r.nextDouble() * 0.99 * chromosomes.length);
            Chromosome c = chromosomes[cIdx];
            int peakIdx = ((int) (r.nextDouble() * c.getLength())) / step;
            int peak = peakIdx * step;
            int start = peak + (int) (r.nextGaussian() * width);
            int end = start + readLength;
            if ((start > 0) && (end < c.getLength()))
            {
                String strand = (r.nextBoolean()) ? "-" : "+";
                pw.println(c.getName() + "\t" + start + "\t" + end + "\t" + strand);
            }
        }


        pw.close();
    }

}
